/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.MillipedeHeadEntity;
import com.pepper.faunify.entity.client.model.MillipedeHeadModel;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MillipedeHeadRenderer
extends GeoEntityRenderer<MillipedeHeadEntity> {
    private static final class_2960 GIANT = new class_2960("faunify", "textures/entity/millipede1.png");
    private static final class_2960 TWISTEDCLAW = new class_2960("faunify", "textures/entity/millipede2.png");
    private static final class_2960 NARCEUS = new class_2960("faunify", "textures/entity/millipede3.png");
    private static final class_2960 PHOBIA_TEXTURE = new class_2960("faunify", "textures/entity/phobiafriendly/millipede.png");
    private static final int SOUND_INTERVAL_TICKS = 10;
    private static final int CLEANUP_INTERVAL = 200;
    private static final Map<UUID, Integer> soundTimers = new HashMap<UUID, Integer>();
    private static int cleanupCounter = 0;

    public MillipedeHeadRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (GeoModel)new MillipedeHeadModel());
        this.field_4673 = 0.45f;
    }

    public class_2960 getTextureLocation(MillipedeHeadEntity entity) {
        if (FaunifyClientConfig.millipedePhobiaFriendly) {
            return PHOBIA_TEXTURE;
        }
        return MillipedeHeadRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(class_4587 poseStack, MillipedeHeadEntity animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (++cleanupCounter >= 200) {
            MillipedeHeadRenderer.cleanupStaleEntries();
            cleanupCounter = 0;
        }
        if (!isReRender && !FaunifyClientConfig.millipedePhobiaFriendly) {
            boolean isMoving = animatable.method_18798().method_37268() > 1.0E-4;
            boolean isOnGround = animatable.method_24828();
            if (isMoving && isOnGround) {
                UUID uuid = animatable.method_5667();
                int currentTick = animatable.field_6012;
                Integer lastSoundTick = soundTimers.get(uuid);
                if (lastSoundTick == null || currentTick - lastSoundTick >= 10) {
                    animatable.method_37908().method_8486(animatable.method_23317(), animatable.method_23318(), animatable.method_23321(), FaunifySounds.MILLIPEDE_WALK, animatable.method_5634(), 0.5f, 1.0f, false);
                    soundTimers.put(uuid, currentTick);
                }
            } else if (!isMoving) {
                soundTimers.remove(animatable.method_5667());
            }
        }
        float bugScale = 1.15f;
        poseStack.method_22905(bugScale, bugScale, bugScale);
    }

    public static class_2960 getVariantTexture(MillipedeHeadEntity.Variant variant) {
        switch (variant) {
            case GIANT: {
                return GIANT;
            }
            case TWISTEDCLAW: {
                return TWISTEDCLAW;
            }
            case NARCEUS: {
                return NARCEUS;
            }
        }
        return GIANT;
    }

    private static void cleanupStaleEntries() {
        if (soundTimers.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            soundTimers.clear();
            return;
        }
        Iterator<UUID> iterator = soundTimers.keySet().iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            if (mc.field_1687.method_8469(uuid.hashCode()) != null) continue;
            iterator.remove();
        }
    }
}

