/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.StickbugEntity;
import com.pepper.faunify.entity.client.model.StickbugModel;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class StickbugRenderer
extends GeoEntityRenderer<StickbugEntity> {
    private static final class_2960 BROWN = new class_2960("faunify", "textures/entity/stickbug1.png");
    private static final class_2960 DARKBROWN = new class_2960("faunify", "textures/entity/stickbug2.png");
    private static final class_2960 GREEN = new class_2960("faunify", "textures/entity/stickbug3.png");
    private static final class_2960 DARKGREEN = new class_2960("faunify", "textures/entity/stickbug4.png");
    private static final class_2960 GREY = new class_2960("faunify", "textures/entity/stickbug5.png");
    private static final class_2960 PHOBIA_TEXTURE = new class_2960("faunify", "textures/entity/phobiafriendly/stickbug.png");

    public StickbugRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (GeoModel)new StickbugModel());
        this.field_4673 = 0.55f;
    }

    public class_2960 getTextureLocation(StickbugEntity entity) {
        if (FaunifyClientConfig.stickbugPhobiaFriendly) {
            return PHOBIA_TEXTURE;
        }
        return StickbugRenderer.getVariantTexture(entity.getVariant());
    }

    public void preRender(class_4587 poseStack, StickbugEntity animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        float bugScale = 0.9f;
        poseStack.method_22905(bugScale, bugScale, bugScale);
    }

    public void actuallyRender(class_4587 poseStack, StickbugEntity animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (FaunifyClientConfig.stickbugPhobiaFriendly) {
            float camouflageBlend = animatable.getCamouflageBlend();
            int blockColor = animatable.getBlockBelowColor();
            if (blockColor == 0 || camouflageBlend == 0.0f) {
                super.actuallyRender(poseStack, (class_1297)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                return;
            }
            float blockRed = (float)(blockColor >> 16 & 0xFF) / 255.0f;
            float blockGreen = (float)(blockColor >> 8 & 0xFF) / 255.0f;
            float blockBlue = (float)(blockColor & 0xFF) / 255.0f;
            float maxChannel = Math.max(Math.max(blockRed, blockGreen), blockBlue);
            float minChannel = Math.min(Math.min(blockRed, blockGreen), blockBlue);
            float blockSaturation = maxChannel > 0.0f ? (maxChannel - minChannel) / maxChannel : 0.0f;
            float grey = (blockRed + blockGreen + blockBlue) / 3.0f;
            float desaturationFactor = 1.0f;
            float tintedRed = this.lerp(grey, blockRed, blockSaturation * desaturationFactor);
            float tintedGreen = this.lerp(grey, blockGreen, blockSaturation * desaturationFactor);
            float tintedBlue = this.lerp(grey, blockBlue, blockSaturation * desaturationFactor);
            float brightnessBoost = 1.5f;
            tintedRed = Math.min(1.0f, tintedRed * brightnessBoost);
            tintedGreen = Math.min(1.0f, tintedGreen * brightnessBoost);
            tintedBlue = Math.min(1.0f, tintedBlue * brightnessBoost);
            float finalRed = this.lerp(red, tintedRed, camouflageBlend);
            float finalGreen = this.lerp(green, tintedGreen, camouflageBlend);
            float finalBlue = this.lerp(blue, tintedBlue, camouflageBlend);
            super.actuallyRender(poseStack, (class_1297)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, finalRed, finalGreen, finalBlue, alpha);
            return;
        }
        float camouflageBlend = animatable.getCamouflageBlend();
        int blockColor = animatable.getBlockBelowColor();
        if (blockColor == 0) {
            super.actuallyRender(poseStack, (class_1297)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            return;
        }
        if (camouflageBlend < 1.0f) {
            float originalAlpha = alpha * (1.0f - camouflageBlend);
            super.actuallyRender(poseStack, (class_1297)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, originalAlpha);
        }
        if (camouflageBlend > 0.0f) {
            float blockRed = (float)(blockColor >> 16 & 0xFF) / 255.0f;
            float blockGreen = (float)(blockColor >> 8 & 0xFF) / 255.0f;
            float blockBlue = (float)(blockColor & 0xFF) / 255.0f;
            float maxChannel = Math.max(Math.max(blockRed, blockGreen), blockBlue);
            float minChannel = Math.min(Math.min(blockRed, blockGreen), blockBlue);
            float blockSaturation = maxChannel > 0.0f ? (maxChannel - minChannel) / maxChannel : 0.0f;
            float grey = (blockRed + blockGreen + blockBlue) / 3.0f;
            float desaturationFactor = 1.0f;
            float tintedRed = this.lerp(grey, blockRed, blockSaturation * desaturationFactor);
            float tintedGreen = this.lerp(grey, blockGreen, blockSaturation * desaturationFactor);
            float tintedBlue = this.lerp(grey, blockBlue, blockSaturation * desaturationFactor);
            float brightnessBoost = 1.5f;
            tintedRed = Math.min(1.0f, tintedRed * brightnessBoost);
            tintedGreen = Math.min(1.0f, tintedGreen * brightnessBoost);
            tintedBlue = Math.min(1.0f, tintedBlue * brightnessBoost);
            class_2960 greyTexture = StickbugRenderer.getVariantTexture(StickbugEntity.Variant.GREY);
            class_1921 greyRenderType = class_1921.method_23580((class_2960)greyTexture);
            class_4588 greyBuffer = bufferSource.getBuffer(greyRenderType);
            float greyAlpha = alpha * camouflageBlend;
            super.actuallyRender(poseStack, (class_1297)animatable, model, greyRenderType, bufferSource, greyBuffer, isReRender, partialTick, packedLight, packedOverlay, tintedRed, tintedGreen, tintedBlue, greyAlpha);
        }
    }

    public static class_2960 getVariantTexture(StickbugEntity.Variant variant) {
        switch (variant) {
            case BROWN: {
                return BROWN;
            }
            case DARKBROWN: {
                return DARKBROWN;
            }
            case GREEN: {
                return GREEN;
            }
            case DARKGREEN: {
                return DARKGREEN;
            }
            case GREY: {
                return GREY;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    private float lerp(float start, float end, float amount) {
        return start + (end - start) * amount;
    }
}

