/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.goal;

import com.pepper.faunify.entity.client.IFlyingBug;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class BugFlightGoal<T extends class_1429>
extends class_1352 {
    private final T insect;
    private final int maxFlightHeight;
    private final int flightChanceModifier;
    private double x;
    private double y;
    private double z;
    private int flyDuration;
    private int restDuration;
    private int currentTimer;
    private boolean shouldRest;
    private int landingTimer;
    private class_243 landingTarget;

    public BugFlightGoal(T insect, int maxFlightHeight, int flightChanceModifier) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.insect = insect;
        this.maxFlightHeight = maxFlightHeight;
        this.flightChanceModifier = flightChanceModifier;
        this.resetTimers();
        this.landingTimer = 0;
    }

    public boolean method_6264() {
        if (this.insect.method_5782() || this.insect.method_5765()) {
            return false;
        }
        if (!((IFlyingBug)this.insect).isFlying() && this.insect.method_6051().method_43048(this.flightChanceModifier) != 0 && !this.shouldRest) {
            return false;
        }
        class_243 target = this.getPosition();
        if (target == null) {
            return false;
        }
        this.x = target.field_1352;
        this.y = target.field_1351;
        this.z = target.field_1350;
        return true;
    }

    public boolean method_6266() {
        if (!((IFlyingBug)this.insect).isFlying() && this.insect.method_24828() && this.currentTimer >= this.restDuration) {
            return false;
        }
        if (((IFlyingBug)this.insect).getLandingFlag()) {
            return !this.insect.method_24828() && ((IFlyingBug)this.insect).getGroundedFor() <= 0;
        }
        return ((IFlyingBug)this.insect).isFlying() && !this.insect.method_5942().method_6357() && ((IFlyingBug)this.insect).getGroundedFor() <= 0;
    }

    public void method_6269() {
        ((IFlyingBug)this.insect).setFlying(true);
        this.insect.method_5942().method_6337(this.x, this.y, this.z, 0.5);
    }

    public void method_6270() {
        this.insect.method_5942().method_6340();
        ((IFlyingBug)this.insect).setLandingFlag(false);
        this.landingTimer = 0;
        this.landingTarget = null;
        if (this.insect.method_24828()) {
            this.insect.method_18799(class_243.field_1353);
        }
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        super.method_6270();
    }

    public void method_6268() {
        if (!((IFlyingBug)this.insect).isFlying() && this.insect.method_24828()) {
            ++this.currentTimer;
            class_2338 bugPos = this.insect.method_24515();
            class_2680 stateAtPos = this.insect.method_37908().method_8320(bugPos);
            if (!stateAtPos.method_26215() && !stateAtPos.method_45474()) {
                return;
            }
            this.insect.method_18799(class_243.field_1353);
            this.insect.method_5942().method_6340();
            return;
        }
        ++this.currentTimer;
        if (((IFlyingBug)this.insect).isFlying()) {
            class_243 newTarget;
            if ((this.insect.method_5942().method_6357() || this.currentTimer % 40 == 0) && !((IFlyingBug)this.insect).getLandingFlag() && (newTarget = this.findFlightPos()) != null) {
                this.insect.method_5942().method_6337(newTarget.field_1352, newTarget.field_1351, newTarget.field_1350, 0.5);
            }
            if (this.currentTimer >= this.flyDuration) {
                this.shouldRest = true;
                ((IFlyingBug)this.insect).setLandingFlag(true);
                if (this.landingTarget == null) {
                    this.landingTarget = this.findLandingPos();
                }
            }
            if (((IFlyingBug)this.insect).getLandingFlag()) {
                if (this.landingTarget == null) {
                    this.landingTarget = this.findLandingPos();
                }
                if (this.landingTarget != null) {
                    ++this.landingTimer;
                    if (this.landingTimer % 15 == 0) {
                        class_243 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                        this.insect.method_5942().method_6337(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350, (double)0.3f);
                    }
                    if (this.insect.method_24828() || this.insect.method_23318() - this.landingTarget.field_1351 < 1.0 && this.landingTimer > 40) {
                        ((IFlyingBug)this.insect).setFlying(false);
                        this.insect.method_18799(class_243.field_1353);
                        this.insect.method_5942().method_6340();
                        this.currentTimer = 0;
                        this.shouldRest = false;
                        ((IFlyingBug)this.insect).setLandingFlag(false);
                        this.landingTarget = null;
                        this.landingTimer = 0;
                        this.resetTimers();
                    }
                } else {
                    ((IFlyingBug)this.insect).setLandingFlag(false);
                    this.shouldRest = false;
                    this.landingTimer = 0;
                }
            }
        }
        if (this.isOverWaterOrVoid() || this.insect.method_5799()) {
            ((IFlyingBug)this.insect).setFlying(true);
            ((IFlyingBug)this.insect).setLandingFlag(false);
            this.shouldRest = false;
            this.landingTimer = 0;
            this.landingTarget = null;
        }
    }

    private void resetTimers() {
        this.flyDuration = 100 + this.insect.method_6051().method_43048(100);
        this.restDuration = 120 + this.insect.method_6051().method_43048(100);
        this.currentTimer = 0;
        this.shouldRest = false;
        this.landingTimer = 0;
    }

    private class_243 getPosition() {
        if (this.shouldRest) {
            this.landingTarget = this.findLandingPos();
            return this.getCirclingPosition(this.landingTarget);
        }
        return this.findFlightPos();
    }

    private class_243 getDescentPosition(class_243 target, int timer) {
        if (target == null) {
            return this.insect.method_19538();
        }
        double progress = Math.min((double)timer / 80.0, 1.0);
        double angle = (double)timer * 0.15 % (Math.PI * 2);
        double radius = 1.5 * (1.0 - progress * 0.7);
        double xOffset = Math.cos(angle) * radius;
        double zOffset = Math.sin(angle) * radius;
        double currentHeight = this.insect.method_23318();
        double targetHeight = target.field_1351 + 0.5;
        double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.25;
        return new class_243(target.field_1352 + xOffset, Math.max(descentHeight, targetHeight), target.field_1350 + zOffset);
    }

    private class_243 getCirclingPosition(class_243 target) {
        double angle = this.insect.method_6051().method_43058() * Math.PI * 2.0;
        double radius = 1.5 + this.insect.method_6051().method_43058() * 1.5;
        double xOffset = Math.cos(angle) * radius;
        double zOffset = Math.sin(angle) * radius;
        double yOffset = 2.0 + this.insect.method_6051().method_43058();
        return new class_243(target.field_1352 + xOffset, target.field_1351 + yOffset, target.field_1350 + zOffset);
    }

    private class_243 findFlightPos() {
        int range = 10;
        int maxAttempts = 10;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            class_243 basePos = this.insect.method_19538().method_1031((double)(this.insect.method_6051().method_43048(range * 2) - range), 0.0, (double)(this.insect.method_6051().method_43048(range * 2) - range));
            class_243 ground = this.groundPosition(basePos);
            class_2338 groundBlockPos = class_2338.method_49638((class_2374)ground);
            if (!this.insect.method_37908().method_8316(groundBlockPos).method_15769()) {
                continue;
            }
            int flightHeight = 1 + this.insect.method_6051().method_43048(this.maxFlightHeight);
            class_243 targetPos = new class_243(basePos.field_1352, ground.field_1351 + (double)flightHeight, basePos.field_1350);
            class_3965 result = this.insect.method_37908().method_17742(new class_3959(this.insect.method_33571(), targetPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this.insect));
            if (result.method_17783() == class_239.class_240.field_1333) {
                return targetPos;
            }
            return result.method_17784();
        }
        class_243 ground = this.groundPosition(this.insect.method_19538());
        return new class_243(this.insect.method_23317(), ground.field_1351 + 2.0, this.insect.method_23321());
    }

    private class_243 findLandingPos() {
        class_243 currentPos = this.insect.method_19538();
        class_243 ground = this.groundPosition(currentPos);
        class_2338 landingPos = class_2338.method_49638((class_2374)ground);
        if (!this.insect.method_37908().method_8316(landingPos).method_15769()) {
            for (int attempt = 0; attempt < 8; ++attempt) {
                int offsetX = this.insect.method_6051().method_43048(6) - 3;
                int offsetZ = this.insect.method_6051().method_43048(6) - 3;
                class_2338 testPos = landingPos.method_10069(offsetX, 0, offsetZ);
                class_243 testGround = this.groundPosition(class_243.method_24953((class_2382)testPos));
                class_2338 testGroundPos = class_2338.method_49638((class_2374)testGround);
                if (!this.insect.method_37908().method_8316(testGroundPos).method_15769()) continue;
                landingPos = testGroundPos;
                break;
            }
            if (!this.insect.method_37908().method_8316(landingPos).method_15769()) {
                return null;
            }
        }
        while (landingPos.method_10264() < this.insect.method_37908().method_31600() && !this.insect.method_37908().method_8320(landingPos).method_26215() && !this.insect.method_37908().method_8320(landingPos).method_45474()) {
            landingPos = landingPos.method_10084();
        }
        return class_243.method_24953((class_2382)landingPos);
    }

    private class_243 groundPosition(class_243 airPosition) {
        class_2338.class_2339 ground = new class_2338.class_2339();
        ground.method_10102(airPosition.field_1352, airPosition.field_1351, airPosition.field_1350);
        boolean flag = false;
        while (ground.method_10264() < this.insect.method_37908().method_31600() && !this.insect.method_37908().method_8320((class_2338)ground).method_26216((class_1922)this.insect.method_37908(), (class_2338)ground) && this.insect.method_37908().method_8316((class_2338)ground).method_15769()) {
            ground.method_10100(0, 1, 0);
            flag = true;
        }
        ground.method_10100(0, -1, 0);
        while (ground.method_10264() > this.insect.method_37908().method_31607() && !this.insect.method_37908().method_8320((class_2338)ground).method_26216((class_1922)this.insect.method_37908(), (class_2338)ground) && this.insect.method_37908().method_8316((class_2338)ground).method_15769()) {
            ground.method_10100(0, -1, 0);
        }
        return class_243.method_24953((class_2382)(flag ? ground.method_10084() : ground.method_10074()));
    }

    private boolean isOverWaterOrVoid() {
        class_2338 position = this.insect.method_24515();
        while (position.method_10264() > this.insect.method_37908().method_31607() && this.insect.method_37908().method_22347(position) && this.insect.method_37908().method_8316(position).method_15769()) {
            position = position.method_10074();
        }
        return !this.insect.method_37908().method_8316(position).method_15769() || this.insect.method_37908().method_8320(position).method_27852(class_2246.field_10597) || position.method_10264() <= this.insect.method_37908().method_31607();
    }
}

