/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.items;

import com.pepper.faunify.entity.MillipedeHeadEntity;
import com.pepper.faunify.entity.MillipedeSegmentEntity;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifyTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;

public class BugNetItem
extends class_1792 {
    public static final class_6862<class_1299<?>> CATCHABLE_ENTITIES = class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)new class_2960("faunify", "bug_net_catchable"));

    public BugNetItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void registerItemProperties() {
        class_5272.method_27879((class_1792)FaunifyItems.BUG_NET, (class_2960)new class_2960("faunify", "has_entity"), (stack, world, entity, seed) -> BugNetItem.hasStoredEntity(stack) ? 1.0f : 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        class_1799 filledNet;
        if (BugNetItem.hasStoredEntity(stack)) {
            return class_1269.field_5811;
        }
        if (!this.canCatchEntity(target)) {
            return class_1269.field_5811;
        }
        if (player.method_37908().field_9236) return class_1269.method_29236((boolean)player.method_37908().field_9236);
        MillipedeHeadEntity headToDiscard = null;
        if (target instanceof MillipedeHeadEntity) {
            MillipedeHeadEntity millipedeHead = (MillipedeHeadEntity)target;
            filledNet = this.captureMillipede(stack, millipedeHead, player);
            headToDiscard = millipedeHead;
        } else if (target instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity segment = (MillipedeSegmentEntity)target;
            MillipedeHeadEntity head = this.findHead(segment);
            if (head == null) return class_1269.field_5814;
            filledNet = this.captureMillipede(stack, head, player);
            headToDiscard = head;
        } else {
            filledNet = this.getFilledNet(stack, target);
        }
        filledNet.method_7974(stack.method_7919());
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14667, class_3419.field_15248, 1.0f, 1.0f);
        if (player.method_31549().field_7477) {
            if (!player.method_31548().method_7394(filledNet)) {
                player.method_7328(filledNet, false);
            }
        } else {
            player.method_6122(hand, filledNet);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            FaunifyTriggers.CATCH_ENTITY.trigger(serverPlayer, (class_1297)target, stack);
            FaunifyTriggers.CATCH_ALL_BEETLES.trigger(serverPlayer, (class_1297)target, stack);
        }
        if (headToDiscard != null) {
            headToDiscard.method_31472();
        } else {
            target.method_31472();
        }
        player.method_37908().method_43275((class_1297)player, class_5712.field_28725, target.method_19538());
        return class_1269.field_5812;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2487 entityNbt;
        Optional entityTypeOpt;
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        if (!BugNetItem.hasStoredEntity(stack) || player == null) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2338 spawnPos = clickedPos.method_10093(context.method_8038());
        class_2487 stackNbt = stack.method_7969();
        if (stackNbt != null && stackNbt.method_10545("StoredEntity") && (entityTypeOpt = class_1299.method_17684((class_2487)(entityNbt = stackNbt.method_10562("StoredEntity")))).isPresent()) {
            class_1299 entityType = (class_1299)entityTypeOpt.get();
            if (stackNbt.method_10577("IsMillipede")) {
                return this.spawnMillipede(stackNbt, (class_3218)world, spawnPos, player, context, stack);
            }
            class_1297 entity = entityType.method_5883((class_1937)((class_3218)world));
            if (entity != null) {
                entity.method_5651(entityNbt);
                if (player.method_31549().field_7477) {
                    entity.method_5826(UUID.randomUUID());
                }
                if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    mob.method_5971();
                }
                entity.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), 0.0f);
                boolean spawned = world.method_8649(entity);
                if (spawned) {
                    world.method_8396(null, spawnPos, class_3417.field_14770, class_3419.field_15254, 1.0f, 1.0f);
                    world.method_33596((class_1297)player, class_5712.field_28738, spawnPos);
                    if (!player.method_31549().field_7477) {
                        class_1799 emptyNet = new class_1799((class_1935)this);
                        emptyNet.method_7974(stack.method_7919());
                        emptyNet.method_7956(1, (class_1309)player, p -> p.method_20236(context.method_20287()));
                        player.method_6122(context.method_20287(), emptyNet);
                        return class_1269.field_21466;
                    }
                    return class_1269.field_5812;
                }
            }
        }
        return class_1269.field_5814;
    }

    private MillipedeHeadEntity findHead(MillipedeSegmentEntity segment) {
        MillipedeSegmentEntity current = segment;
        int safety = 0;
        while (current instanceof MillipedeSegmentEntity) {
            MillipedeSegmentEntity millipedeSeg = current;
            if (safety >= 20) break;
            class_1297 parent = millipedeSeg.getParentSegment();
            if (parent instanceof MillipedeHeadEntity) {
                MillipedeHeadEntity head = (MillipedeHeadEntity)parent;
                return head;
            }
            if (!(parent instanceof MillipedeSegmentEntity)) break;
            current = parent;
            ++safety;
        }
        return null;
    }

    private class_1799 captureMillipede(class_1799 emptyNet, MillipedeHeadEntity head, class_1657 player) {
        Object object;
        class_1799 filledNet = new class_1799((class_1935)this);
        class_2487 stackNbt = filledNet.method_7948();
        class_2487 headNbt = new class_2487();
        head.method_5662(headNbt);
        stackNbt.method_10566("StoredEntity", (class_2520)headNbt);
        stackNbt.method_10582("StoredEntityType", class_1299.method_5890((class_1299)head.method_5864()).toString());
        stackNbt.method_10556("IsMillipede", true);
        ArrayList<class_2487> segmentNbts = new ArrayList<class_2487>();
        if (!player.method_37908().field_9236 && (object = player.method_37908()) instanceof class_3218) {
            class_1297 current;
            class_3218 serverWorld = (class_3218)object;
            UUID childId = head.getChildId();
            class_1297 class_12972 = current = childId != null ? serverWorld.method_14190(childId) : null;
            while (current instanceof MillipedeSegmentEntity) {
                MillipedeSegmentEntity segment = (MillipedeSegmentEntity)current;
                class_2487 segNbt = new class_2487();
                segment.method_5662(segNbt);
                segmentNbts.add(segNbt);
                segment.method_31472();
                UUID nextId = segment.getChildId();
                current = nextId != null ? serverWorld.method_14190(nextId) : null;
            }
        }
        if (!segmentNbts.isEmpty()) {
            class_2499 segmentList = new class_2499();
            for (class_2487 segNbt : segmentNbts) {
                segmentList.add((Object)segNbt);
            }
            stackNbt.method_10566("MillipedeSegments", (class_2520)segmentList);
        }
        return filledNet;
    }

    private class_1269 spawnMillipede(class_2487 stackNbt, class_3218 world, class_2338 spawnPos, class_1657 player, class_1838 context, class_1799 stack) {
        class_2487 headNbt = stackNbt.method_10562("StoredEntity");
        Optional headTypeOpt = class_1299.method_17684((class_2487)headNbt);
        if (headTypeOpt.isEmpty() || !(((class_1299)headTypeOpt.get()).method_5883((class_1937)world) instanceof MillipedeHeadEntity)) {
            return class_1269.field_5814;
        }
        MillipedeHeadEntity head = (MillipedeHeadEntity)((class_1299)headTypeOpt.get()).method_5883((class_1937)world);
        if (head == null) {
            return class_1269.field_5814;
        }
        head.method_5651(headNbt);
        if (player.method_31549().field_7477) {
            head.method_5826(UUID.randomUUID());
        }
        head.method_5971();
        head.method_5808((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), 0.0f);
        boolean headSpawned = world.method_8649((class_1297)head);
        if (!headSpawned) {
            return class_1269.field_5814;
        }
        if (stackNbt.method_10545("MillipedeSegments")) {
            class_2499 segmentList = stackNbt.method_10554("MillipedeSegments", 10);
            GeoEntity previousEntity = head;
            for (int i = 0; i < segmentList.size(); ++i) {
                class_1297 segment;
                class_2487 segNbt = segmentList.method_10602(i);
                Optional segTypeOpt = class_1299.method_17684((class_2487)segNbt);
                if (!segTypeOpt.isPresent() || !((segment = ((class_1299)segTypeOpt.get()).method_5883((class_1937)world)) instanceof MillipedeSegmentEntity)) continue;
                MillipedeSegmentEntity millipedeSeg = (MillipedeSegmentEntity)segment;
                millipedeSeg.method_5651(segNbt);
                if (player.method_31549().field_7477) {
                    millipedeSeg.method_5826(UUID.randomUUID());
                }
                millipedeSeg.method_5971();
                millipedeSeg.setParentSegment((class_1297)previousEntity);
                if (previousEntity instanceof MillipedeHeadEntity) {
                    MillipedeHeadEntity prevHead = previousEntity;
                    prevHead.setChildId(millipedeSeg.method_5667());
                } else if (previousEntity instanceof MillipedeSegmentEntity) {
                    MillipedeSegmentEntity prevSeg = (MillipedeSegmentEntity)previousEntity;
                    prevSeg.setChildId(millipedeSeg.method_5667());
                }
                millipedeSeg.method_5808((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), 0.0f);
                world.method_8649((class_1297)millipedeSeg);
                previousEntity = millipedeSeg;
            }
        }
        world.method_8396(null, spawnPos, class_3417.field_14770, class_3419.field_15254, 1.0f, 1.0f);
        world.method_33596((class_1297)player, class_5712.field_28738, spawnPos);
        if (!player.method_31549().field_7477) {
            class_1799 emptyNet = new class_1799((class_1935)this);
            emptyNet.method_7974(stack.method_7919());
            emptyNet.method_7956(1, (class_1309)player, p -> p.method_20236(context.method_20287()));
            player.method_6122(context.method_20287(), emptyNet);
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    private boolean canCatchEntity(class_1309 entity) {
        return entity.method_5864().method_20210(CATCHABLE_ENTITIES);
    }

    private class_1799 getFilledNet(class_1799 emptyNet, class_1309 entity) {
        class_1799 filledNet = new class_1799((class_1935)this);
        class_2487 entityNbt = new class_2487();
        entity.method_5662(entityNbt);
        class_2487 stackNbt = filledNet.method_7948();
        stackNbt.method_10566("StoredEntity", (class_2520)entityNbt);
        stackNbt.method_10582("StoredEntityType", class_1299.method_5890((class_1299)entity.method_5864()).toString());
        return filledNet;
    }

    private static boolean hasStoredEntity(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10545("StoredEntity");
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        String entityTypeId;
        Optional entityType;
        class_2487 nbt;
        if (BugNetItem.hasStoredEntity(stack) && (nbt = stack.method_7969()) != null && nbt.method_10545("StoredEntityType") && (entityType = class_1299.method_5898((String)(entityTypeId = nbt.method_10558("StoredEntityType")))).isPresent()) {
            class_2561 entityName = ((class_1299)entityType.get()).method_5897();
            tooltip.add((class_2561)class_2561.method_43469((String)"item.faunify.bug_net.contains", (Object[])new Object[]{entityName}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            if (nbt.method_10577("IsMillipede") && nbt.method_10545("MillipedeSegments")) {
                int segmentCount = nbt.method_10554("MillipedeSegments", 10).size();
                tooltip.add((class_2561)class_2561.method_43470((String)("  (" + (segmentCount + 1) + " parts)")).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
            }
        }
    }

    public boolean method_7886(class_1799 stack) {
        return BugNetItem.hasStoredEntity(stack);
    }
}

