/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.blocks;

import java.util.Objects;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class CoffeeTable
extends class_2383 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<TableType> TYPE = class_2754.method_11850((String)"type", TableType.class);
    private static final class_265 STRAIGHT_SHAPE = class_259.method_17786((class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.125, (double)0.125, (double)0.375, (double)0.25), (class_265[])new class_265[]{class_259.method_1081((double)0.875, (double)0.0, (double)0.125, (double)1.0, (double)0.375, (double)0.25), class_259.method_1081((double)0.0, (double)0.0, (double)0.75, (double)0.125, (double)0.375, (double)0.875), class_259.method_1081((double)0.875, (double)0.0, (double)0.75, (double)1.0, (double)0.375, (double)0.875), class_259.method_1081((double)0.015625, (double)0.06875, (double)0.140625, (double)0.984375, (double)0.125, (double)0.859375), class_259.method_1081((double)0.0, (double)0.375, (double)0.0625, (double)1.0, (double)0.4375, (double)0.9375)});
    private static final class_265 CORNER_SHAPE = class_259.method_17786((class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.125, (double)0.875, (double)0.375, (double)0.25), (class_265[])new class_265[]{class_259.method_1081((double)0.75, (double)0.0, (double)0.75, (double)0.875, (double)0.375, (double)0.875), class_259.method_1081((double)0.0, (double)0.375, (double)0.0625, (double)0.9375, (double)0.4375, (double)1.0), class_259.method_1081((double)0.125, (double)0.0, (double)0.75, (double)0.25, (double)0.375, (double)0.875), class_259.method_1081((double)0.125, (double)0.0, (double)0.125, (double)0.25, (double)0.375, (double)0.25)});

    public CoffeeTable(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)TableType.STRAIGHT)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
        return this.updateTableType(state, (class_1936)ctx.method_8045(), ctx.method_8037());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, TYPE});
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighbor, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (dir == class_2350.field_11033 && !this.method_9558(state, (class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return this.updateTableType(state, world, pos);
    }

    private class_2680 updateTableType(class_2680 state, class_1936 world, class_2338 pos) {
        boolean rightStraight;
        class_2350 facing;
        class_2350 front = facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2350 left = facing.method_10160();
        class_2350 right = facing.method_10170();
        class_2680 frontState = world.method_8320(pos.method_10093(front));
        class_2680 leftState = world.method_8320(pos.method_10093(left));
        class_2680 rightState = world.method_8320(pos.method_10093(right));
        boolean frontStraight = frontState.method_26204() instanceof CoffeeTable && frontState.method_11654(TYPE) == TableType.STRAIGHT;
        boolean leftStraight = leftState.method_26204() instanceof CoffeeTable && leftState.method_11654(TYPE) == TableType.STRAIGHT;
        boolean bl = rightStraight = rightState.method_26204() instanceof CoffeeTable && rightState.method_11654(TYPE) == TableType.STRAIGHT;
        if (frontStraight && leftStraight || frontStraight && rightStraight) {
            return (class_2680)state.method_11657(TYPE, (Comparable)((Object)TableType.CORNER));
        }
        return (class_2680)state.method_11657(TYPE, (Comparable)((Object)TableType.STRAIGHT));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return CoffeeTable.method_20044((class_4538)world, (class_2338)pos.method_10074(), (class_2350)class_2350.field_11036);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        class_265 shape = Objects.requireNonNull((TableType)((Object)state.method_11654(TYPE))) == TableType.CORNER ? CORNER_SHAPE : STRAIGHT_SHAPE;
        return CoffeeTable.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), shape);
    }

    private static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static enum TableType implements class_3542
    {
        STRAIGHT("straight"),
        CORNER("corner");

        private final String name;

        private TableType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

