/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.blocks;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import us.mikebartosh.minecraft.MikesFurniture;
import us.mikebartosh.minecraft.blockentities.FurnitureEntities;
import us.mikebartosh.minecraft.blockentities.SeatEntity;

public class Couch
extends class_2383 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<CouchPart> PART = class_2754.method_11850((String)"part", CouchPart.class);
    private static final class_265 BASE_SHAPE = Couch.makeBaseShape();
    private static final class_265 LEFT_SHAPE = Couch.makeLeftShape();
    private static final class_265 RIGHT_SHAPE = Couch.makeRightShape();
    private static final class_265 MIDDLE_SHAPE = Couch.makeMiddleShape();
    private static final class_265 CORNER_LEFT_SHAPE = Couch.makeCornerLeftShape();
    private static final class_265 CORNER_RIGHT_SHAPE = Couch.makeCornerRightShape();
    private static final class_265 INNER_CORNER_LEFT_SHAPE = Couch.makeInnerCornerLeftShape();
    private static final class_265 INNER_CORNER_RIGHT_SHAPE = Couch.makeInnerCornerRightShape();

    public Couch(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(PART, (Comparable)((Object)CouchPart.BASE)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, PART});
    }

    private Set<class_2350> effectiveFacings(class_2680 neighbor) {
        if (!Couch.isCouch(neighbor)) {
            return EnumSet.noneOf(class_2350.class);
        }
        class_2350 nf = (class_2350)neighbor.method_11654((class_2769)FACING);
        CouchPart np = (CouchPart)((Object)neighbor.method_11654(PART));
        return switch (np.ordinal()) {
            case 0, 1, 2, 3 -> EnumSet.of(nf);
            case 4 -> EnumSet.of(nf, nf.method_10160());
            case 5 -> EnumSet.of(nf, nf.method_10170());
            case 6 -> EnumSet.of(nf.method_10153(), nf.method_10160());
            case 7 -> EnumSet.of(nf.method_10153(), nf.method_10170());
            default -> EnumSet.of(nf);
        };
    }

    private static boolean isCouch(class_2680 state) {
        return state.method_26204() instanceof Couch;
    }

    private static boolean isDifferentOrientation(class_2680 state, class_1922 world, class_2338 pos, class_2350 dir) {
        class_2680 other = world.method_8320(pos.method_10093(dir));
        return !Couch.isCouch(other) || other.method_11654((class_2769)FACING) != state.method_11654((class_2769)FACING);
    }

    private class_2350 leftDir(class_2350 facing) {
        return facing.method_10160();
    }

    private class_2350 rightDir(class_2350 facing) {
        return facing.method_10170();
    }

    private CouchPart getCouchPart(class_2680 state, class_1922 world, class_2338 pos) {
        class_2350 backFacing;
        class_2350 frontFacing;
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2680 frontState = world.method_8320(pos.method_10093(facing));
        if (Couch.isCouch(frontState) && (frontFacing = (class_2350)frontState.method_11654((class_2769)FACING)).method_10166() != facing.method_10166() && Couch.isDifferentOrientation(state, world, pos, frontFacing.method_10153())) {
            if (frontFacing == facing.method_10160()) {
                return CouchPart.CORNER_LEFT;
            }
            return CouchPart.CORNER_RIGHT;
        }
        class_2680 backState = world.method_8320(pos.method_10093(facing.method_10153()));
        if (Couch.isCouch(backState) && (backFacing = (class_2350)backState.method_11654((class_2769)FACING)).method_10166() != facing.method_10166() && Couch.isDifferentOrientation(state, world, pos, backFacing)) {
            if (backFacing == facing.method_10160()) {
                return CouchPart.INNER_LEFT;
            }
            return CouchPart.INNER_RIGHT;
        }
        class_2680 leftState = world.method_8320(pos.method_10093(this.leftDir(facing)));
        class_2680 rightState = world.method_8320(pos.method_10093(this.rightDir(facing)));
        boolean left = this.connectsStraight(leftState, facing, this.leftDir(facing));
        boolean right = this.connectsStraight(rightState, facing, this.rightDir(facing));
        if (left && right) {
            return CouchPart.MIDDLE;
        }
        if (left) {
            return CouchPart.LEFT;
        }
        if (right) {
            return CouchPart.RIGHT;
        }
        return CouchPart.BASE;
    }

    private boolean connectsStraight(class_2680 neighbor, class_2350 myFacing, class_2350 sideFromMe) {
        if (!Couch.isCouch(neighbor)) {
            return false;
        }
        if (neighbor.method_11654((class_2769)FACING) == myFacing) {
            return true;
        }
        Set<class_2350> eff = this.effectiveFacings(neighbor);
        return eff.contains(myFacing);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8042().method_10153();
        if (facing.method_10166().method_10178()) {
            facing = class_2350.field_11043;
        }
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing);
        return (class_2680)state.method_11657(PART, (Comparable)((Object)this.getCouchPart(state, (class_1922)ctx.method_8045(), ctx.method_8037())));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10166().method_10179()) {
            return (class_2680)state.method_11657(PART, (Comparable)((Object)this.getCouchPart(state, (class_1922)world, pos)));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == MikesFurniture.WRENCH_ITEM) {
            if (!world.method_8608()) {
                if (player.method_5715()) {
                    class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                    class_2350 newFacing = facing.method_10170();
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)FACING, (Comparable)newFacing), 16);
                    return class_1269.field_5812;
                }
                CouchPart current = (CouchPart)((Object)state.method_11654(PART));
                CouchPart[] parts = CouchPart.values();
                int nextIndex = (current.ordinal() + 1) % parts.length;
                CouchPart next = parts[nextIndex];
                world.method_8652(pos, (class_2680)state.method_11657(PART, (Comparable)((Object)next)), 16);
            }
            return class_1269.field_5812;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (stack.method_7960() && !player.method_5765()) {
            class_243 seatPos = class_243.method_24953((class_2382)pos).method_1031(0.0, -0.65, 0.0);
            SeatEntity seat = new SeatEntity(FurnitureEntities.SEAT, world);
            seat.method_33574(seatPos);
            world.method_8649((class_1297)seat);
            player.method_5873((class_1297)seat, false);
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        CouchPart part = (CouchPart)((Object)state.method_11654(PART));
        class_265 shape = switch (part.ordinal()) {
            case 1 -> LEFT_SHAPE;
            case 2 -> RIGHT_SHAPE;
            case 3 -> MIDDLE_SHAPE;
            case 4 -> CORNER_LEFT_SHAPE;
            case 5 -> CORNER_RIGHT_SHAPE;
            case 6 -> INNER_CORNER_LEFT_SHAPE;
            case 7 -> INNER_CORNER_RIGHT_SHAPE;
            default -> BASE_SHAPE;
        };
        return Couch.rotateShape(class_2350.field_11043, facing, shape);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    private static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    private static class_265 makeMiddleShape() {
        return class_259.method_1084((class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.0625, (double)1.0, (double)0.4375, (double)1.0), (class_265)class_259.method_1081((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0));
    }

    private static class_265 makeBaseShape() {
        return class_259.method_17786((class_265)class_259.method_1081((double)0.921875, (double)0.4375, (double)0.078125, (double)0.984375, (double)0.5, (double)0.75), (class_265[])new class_265[]{class_259.method_1081((double)0.015625, (double)0.4375, (double)0.078125, (double)0.078125, (double)0.5, (double)0.75), class_259.method_1081((double)0.0, (double)0.125, (double)0.0625, (double)1.0, (double)0.4375, (double)1.0), class_259.method_1081((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0)});
    }

    private static class_265 makeLeftShape() {
        return class_259.method_17786((class_265)class_259.method_1081((double)0.921875, (double)0.4375, (double)0.078125, (double)0.984375, (double)0.5, (double)0.75), (class_265[])new class_265[]{class_259.method_1081((double)0.0, (double)0.125, (double)0.0625, (double)1.0, (double)0.4375, (double)1.0), class_259.method_1081((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0)});
    }

    private static class_265 makeRightShape() {
        return class_259.method_17786((class_265)class_259.method_1081((double)0.015625, (double)0.4375, (double)0.078125, (double)0.078125, (double)0.5, (double)0.75), (class_265[])new class_265[]{class_259.method_1081((double)0.0, (double)0.125, (double)0.0625, (double)1.0, (double)0.4375, (double)1.0), class_259.method_1081((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0)});
    }

    private static class_265 makeCornerRightShape() {
        return class_259.method_17786((class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (class_265[])new class_265[]{class_259.method_1081((double)0.25, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0), class_259.method_1081((double)0.0, (double)0.4375, (double)0.0, (double)0.25, (double)1.0, (double)1.0)});
    }

    private static class_265 makeCornerLeftShape() {
        return class_259.method_17786((class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (class_265[])new class_265[]{class_259.method_1081((double)0.75, (double)0.4375, (double)0.0, (double)1.0, (double)1.0, (double)0.75), class_259.method_1081((double)0.0, (double)0.4375, (double)0.75, (double)1.0, (double)1.0, (double)1.0)});
    }

    private static class_265 makeInnerCornerRightShape() {
        return class_259.method_1084((class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.0625, (double)0.9375, (double)0.4375, (double)1.0), (class_265)class_259.method_1081((double)0.0, (double)0.4375, (double)0.8125, (double)0.1875, (double)1.015625, (double)1.0));
    }

    private static class_265 makeInnerCornerLeftShape() {
        return class_259.method_1084((class_265)class_259.method_1081((double)0.0625, (double)0.125, (double)0.0625, (double)1.0, (double)0.4375, (double)1.0), (class_265)class_259.method_1081((double)0.8125, (double)0.4375, (double)0.8125, (double)1.0, (double)1.015625, (double)1.0));
    }

    public static enum CouchPart implements class_3542
    {
        BASE("base"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right");

        private final String name;

        private CouchPart(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

