/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.blocks;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import us.mikebartosh.minecraft.MikesFurniture;

public class Lamp
extends class_2383 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2754<LampType> TYPE = class_2754.method_11850((String)"type", LampType.class);
    private static final class_265 DEFAULT_SHAPE = class_259.method_1084((class_265)class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.03125, (double)0.6875), (class_265)class_259.method_1081((double)0.4375, (double)0.03125, (double)0.4375, (double)0.5625, (double)0.5875, (double)0.5625));
    private static final class_265 STEM_SHAPE = class_259.method_1081((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
    private static final class_265 STEM_BASE_SHAPE = class_259.method_1084((class_265)class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.03125, (double)0.6875), (class_265)class_259.method_1081((double)0.4375, (double)0.03125, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625));

    public Lamp(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657(TYPE, (Comparable)((Object)LampType.DEFAULT)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == MikesFurniture.WRENCH_ITEM) {
            if (!world.method_8608()) {
                if (player.method_5715()) {
                    class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                    class_2350 newFacing = facing.method_10170();
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)FACING, (Comparable)newFacing), 16);
                    return class_1269.field_5812;
                }
                LampType current = (LampType)((Object)state.method_11654(TYPE));
                LampType[] types = LampType.values();
                int next = (current.ordinal() + 1) % types.length;
                world.method_8652(pos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)types[next])), 16);
            }
            return class_1269.field_5812;
        }
        LampType type = (LampType)((Object)state.method_11654(TYPE));
        if (type != LampType.DEFAULT && type != LampType.HEAD) {
            return class_1269.field_5814;
        }
        boolean newLit = (Boolean)state.method_11654((class_2769)LIT) == false;
        this.updateLitChain(world, pos, newLit);
        return world.field_9236 ? class_1269.field_5812 : class_1269.field_21466;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8042().method_10153();
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false));
        return this.updateLampType((class_1936)ctx.method_8045(), ctx.method_8037(), state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, LIT, TYPE});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return Lamp.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), switch (((LampType)((Object)state.method_11654(TYPE))).ordinal()) {
            case 0 -> STEM_BASE_SHAPE;
            case 1, 2, 3 -> STEM_SHAPE;
            default -> DEFAULT_SHAPE;
        });
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighbor, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (dir == class_2350.field_11033 && !this.method_9558(state, (class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        state = this.updateLampType(world, pos, state);
        this.syncStackLighting((class_1937)world, pos, state);
        return state;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 below = world.method_8320(pos.method_10074());
        if (below.method_26204() instanceof Lamp) {
            return true;
        }
        return Lamp.method_20044((class_4538)world, (class_2338)pos.method_10074(), (class_2350)class_2350.field_11036);
    }

    private class_2680 updateLampType(class_1936 world, class_2338 pos, class_2680 state) {
        int variant;
        boolean above = this.isLamp(world.method_8320(pos.method_10084()));
        boolean below = this.isLamp(world.method_8320(pos.method_10074()));
        LampType type = !above && !below ? LampType.DEFAULT : (!above && below ? LampType.HEAD : (above && !below ? LampType.STEM_BASE : ((variant = Lamp.getStaticVariant(pos)) == 0 ? LampType.STEM_FLOWER : LampType.STEM)));
        return (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
    }

    public static int getStaticVariant(class_2338 pos) {
        long x = pos.method_10263();
        long y = pos.method_10264();
        long z = pos.method_10260();
        long seed = x * 73428767L ^ y * 91293199L ^ z * 472882049L;
        seed = (seed ^ seed >> 30) * -4658895280553007687L;
        seed = (seed ^ seed >> 27) * -7723592293110705685L;
        seed ^= seed >> 31;
        return (int)(Math.abs(seed) % 10L);
    }

    private boolean isLamp(class_2680 state) {
        return state.method_26204() instanceof Lamp;
    }

    private static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    private void updateLitChain(class_1937 world, class_2338 pos, boolean litValue) {
        class_2680 s;
        class_2338 cursor = pos;
        while ((s = world.method_8320(cursor)).method_26204() instanceof Lamp) {
            world.method_8652(cursor, (class_2680)s.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(litValue)), 2);
            cursor = cursor.method_10074();
        }
    }

    private void syncStackLighting(class_1937 world, class_2338 pos, class_2680 state) {
        class_2680 below;
        class_2680 loop;
        class_2338 cursor = pos;
        while ((loop = world.method_8320(cursor)).method_26204() instanceof Lamp && loop.method_11654(TYPE) != LampType.HEAD) {
            cursor = cursor.method_10084();
        }
        if (!(loop.method_26204() instanceof Lamp)) {
            return;
        }
        boolean lit = (Boolean)loop.method_11654((class_2769)LIT);
        class_2338 down = cursor.method_10074();
        while ((below = world.method_8320(down)).method_26204() instanceof Lamp) {
            if ((Boolean)below.method_11654((class_2769)LIT) != lit) {
                world.method_8652(down, (class_2680)below.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            }
            down = down.method_10074();
        }
    }

    public static enum LampType implements class_3542
    {
        STEM_BASE("stem_base"),
        STEM("stem"),
        STEM_FLOWER("stem_flower"),
        HEAD("head"),
        DEFAULT("default");

        private final String name;

        private LampType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

