/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.datagen;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1767;
import us.mikebartosh.minecraft.MikesFurniture;
import us.mikebartosh.minecraft.blocks.FurnitureBlocks;

public class FurnitureLangProvider
extends FabricLanguageProvider {
    public FurnitureLangProvider(FabricDataOutput output) {
        super(output, "en_us");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        builder.add("itemGroup.mikes-furniture", "Mike's Furniture");
        FurnitureBlocks.COUCHES.forEach((dyeColor, block) -> builder.add(block, FurnitureLangProvider.formatColor(dyeColor) + " Couch"));
        FurnitureBlocks.CHAISES.forEach((dyeColor, block) -> builder.add(block, FurnitureLangProvider.formatColor(dyeColor) + " Chaise"));
        FurnitureBlocks.LAMPS.forEach((dyeColor, block) -> builder.add(block, FurnitureLangProvider.formatColor(dyeColor) + " Lamp"));
        builder.add(FurnitureBlocks.COFFEE_TABLE, "Coffee Table");
        builder.add(MikesFurniture.WRENCH_ITEM, "Wrench");
    }

    private static String formatColor(class_1767 color) {
        return Arrays.stream(color.method_7792().split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }
}

