/*
 * Decompiled with CFR 0.152.
 */
package net.manus.chokemod;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chokemod")
public class ChokeEventHandler {
    private static final Map<UUID, UUID> chokingTargets = new ConcurrentHashMap<UUID, UUID>();
    private static final Map<UUID, Integer> chokeTicks = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<UUID, UUID> reverseLookup = new ConcurrentHashMap<UUID, UUID>();

    public static void handleChokeInput(ServerPlayer player, boolean pressing) {
        if (player == null) {
            return;
        }
        if (pressing) {
            if (!chokingTargets.containsKey(player.m_20148_())) {
                ChokeEventHandler.startChoking(player);
            }
        } else {
            ChokeEventHandler.stopChoking(player);
        }
    }

    private static void startChoking(ServerPlayer player) {
        Vec3 look = player.m_20154_();
        Vec3 start = player.m_146892_();
        Vec3 end = start.m_82549_(look.m_82490_(3.0));
        AABB area = new AABB(start, end).m_82400_(1.0);
        for (Entity entity : player.m_9236_().m_45933_((Entity)player, area)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (entity instanceof EnderDragon || entity instanceof WitherBoss) continue;
            chokingTargets.put(player.m_20148_(), target.m_20148_());
            reverseLookup.put(target.m_20148_(), player.m_20148_());
            chokeTicks.put(player.m_20148_(), 0);
            Vec3 targetLook = target.m_20154_().m_82541_();
            Vec3 behindPos = target.m_20182_().m_82546_(targetLook.m_82490_(0.6));
            player.m_6021_(behindPos.f_82479_, behindPos.f_82480_, behindPos.f_82481_);
            player.m_146922_(target.m_146908_());
            player.m_146926_(target.m_146909_());
            break;
        }
    }

    private static void stopChoking(ServerPlayer player) {
        if (player != null) {
            UUID targetUUID = chokingTargets.remove(player.m_20148_());
            if (targetUUID != null) {
                ChokeEventHandler.restoreMob(player.m_9236_(), targetUUID);
                reverseLookup.remove(targetUUID);
            }
            chokeTicks.remove(player.m_20148_());
        }
    }

    private static void restoreMob(Level level, UUID targetUUID) {
        ServerLevel serverLevel;
        Entity targetEntity;
        if (level instanceof ServerLevel && (targetEntity = (serverLevel = (ServerLevel)level).m_8791_(targetUUID)) instanceof Mob) {
            Mob mob = (Mob)targetEntity;
            mob.m_21557_(false);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        chokingTargets.forEach((playerUUID, targetUUID) -> {
            Mob mob;
            LivingEntity target;
            ServerPlayer player = event.getServer().m_6846_().m_11259_(playerUUID);
            if (player == null) {
                ChokeEventHandler.restoreMob((Level)event.getServer().m_129783_(), targetUUID);
                chokingTargets.remove(playerUUID);
                reverseLookup.remove(targetUUID);
                chokeTicks.remove(playerUUID);
                return;
            }
            Level patt3965$temp = player.m_9236_();
            if (!(patt3965$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt3965$temp;
            Entity targetEntity = serverLevel.m_8791_(targetUUID);
            if (!(targetEntity instanceof LivingEntity) || !(target = (LivingEntity)targetEntity).m_6084_() || target.m_9236_() != player.m_9236_()) {
                ChokeEventHandler.stopChoking(player);
                return;
            }
            player.m_20334_(0.0, 0.0, 0.0);
            target.m_20334_(0.0, 0.0, 0.0);
            if (target instanceof Mob && !(mob = (Mob)target).m_21525_()) {
                mob.m_21557_(true);
            }
            Vec3 targetLook = target.m_20154_().m_82541_();
            Vec3 behindPos = target.m_20182_().m_82546_(targetLook.m_82490_(0.6));
            double shakeX = (Math.random() - 0.5) * 0.05;
            double shakeZ = (Math.random() - 0.5) * 0.05;
            target.m_6034_(target.m_20185_() + shakeX, target.m_20186_(), target.m_20189_() + shakeZ);
            player.m_6034_(behindPos.f_82479_, behindPos.f_82480_, behindPos.f_82481_);
            player.m_146922_(target.m_146908_());
            player.m_146926_(target.m_146909_());
            int ticks = chokeTicks.getOrDefault(playerUUID, 0) + 1;
            if (ticks % 5 == 0) {
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                player.m_21011_(InteractionHand.OFF_HAND, true);
            }
            if (ticks >= 20) {
                float damageAmount = 1.0f + (float)(Math.random() * 2.0);
                float newHealth = target.m_21223_() - damageAmount;
                target.m_21153_(Math.max(0.0f, newHealth));
                target.m_6469_(player.m_269291_().m_269264_(), 0.01f);
                target.f_19802_ = 0;
                if (target.m_21223_() <= 0.0f) {
                    target.m_6667_(player.m_269291_().m_269075_((Player)player));
                    ChokeEventHandler.stopChoking(player);
                }
                ticks = 0;
            }
            chokeTicks.put((UUID)playerUUID, ticks);
        });
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        if (reverseLookup.containsKey(event.getEntity().m_20148_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (reverseLookup.containsKey(event.getEntity().m_20148_())) {
            event.setCanceled(true);
        }
    }
}

