/*
 * Decompiled with CFR 0.152.
 */
package net.manus.chokemod.network;

import java.util.function.Supplier;
import net.manus.chokemod.ChokeEventHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ChokePacket {
    private final boolean pressing;

    public ChokePacket(boolean pressing) {
        this.pressing = pressing;
    }

    public static ChokePacket decode(FriendlyByteBuf buf) {
        return new ChokePacket(buf.readBoolean());
    }

    public static void encode(ChokePacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.pressing);
    }

    public static void handle(ChokePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ChokeEventHandler.handleChokeInput(player, msg.pressing);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

