/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nesquik.crosshair.NesquikCrosshairMod;
import com.nesquik.crosshair.crosshair.CrosshairType;
import com.nesquik.crosshair.crosshair.CustomCrosshair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class CrosshairConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "nesquikcrosshair.json";
    private boolean enabled = true;
    private CrosshairType crosshairType = CrosshairType.DEFAULT;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;
    private float scale = 1.0f;
    private List<CustomCrosshair> customCrosshairs = new ArrayList<CustomCrosshair>();
    private int selectedCustomIndex = 0;
    private String selectedImageFile = "";
    private boolean entityTargetColorEnabled = false;
    private int entityTargetRed = 255;
    private int entityTargetGreen = 0;
    private int entityTargetBlue = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CrosshairConfig load() {
        Path configPath = CrosshairConfig.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                CrosshairConfig config = (CrosshairConfig)GSON.fromJson((Reader)reader, CrosshairConfig.class);
                if (config != null) {
                    config.validateAfterLoad();
                    NesquikCrosshairMod.LOGGER.info("Config loaded successfully");
                    CrosshairConfig crosshairConfig = config;
                    return crosshairConfig;
                }
            }
            catch (Exception e) {
                NesquikCrosshairMod.LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
        CrosshairConfig config = new CrosshairConfig();
        config.save();
        return config;
    }

    public void save() {
        Path configPath = CrosshairConfig.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
                NesquikCrosshairMod.LOGGER.info("Config saved successfully");
            }
        }
        catch (Exception e) {
            NesquikCrosshairMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE);
    }

    private void validateAfterLoad() {
        if (this.customCrosshairs == null) {
            this.customCrosshairs = new ArrayList<CustomCrosshair>();
        }
        if (this.selectedCustomIndex < 0 || this.selectedCustomIndex >= Math.max(1, this.customCrosshairs.size())) {
            this.selectedCustomIndex = 0;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CrosshairType getCrosshairType() {
        return this.crosshairType;
    }

    public void setCrosshairType(CrosshairType crosshairType) {
        this.crosshairType = crosshairType;
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = Math.max(0, Math.min(255, red));
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = Math.max(0, Math.min(255, green));
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = Math.max(0, Math.min(255, blue));
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = Math.max(0, Math.min(255, alpha));
    }

    public int getColorWithAlpha() {
        return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
    }

    public void setColor(int red, int green, int blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = Math.max(0.5f, Math.min(3.0f, scale));
    }

    public List<CustomCrosshair> getCustomCrosshairs() {
        return Collections.unmodifiableList(this.customCrosshairs);
    }

    public void addCustomCrosshair(CustomCrosshair crosshair) {
        this.customCrosshairs.add(crosshair);
    }

    public void removeCustomCrosshair(int index) {
        if (index >= 0 && index < this.customCrosshairs.size()) {
            this.customCrosshairs.remove(index);
            if (this.selectedCustomIndex >= this.customCrosshairs.size()) {
                this.selectedCustomIndex = Math.max(0, this.customCrosshairs.size() - 1);
            }
        }
    }

    public void replaceCustomCrosshair(int index, CustomCrosshair crosshair) {
        if (index >= 0 && index < this.customCrosshairs.size()) {
            this.customCrosshairs.set(index, crosshair);
        }
    }

    public CustomCrosshair getCustomCrosshair() {
        if (this.customCrosshairs.isEmpty() || this.selectedCustomIndex >= this.customCrosshairs.size()) {
            return null;
        }
        return this.customCrosshairs.get(this.selectedCustomIndex);
    }

    public int getSelectedCustomIndex() {
        return this.selectedCustomIndex;
    }

    public void setSelectedCustomIndex(int index) {
        this.selectedCustomIndex = index;
    }

    public boolean isEntityTargetColorEnabled() {
        return this.entityTargetColorEnabled;
    }

    public void setEntityTargetColorEnabled(boolean enabled) {
        this.entityTargetColorEnabled = enabled;
    }

    public int getEntityTargetRed() {
        return this.entityTargetRed;
    }

    public void setEntityTargetRed(int red) {
        this.entityTargetRed = Math.max(0, Math.min(255, red));
    }

    public int getEntityTargetGreen() {
        return this.entityTargetGreen;
    }

    public void setEntityTargetGreen(int green) {
        this.entityTargetGreen = Math.max(0, Math.min(255, green));
    }

    public int getEntityTargetBlue() {
        return this.entityTargetBlue;
    }

    public void setEntityTargetBlue(int blue) {
        this.entityTargetBlue = Math.max(0, Math.min(255, blue));
    }

    public int getEntityTargetColorWithAlpha() {
        return this.alpha << 24 | this.entityTargetRed << 16 | this.entityTargetGreen << 8 | this.entityTargetBlue;
    }

    public void setEntityTargetColor(int red, int green, int blue) {
        this.setEntityTargetRed(red);
        this.setEntityTargetGreen(green);
        this.setEntityTargetBlue(blue);
    }

    public String getSelectedImageFile() {
        return this.selectedImageFile != null ? this.selectedImageFile : "";
    }

    public void setSelectedImageFile(String file) {
        this.selectedImageFile = file != null ? file : "";
    }
}

