/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.crosshair;

import com.nesquik.crosshair.NesquikCrosshairMod;
import com.nesquik.crosshair.config.CrosshairConfig;
import com.nesquik.crosshair.crosshair.CrosshairType;
import com.nesquik.crosshair.crosshair.CustomCrosshair;
import com.nesquik.crosshair.crosshair.ImageCrosshairData;
import com.nesquik.crosshair.crosshair.ImageCrosshairManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_5498;

public class CrosshairRenderer {
    private static final int MAX_CROSSHAIR_SIZE = 32;

    public static void renderAt(class_332 context, int centerX, int centerY, CrosshairType type, int color, int scale, CustomCrosshair custom) {
        CrosshairRenderer.renderAt(context, centerX, centerY, type, color, scale, custom, null);
    }

    public static void renderAt(class_332 context, int centerX, int centerY, CrosshairType type, int color, int scale, CustomCrosshair custom, String imageFile) {
        int s = Math.max(1, scale);
        switch (type) {
            case DEFAULT: {
                CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
                break;
            }
            case DOT: {
                CrosshairRenderer.renderDot(context, centerX, centerY, color, s);
                break;
            }
            case CIRCLE: {
                CrosshairRenderer.renderCircle(context, centerX, centerY, color, s);
                break;
            }
            case CROSS_DOT: {
                CrosshairRenderer.renderCrossDot(context, centerX, centerY, color, s);
                break;
            }
            case TRIANGLE: {
                CrosshairRenderer.renderTriangle(context, centerX, centerY, color, s);
                break;
            }
            case DIAMOND: {
                CrosshairRenderer.renderDiamond(context, centerX, centerY, color, s);
                break;
            }
            case PLUS: {
                CrosshairRenderer.renderPlus(context, centerX, centerY, color, s);
                break;
            }
            case X_SHAPE: {
                CrosshairRenderer.renderXShape(context, centerX, centerY, color, s);
                break;
            }
            case SQUARE: {
                CrosshairRenderer.renderSquare(context, centerX, centerY, color, s);
                break;
            }
            case IMAGE: {
                String file = imageFile != null ? imageFile : NesquikCrosshairMod.getConfig().getSelectedImageFile();
                ImageCrosshairData data = ImageCrosshairManager.getInstance().getLoadedImage(file);
                if (data != null) {
                    CrosshairRenderer.renderImageDirect(context, centerX, centerY, data, s, color);
                    break;
                }
                CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
                break;
            }
            case CUSTOM: {
                if (custom != null) {
                    CrosshairRenderer.renderCustomDirect(context, centerX, centerY, custom, s, color);
                    break;
                }
                CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
            }
        }
    }

    public static void render(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        CrosshairConfig config = NesquikCrosshairMod.getConfig();
        if (!config.isEnabled()) {
            return;
        }
        if (client.field_1690.method_31044() != class_5498.field_26664) {
            return;
        }
        if (client.field_1724.method_7325() && (client.field_1765 == null || client.field_1765.method_17783() == class_239.class_240.field_1333)) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int color = config.isEntityTargetColorEnabled() && CrosshairRenderer.isTargetingEntity(client) ? config.getEntityTargetColorWithAlpha() : config.getColorWithAlpha();
        float scale = config.getScale();
        int s = Math.max(1, Math.round(scale));
        switch (config.getCrosshairType()) {
            case DEFAULT: {
                CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
                break;
            }
            case DOT: {
                CrosshairRenderer.renderDot(context, centerX, centerY, color, s);
                break;
            }
            case CIRCLE: {
                CrosshairRenderer.renderCircle(context, centerX, centerY, color, s);
                break;
            }
            case CROSS_DOT: {
                CrosshairRenderer.renderCrossDot(context, centerX, centerY, color, s);
                break;
            }
            case TRIANGLE: {
                CrosshairRenderer.renderTriangle(context, centerX, centerY, color, s);
                break;
            }
            case DIAMOND: {
                CrosshairRenderer.renderDiamond(context, centerX, centerY, color, s);
                break;
            }
            case PLUS: {
                CrosshairRenderer.renderPlus(context, centerX, centerY, color, s);
                break;
            }
            case X_SHAPE: {
                CrosshairRenderer.renderXShape(context, centerX, centerY, color, s);
                break;
            }
            case SQUARE: {
                CrosshairRenderer.renderSquare(context, centerX, centerY, color, s);
                break;
            }
            case IMAGE: {
                ImageCrosshairData data = ImageCrosshairManager.getInstance().getLoadedImage(config.getSelectedImageFile());
                if (data != null) {
                    CrosshairRenderer.renderImageDirect(context, centerX, centerY, data, s, color);
                    break;
                }
                CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
                break;
            }
            case CUSTOM: {
                CustomCrosshair custom = config.getCustomCrosshair();
                if (custom != null) {
                    boolean useOverride = config.isEntityTargetColorEnabled() && color != config.getColorWithAlpha();
                    CrosshairRenderer.renderCustomDirect(context, centerX, centerY, custom, s, useOverride ? color : 0);
                    break;
                }
                CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
            }
        }
    }

    private static boolean isTargetingEntity(class_310 client) {
        class_239 hitResult = client.field_1765;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331) {
            class_3966 entityHit = (class_3966)hitResult;
            class_1297 entity = entityHit.method_17782();
            return entity instanceof class_1309;
        }
        return false;
    }

    private static void renderDefault(class_332 context, int centerX, int centerY, int color, int s) {
        int length = 6 * s;
        int thickness = Math.max(1, s);
        int gap = 2 * s;
        int halfThick = thickness / 2;
        context.method_25294(centerX - length - gap, centerY - halfThick, centerX - gap, centerY - halfThick + thickness, color);
        context.method_25294(centerX + gap, centerY - halfThick, centerX + length + gap, centerY - halfThick + thickness, color);
        context.method_25294(centerX - halfThick, centerY - length - gap, centerX - halfThick + thickness, centerY - gap, color);
        context.method_25294(centerX - halfThick, centerY + gap, centerX - halfThick + thickness, centerY + length + gap, color);
    }

    private static void renderDot(class_332 context, int centerX, int centerY, int color, int s) {
        int size = Math.max(2, 2 * s);
        int half = size / 2;
        context.method_25294(centerX - half, centerY - half, centerX - half + size, centerY - half + size, color);
    }

    private static void renderCircle(class_332 context, int centerX, int centerY, int color, int s) {
        int radius = 5 * s;
        int thickness = Math.max(1, s);
        int halfT = thickness / 2;
        int y = radius;
        int d = 1 - radius;
        for (int x = 0; x <= y; ++x) {
            CrosshairRenderer.drawCircleOctants(context, centerX, centerY, x, y, halfT, thickness, color);
            if (d < 0) {
                d += 2 * x + 3;
                continue;
            }
            d += 2 * (x - y) + 5;
            --y;
        }
    }

    private static void drawCircleOctants(class_332 ctx, int cx, int cy, int x, int y, int ht, int t, int color) {
        ctx.method_25294(cx + x - ht, cy + y - ht, cx + x - ht + t, cy + y - ht + t, color);
        ctx.method_25294(cx - x - ht, cy + y - ht, cx - x - ht + t, cy + y - ht + t, color);
        ctx.method_25294(cx + x - ht, cy - y - ht, cx + x - ht + t, cy - y - ht + t, color);
        ctx.method_25294(cx - x - ht, cy - y - ht, cx - x - ht + t, cy - y - ht + t, color);
        ctx.method_25294(cx + y - ht, cy + x - ht, cx + y - ht + t, cy + x - ht + t, color);
        ctx.method_25294(cx - y - ht, cy + x - ht, cx - y - ht + t, cy + x - ht + t, color);
        ctx.method_25294(cx + y - ht, cy - x - ht, cx + y - ht + t, cy - x - ht + t, color);
        ctx.method_25294(cx - y - ht, cy - x - ht, cx - y - ht + t, cy - x - ht + t, color);
    }

    private static void renderCrossDot(class_332 context, int centerX, int centerY, int color, int s) {
        CrosshairRenderer.renderDefault(context, centerX, centerY, color, s);
        int dotSize = Math.max(1, s);
        int half = dotSize / 2;
        context.method_25294(centerX - half, centerY - half, centerX - half + dotSize, centerY - half + dotSize, color);
    }

    private static void renderTriangle(class_332 context, int centerX, int centerY, int color, int s) {
        int size = 5 * s;
        int thickness = Math.max(1, s);
        context.method_25294(centerX - thickness / 2, centerY - size, centerX + thickness / 2 + 1, centerY - size + thickness, color);
        context.method_25294(centerX - size, centerY + size - thickness + 1, centerX + size + 1, centerY + size + 1, color);
        for (int i = 0; i <= size; i += Math.max(1, s / 2 + 1)) {
            int yOffset = size - i;
            context.method_25294(centerX - size + i, centerY + yOffset, centerX - size + i + thickness, centerY + yOffset + thickness, color);
            context.method_25294(centerX + size - i - thickness + 1, centerY + yOffset, centerX + size - i + 1, centerY + yOffset + thickness, color);
        }
    }

    private static void renderDiamond(class_332 context, int centerX, int centerY, int color, int s) {
        int size = 5 * s;
        int thickness = Math.max(1, s);
        for (int i = 0; i <= size; i += Math.max(1, s / 2 + 1)) {
            context.method_25294(centerX + i, centerY - size + i, centerX + i + thickness, centerY - size + i + thickness, color);
            context.method_25294(centerX - i - thickness + 1, centerY - size + i, centerX - i + 1, centerY - size + i + thickness, color);
            context.method_25294(centerX + i, centerY + size - i - thickness + 1, centerX + i + thickness, centerY + size - i + 1, color);
            context.method_25294(centerX - i - thickness + 1, centerY + size - i - thickness + 1, centerX - i + 1, centerY + size - i + 1, color);
        }
    }

    private static void renderPlus(class_332 context, int centerX, int centerY, int color, int s) {
        int length = 6 * s;
        int thickness = 3 * s;
        int halfThick = thickness / 2;
        context.method_25294(centerX - length, centerY - halfThick, centerX + length, centerY - halfThick + thickness, color);
        context.method_25294(centerX - halfThick, centerY - length, centerX - halfThick + thickness, centerY + length, color);
    }

    private static void renderXShape(class_332 context, int centerX, int centerY, int color, int s) {
        int size = 5 * s;
        int thickness = Math.max(1, s);
        for (int i = -size; i <= size; i += Math.max(1, s / 2 + 1)) {
            context.method_25294(centerX + i, centerY + i, centerX + i + thickness, centerY + i + thickness, color);
            context.method_25294(centerX + i, centerY - i, centerX + i + thickness, centerY - i + thickness, color);
        }
    }

    private static void renderSquare(class_332 context, int centerX, int centerY, int color, int s) {
        int size = 4 * s;
        int thickness = Math.max(1, s);
        context.method_25294(centerX - size, centerY - size, centerX + size, centerY - size + thickness, color);
        context.method_25294(centerX - size, centerY + size - thickness + 1, centerX + size, centerY + size + 1, color);
        context.method_25294(centerX - size, centerY - size, centerX - size + thickness, centerY + size + 1, color);
        context.method_25294(centerX + size - thickness, centerY - size, centerX + size, centerY + size + 1, color);
    }

    private static void renderImageDirect(class_332 context, int centerX, int centerY, ImageCrosshairData data, int s, int color) {
        class_2960 textureId = data.getCurrentFrameId();
        int imgW = data.getWidth();
        int imgH = data.getHeight();
        int maxDim = Math.max(imgW, imgH);
        float autoScale = 1.0f;
        if (maxDim > 32) {
            autoScale = 32.0f / (float)maxDim;
        }
        int w = Math.max(1, Math.round((float)imgW * autoScale * (float)s));
        int h = Math.max(1, Math.round((float)imgH * autoScale * (float)s));
        int x = centerX - w / 2;
        int y = centerY - h / 2;
        int alpha = color >> 24 & 0xFF;
        int tintColor = alpha << 24 | 0xFFFFFF;
        context.method_25291(class_1921::method_62277, textureId, x, y, 0.0f, 0.0f, w, h, w, h, tintColor);
    }

    private static void renderCustomDirect(class_332 context, int centerX, int centerY, CustomCrosshair custom, int s, int overrideColor) {
        int[][] pixels = custom.getPixels();
        int offsetX = centerX - 8 * s;
        int offsetY = centerY - 8 * s;
        for (int y = 0; y < 16; ++y) {
            int x = 0;
            while (x < 16) {
                int nextPixel;
                int spanEnd;
                int pixelColor = pixels[y][x];
                if (pixelColor == 0) {
                    ++x;
                    continue;
                }
                int finalColor = overrideColor != 0 ? overrideColor : pixelColor;
                for (spanEnd = x + 1; spanEnd < 16 && (nextPixel = pixels[y][spanEnd]) != 0; ++spanEnd) {
                    int nextFinal;
                    int n = nextFinal = overrideColor != 0 ? overrideColor : nextPixel;
                    if (nextFinal != finalColor) break;
                }
                int px = offsetX + x * s;
                int py = offsetY + y * s;
                context.method_25294(px, py, offsetX + spanEnd * s, py + s, finalColor);
                x = spanEnd;
            }
        }
    }
}

