/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.crosshair;

import java.util.Arrays;

public class CustomCrosshair {
    private String name;
    private int[][] pixels;

    public CustomCrosshair(String name) {
        this.name = name;
        this.pixels = new int[16][16];
    }

    public CustomCrosshair(String name, int[][] pixels) {
        this.name = name;
        this.pixels = pixels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[][] getPixels() {
        return this.pixels;
    }

    public void setPixel(int x, int y, int color) {
        if (x >= 0 && x < 16 && y >= 0 && y < 16) {
            this.pixels[y][x] = color;
        }
    }

    public int getPixel(int x, int y) {
        if (x >= 0 && x < 16 && y >= 0 && y < 16) {
            return this.pixels[y][x];
        }
        return 0;
    }

    public void clear() {
        for (int[] row : this.pixels) {
            Arrays.fill(row, 0);
        }
    }

    public CustomCrosshair copy() {
        int[][] newPixels = new int[16][16];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(this.pixels[i], 0, newPixels[i], 0, 16);
        }
        return new CustomCrosshair(this.name, newPixels);
    }
}

