/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.crosshair;

import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageCrosshairData {
    private final String fileName;
    private final List<class_2960> frameIds;
    private final List<Integer> frameDelaysMs;
    private final int width;
    private final int height;
    private final long totalDurationMs;

    public ImageCrosshairData(String fileName, List<class_2960> frameIds, List<Integer> frameDelaysMs, int width, int height) {
        this.fileName = fileName;
        this.frameIds = frameIds;
        this.frameDelaysMs = frameDelaysMs;
        this.width = width;
        this.height = height;
        long total = 0L;
        for (int d : frameDelaysMs) {
            total += (long)d;
        }
        this.totalDurationMs = total > 0L ? total : 1L;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isAnimated() {
        return this.frameIds.size() > 1;
    }

    public int getFrameCount() {
        return this.frameIds.size();
    }

    public class_2960 getCurrentFrameId() {
        if (this.frameIds.size() == 1) {
            return this.frameIds.get(0);
        }
        long time = System.currentTimeMillis() % this.totalDurationMs;
        long elapsed = 0L;
        for (int i = 0; i < this.frameIds.size(); ++i) {
            if (time >= (elapsed += (long)this.frameDelaysMs.get(i).intValue())) continue;
            return this.frameIds.get(i);
        }
        return this.frameIds.get(0);
    }

    public void destroy(class_310 client) {
        for (class_2960 id : this.frameIds) {
            client.method_1531().method_4615(id);
        }
    }
}

