/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.crosshair;

import com.nesquik.crosshair.NesquikCrosshairMod;
import com.nesquik.crosshair.crosshair.ImageCrosshairData;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.w3c.dom.Node;

public class ImageCrosshairManager {
    private static final ImageCrosshairManager INSTANCE = new ImageCrosshairManager();
    private static final int MAX_SIZE = 128;
    private static final int MAX_GIF_FRAMES = 100;
    private final Map<String, ImageCrosshairData> cache = new HashMap<String, ImageCrosshairData>();
    private final Set<String> failedFiles = new HashSet<String>();
    private List<String> availableFiles = new ArrayList<String>();
    private Path imagesFolder;
    private boolean initialized = false;

    public static ImageCrosshairManager getInstance() {
        return INSTANCE;
    }

    public void ensureInitialized() {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() {
        this.imagesFolder = FabricLoader.getInstance().getConfigDir().resolve("nesquikcrosshair").resolve("images");
        try {
            Files.createDirectories(this.imagesFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            NesquikCrosshairMod.LOGGER.error("Failed to create images folder", (Throwable)e);
        }
        this.scanFolder();
        this.initialized = true;
    }

    public void scanFolder() {
        if (this.imagesFolder == null) {
            return;
        }
        this.availableFiles.clear();
        if (!Files.exists(this.imagesFolder, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.imagesFolder);){
            for (Path entry : stream) {
                String name = entry.getFileName().toString().toLowerCase();
                if (!name.endsWith(".png") && !name.endsWith(".gif") && !name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".bmp")) continue;
                this.availableFiles.add(entry.getFileName().toString());
            }
            Collections.sort(this.availableFiles, String.CASE_INSENSITIVE_ORDER);
        }
        catch (IOException e) {
            NesquikCrosshairMod.LOGGER.error("Failed to scan images folder", (Throwable)e);
        }
    }

    public List<String> getAvailableFiles() {
        this.ensureInitialized();
        return Collections.unmodifiableList(this.availableFiles);
    }

    public ImageCrosshairData getLoadedImage(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        this.ensureInitialized();
        if (this.cache.containsKey(fileName)) {
            return this.cache.get(fileName);
        }
        if (this.failedFiles.contains(fileName)) {
            return null;
        }
        Path filePath = this.imagesFolder.resolve(fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return null;
        }
        try {
            ImageCrosshairData data = fileName.toLowerCase().endsWith(".gif") ? this.loadGif(fileName, filePath) : this.loadStaticImage(fileName, filePath);
            if (data != null) {
                this.cache.put(fileName, data);
                NesquikCrosshairMod.LOGGER.info("Loaded image crosshair: {} ({}x{}, {} frames)", new Object[]{fileName, data.getWidth(), data.getHeight(), data.getFrameCount()});
            } else {
                this.failedFiles.add(fileName);
                NesquikCrosshairMod.LOGGER.warn("Could not load image crosshair: {}", (Object)fileName);
            }
            return data;
        }
        catch (Exception e) {
            this.failedFiles.add(fileName);
            NesquikCrosshairMod.LOGGER.error("Failed to load image crosshair: " + fileName, (Throwable)e);
            return null;
        }
    }

    private ImageCrosshairData loadStaticImage(String fileName, Path filePath) throws IOException {
        class_1011 nativeImage;
        BufferedImage original = ImageIO.read(filePath.toFile());
        if (original == null) {
            NesquikCrosshairMod.LOGGER.warn("ImageIO could not read file: {} (unsupported format?)", (Object)fileName);
            return null;
        }
        int w = original.getWidth();
        int h = original.getHeight();
        if (w > 128 || h > 128) {
            NesquikCrosshairMod.LOGGER.info("Image {} is large ({}x{}), resizing to fit {}x{}", new Object[]{fileName, w, h, 128, 128});
            original = this.resizeImage(original, 128);
            w = original.getWidth();
            h = original.getHeight();
        }
        if ((nativeImage = this.bufferedImageToNative(original)) == null) {
            return null;
        }
        class_2960 id = this.createSafeIdentifier("img/" + this.sanitize(fileName));
        if (id == null) {
            nativeImage.close();
            return null;
        }
        class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(nativeImage));
        return new ImageCrosshairData(fileName, List.of(id), List.of(Integer.valueOf(0)), w, h);
    }

    private ImageCrosshairData loadGif(String fileName, Path filePath) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
        if (!readers.hasNext()) {
            NesquikCrosshairMod.LOGGER.error("No GIF ImageReader available");
            return null;
        }
        ImageReader reader = readers.next();
        try {
            ImageCrosshairData imageCrosshairData;
            block26: {
                ArrayList<Integer> delays;
                ArrayList<class_2960> frameIds;
                int height;
                int width;
                ImageInputStream iis;
                block24: {
                    ImageCrosshairData imageCrosshairData2;
                    block25: {
                        int numFrames;
                        block22: {
                            ImageCrosshairData imageCrosshairData3;
                            block23: {
                                iis = ImageIO.createImageInputStream(filePath.toFile());
                                reader.setInput(iis, false, false);
                                numFrames = reader.getNumImages(true);
                                if (numFrames != 0) break block22;
                                imageCrosshairData3 = null;
                                if (iis == null) break block23;
                                iis.close();
                            }
                            return imageCrosshairData3;
                        }
                        try {
                            numFrames = Math.min(numFrames, 100);
                            int origWidth = reader.getWidth(0);
                            int origHeight = reader.getHeight(0);
                            boolean needsResize = origWidth > 128 || origHeight > 128;
                            float resizeRatio = 1.0f;
                            if (needsResize) {
                                resizeRatio = 128.0f / (float)Math.max(origWidth, origHeight);
                                NesquikCrosshairMod.LOGGER.info("GIF {} is large ({}x{}), will resize frames to fit {}x{}", new Object[]{fileName, origWidth, origHeight, 128, 128});
                            }
                            width = needsResize ? Math.round((float)origWidth * resizeRatio) : origWidth;
                            height = needsResize ? Math.round((float)origHeight * resizeRatio) : origHeight;
                            frameIds = new ArrayList<class_2960>();
                            delays = new ArrayList<Integer>();
                            BufferedImage canvas = new BufferedImage(origWidth, origHeight, 2);
                            BufferedImage previousCanvas = null;
                            for (int i = 0; i < numFrames; ++i) {
                                try {
                                    BufferedImage frame = reader.read(i);
                                    IIOMetadata metadata = reader.getImageMetadata(i);
                                    String disposal = this.getDisposalMethod(metadata);
                                    Point offset = this.getFrameOffset(metadata);
                                    if ("restoreToPrevious".equals(disposal)) {
                                        previousCanvas = this.copyImage(canvas);
                                    }
                                    Graphics2D g = canvas.createGraphics();
                                    g.setComposite(AlphaComposite.SrcOver);
                                    g.drawImage((Image)frame, offset.x, offset.y, null);
                                    g.dispose();
                                    BufferedImage frameOut = needsResize ? this.resizeImage(canvas, 128) : canvas;
                                    class_1011 nativeImage = this.bufferedImageToNative(frameOut);
                                    if (nativeImage == null) {
                                        NesquikCrosshairMod.LOGGER.warn("Failed to convert GIF frame {} of {}", (Object)i, (Object)fileName);
                                        continue;
                                    }
                                    String sanitized = this.sanitize(fileName);
                                    class_2960 id = this.createSafeIdentifier("gif/" + sanitized + "/f" + i);
                                    if (id == null) {
                                        nativeImage.close();
                                        continue;
                                    }
                                    class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(nativeImage));
                                    frameIds.add(id);
                                    delays.add(this.getFrameDelay(reader, i));
                                    if ("restoreToBackgroundColor".equals(disposal)) {
                                        Graphics2D g2 = canvas.createGraphics();
                                        g2.setComposite(AlphaComposite.Clear);
                                        g2.fillRect(offset.x, offset.y, frame.getWidth(), frame.getHeight());
                                        g2.dispose();
                                        continue;
                                    }
                                    if (!"restoreToPrevious".equals(disposal) || previousCanvas == null) continue;
                                    canvas = previousCanvas;
                                    continue;
                                }
                                catch (Exception e) {
                                    NesquikCrosshairMod.LOGGER.warn("Failed to read GIF frame {} of {}: {}", new Object[]{i, fileName, e.getMessage()});
                                }
                            }
                            if (!frameIds.isEmpty()) break block24;
                            imageCrosshairData2 = null;
                            if (iis == null) break block25;
                        }
                        catch (Throwable throwable) {
                            if (iis != null) {
                                try {
                                    iis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        iis.close();
                    }
                    return imageCrosshairData2;
                }
                imageCrosshairData = new ImageCrosshairData(fileName, frameIds, delays, width, height);
                if (iis == null) break block26;
                iis.close();
            }
            return imageCrosshairData;
        }
        finally {
            reader.dispose();
        }
    }

    private int getFrameDelay(ImageReader reader, int frameIndex) {
        try {
            String delayStr;
            IIOMetadata metadata = reader.getImageMetadata(frameIndex);
            String formatName = metadata.getNativeMetadataFormatName();
            IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(formatName);
            IIOMetadataNode gce = this.findNode(root, "GraphicControlExtension");
            if (gce != null && (delayStr = gce.getAttribute("delayTime")) != null) {
                int delay = Integer.parseInt(delayStr) * 10;
                return Math.max(delay, 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 100;
    }

    private IIOMetadataNode findNode(IIOMetadataNode root, String nodeName) {
        int length = root.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = root.item(i);
            if (!(node instanceof IIOMetadataNode)) continue;
            IIOMetadataNode node2 = (IIOMetadataNode)node;
            if (node2.getNodeName().equals(nodeName)) {
                return node2;
            }
            IIOMetadataNode found = this.findNode(node2, nodeName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private class_1011 bufferedImageToNative(BufferedImage original) {
        class_1011 class_10112;
        BufferedImage argb = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Graphics2D g = argb.createGraphics();
        g.drawImage((Image)original, 0, 0, null);
        g.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)argb, "PNG", baos);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        try {
            class_10112 = class_1011.method_4309((InputStream)bis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)bis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                NesquikCrosshairMod.LOGGER.error("Failed to convert image to NativeImage", (Throwable)e);
                return null;
            }
        }
        ((InputStream)bis).close();
        return class_10112;
    }

    private class_2960 createSafeIdentifier(String path) {
        try {
            return class_2960.method_60655((String)"nesquikcrosshair", (String)path);
        }
        catch (Exception e) {
            NesquikCrosshairMod.LOGGER.error("Invalid identifier path: {}", (Object)path, (Object)e);
            return null;
        }
    }

    private String getDisposalMethod(IIOMetadata metadata) {
        try {
            String formatName = metadata.getNativeMetadataFormatName();
            IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(formatName);
            IIOMetadataNode gce = this.findNode(root, "GraphicControlExtension");
            if (gce != null) {
                return gce.getAttribute("disposalMethod");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "none";
    }

    private Point getFrameOffset(IIOMetadata metadata) {
        try {
            String formatName = metadata.getNativeMetadataFormatName();
            IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(formatName);
            IIOMetadataNode desc = this.findNode(root, "ImageDescriptor");
            if (desc != null) {
                int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                return new Point(x, y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Point(0, 0);
    }

    private BufferedImage copyImage(BufferedImage src) {
        BufferedImage copy = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        int[] pixels = src.getRGB(0, 0, src.getWidth(), src.getHeight(), null, 0, src.getWidth());
        copy.setRGB(0, 0, src.getWidth(), src.getHeight(), pixels, 0, src.getWidth());
        return copy;
    }

    private BufferedImage resizeImage(BufferedImage src, int maxDim) {
        int w = src.getWidth();
        int h = src.getHeight();
        float ratio = (float)maxDim / (float)Math.max(w, h);
        int newW = Math.max(1, Math.round((float)w * ratio));
        int newH = Math.max(1, Math.round((float)h * ratio));
        BufferedImage resized = new BufferedImage(newW, newH, 2);
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawImage(src, 0, 0, newW, newH, null);
        g.dispose();
        return resized;
    }

    private String sanitize(String name) {
        Object result = name.toLowerCase().replaceAll("[^a-z0-9_/\\-.]", "_");
        if (!((String)result).isEmpty() && !Character.isLetter(((String)result).charAt(0))) {
            result = "f" + (String)result;
        }
        return result;
    }

    public void clearCache() {
        class_310 client = class_310.method_1551();
        for (ImageCrosshairData data : this.cache.values()) {
            data.destroy(client);
        }
        this.cache.clear();
    }

    public void refresh() {
        this.clearCache();
        this.failedFiles.clear();
        this.scanFolder();
    }

    public Path getImagesFolder() {
        this.ensureInitialized();
        return this.imagesFolder;
    }
}

