/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.gui;

import com.nesquik.crosshair.NesquikCrosshairMod;
import com.nesquik.crosshair.config.CrosshairConfig;
import com.nesquik.crosshair.crosshair.CrosshairType;
import com.nesquik.crosshair.crosshair.CustomCrosshair;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class CrosshairEditorScreen
extends class_437 {
    private final class_437 parent;
    private final CrosshairConfig config;
    private CustomCrosshair editingCrosshair;
    private class_342 nameField;
    private static final int BG_DARK = -267909112;
    private static final int BG_PANEL = -267382768;
    private static final int TEXT_WHITE = -1;
    private static final int TEXT_GRAY = -7829368;
    private static final int BORDER_COLOR = -13619152;
    private static final int BORDER_LIGHT = -12566464;
    private int selectedColor = -1;
    private int canvasX;
    private int canvasY;
    private static final int PIXEL_SIZE = 14;
    private static final int GRID_SIZE = 16;
    private static final int CANVAS_SIZE = 224;
    private static final int[] PALETTE_COLORS = new int[]{-1, -2236963, -4473925, -6710887, -8947849, -11184811, -13421773, -16777216, -65536, -16711936, -16776961, -256, -65281, -16711681, -30720, -7864065};
    private boolean isDrawing = false;
    private boolean isErasing = false;
    private final Deque<int[][]> undoStack = new ArrayDeque<int[][]>();
    private static final int MAX_UNDO = 50;
    private final int editIndex;

    public CrosshairEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.screen_title"));
        this.parent = parent;
        this.config = NesquikCrosshairMod.getConfig();
        this.editingCrosshair = new CustomCrosshair(class_2561.method_43471((String)"nesquikcrosshair.editor.default_name").getString());
        this.editIndex = -1;
    }

    public CrosshairEditorScreen(class_437 parent, CustomCrosshair existing, int index) {
        super((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.screen_title"));
        this.parent = parent;
        this.config = NesquikCrosshairMod.getConfig();
        this.editingCrosshair = existing.copy();
        this.editIndex = index;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        this.canvasX = centerX - 112 - 20;
        this.canvasY = 60;
        this.nameField = new class_342(this.field_22793, centerX - 80, 30, 160, 18, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.name"));
        this.nameField.method_1852(this.editingCrosshair.getName());
        this.nameField.method_1880(32);
        this.method_37063((class_364)this.nameField);
        int buttonY = this.canvasY + 224 + 25;
        int btnW = 75;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.clear"), button -> {
            this.saveUndoState();
            this.editingCrosshair.clear();
        }).method_46434(centerX - 193, buttonY, btnW, 22).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.fill"), button -> {
            this.saveUndoState();
            this.fillCanvas();
        }).method_46434(centerX - 115, buttonY, btnW, 22).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.invert"), button -> {
            this.saveUndoState();
            this.invertCanvas();
        }).method_46434(centerX - 37, buttonY, btnW, 22).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.center"), button -> {
            this.saveUndoState();
            this.drawCenterCross();
        }).method_46434(centerX + 41, buttonY, btnW, 22).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.undo"), button -> this.undo()).method_46434(centerX + 119, buttonY, btnW, 22).method_46431());
        int bottomY = this.field_22790 - 35;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.save"), button -> this.saveCustomCrosshair()).method_46434(centerX - 95, bottomY, 90, 22).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.cancel"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 5, bottomY, 90, 22).method_46431());
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -267909112);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.title"), centerX, 10, -1);
        context.method_25300(this.field_22793, "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", centerX, 20, -13619152);
        int panelLeft = this.canvasX - 15;
        int panelTop = this.canvasY - 10;
        int panelWidth = 404;
        int panelHeight = 254;
        this.drawPanel(context, panelLeft, panelTop, panelWidth, panelHeight);
        this.drawCanvasBorder(context, this.canvasX, this.canvasY, 224);
        this.drawCheckerboard(context, this.canvasX, this.canvasY, 224, 224, 14, -16119286, -15395563);
        for (int i = 0; i <= 16; ++i) {
            int lineColor = i == 8 ? -12566464 : -14671840;
            context.method_25294(this.canvasX + i * 14, this.canvasY, this.canvasX + i * 14 + 1, this.canvasY + 224, lineColor);
            context.method_25294(this.canvasX, this.canvasY + i * 14, this.canvasX + 224, this.canvasY + i * 14 + 1, lineColor);
        }
        int[][] pixels = this.editingCrosshair.getPixels();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                int color = pixels[y][x];
                if (color == 0) continue;
                int px = this.canvasX + x * 14 + 1;
                int py = this.canvasY + y * 14 + 1;
                context.method_25294(px, py, px + 14 - 1, py + 14 - 1, color);
            }
        }
        if (this.isMouseOverCanvas(mouseX, mouseY)) {
            int gridX = (mouseX - this.canvasX) / 14;
            int gridY = (mouseY - this.canvasY) / 14;
            if (gridX >= 0 && gridX < 16 && gridY >= 0 && gridY < 16) {
                int px = this.canvasX + gridX * 14;
                int py = this.canvasY + gridY * 14;
                context.method_25294(px, py, px + 14, py + 1, -3355444);
                context.method_25294(px, py + 14 - 1, px + 14, py + 14, -3355444);
                context.method_25294(px, py, px + 1, py + 14, -3355444);
                context.method_25294(px + 14 - 1, py, px + 14, py + 14, -3355444);
            }
        }
        int paletteX = this.canvasX + 224 + 25;
        int paletteY = this.canvasY + 5;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.colors"), paletteX, paletteY - 15, -7829368);
        for (int i = 0; i < PALETTE_COLORS.length; ++i) {
            int row = i / 4;
            int col = i % 4;
            int px = paletteX + col * 28;
            int py = paletteY + row * 28;
            if (PALETTE_COLORS[i] == this.selectedColor) {
                context.method_25294(px - 3, py - 3, px + 25, py + 25, -3355444);
            } else {
                context.method_25294(px - 1, py - 1, px + 23, py + 23, -13619152);
            }
            context.method_25294(px, py, px + 22, py + 22, PALETTE_COLORS[i]);
        }
        int previewX = paletteX + 20;
        int previewY = paletteY + 130;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.preview"), paletteX, previewY - 15, -7829368);
        this.drawPreviewBox(context, previewX - 20, previewY, 70, 70);
        int previewCenterX = previewX + 15;
        int previewCenterY = previewY + 35;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                int color = pixels[y][x];
                if (color == 0) continue;
                int px2 = previewCenterX - 8 + x;
                int py2 = previewCenterY - 8 + y;
                context.method_25294(px2, py2, px2 + 1, py2 + 1, color);
            }
        }
        int instructY = this.canvasY + 224 + 55;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.draw_hint"), this.canvasX, instructY, -7829368);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.erase_hint"), this.canvasX, instructY + 14, -7829368);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.undo_hint"), this.canvasX, instructY + 28, -7829368);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.current_color"), this.canvasX + 180, instructY, -7829368);
        context.method_25294(this.canvasX + 260, instructY - 2, this.canvasX + 290, instructY + 12, -13619152);
        context.method_25294(this.canvasX + 262, instructY, this.canvasX + 288, instructY + 10, this.selectedColor);
        for (class_364 drawable : this.method_25396()) {
            if (!(drawable instanceof class_4068)) continue;
            class_4068 d = (class_4068)drawable;
            d.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private void drawPanel(class_332 context, int x, int y, int width, int height) {
        context.method_25294(x - 1, y - 1, x + width + 1, y + height + 1, -13619152);
        context.method_25294(x, y, x + width, y + height, -267382768);
    }

    private void drawCanvasBorder(class_332 context, int x, int y, int size) {
        context.method_25294(x - 2, y - 2, x + size + 2, y + size + 2, -13619152);
        int corner = 6;
        context.method_25294(x - 2, y - 2, x - 2 + corner, y - 1, -12566464);
        context.method_25294(x - 2, y - 2, x - 1, y - 2 + corner, -12566464);
        context.method_25294(x + size + 2 - corner, y - 2, x + size + 2, y - 1, -12566464);
        context.method_25294(x + size + 1, y - 2, x + size + 2, y - 2 + corner, -12566464);
        context.method_25294(x - 2, y + size + 1, x - 2 + corner, y + size + 2, -12566464);
        context.method_25294(x - 2, y + size + 2 - corner, x - 1, y + size + 2, -12566464);
        context.method_25294(x + size + 2 - corner, y + size + 1, x + size + 2, y + size + 2, -12566464);
        context.method_25294(x + size + 1, y + size + 2 - corner, x + size + 2, y + size + 2, -12566464);
    }

    private void drawPreviewBox(class_332 context, int x, int y, int width, int height) {
        context.method_25294(x - 1, y - 1, x + width + 1, y + height + 1, -13619152);
        this.drawCheckerboard(context, x, y, width, height, 4, -15066598, -14013910);
    }

    private void drawCheckerboard(class_332 ctx, int x, int y, int w, int h, int cellSize, int color1, int color2) {
        int row = 0;
        while (row * cellSize < h) {
            int col = 0;
            while (col * cellSize < w) {
                int cx = x + col * cellSize;
                int cy = y + row * cellSize;
                int cw = Math.min(cellSize, x + w - cx);
                int ch = Math.min(cellSize, y + h - cy);
                int color = (row + col) % 2 == 0 ? color1 : color2;
                ctx.method_25294(cx, cy, cx + cw, cy + ch, color);
                ++col;
            }
            ++row;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int paletteX = this.canvasX + 224 + 25;
        int paletteY = this.canvasY + 5;
        for (int i = 0; i < PALETTE_COLORS.length; ++i) {
            int row = i / 4;
            int col = i % 4;
            int px = paletteX + col * 28;
            int py = paletteY + row * 28;
            if (!(mouseX >= (double)px) || !(mouseX < (double)(px + 22)) || !(mouseY >= (double)py) || !(mouseY < (double)(py + 22))) continue;
            this.selectedColor = PALETTE_COLORS[i];
            return true;
        }
        if (this.isMouseOverCanvas((int)mouseX, (int)mouseY)) {
            if (button == 0) {
                this.saveUndoState();
                this.isDrawing = true;
                this.drawPixel((int)mouseX, (int)mouseY);
                return true;
            }
            if (button == 1) {
                this.saveUndoState();
                this.isErasing = true;
                this.erasePixel((int)mouseX, (int)mouseY);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDrawing = false;
        }
        if (button == 1) {
            this.isErasing = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDrawing && this.isMouseOverCanvas((int)mouseX, (int)mouseY)) {
            this.drawPixel((int)mouseX, (int)mouseY);
            return true;
        }
        if (this.isErasing && this.isMouseOverCanvas((int)mouseX, (int)mouseY)) {
            this.erasePixel((int)mouseX, (int)mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 90 && (modifiers & 2) != 0) {
            this.undo();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean isMouseOverCanvas(int mouseX, int mouseY) {
        return mouseX >= this.canvasX && mouseX < this.canvasX + 224 && mouseY >= this.canvasY && mouseY < this.canvasY + 224;
    }

    private void drawPixel(int mouseX, int mouseY) {
        int gridX = (mouseX - this.canvasX) / 14;
        int gridY = (mouseY - this.canvasY) / 14;
        if (gridX >= 0 && gridX < 16 && gridY >= 0 && gridY < 16) {
            this.editingCrosshair.setPixel(gridX, gridY, this.selectedColor);
        }
    }

    private void erasePixel(int mouseX, int mouseY) {
        int gridX = (mouseX - this.canvasX) / 14;
        int gridY = (mouseY - this.canvasY) / 14;
        if (gridX >= 0 && gridX < 16 && gridY >= 0 && gridY < 16) {
            this.editingCrosshair.setPixel(gridX, gridY, 0);
        }
    }

    private void fillCanvas() {
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                this.editingCrosshair.setPixel(x, y, this.selectedColor);
            }
        }
    }

    private void invertCanvas() {
        int[][] pixels = this.editingCrosshair.getPixels();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                if (pixels[y][x] != 0) {
                    this.editingCrosshair.setPixel(x, y, 0);
                    continue;
                }
                this.editingCrosshair.setPixel(x, y, this.selectedColor);
            }
        }
    }

    private void drawCenterCross() {
        int center = 8;
        for (int x = center - 3; x <= center + 2; ++x) {
            if (x == center - 1 || x == center) continue;
            this.editingCrosshair.setPixel(x, center - 1, this.selectedColor);
            this.editingCrosshair.setPixel(x, center, this.selectedColor);
        }
        for (int y = center - 3; y <= center + 2; ++y) {
            if (y == center - 1 || y == center) continue;
            this.editingCrosshair.setPixel(center - 1, y, this.selectedColor);
            this.editingCrosshair.setPixel(center, y, this.selectedColor);
        }
    }

    private void saveCustomCrosshair() {
        Object name = this.nameField.method_1882().trim();
        if (((String)name).isEmpty()) {
            name = class_2561.method_43471((String)"nesquikcrosshair.editor.default_save_name").getString() + " " + (this.config.getCustomCrosshairs().size() + 1);
        }
        this.editingCrosshair.setName((String)name);
        if (this.editIndex >= 0) {
            this.config.replaceCustomCrosshair(this.editIndex, this.editingCrosshair.copy());
        } else {
            this.config.addCustomCrosshair(this.editingCrosshair.copy());
            this.config.setSelectedCustomIndex(this.config.getCustomCrosshairs().size() - 1);
        }
        this.config.setCrosshairType(CrosshairType.CUSTOM);
        NesquikCrosshairMod.saveConfig();
        this.field_22787.method_1507(this.parent);
    }

    private void saveUndoState() {
        int[][] pixels = this.editingCrosshair.getPixels();
        int[][] copy = new int[16][16];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(pixels[i], 0, copy[i], 0, 16);
        }
        this.undoStack.push(copy);
        if (this.undoStack.size() > 50) {
            ((ArrayDeque)this.undoStack).removeLast();
        }
    }

    private void undo() {
        if (!this.undoStack.isEmpty()) {
            int[][] state = this.undoStack.pop();
            int[][] pixels = this.editingCrosshair.getPixels();
            for (int i = 0; i < 16; ++i) {
                System.arraycopy(state[i], 0, pixels[i], 0, 16);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }
}

