/*
 * Decompiled with CFR 0.152.
 */
package com.nesquik.crosshair.gui;

import com.nesquik.crosshair.NesquikCrosshairMod;
import com.nesquik.crosshair.config.CrosshairConfig;
import com.nesquik.crosshair.crosshair.CrosshairRenderer;
import com.nesquik.crosshair.crosshair.CrosshairType;
import com.nesquik.crosshair.crosshair.CustomCrosshair;
import com.nesquik.crosshair.crosshair.ImageCrosshairManager;
import com.nesquik.crosshair.gui.CrosshairEditorScreen;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class CrosshairMenuScreen
extends class_437 {
    private final CrosshairConfig config;
    private CrosshairType selectedType;
    private int selectedRed;
    private int selectedGreen;
    private int selectedBlue;
    private int selectedAlpha;
    private float selectedScale;
    private boolean entityColorEnabled;
    private int entityRed;
    private int entityGreen;
    private int entityBlue;
    private boolean modEnabled;
    private String selectedImageFile;
    private boolean cancelled = false;
    private CrosshairType origType;
    private int origRed;
    private int origGreen;
    private int origBlue;
    private int origAlpha;
    private float origScale;
    private boolean origEntityColorEnabled;
    private boolean origModEnabled;
    private int origEntityRed;
    private int origEntityGreen;
    private int origEntityBlue;
    private String origImageFile;
    private int currentTab = 0;
    private int colorSubTab = 0;
    private int leftX;
    private int leftW;
    private int rightX;
    private int rightW;
    private int centerX;
    private int centerW;
    private int contentTop;
    private int contentBot;
    private int contentH;
    private int tabContentY;
    private int[] tabBtnY = new int[4];
    private static final int TAB_BTN_H = 20;
    private static final int TAB_GAP = 3;
    private static final int MARGIN = 6;
    private int galleryX;
    private int galleryY;
    private static final int GALLERY_CELL = 40;
    private static final int GALLERY_GAP = 4;
    private int paletteX;
    private int paletteY;
    private static final int PAL_CELL = 14;
    private static final int PAL_GAP = 2;
    private static final int PAL_COLS = 8;
    private static final CrosshairType[] DEFAULT_TYPES = new CrosshairType[]{CrosshairType.DEFAULT, CrosshairType.DOT, CrosshairType.CIRCLE, CrosshairType.CROSS_DOT, CrosshairType.TRIANGLE, CrosshairType.DIAMOND, CrosshairType.PLUS, CrosshairType.X_SHAPE, CrosshairType.SQUARE};
    private static final int[] PALETTE_COLORS = new int[]{-1, -2236963, -4473925, -6710887, -8947849, -11184811, -13421773, -16777216, -65536, -30720, -256, -7799040, -16711936, -16711800, -16711681, -16742145, -16776961, -12320513, -7864065, -65281, -65400, -48060, -12255420, -12303105, -7864320, -7846912, -7829504, -12285952, -16742400, -16742264, -16777080, -12320632};
    private static final int PANEL_BG = -267251182;
    private static final int PANEL_BORDER = -13750738;
    private static final int TAB_ACTIVE_BG = -14013910;
    private static final int TAB_ACTIVE_BD = -3355444;
    private static final int TAB_NORMAL_BG = -15066598;
    private static final int TAB_HOVER_BG = -14540254;
    private static final int TEXT_WHITE = -1;
    private static final int TEXT_GRAY = -5592406;
    private static final int TEXT_DIM = -10066330;
    private static final int TEXT_TITLE = -2236963;
    private static final int CELL_BG = -15856114;
    private static final int CELL_SELECTED = -3355444;
    private static final int CELL_HOVER_BD = -11184811;
    private static final int DIM_BG = 0x40000000;
    private static final int SLIDER_BG = -15856114;
    private static final int SLIDER_FILL = -11908534;
    private static final int SLIDER_HANDLE = -2236963;

    public CrosshairMenuScreen() {
        super((class_2561)class_2561.method_43471((String)"nesquikcrosshair.screen.title"));
        this.config = NesquikCrosshairMod.getConfig();
        this.selectedType = this.config.getCrosshairType();
        this.selectedRed = this.config.getRed();
        this.selectedGreen = this.config.getGreen();
        this.selectedBlue = this.config.getBlue();
        this.selectedAlpha = this.config.getAlpha();
        this.selectedScale = this.config.getScale();
        this.entityColorEnabled = this.config.isEntityTargetColorEnabled();
        this.entityRed = this.config.getEntityTargetRed();
        this.entityGreen = this.config.getEntityTargetGreen();
        this.entityBlue = this.config.getEntityTargetBlue();
        this.modEnabled = this.config.isEnabled();
        this.selectedImageFile = this.config.getSelectedImageFile();
        this.origType = this.selectedType;
        this.origRed = this.selectedRed;
        this.origGreen = this.selectedGreen;
        this.origBlue = this.selectedBlue;
        this.origAlpha = this.selectedAlpha;
        this.origScale = this.selectedScale;
        this.origEntityColorEnabled = this.entityColorEnabled;
        this.origEntityRed = this.entityRed;
        this.origEntityGreen = this.entityGreen;
        this.origEntityBlue = this.entityBlue;
        this.origModEnabled = this.modEnabled;
        this.origImageFile = this.selectedImageFile;
        this.currentTab = this.selectedType == CrosshairType.CUSTOM ? 1 : (this.selectedType == CrosshairType.IMAGE ? 2 : 0);
    }

    private void computeLayout() {
        this.contentTop = 22;
        this.contentBot = this.field_22790 - 26;
        this.contentH = this.contentBot - this.contentTop;
        this.leftX = 6;
        this.leftW = 100;
        this.rightW = 140;
        this.rightX = this.field_22789 - 6 - this.rightW;
        this.centerX = this.leftX + this.leftW + 6;
        this.centerW = this.rightX - 6 - this.centerX;
        for (int i = 0; i < 4; ++i) {
            this.tabBtnY[i] = this.contentTop + 6 + i * 23;
        }
    }

    protected void method_25426() {
        this.computeLayout();
        this.tabContentY = this.contentTop + 22;
        switch (this.currentTab) {
            case 0: {
                this.initDefaultsContent();
                break;
            }
            case 1: {
                this.initEditorContent();
                break;
            }
            case 2: {
                this.initImageContent();
                break;
            }
            case 3: {
                this.initOptionsContent();
            }
        }
        this.initRightPanel();
        int cx = this.field_22789 / 2;
        int btnW = 80;
        int btnY = this.field_22790 - 24;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.save"), b -> this.method_25419()).method_46434(cx - btnW - 4, btnY, btnW, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.cancel"), b -> {
            this.cancelled = true;
            this.method_25419();
        }).method_46434(cx + 4, btnY, btnW, 18).method_46431());
    }

    private void switchTab(int tab) {
        this.currentTab = tab;
        if (tab == 0 && (this.selectedType == CrosshairType.CUSTOM || this.selectedType == CrosshairType.IMAGE)) {
            this.selectedType = CrosshairType.DEFAULT;
        } else if (tab == 1) {
            this.selectedType = CrosshairType.CUSTOM;
        } else if (tab == 2) {
            this.selectedType = CrosshairType.IMAGE;
        }
        this.applyToConfig();
        this.method_41843();
    }

    private void initDefaultsContent() {
        int cols = 3;
        int totalW = cols * 40 + (cols - 1) * 4;
        this.galleryX = this.centerX + (this.centerW - totalW) / 2;
        this.galleryY = this.tabContentY;
    }

    private void initEditorContent() {
        int bw = Math.min(this.centerW - 16, 180);
        int bx = this.centerX + (this.centerW - bw) / 2;
        int y = this.tabContentY;
        if (!this.config.getCustomCrosshairs().isEmpty()) {
            int navW = 26;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), b -> {
                int sz = this.config.getCustomCrosshairs().size();
                this.config.setSelectedCustomIndex((this.config.getSelectedCustomIndex() - 1 + sz) % sz);
                this.applyToConfig();
            }).method_46434(bx, y, navW, 18).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), b -> {
                int sz = this.config.getCustomCrosshairs().size();
                this.config.setSelectedCustomIndex((this.config.getSelectedCustomIndex() + 1) % sz);
                this.applyToConfig();
            }).method_46434(bx + bw - navW, y, navW, 18).method_46431());
            int half = (bw - 4) / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.edit"), b -> {
                CustomCrosshair c = this.config.getCustomCrosshair();
                if (c != null) {
                    this.field_22787.method_1507((class_437)new CrosshairEditorScreen(this, c, this.config.getSelectedCustomIndex()));
                }
            }).method_46434(bx, y += 36, half, 18).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.delete"), b -> {
                this.config.removeCustomCrosshair(this.config.getSelectedCustomIndex());
                NesquikCrosshairMod.saveConfig();
                this.method_41843();
            }).method_46434(bx + half + 4, y, half, 18).method_46431());
            y += 24;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.new"), b -> this.field_22787.method_1507((class_437)new CrosshairEditorScreen(this))).method_46434(bx, y, bw, 20).method_46431());
    }

    private void initImageContent() {
        int bw = Math.min(this.centerW - 16, 180);
        int bx = this.centerX + (this.centerW - bw) / 2;
        int y = this.tabContentY;
        List<String> images = ImageCrosshairManager.getInstance().getAvailableFiles();
        if ((this.selectedImageFile == null || this.selectedImageFile.isEmpty()) && !images.isEmpty()) {
            this.selectedImageFile = images.get(0);
        }
        if (!images.isEmpty()) {
            int navW = 26;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), b -> {
                List<String> f = ImageCrosshairManager.getInstance().getAvailableFiles();
                if (!f.isEmpty()) {
                    int idx = f.indexOf(this.selectedImageFile);
                    this.selectedImageFile = f.get((idx - 1 + f.size()) % f.size());
                }
                this.applyToConfig();
            }).method_46434(bx, y, navW, 18).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), b -> {
                List<String> f = ImageCrosshairManager.getInstance().getAvailableFiles();
                if (!f.isEmpty()) {
                    int idx = f.indexOf(this.selectedImageFile);
                    this.selectedImageFile = f.get((idx + 1) % f.size());
                }
                this.applyToConfig();
            }).method_46434(bx + bw - navW, y, navW, 18).method_46431());
            y += 28;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.image.refresh"), b -> {
            ImageCrosshairManager.getInstance().refresh();
            this.method_41843();
        }).method_46434(bx, y, bw, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.image.open_folder"), b -> {
            Path folder = ImageCrosshairManager.getInstance().getImagesFolder();
            if (folder != null) {
                class_156.method_668().method_673(folder.toUri());
            }
        }).method_46434(bx, y += 24, bw, 20).method_46431());
    }

    private void initOptionsContent() {
        int bw = Math.min(this.centerW - 16, 180);
        int bx = this.centerX + (this.centerW - bw) / 2;
        int y = this.tabContentY;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.modEnabled ? "nesquikcrosshair.mod.on" : "nesquikcrosshair.mod.off")), b -> {
            this.modEnabled = !this.modEnabled;
            b.method_25355((class_2561)class_2561.method_43471((String)(this.modEnabled ? "nesquikcrosshair.mod.on" : "nesquikcrosshair.mod.off")));
            this.applyToConfig();
        }).method_46434(bx, y, bw, 22).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.entityColorEnabled ? "nesquikcrosshair.entity.enabled" : "nesquikcrosshair.entity.disabled")), b -> {
            this.entityColorEnabled = !this.entityColorEnabled;
            b.method_25355((class_2561)class_2561.method_43471((String)(this.entityColorEnabled ? "nesquikcrosshair.entity.enabled" : "nesquikcrosshair.entity.disabled")));
            this.applyToConfig();
        }).method_46434(bx, y += 28, bw, 22).method_46431());
    }

    private void initRightPanel() {
        int rx = this.rightX + 6;
        int rw = this.rightW - 12;
        int y = this.contentTop + 18;
        this.method_37063((class_364)new ModernSlider(this, rx, y, rw, 16, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.scale"), this.selectedScale, 0.5f, 3.0f, v -> {
            this.selectedScale = v.floatValue();
            this.applyToConfig();
        }));
        this.method_37063((class_364)new ModernSlider(this, rx, y += 22, rw, 16, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.opacity"), (float)this.selectedAlpha / 255.0f, 0.0f, 1.0f, v -> {
            this.selectedAlpha = (int)(v.floatValue() * 255.0f);
            this.applyToConfig();
        }));
        y += 28;
        if (this.currentTab != 2) {
            if (this.currentTab == 1) {
                this.colorSubTab = 1;
                y += 18;
            } else {
                int halfW = (rw - 4) / 2;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.color.normal"), b -> {
                    this.colorSubTab = 0;
                    this.method_41843();
                }).method_46434(rx, y, halfW, 16).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"nesquikcrosshair.color.entity"), b -> {
                    this.colorSubTab = 1;
                    this.method_41843();
                }).method_46434(rx + halfW + 4, y, halfW, 16).method_46431());
                y += 32;
            }
            int palTotalW = 126;
            this.paletteX = rx + (rw - palTotalW) / 2;
            this.paletteY = y;
        }
    }

    public void method_25420(class_332 ctx, int mx, int my, float delta) {
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, 0x40000000);
    }

    public void method_25394(class_332 ctx, int mx, int my, float delta) {
        class_304 key;
        this.method_25420(ctx, mx, my, delta);
        this.drawPanel(ctx, this.leftX, this.contentTop, this.leftW, this.contentH);
        this.drawPanel(ctx, this.rightX, this.contentTop, this.rightW, this.contentH);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.screen.title"), this.field_22789 / 2, 8, -2236963);
        this.renderNavTabs(ctx, mx, my);
        this.renderCenterInfo(ctx);
        switch (this.currentTab) {
            case 0: {
                this.renderDefaultsGallery(ctx, mx, my);
                break;
            }
            case 1: {
                this.renderEditorInfo(ctx);
                break;
            }
            case 2: {
                this.renderImageInfo(ctx);
            }
        }
        this.renderRightExtras(ctx, mx, my);
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_4068)) continue;
            class_4068 d = (class_4068)child;
            d.method_25394(ctx, mx, my, delta);
        }
        if (this.currentTab == 0) {
            this.renderGalleryHoverName(ctx, mx, my);
        }
        String keyName = (key = NesquikCrosshairMod.getOpenMenuKey()) != null ? key.method_16007().getString() : "C";
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"nesquikcrosshair.footer", (Object[])new Object[]{keyName}), this.field_22789 / 2, this.field_22790 - 40, -10066330);
    }

    private void renderNavTabs(class_332 ctx, int mx, int my) {
        String[] keys = new String[]{"nesquikcrosshair.tab.defaults", "nesquikcrosshair.tab.editor", "nesquikcrosshair.tab.images", "nesquikcrosshair.tab.options"};
        int txStart = this.leftX + 4;
        int txEnd = this.leftX + this.leftW - 4;
        for (int i = 0; i < 4; ++i) {
            boolean hovered;
            int ty = this.tabBtnY[i];
            boolean active = i == this.currentTab;
            boolean bl = hovered = mx >= txStart && mx < txEnd && my >= ty && my < ty + 20;
            int bg = active ? -14013910 : (hovered ? -14540254 : -15066598);
            ctx.method_25294(txStart, ty, txEnd, ty + 20, bg);
            if (active) {
                ctx.method_25294(txStart, ty, txStart + 2, ty + 20, -3355444);
            }
            ctx.method_25294(txStart, ty + 20 - 1, txEnd, ty + 20, -13750738);
            class_5250 label = class_2561.method_43471((String)keys[i]);
            int textColor = active ? -1 : -5592406;
            int textX = txStart + 6 + (active ? 2 : 0);
            ctx.method_27535(this.field_22793, (class_2561)label, textX, ty + 6, textColor);
        }
        int sepY = this.tabBtnY[3] + 20 + 3;
        ctx.method_25294(this.leftX + 6, sepY, this.leftX + this.leftW - 6, sepY + 1, -13750738);
        int credX = this.leftX + this.leftW / 2;
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Created by"), credX, this.contentBot - 20, -10066330);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Nesquikx1"), credX, this.contentBot - 10, -10066330);
    }

    private void renderCenterInfo(class_332 ctx) {
        int tx = this.centerX + this.centerW / 2;
        ctx.method_27534(this.field_22793, this.selectedType.getDisplayText(), tx, this.contentTop + 6, -1);
    }

    private void renderDefaultsGallery(class_332 ctx, int mx, int my) {
        for (int i = 0; i < DEFAULT_TYPES.length; ++i) {
            boolean hovered;
            int col = i % 3;
            int row = i / 3;
            int cx = this.galleryX + col * 44;
            int cy = this.galleryY + row * 44;
            boolean selected = DEFAULT_TYPES[i] == this.selectedType;
            boolean bl = hovered = mx >= cx && mx < cx + 40 && my >= cy && my < cy + 40;
            int border = selected ? -3355444 : (hovered ? -11184811 : -13750738);
            ctx.method_25294(cx - 1, cy - 1, cx + 40 + 1, cy + 40 + 1, border);
            ctx.method_25294(cx, cy, cx + 40, cy + 40, -15856114);
            if (selected) {
                ctx.method_25294(cx, cy, cx + 40, cy + 1, 0x40FFFFFF);
            }
            CrosshairRenderer.renderAt(ctx, cx + 20, cy + 20, DEFAULT_TYPES[i], -1, 2, null, null);
        }
    }

    private void renderGalleryHoverName(class_332 ctx, int mx, int my) {
        for (int i = 0; i < DEFAULT_TYPES.length; ++i) {
            int col = i % 3;
            int row = i / 3;
            int cx = this.galleryX + col * 44;
            int cy = this.galleryY + row * 44;
            if (mx < cx || mx >= cx + 40 || my < cy || my >= cy + 40) continue;
            int nameY = this.galleryY + 132 + 4;
            ctx.method_27534(this.field_22793, DEFAULT_TYPES[i].getDisplayText(), this.centerX + this.centerW / 2, nameY, -5592406);
            break;
        }
    }

    private void renderEditorInfo(class_332 ctx) {
        int tx = this.centerX + this.centerW / 2;
        if (this.config.getCustomCrosshairs().isEmpty()) {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.editor.empty"), tx, this.tabContentY + 4, -10066330);
        } else {
            CustomCrosshair c = this.config.getCustomCrosshair();
            if (c != null) {
                String counter = this.config.getSelectedCustomIndex() + 1 + "/" + this.config.getCustomCrosshairs().size();
                ctx.method_25300(this.field_22793, counter, tx, this.tabContentY + 4, -5592406);
                Object name = c.getName();
                if (((String)name).length() > 22) {
                    name = ((String)name).substring(0, 20) + "..";
                }
                ctx.method_25300(this.field_22793, (String)name, tx, this.tabContentY + 22, -1);
            }
        }
    }

    private void renderImageInfo(class_332 ctx) {
        int tx = this.centerX + this.centerW / 2;
        List<String> images = ImageCrosshairManager.getInstance().getAvailableFiles();
        if (images.isEmpty()) {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.image.none"), tx, this.tabContentY + 4, -5592406);
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.image.folder_hint"), tx, this.tabContentY + 16, -10066330);
        } else {
            Object name;
            int idx = images.indexOf(this.selectedImageFile);
            String counter = idx + 1 + "/" + images.size();
            ctx.method_25300(this.field_22793, counter, tx, this.tabContentY + 4, -5592406);
            Object object = name = this.selectedImageFile != null ? this.selectedImageFile : "---";
            if (((String)name).length() > 22) {
                name = ((String)name).substring(0, 20) + "..";
            }
            ctx.method_25300(this.field_22793, (String)name, tx, this.tabContentY + 20, -1);
        }
    }

    private void renderRightExtras(class_332 ctx, int mx, int my) {
        int rx = this.rightX + this.rightW / 2;
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.section.style"), rx, this.contentTop + 6, -5592406);
        int sepY = this.contentTop + 60;
        ctx.method_25294(this.rightX + 8, sepY, this.rightX + this.rightW - 8, sepY + 1, -13750738);
        if (this.currentTab == 2) {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.color.disabled"), rx, sepY + 14, -10066330);
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"nesquikcrosshair.color.disabled_hint"), rx, sepY + 28, -10066330);
        } else {
            String label = this.colorSubTab == 0 ? "Normal" : "Entity";
            ctx.method_25300(this.field_22793, label, rx, this.paletteY - 12, -10066330);
            this.renderColorPalette(ctx, mx, my);
            int cR = this.colorSubTab == 0 ? this.selectedRed : this.entityRed;
            int cG = this.colorSubTab == 0 ? this.selectedGreen : this.entityGreen;
            int cB = this.colorSubTab == 0 ? this.selectedBlue : this.entityBlue;
            int color = 0xFF000000 | cR << 16 | cG << 8 | cB;
            int swatchY = this.contentBot - 28;
            int swatchSize = 16;
            int sx = rx - swatchSize / 2;
            ctx.method_25294(sx - 1, swatchY - 1, sx + swatchSize + 1, swatchY + swatchSize + 1, -13750738);
            ctx.method_25294(sx, swatchY, sx + swatchSize, swatchY + swatchSize, color);
            String hex = String.format("#%02X%02X%02X", cR, cG, cB);
            ctx.method_25300(this.field_22793, hex, rx, swatchY + swatchSize + 3, -10066330);
        }
    }

    private void renderColorPalette(class_332 ctx, int mx, int my) {
        int currentColor = this.getCurrentPaletteColor();
        for (int i = 0; i < PALETTE_COLORS.length; ++i) {
            boolean hovered;
            int col = i % 8;
            int row = i / 8;
            int cx = this.paletteX + col * 16;
            int cy = this.paletteY + row * 16;
            int c = PALETTE_COLORS[i];
            boolean selected = c == currentColor;
            boolean bl = hovered = mx >= cx && mx < cx + 14 && my >= cy && my < cy + 14;
            if (selected) {
                ctx.method_25294(cx - 2, cy - 2, cx + 14 + 2, cy + 14 + 2, -1);
            } else if (hovered) {
                ctx.method_25294(cx - 1, cy - 1, cx + 14 + 1, cy + 14 + 1, -7829368);
            }
            ctx.method_25294(cx, cy, cx + 14, cy + 14, c);
        }
    }

    private int getCurrentPaletteColor() {
        int r = this.colorSubTab == 0 ? this.selectedRed : this.entityRed;
        int g = this.colorSubTab == 0 ? this.selectedGreen : this.entityGreen;
        int b = this.colorSubTab == 0 ? this.selectedBlue : this.entityBlue;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private void drawPanel(class_332 ctx, int x, int y, int w, int h) {
        ctx.method_25294(x - 1, y - 1, x + w + 1, y + h + 1, -13750738);
        ctx.method_25294(x, y, x + w, y + h, -267251182);
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + 2, 0x10FFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int cy;
            int cx;
            int row;
            int col;
            int i;
            int txStart = this.leftX + 4;
            int txEnd = this.leftX + this.leftW - 4;
            for (i = 0; i < 4; ++i) {
                int ty = this.tabBtnY[i];
                if (!(mouseX >= (double)txStart) || !(mouseX < (double)txEnd) || !(mouseY >= (double)ty) || !(mouseY < (double)(ty + 20))) continue;
                if (i != this.currentTab) {
                    this.switchTab(i);
                }
                return true;
            }
            if (this.currentTab == 0) {
                for (i = 0; i < DEFAULT_TYPES.length; ++i) {
                    col = i % 3;
                    row = i / 3;
                    cx = this.galleryX + col * 44;
                    cy = this.galleryY + row * 44;
                    if (!(mouseX >= (double)cx) || !(mouseX < (double)(cx + 40)) || !(mouseY >= (double)cy) || !(mouseY < (double)(cy + 40))) continue;
                    this.selectedType = DEFAULT_TYPES[i];
                    this.applyToConfig();
                    return true;
                }
            }
            if (this.currentTab != 2) {
                for (i = 0; i < PALETTE_COLORS.length; ++i) {
                    col = i % 8;
                    row = i / 8;
                    cx = this.paletteX + col * 16;
                    cy = this.paletteY + row * 16;
                    if (!(mouseX >= (double)cx) || !(mouseX < (double)(cx + 14)) || !(mouseY >= (double)cy) || !(mouseY < (double)(cy + 14))) continue;
                    this.applyPaletteColor(PALETTE_COLORS[i]);
                    this.applyToConfig();
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void applyPaletteColor(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        if (this.colorSubTab == 0) {
            this.selectedRed = r;
            this.selectedGreen = g;
            this.selectedBlue = b;
        } else {
            this.entityRed = r;
            this.entityGreen = g;
            this.entityBlue = b;
        }
    }

    private void applyToConfig() {
        this.config.setEnabled(this.modEnabled);
        this.config.setCrosshairType(this.selectedType);
        this.config.setRed(this.selectedRed);
        this.config.setGreen(this.selectedGreen);
        this.config.setBlue(this.selectedBlue);
        this.config.setAlpha(this.selectedAlpha);
        this.config.setScale(this.selectedScale);
        this.config.setEntityTargetColorEnabled(this.entityColorEnabled);
        this.config.setEntityTargetRed(this.entityRed);
        this.config.setEntityTargetGreen(this.entityGreen);
        this.config.setEntityTargetBlue(this.entityBlue);
        this.config.setSelectedImageFile(this.selectedImageFile);
    }

    private void saveSettings() {
        this.applyToConfig();
        NesquikCrosshairMod.saveConfig();
    }

    private void restoreOriginal() {
        this.config.setEnabled(this.origModEnabled);
        this.config.setCrosshairType(this.origType);
        this.config.setRed(this.origRed);
        this.config.setGreen(this.origGreen);
        this.config.setBlue(this.origBlue);
        this.config.setAlpha(this.origAlpha);
        this.config.setScale(this.origScale);
        this.config.setEntityTargetColorEnabled(this.origEntityColorEnabled);
        this.config.setEntityTargetRed(this.origEntityRed);
        this.config.setEntityTargetGreen(this.origEntityGreen);
        this.config.setEntityTargetBlue(this.origEntityBlue);
        this.config.setSelectedImageFile(this.origImageFile);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        if (this.cancelled) {
            this.restoreOriginal();
        } else {
            this.saveSettings();
        }
        super.method_25419();
    }

    private class ModernSlider
    extends class_357 {
        private final Consumer<Float> onChange;
        private final class_2561 label;
        private final float min;
        private final float max;

        ModernSlider(CrosshairMenuScreen crosshairMenuScreen, int x, int y, int w, int h, class_2561 label, float cur, float mn, float mx, Consumer<Float> onChange) {
            super(x, y, w, h, (class_2561)label.method_27661().method_27693(": " + String.format("%.1f", Float.valueOf(cur))), (double)((cur - mn) / (mx - mn)));
            this.onChange = onChange;
            this.label = label;
            this.min = mn;
            this.max = mx;
        }

        protected void method_25346() {
            float val = this.min + (float)this.field_22753 * (this.max - this.min);
            String fmt = this.max - this.min <= 1.0f ? String.format("%.0f%%", Float.valueOf(val * 100.0f)) : String.format("%.1f", Float.valueOf(val));
            this.method_25355((class_2561)this.label.method_27661().method_27693(": " + fmt));
        }

        protected void method_25344() {
            this.onChange.accept(Float.valueOf(this.min + (float)this.field_22753 * (this.max - this.min)));
        }

        public void method_48579(class_332 c, int mx, int my, float d) {
            c.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -15856114);
            int fw = (int)(this.field_22753 * (double)(this.method_25368() - 4));
            c.method_25294(this.method_46426() + 2, this.method_46427() + 2, this.method_46426() + 2 + fw, this.method_46427() + this.method_25364() - 2, -11908534);
            int hx = this.method_46426() + 2 + fw - 3;
            c.method_25294(hx, this.method_46427(), hx + 6, this.method_46427() + this.method_25364(), -2236963);
            c.method_27534(class_310.method_1551().field_1772, this.method_25369(), this.method_46426() + this.method_25368() / 2, this.method_46427() + 4, -1);
        }
    }
}

