/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag;

import com.github.mechalopa.hmag.HMaG;
import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModEffects;
import com.github.mechalopa.hmag.registry.ModEnchantments;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.registry.ModItems;
import com.github.mechalopa.hmag.util.ModDamageTypes;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.item.AncientShieldItem;
import com.github.mechalopa.hmag.world.item.ILevelItem;
import com.github.mechalopa.hmag.world.item.InsomniaSwordItem;
import com.github.mechalopa.hmag.world.item.ModArmorMaterial;
import com.github.mechalopa.hmag.world.item.NemesisBladeItem;
import com.github.mechalopa.hmag.world.item.enchantment.HealthBoostEnchantment;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="hmag", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final UUID[] NECROTIC_CHAINMAIL_ARMOR_ATTACK_SPEED_UUIDS = new UUID[]{UUID.fromString("81D1E394-8B33-AC3D-325A-C8A03E757B51"), UUID.fromString("B4EFB0CA-2180-0043-0FF9-BE033CC510D5"), UUID.fromString("7FD9FBE7-0438-BF0F-F901-F961384F9591"), UUID.fromString("28E5C0B5-109B-339B-BE83-610B5B399256")};
    private static final Component INSOMNIA_ITEM_MESSAGE = Component.m_237115_((String)"message.hmag.insomnia_item");

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() != null && event.getSource() != null) {
            Entity stack2;
            LivingEntity livingentity = event.getEntity();
            DamageSource source = event.getSource();
            if (!event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
                int level;
                LivingEntity attacker;
                ItemStack stack2;
                Entity entity;
                if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity && !(stack2 = (attacker = (LivingEntity)entity).m_21205_()).m_41619_() && stack2.m_41782_() && (level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.WATER_ASPECT.get()), (ItemStack)stack2)) > 0) {
                    if (livingentity.m_6060_()) {
                        livingentity.m_20095_();
                    }
                    if (livingentity.m_6126_()) {
                        event.setAmount(event.getAmount() + (float)level * 2.5f);
                    }
                }
            } else if (source.m_7640_() != null && (stack2 = source.m_7640_()) instanceof AbstractArrow) {
                AbstractArrow arrowentity = (AbstractArrow)stack2;
                if (arrowentity.m_6095_().equals(ModEntityTypes.EVIL_ARROW.get())) {
                    if (arrowentity.m_36792_()) {
                        event.setAmount(event.getAmount() * 1.2f);
                        source = ModDamageTypes.source(source.m_7639_().m_9236_(), ModDamageTypes.CRITICAL_EVIL_ARROW, source.m_7639_(), (Entity)arrowentity);
                    } else {
                        event.setAmount(event.getAmount() * 1.1f);
                    }
                }
                if (source.m_7639_() != null && source.m_7639_() instanceof LivingEntity && arrowentity.m_36795_()) {
                    LivingEntity attacker = (LivingEntity)source.m_7639_();
                    int level = 0;
                    for (InteractionHand hand : InteractionHand.values()) {
                        ItemStack stack3 = attacker.m_21120_(hand);
                        if (stack3.m_41619_() || !stack3.m_41782_()) continue;
                        level = Math.max(level, EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.ANTI_AIR.get()), (ItemStack)stack3));
                    }
                    if (!(level <= 0 || livingentity.m_20096_() || livingentity.m_20072_() || livingentity.m_20077_() || livingentity.m_20159_())) {
                        event.setAmount(event.getAmount() * (1.0f + (float)level * 0.3f));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDamage(LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() != null && event.getSource() != null && event.getSource().m_269533_(DamageTypeTags.f_268745_) && !event.getEntity().m_21211_().m_41619_() && event.getEntity().m_21211_().m_41720_() == ModItems.FORTRESS_SHIELD.get()) {
            event.setAmount(event.getAmount() * 0.25f);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() != null && event.getSource() != null) {
            LivingEntity livingentity = event.getEntity();
            DamageSource source = event.getSource();
            if (!livingentity.m_21211_().m_41619_() && source.m_7639_() != null && source.m_7639_() instanceof LivingEntity && source.m_7640_() != null && source.m_7639_().equals((Object)source.m_7640_())) {
                if (livingentity.m_21211_().m_41720_() == ModItems.ANCIENT_SHIELD.get()) {
                    if (livingentity.m_217043_().m_188503_(3) == 0) {
                        int i = livingentity.m_217043_().m_188503_(3);
                        ((LivingEntity)source.m_7639_()).m_7292_(new MobEffectInstance(i == 2 ? MobEffects.f_19613_ : (i == 1 ? MobEffects.f_19597_ : MobEffects.f_19599_), 100, 0));
                    }
                } else if (livingentity.m_21211_().m_41720_() == ModItems.FORTRESS_SHIELD.get() && livingentity.m_217043_().m_188503_(3) == 0) {
                    source.m_7639_().m_20254_(8);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (event.getEntity() == null || event.getLookingEntity() == null) {
            return;
        }
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
        EntityType entitytype = event.getLookingEntity().m_6095_();
        if (entitytype == ModEntityTypes.SKELETON_GIRL.get() && stack.m_150930_(Items.f_42678_) || entitytype == ModEntityTypes.ZOMBIE_GIRL.get() && stack.m_150930_(Items.f_42681_) || entitytype == ModEntityTypes.CREEPER_GIRL.get() && stack.m_150930_(Items.f_42682_)) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().f_19797_ == 1 && !event.getEntity().getPersistentData().m_128471_("hmag.checked")) {
            event.getEntity().getPersistentData().m_128379_("hmag.checked", true);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                if (mob.getPersistentData().m_128471_("hmag.withSpawnParticle")) {
                    mob.m_21373_();
                    mob.getPersistentData().m_128473_("hmag.withSpawnParticle");
                }
                if (!(!mob.m_21515_() || !mob.getPersistentData().m_128471_("hmag.checking") || mob.getPersistentData().m_128471_("hmag.notReplaced") || mob.m_20160_() || mob.m_20159_() || mob.m_21532_() || mob.m_8023_())) {
                    ServerLevel serverlevel = (ServerLevel)event.getEntity().m_20193_();
                    double d = event.getEntity().m_217043_().m_188500_();
                    if (ModConfigs.cachedServer.ZOMBIE_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.ZOMBIE_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.ZOMBIE_GIRL.get());
                    } else if (ModConfigs.cachedServer.HUSK_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.HUSK_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.HUSK_GIRL.get());
                    } else if (ModConfigs.cachedServer.DROWNED_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.DROWNED_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.DROWNED_GIRL.get());
                    } else if (ModConfigs.cachedServer.SKELETON_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.SKELETON_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.SKELETON_GIRL.get());
                    } else if (ModConfigs.cachedServer.WITHER_SKELETON_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.WITHER_SKELETON_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.WITHER_SKELETON_GIRL.get());
                    } else if (ModConfigs.cachedServer.STRAY_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.STRAY_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.STRAY_GIRL.get());
                    } else if (ModConfigs.cachedServer.CREEPER_GIRL_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.CREEPER_GIRL_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.CREEPER_GIRL.get());
                    } else if (ModConfigs.cachedServer.ENDER_EXECUTOR_REPLACE_CHANCE > d && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.ENDER_EXECUTOR_REPLACEABLES)) {
                        ModEvents.replace(serverlevel, mob, (EntityType)ModEntityTypes.ENDER_EXECUTOR.get());
                    }
                }
            }
        }
    }

    private static boolean replace(ServerLevel level, Mob replacementMob, EntityType<?> type) {
        if (replacementMob.m_6095_().equals(type)) {
            return false;
        }
        Mob mob = ModEvents.createMob(level, type);
        if (mob == null) {
            return false;
        }
        SpawnGroupData spawndata = null;
        mob.m_20359_((Entity)replacementMob);
        spawndata = mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(replacementMob.m_20183_()), MobSpawnType.NATURAL, spawndata, (CompoundTag)null);
        mob.m_21557_(replacementMob.m_21525_());
        if (replacementMob.m_8077_()) {
            mob.m_6593_(replacementMob.m_7770_());
            mob.m_20340_(replacementMob.m_20151_());
        }
        mob.getPersistentData().m_128379_("hmag.notReplaced", true);
        level.m_47205_((Entity)mob);
        replacementMob.m_146870_();
        return true;
    }

    @Nullable
    private static Mob createMob(ServerLevel level, EntityType<?> type) {
        try {
            Entity entity = type.m_20615_((Level)level);
            if (!(entity instanceof Mob)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + ForgeRegistries.ENTITY_TYPES.getKey(type));
            }
            return (Mob)entity;
        }
        catch (Exception e) {
            HMaG.LOGGER.warn("Failed to create hmag mob", (Throwable)e);
            return null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Level level;
        if (event.getResult() == Event.Result.DENY || event.getEntity() == null) {
            return;
        }
        if (event.getSpawnType() == MobSpawnType.NATURAL && (level = event.getEntity().m_20193_()) != null) {
            Holder holder = level.m_204166_(event.getEntity().m_20183_());
            Mob mob = event.getEntity();
            if (!holder.containsTag(ModTags.BiomeTags.NO_MOB_REPLACEMENTS)) {
                if (ModConfigs.cachedServer.ZOMBIE_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.ZOMBIE_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.HUSK_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.HUSK_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.DROWNED_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.DROWNED_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.SKELETON_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.SKELETON_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.WITHER_SKELETON_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.WITHER_SKELETON_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.STRAY_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.STRAY_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.CREEPER_GIRL_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.CREEPER_GIRL_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                } else if (ModConfigs.cachedServer.ENDER_EXECUTOR_REPLACE_CHANCE > 0.0 && mob.m_6095_().m_204039_(ModTags.EntityTypeTags.ENDER_EXECUTOR_REPLACEABLES)) {
                    ModEvents.putCheckingTag((LivingEntity)mob);
                }
            }
        }
    }

    private static void putCheckingTag(LivingEntity living) {
        living.getPersistentData().m_128379_("hmag.checking", true);
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        try {
            Entity entity;
            if (event.getEntity() != null && (entity = event.getEntity()) instanceof EnderMan) {
                EnderMan enderman = (EnderMan)entity;
                enderman.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)enderman, LivingEntity.class, 10, false, false, p -> {
                    if (p.m_21023_((MobEffect)ModEffects.ENDER_RAGE.get())) {
                        double d0 = 8.0 + (double)p.m_21124_((MobEffect)ModEffects.ENDER_RAGE.get()).m_19564_() * 12.0;
                        return p.m_20280_((Entity)enderman) <= d0 * d0;
                    }
                    return false;
                }).m_26146_(30));
            }
        }
        catch (Exception e) {
            HMaG.LOGGER.warn("Failed to add goals to mobs", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onMobEffectApplicable(MobEffectEvent.Applicable event) {
        if (event.getEntity() != null && event.getEffectInstance() != null) {
            LivingEntity livingentity = event.getEntity();
            MobEffect effect = event.getEffectInstance().m_19544_();
            if (effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19613_) {
                int i = 0;
                for (ItemStack stack : livingentity.m_6168_()) {
                    Item item;
                    if (stack.m_41619_() || (item = stack.m_41720_()) == null || !(item instanceof ArmorItem) || ((ArmorItem)item).m_40401_() != ModArmorMaterial.ANCIENT) continue;
                    ++i;
                }
                if (!ModUtils.getHeldItem(livingentity, (Item)ModItems.ANCIENT_SHIELD.get()).m_41619_()) {
                    ++i;
                }
                if (i >= 4 || i > event.getEffectInstance().m_19564_() + 1) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == MobEffects.f_19610_) {
                ItemStack stack1;
                if (livingentity.m_21023_((MobEffect)ModEffects.DARKNESS_RESISTANCE.get())) {
                    event.setResult(Event.Result.DENY);
                } else if (livingentity instanceof Player && !(stack1 = livingentity.m_21205_()).m_41619_() && stack1.m_41720_() == ModItems.INSOMNIA_SWORD.get() && ILevelItem.getItemLevel(stack1) > 0) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == MobEffects.f_216964_) {
                if (livingentity.m_21023_((MobEffect)ModEffects.DARKNESS_RESISTANCE.get())) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == ModEffects.COMBUSTION.get()) {
                if (livingentity.m_5825_() || !ModUtils.getHeldItem(livingentity, (Item)ModItems.FORTRESS_SHIELD.get()).m_41619_()) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == ModEffects.ENDER_RAGE.get() && !livingentity.m_6095_().m_204039_(ModTags.EntityTypeTags.ENDER_RAGE_IMMUNE_BLACKLIST) && (livingentity instanceof EnderMan || livingentity.m_6095_().m_204039_(ModTags.EntityTypeTags.ENDER_RAGE_IMMUNE_WHITELIST))) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onItemAttributeModifier(ItemAttributeModifierEvent event) {
        if (!event.getItemStack().m_41619_() && event.getItemStack().m_41720_() != null && event.getSlotType() != null && event.getSlotType().m_20743_() != null) {
            ItemStack stack = event.getItemStack();
            if (event.getSlotType() == Mob.m_147233_((ItemStack)stack)) {
                int level;
                int i = event.getSlotType().m_20749_();
                if (event.getSlotType().m_254934_() && i >= 0 && i < HealthBoostEnchantment.HEALTH_BOOST_ENCHANTMENT_MAX_HEALTH_UUIDS.length && (level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.HEALTH_BOOST.get()), (ItemStack)stack)) > 0) {
                    event.addModifier(Attributes.f_22276_, new AttributeModifier(HealthBoostEnchantment.HEALTH_BOOST_ENCHANTMENT_MAX_HEALTH_UUIDS[i], "Health boost enchantment " + event.getSlotType().m_20751_() + " max health bonus", (double)((float)level * 1.0f), AttributeModifier.Operation.ADDITION));
                }
                if (stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40401_() == ModArmorMaterial.NECROTIC_CHAIN) {
                    event.addModifier(Attributes.f_22283_, new AttributeModifier(NECROTIC_CHAINMAIL_ARMOR_ATTACK_SPEED_UUIDS[i], "Necrotic chainmail armor " + event.getSlotType().m_20751_() + " attack speed bonus", (double)0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL));
                } else if (stack.m_41720_() == ModItems.INSOMNIA_SWORD.get()) {
                    int level1 = ILevelItem.getItemLevel(stack);
                    if (level1 > 0) {
                        event.addModifier(Attributes.f_22281_, new AttributeModifier(InsomniaSwordItem.INSOMNIA_SWORD_ATTACK_DAMAGE_UUID, "Insomnia sword attack damage bonus", (double)((float)level1 * 1.0f + 1.0f), AttributeModifier.Operation.ADDITION));
                    }
                } else if (stack.m_41720_() == ModItems.NEMESIS_BLADE.get()) {
                    int level2 = ILevelItem.getItemLevel(stack);
                    if (level2 > 0) {
                        event.addModifier(Attributes.f_22281_, new AttributeModifier(NemesisBladeItem.NEMESIS_BLADE_ATTACK_DAMAGE_UUID, "Nemesis blade attack damage bonus", (double)((float)level2 * 1.0f), AttributeModifier.Operation.ADDITION));
                        event.addModifier(Attributes.f_22283_, new AttributeModifier(NemesisBladeItem.NEMESIS_BLADE_ATTACK_SPEED_UUID, "Nemesis blade attack speed bonus", (double)((float)level2 * 0.25f), AttributeModifier.Operation.ADDITION));
                    } else {
                        event.addModifier(Attributes.f_22279_, NemesisBladeItem.NEMESIS_BLADE_MOVEMENT_SPEED_MODIFIER);
                    }
                }
            }
            if (event.getSlotType().m_20743_() == EquipmentSlot.Type.HAND && stack.m_41720_() == ModItems.ANCIENT_SHIELD.get()) {
                event.addModifier(Attributes.f_22278_, AncientShieldItem.ANCIENT_SHIELD_KNOCKBACK_RESISTANCE_MODIFIER);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (event.getResultStatus() == null && event.getEntity().m_150109_().m_204075_(ModTags.ItemTags.INSOMNIA_ITEMS)) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            event.getEntity().m_5661_(INSOMNIA_ITEM_MESSAGE, true);
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() != null && event.getEntity().m_32055_() != null && !event.getEntity().m_32055_().m_41619_() && event.getEntity().m_32055_().m_41720_() != null && event.getEntity().m_32055_().m_41720_() instanceof ILevelItem) {
            ILevelItem.removeItemLevelTag(event.getEntity().m_32055_());
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() != null && !(event.getEntity() instanceof Player) && event.getTo() != null && !event.getTo().m_41619_() && event.getTo().m_41720_() != null && event.getTo().m_41720_() instanceof ILevelItem) {
            ILevelItem.removeItemLevelTag(event.getTo());
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (ModConfigs.cachedServer.ADDITIONAL_VILLAGER_TRADES && event.getType() != null) {
            Int2ObjectMap trades = event.getTrades();
            if (event.getType() == VillagerProfession.f_35589_) {
                ((List)trades.get(2)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.SOUL_POWDER.get(), 24), new ItemStack((ItemLike)Items.f_42616_, 1), 16, 2, 0.05f));
                ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.CUREBERRY.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 1), 16, 15, 0.05f));
                ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.RANDOMBERRY.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 1), 16, 15, 0.05f));
                ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.EXP_BERRY.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 1), 16, 15, 0.05f));
                ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.SPECTRAL_SOUP.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 1), 16, 15, 0.05f));
            }
            if (event.getType() == VillagerProfession.f_35593_) {
                ((List)trades.get(3)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.BAT_WING.get(), 4), new ItemStack((ItemLike)Items.f_42616_, 1), 16, 15, 0.05f));
                ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.KOBOLD_LEATHER.get(), 4), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 20, 0.05f));
            }
            if (event.getType() == VillagerProfession.f_35590_) {
                ((List)trades.get(2)).add(new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)ModItems.LEMON.get(), 4), 12, 4, 0.05f));
            }
            if (event.getType() == VillagerProfession.f_35591_) {
                ((List)trades.get(4)).add(new BasicItemListing(new ItemStack((ItemLike)ModItems.SAVAGEFANG_MEAT.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 20, 0.05f));
            }
        }
    }

    @SubscribeEvent
    public void onWandererTrades(WandererTradesEvent event) {
        if (ModConfigs.cachedServer.ADDITIONAL_WANDERER_TRADES) {
            List genericTrades = event.getGenericTrades();
            List rareTrades = event.getRareTrades();
            if (ModConfigs.cachedServer.ENDER_EXECUTOR_REPLACE_CHANCE > 0.0) {
                genericTrades.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.ENDER_PLASM.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 2), 32, 1, 0.05f));
            }
            genericTrades.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.ANCIENT_STONE.get(), 2), new ItemStack((ItemLike)Items.f_42616_, 1), 32, 1, 0.05f));
            genericTrades.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.OGRE_HORN.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 3), 32, 1, 0.05f));
            genericTrades.add(new BasicItemListing(new ItemStack((ItemLike)ModItems.RAVAGER_MEAT.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 1), 32, 1, 0.05f));
            genericTrades.add(new BasicItemListing(2, new ItemStack((ItemLike)ModItems.LEMON.get()), 5, 1, 1.0f));
            genericTrades.add(new BasicItemListing(5, new ItemStack((ItemLike)ModItems.FIRE_BOTTLE.get()), 8, 1, 1.0f));
            rareTrades.add(new BasicItemListing(1, new ItemStack((ItemLike)ModItems.SOUL_POWDER.get()), 8, 1, 0.05f));
            rareTrades.add(new BasicItemListing(64, new ItemStack((ItemLike)ModItems.LIGHTNING_PARTICLE.get()), 5, 1, 0.05f));
            rareTrades.add(new BasicItemListing(32, new ItemStack((ItemLike)ModItems.PURIFICATION_CLOTH.get()), 3, 1, 0.05f));
        }
    }
}

