/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.DyssomniaEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DyssomniaModel<T extends DyssomniaEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headPart1;
    private final ModelPart headPart2Left1;
    private final ModelPart headPart2Right1;
    private final ModelPart headPart2Left2;
    private final ModelPart headPart2Right2;
    private final ModelPart leftFang1;
    private final ModelPart rightFang1;
    private final ModelPart leftFang2;
    private final ModelPart rightFang2;
    private final ModelPart leftHeadFin;
    private final ModelPart rightHeadFin;
    private final ModelPart body;
    private final ModelPart bodyPart1;
    private final ModelPart bodyPart2;
    private final ModelPart bodyPart3;
    private final ModelPart leftRib;
    private final ModelPart rightRib;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart leftTailFin;
    private final ModelPart rightTailFin;
    private final ModelPart leftWingBase;
    private final ModelPart leftWing1;
    private final ModelPart leftWing2;
    private final ModelPart leftWing3;
    private final ModelPart rightWingBase;
    private final ModelPart rightWing1;
    private final ModelPart rightWing2;
    private final ModelPart rightWing3;
    private final ModelPart smallLeftWingBase;
    private final ModelPart smallLeftWing1;
    private final ModelPart smallLeftWing2;
    private final ModelPart smallRightWingBase;
    private final ModelPart smallRightWing1;
    private final ModelPart smallRightWing2;
    private final ModelPart leftBodyFin;
    private final ModelPart rightBodyFin;
    private final ModelPart smallLeftBodyFin;
    private final ModelPart smallRightBodyFin;

    public DyssomniaModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.m_171324_("head");
        this.headPart1 = this.head.m_171324_("head_part_1");
        this.headPart2Left1 = this.headPart1.m_171324_("head_part_2_left_1");
        this.headPart2Right1 = this.headPart1.m_171324_("head_part_2_right_1");
        this.headPart2Left2 = this.headPart2Left1.m_171324_("head_part_2_left_2");
        this.headPart2Right2 = this.headPart2Right1.m_171324_("head_part_2_right_2");
        this.leftFang1 = this.headPart2Left1.m_171324_("left_fang_1");
        this.rightFang1 = this.headPart2Right1.m_171324_("right_fang_1");
        this.leftFang2 = this.headPart2Left2.m_171324_("left_fang_2");
        this.rightFang2 = this.headPart2Right2.m_171324_("right_fang_2");
        this.leftHeadFin = this.headPart1.m_171324_("left_head_fin");
        this.rightHeadFin = this.headPart1.m_171324_("right_head_fin");
        this.body = modelPart.m_171324_("body");
        this.bodyPart1 = this.body.m_171324_("body_part_1");
        this.bodyPart2 = this.bodyPart1.m_171324_("body_part_2");
        this.bodyPart3 = this.body.m_171324_("body_part_3");
        this.leftRib = this.body.m_171324_("left_rib");
        this.rightRib = this.body.m_171324_("right_rib");
        this.tail1 = this.bodyPart2.m_171324_("tail_1");
        this.tail2 = this.tail1.m_171324_("tail_2");
        this.tail3 = this.tail2.m_171324_("tail_3");
        this.leftTailFin = this.tail2.m_171324_("left_tail_fin");
        this.rightTailFin = this.tail2.m_171324_("right_tail_fin");
        this.leftWingBase = this.body.m_171324_("left_wing_base");
        this.leftWing1 = this.leftWingBase.m_171324_("left_wing_1");
        this.leftWing2 = this.leftWing1.m_171324_("left_wing_2");
        this.leftWing3 = this.leftWing2.m_171324_("left_wing_3");
        this.rightWingBase = this.body.m_171324_("right_wing_base");
        this.rightWing1 = this.rightWingBase.m_171324_("right_wing_1");
        this.rightWing2 = this.rightWing1.m_171324_("right_wing_2");
        this.rightWing3 = this.rightWing2.m_171324_("right_wing_3");
        this.smallLeftWingBase = this.bodyPart2.m_171324_("small_left_wing_base");
        this.smallLeftWing1 = this.smallLeftWingBase.m_171324_("small_left_wing_1");
        this.smallLeftWing2 = this.smallLeftWing1.m_171324_("small_left_wing_2");
        this.smallRightWingBase = this.bodyPart2.m_171324_("small_right_wing_base");
        this.smallRightWing1 = this.smallRightWingBase.m_171324_("small_right_wing_1");
        this.smallRightWing2 = this.smallRightWing1.m_171324_("small_right_wing_2");
        this.leftBodyFin = this.body.m_171324_("left_body_fin");
        this.rightBodyFin = this.body.m_171324_("right_body_fin");
        this.smallLeftBodyFin = this.bodyPart2.m_171324_("small_left_body_fin");
        this.smallRightBodyFin = this.bodyPart2.m_171324_("small_right_body_fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition md = new MeshDefinition();
        PartDefinition pd = md.m_171576_();
        PartDefinition headpd = ModClientUtils.addC(pd, "head", 0, 0, -3.5f, -2.0f, -2.0f, 7.0f, 2.0f, 2.0f, 0.0f, -1.0f, -9.0f);
        PartDefinition hp1pd = ModClientUtils.addC(headpd, "head_part_1", 0, 8, -3.5f, -2.0f, -4.0f, 7.0f, 3.0f, 4.0f, 0.0f, 0.0f, -2.0f);
        PartDefinition hp2l1pd = ModClientUtils.addC(hp1pd, "head_part_2_left_1", 24, 0, -2.0f, -1.0f, -1.0f, 4.0f, 3.0f, 1.0f, 2.5f, -0.5f, -2.5f, 0.0f, -1.0471976f, 0.0f);
        PartDefinition hp2r1pd = ModClientUtils.addC(hp1pd, "head_part_2_right_1", 24, 0, -2.0f, -1.0f, -1.0f, 4.0f, 3.0f, 1.0f, -2.5f, -0.5f, -2.5f, 0.0f, 1.0471976f, 0.0f, true);
        PartDefinition hp2l2pd = ModClientUtils.addC(hp2l1pd, "head_part_2_left_2", 40, 0, -4.0f, -1.0f, -1.0f, 7.0f, 3.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        PartDefinition hp2r2pd = ModClientUtils.addC(hp2r1pd, "head_part_2_right_2", 40, 0, -3.0f, -1.0f, -1.0f, 7.0f, 3.0f, 1.0f, 0.0f, 0.0f, -1.0f, true);
        ModClientUtils.addC(hp2l1pd, "left_fang_1", 24, 8, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, 1.0f, -1.5f, 0.0f, -0.5f, -0.5f);
        ModClientUtils.addC(hp2r1pd, "right_fang_1", 24, 8, 0.0f, -1.0f, 0.0f, 2.0f, 3.0f, 1.0f, 1.5f, 0.0f, -0.5f, true, -0.5f);
        ModClientUtils.addC(hp2l2pd, "left_fang_2", 24, 12, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, 1.0f, -4.0f, 0.0f, -1.0f);
        ModClientUtils.addC(hp2r2pd, "right_fang_2", 24, 12, 0.0f, -1.0f, 0.0f, 2.0f, 3.0f, 1.0f, 4.0f, 0.0f, -1.0f, true);
        ModClientUtils.addC(hp1pd, "left_head_fin", 32, 8, 0.0f, -2.0f, -4.0f, 1.0f, 2.0f, 4.0f, 1.5f, -2.0f, 0.5f);
        ModClientUtils.addC(hp1pd, "right_head_fin", 32, 8, -1.0f, -2.0f, -4.0f, 1.0f, 2.0f, 4.0f, -1.5f, -2.0f, 0.5f, true);
        PartDefinition bodypd = ModClientUtils.addC(pd, "body", 0, 16, -5.5f, -3.0f, -9.0f, 11.0f, 4.0f, 11.0f, 0.0f, 0.0f, 0.0f);
        PartDefinition bp1pd = ModClientUtils.addC(bodypd, "body_part_1", 0, 32, -4.5f, -3.0f, 0.0f, 9.0f, 4.0f, 1.0f, 0.0f, 0.0f, 2.0f);
        PartDefinition bp2pd = ModClientUtils.addC(bp1pd, "body_part_2", 0, 40, -3.5f, -1.5f, 0.0f, 7.0f, 3.0f, 6.0f, 0.0f, -1.0f, 1.0f);
        ModClientUtils.addC(bodypd, "body_part_3", 32, 32, -4.5f, -2.0f, -1.0f, 9.0f, 3.0f, 1.0f, 0.0f, -0.5f, -9.0f);
        ModClientUtils.addC(bodypd, "left_rib", 64, 0, -1.0f, -2.0f, -3.0f, 3.0f, 3.0f, 7.0f, 2.0f, 2.25f, -2.0f);
        ModClientUtils.addC(bodypd, "right_rib", 64, 0, -2.0f, -2.0f, -3.0f, 3.0f, 3.0f, 7.0f, -2.0f, 2.25f, -2.0f, true);
        PartDefinition t1pd = ModClientUtils.addC(bp2pd, "tail_1", 0, 52, -2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 6.0f, 0.0f, -1.0f, 6.0f);
        PartDefinition t2pd = ModClientUtils.addC(t1pd, "tail_2", 0, 60, -1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 4.0f, 0.0f, 0.5f, 6.0f);
        ModClientUtils.addC(t2pd, "tail_3", 0, 68, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 8.0f, 0.0f, 0.0f, 4.0f);
        ModClientUtils.addC(t2pd, "left_tail_fin", 0, 80, 0.0f, 0.0f, 0.0f, 7.0f, 1.0f, 15.0f, 1.5f, 0.0f, 1.0f);
        ModClientUtils.addC(t2pd, "right_tail_fin", 0, 80, -7.0f, 0.0f, 0.0f, 7.0f, 1.0f, 15.0f, -1.5f, 0.0f, 1.0f, true);
        PartDefinition lwbpd = ModClientUtils.addC(bodypd, "left_wing_base", 64, 16, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 10.0f, 4.0f, -2.75f, -8.0f);
        PartDefinition lw1pd = ModClientUtils.addC(lwbpd, "left_wing_1", 64, 32, 0.0f, 0.0f, 0.0f, 4.0f, 3.0f, 10.0f, 2.0f, 0.0f, -0.5f, 0.0f, 0.0f, 0.1f);
        PartDefinition lw2pd = ModClientUtils.addC(lw1pd, "left_wing_2", 64, 48, 0.0f, 0.0f, 0.0f, 6.0f, 2.0f, 9.0f, 4.0f, 0.0f, -0.5f, 0.0f, 0.0f, 0.1f);
        ModClientUtils.addC(lw2pd, "left_wing_3", 64, 64, 0.0f, 0.0f, 0.0f, 13.0f, 1.0f, 9.0f, 6.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f);
        PartDefinition rwbpd = ModClientUtils.addC(bodypd, "right_wing_base", 64, 16, -2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 10.0f, -4.0f, -2.75f, -8.0f, true);
        PartDefinition rw1pd = ModClientUtils.addC(rwbpd, "right_wing_1", 64, 32, -4.0f, 0.0f, 0.0f, 4.0f, 3.0f, 10.0f, -2.0f, 0.0f, -0.5f, 0.0f, 0.0f, -0.1f, true);
        PartDefinition rw2pd = ModClientUtils.addC(rw1pd, "right_wing_2", 64, 48, -6.0f, 0.0f, 0.0f, 6.0f, 2.0f, 9.0f, -4.0f, 0.0f, -0.5f, 0.0f, 0.0f, -0.1f, true);
        ModClientUtils.addC(rw2pd, "right_wing_3", 64, 64, -13.0f, 0.0f, 0.0f, 13.0f, 1.0f, 9.0f, -6.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, true);
        PartDefinition slwbpd = ModClientUtils.addC(bp2pd, "small_left_wing_base", 32, 40, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 7.0f, 4.0f, -0.5f, 0.0f);
        PartDefinition slw1pd = ModClientUtils.addC(slwbpd, "small_left_wing_1", 32, 52, 0.0f, 0.0f, 0.0f, 4.0f, 1.0f, 8.0f, 2.0f, 0.0f, -0.5f, 0.0f, 0.0f, 0.1f);
        ModClientUtils.addC(slw1pd, "small_left_wing_2", 32, 64, 0.0f, 0.0f, 0.0f, 9.0f, 1.0f, 7.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f);
        PartDefinition srwbpd = ModClientUtils.addC(bp2pd, "small_right_wing_base", 32, 40, -2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 7.0f, -4.0f, -0.5f, 0.0f, true);
        PartDefinition srw1pd = ModClientUtils.addC(srwbpd, "small_right_wing_1", 32, 52, -4.0f, 0.0f, 0.0f, 4.0f, 1.0f, 8.0f, -2.0f, 0.0f, -0.5f, 0.0f, 0.0f, -0.1f, true);
        ModClientUtils.addC(srw1pd, "small_right_wing_2", 32, 64, -9.0f, 0.0f, 0.0f, 9.0f, 1.0f, 7.0f, -4.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, true);
        ModClientUtils.addC(bodypd, "left_body_fin", 96, 0, 0.0f, -5.0f, -10.0f, 1.0f, 5.0f, 12.0f, 1.5f, -2.25f, 2.0f);
        ModClientUtils.addC(bodypd, "right_body_fin", 96, 0, -1.0f, -5.0f, -10.0f, 1.0f, 5.0f, 12.0f, -1.5f, -2.25f, 2.0f, true);
        ModClientUtils.addC(bp2pd, "small_left_body_fin", 96, 24, 0.0f, -3.0f, -6.0f, 1.0f, 3.0f, 6.0f, 1.5f, -0.5f, 7.0f);
        ModClientUtils.addC(bp2pd, "small_right_body_fin", 96, 24, -1.0f, -3.0f, -6.0f, 1.0f, 3.0f, 6.0f, -1.5f, -0.5f, 7.0f, true);
        return LayerDefinition.m_171565_((MeshDefinition)md, (int)128, (int)128);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.headPart2Left1.f_104204_ = -1.0471976f;
        this.headPart2Right1.f_104204_ = 1.0471976f;
        float f = ((DyssomniaEntity)((Object)entityIn)).getAttackAnimationScale(partialTick);
        if (f > 0.0f) {
            this.headPart2Left1.f_104204_ -= f * ((float)Math.PI / 180) * 57.0f;
            this.headPart2Right1.f_104204_ += f * ((float)Math.PI / 180) * 57.0f;
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = 0.2f;
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = 0.0f;
        this.body.f_104203_ = -0.1f;
        this.bodyPart2.f_104203_ = 0.15f;
        this.bodyPart3.f_104203_ = 0.0f;
        this.leftRib.f_104205_ = 0.62831855f;
        this.rightRib.f_104205_ = -0.62831855f;
        this.leftRib.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.033f;
        this.rightRib.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.033f;
        this.leftRib.f_104204_ = 0.14959966f;
        this.rightRib.f_104204_ = -0.14959966f;
        float f = ((float)(entityIn.m_19879_() * 3) + ageInTicks) * 0.13f;
        float f1 = 9.0f;
        float f2 = (float)Math.PI / 180;
        this.leftFang1.f_104204_ = (8.0f + Mth.m_14089_((float)(f * 1.5f + 0.3926991f)) * 8.0f) * f2;
        this.rightFang1.f_104204_ = -this.leftFang1.f_104204_;
        this.leftFang2.f_104204_ = (9.0f + Mth.m_14089_((float)(f * 1.5f + 0.7853982f)) * 9.0f) * f2;
        this.rightFang2.f_104204_ = -this.leftFang2.f_104204_;
        this.leftWingBase.f_104204_ = 0.15707964f;
        this.rightWingBase.f_104204_ = -0.15707964f;
        this.leftWing1.f_104205_ = Mth.m_14089_((float)f) * f1 * f2;
        this.leftWing2.f_104205_ = Mth.m_14089_((float)f) * f1 * f2;
        this.leftWing3.f_104205_ = Mth.m_14089_((float)f) * f1 * f2;
        this.rightWing1.f_104205_ = -this.leftWing1.f_104205_;
        this.rightWing2.f_104205_ = -this.leftWing2.f_104205_;
        this.rightWing3.f_104205_ = -this.leftWing3.f_104205_;
        this.smallLeftWingBase.f_104204_ = -0.20943952f;
        this.smallRightWingBase.f_104204_ = 0.20943952f;
        this.smallLeftWing1.f_104205_ = Mth.m_14089_((float)(f + 0.62831855f)) * f1 * f2;
        this.smallLeftWing2.f_104205_ = Mth.m_14089_((float)(f + 0.62831855f)) * f1 * f2;
        this.smallRightWing1.f_104205_ = -this.smallLeftWing1.f_104205_;
        this.smallRightWing2.f_104205_ = -this.smallLeftWing2.f_104205_;
        this.leftHeadFin.f_104205_ = 0.7853982f;
        this.leftHeadFin.f_104205_ += Mth.m_14089_((float)(f * 2.0f + 1.4398967f)) * f1 * 0.5f * f2;
        this.rightHeadFin.f_104205_ = -this.leftBodyFin.f_104205_;
        this.leftBodyFin.f_104204_ = 0.10471976f;
        this.rightBodyFin.f_104204_ = -0.10471976f;
        this.leftBodyFin.f_104205_ = 0.7853982f;
        this.leftBodyFin.f_104205_ += Mth.m_14089_((float)(f * 2.0f + 1.5707964f)) * f1 * 0.5f * f2;
        this.rightBodyFin.f_104205_ = -this.leftBodyFin.f_104205_;
        this.smallLeftBodyFin.f_104205_ = 0.7853982f;
        this.smallLeftBodyFin.f_104205_ += Mth.m_14089_((float)(f * 2.0f + 1.701696f)) * f1 * 0.5f * f2;
        this.smallRightBodyFin.f_104205_ = -this.smallLeftBodyFin.f_104205_;
        this.tail1.f_104203_ = -(2.5f + Mth.m_14089_((float)(f * 2.0f)) * 5.0f) * f2 * 1.5f;
        this.tail2.f_104203_ = -(2.5f + Mth.m_14089_((float)(f * 2.0f)) * 5.0f) * f2 * 1.75f;
        this.tail3.f_104203_ = -(2.5f + Mth.m_14089_((float)(f * 2.0f)) * 5.0f) * f2 * 1.5f;
        this.leftTailFin.f_104205_ = Mth.m_14089_((float)(f * 2.0f + 1.5707964f)) * f1 * 1.2f * f2;
        this.rightTailFin.f_104205_ = -this.leftTailFin.f_104205_;
    }
}

