/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.AbstractFlyingMonsterEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HornetModel<T extends AbstractFlyingMonsterEntity>
extends HumanoidModel<T> {
    private ModelPart rightFeelerPart1;
    private ModelPart rightFeelerPart2;
    private ModelPart leftFeelerPart1;
    private ModelPart leftFeelerPart2;
    private ModelPart bust;
    private ModelPart rightWingA;
    private ModelPart leftWingA;
    private ModelPart rightWingB;
    private ModelPart leftWingB;
    private ModelPart rightArmAPart1;
    private ModelPart rightArmAPart2;
    private ModelPart leftArmAPart1;
    private ModelPart leftArmAPart2;
    private ModelPart rightArmB;
    private ModelPart rightArmBPart1;
    private ModelPart rightArmBPart2;
    private ModelPart leftArmB;
    private ModelPart leftArmBPart1;
    private ModelPart leftArmBPart2;
    private ModelPart rightLegPart1;
    private ModelPart rightLegPart2;
    private ModelPart rightLegPart3;
    private ModelPart rightLegPart4;
    private ModelPart leftLegPart1;
    private ModelPart leftLegPart2;
    private ModelPart leftLegPart3;
    private ModelPart leftLegPart4;
    private ModelPart thorax;
    private ModelPart abdomenPart1;
    private ModelPart abdomenPart2;
    private ModelPart abdomenPart3;
    private ModelPart abdomenPart4;
    private ModelPart abdomenPart5;
    private ModelPart abdomenPart6;
    private ModelPart abdomenPart7;
    private ModelPart abdomenPart8;
    private ModelPart abdomenPart9;
    private ModelPart needle;

    public HornetModel(ModelPart modelPart) {
        super(modelPart);
        this.rightFeelerPart1 = this.f_102808_.m_171324_("right_feeler_part_1");
        this.rightFeelerPart2 = this.rightFeelerPart1.m_171324_("right_feeler_part_2");
        this.leftFeelerPart1 = this.f_102808_.m_171324_("left_feeler_part_1");
        this.leftFeelerPart2 = this.leftFeelerPart1.m_171324_("left_feeler_part_2");
        this.bust = this.f_102810_.m_171324_("bust");
        this.rightWingA = this.f_102810_.m_171324_("right_wing_a");
        this.leftWingA = this.f_102810_.m_171324_("left_wing_a");
        this.rightWingB = this.f_102810_.m_171324_("right_wing_b");
        this.leftWingB = this.f_102810_.m_171324_("left_wing_b");
        this.rightArmAPart1 = this.f_102811_.m_171324_("right_arm_a_part_1");
        this.rightArmAPart2 = this.rightArmAPart1.m_171324_("right_arm_a_part_2");
        this.leftArmAPart1 = this.f_102812_.m_171324_("left_arm_a_part_1");
        this.leftArmAPart2 = this.leftArmAPart1.m_171324_("left_arm_a_part_2");
        this.rightArmB = modelPart.m_171324_("right_arm_b");
        this.rightArmBPart1 = this.rightArmB.m_171324_("right_arm_b_part_1");
        this.rightArmBPart2 = this.rightArmBPart1.m_171324_("right_arm_b_part_2");
        this.leftArmB = modelPart.m_171324_("left_arm_b");
        this.leftArmBPart1 = this.leftArmB.m_171324_("left_arm_b_part_1");
        this.leftArmBPart2 = this.leftArmBPart1.m_171324_("left_arm_b_part_2");
        this.rightLegPart1 = this.f_102813_.m_171324_("right_leg_part_1");
        this.rightLegPart2 = this.rightLegPart1.m_171324_("right_leg_part_2");
        this.rightLegPart3 = this.rightLegPart2.m_171324_("right_leg_part_3");
        this.rightLegPart4 = this.rightLegPart3.m_171324_("right_leg_part_4");
        this.leftLegPart1 = this.f_102814_.m_171324_("left_leg_part_1");
        this.leftLegPart2 = this.leftLegPart1.m_171324_("left_leg_part_2");
        this.leftLegPart3 = this.leftLegPart2.m_171324_("left_leg_part_3");
        this.leftLegPart4 = this.leftLegPart3.m_171324_("left_leg_part_4");
        this.thorax = this.f_102810_.m_171324_("thorax");
        this.abdomenPart1 = this.thorax.m_171324_("abdomen_part_1");
        this.abdomenPart2 = this.abdomenPart1.m_171324_("abdomen_part_2");
        this.abdomenPart3 = this.abdomenPart2.m_171324_("abdomen_part_3");
        this.abdomenPart4 = this.abdomenPart3.m_171324_("abdomen_part_4");
        this.abdomenPart5 = this.abdomenPart4.m_171324_("abdomen_part_5");
        this.abdomenPart6 = this.abdomenPart5.m_171324_("abdomen_part_6");
        this.abdomenPart7 = this.abdomenPart6.m_171324_("abdomen_part_7");
        this.abdomenPart8 = this.abdomenPart7.m_171324_("abdomen_part_8");
        this.abdomenPart9 = this.abdomenPart8.m_171324_("abdomen_part_9");
        this.needle = this.abdomenPart9.m_171324_("needle");
    }

    public static MeshDefinition createMesh(CubeDeformation cd) {
        MeshDefinition md = HumanoidModel.m_170681_((CubeDeformation)cd, (float)0.0f);
        PartDefinition pd = md.m_171576_();
        PartDefinition headpd = ModClientUtils.addC(pd, cd, "head", 0, 0, -3.0f, -7.0f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        PartDefinition rfp1pd = ModClientUtils.addC(headpd, cd, "right_feeler_part_1", 40, 32, -0.5f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f, -2.0f, -7.5f, -1.5f);
        ModClientUtils.addC(rfp1pd, cd, "right_feeler_part_2", 40, 40, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f, -4.75f, -0.25f, -0.25f);
        PartDefinition lfp1pd = ModClientUtils.addC(headpd, cd, "left_feeler_part_1", 40, 32, -0.5f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f, 2.0f, -7.5f, -1.5f, true);
        ModClientUtils.addC(lfp1pd, cd, "left_feeler_part_2", 40, 40, -1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f, -4.75f, -0.25f, true, -0.25f);
        PartDefinition bodypd = ModClientUtils.addC(pd, cd, "body", 16, 16, -3.0f, 0.0f, -1.5f, 6.0f, 8.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        ModClientUtils.addC(bodypd, cd, "bust", 0, 32, -3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f, 0.0f, 3.5f, -1.1f, -0.005f);
        ModClientUtils.addC(bodypd, cd, "right_wing_a", 24, 96, -16.0f, -8.0f, 0.0f, 16.0f, 8.0f, 1.0f, -1.5f, 4.0f, 1.5f);
        ModClientUtils.addC(bodypd, cd, "left_wing_a", 24, 96, 0.0f, -8.0f, 0.0f, 16.0f, 8.0f, 1.0f, 1.5f, 4.0f, 1.5f, true);
        ModClientUtils.addC(bodypd, cd, "right_wing_b", 24, 108, -10.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f, -1.5f, 5.0f, 1.5f);
        ModClientUtils.addC(bodypd, cd, "left_wing_b", 24, 108, 0.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f, 1.5f, 5.0f, 1.5f, true);
        PartDefinition rapd = ModClientUtils.addC(pd, cd, "right_arm", 40, 16, -2.0f, -2.0f, -1.5f, 4.0f, 2.0f, 3.0f, -5.0f, 2.0f, 0.0f);
        PartDefinition raap1pd = ModClientUtils.addC(rapd, cd, "right_arm_a_part_1", 48, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, -0.5f, -0.5f, 0.0f);
        ModClientUtils.addC(raap1pd, cd, "right_arm_a_part_2", 56, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 4.75f, 0.0f, 0.25f);
        PartDefinition lapd = ModClientUtils.addC(pd, cd, "left_arm", 40, 16, -2.0f, -2.0f, -1.5f, 4.0f, 2.0f, 3.0f, 5.0f, 2.0f, 0.0f, true);
        PartDefinition laap1pd = ModClientUtils.addC(lapd, cd, "left_arm_a_part_1", 48, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.5f, -0.5f, 0.0f, true);
        ModClientUtils.addC(laap1pd, cd, "left_arm_a_part_2", 56, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 4.75f, 0.0f, true, 0.25f);
        PartDefinition rabpd = ModClientUtils.addC(pd, cd, "right_arm_b", 48, 32, -1.0f, -2.0f, -1.5f, 2.0f, 2.0f, 3.0f, -4.0f, 4.5f, 0.0f);
        PartDefinition rabp1pd = ModClientUtils.addC(rabpd, cd, "right_arm_b_part_1", 48, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.5f, -0.5f, 0.0f);
        ModClientUtils.addC(rabp1pd, cd, "right_arm_b_part_2", 56, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 4.75f, 0.0f, 0.25f);
        PartDefinition labpd = ModClientUtils.addC(pd, cd, "left_arm_b", 48, 32, -1.0f, -2.0f, -1.5f, 2.0f, 2.0f, 3.0f, 4.0f, 4.5f, 0.0f, true);
        PartDefinition labp1pd = ModClientUtils.addC(labpd, cd, "left_arm_b_part_1", 48, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, -0.5f, -0.5f, 0.0f, true);
        ModClientUtils.addC(labp1pd, cd, "left_arm_b_part_2", 56, 40, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 4.75f, 0.0f, true, 0.25f);
        PartDefinition rlpd = ModClientUtils.addC(pd, cd, "right_leg", 0, 16, -1.5f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, -1.5f, 6.5f, -2.0f);
        PartDefinition rlp1pd = ModClientUtils.addC(rlpd, cd, "right_leg_part_1", 40, 56, -1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, 2.75f, 0.0f);
        PartDefinition rlp2pd = ModClientUtils.addC(rlp1pd, cd, "right_leg_part_2", 40, 64, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 3.75f, 0.0f, 0.25f);
        PartDefinition rlp3pd = ModClientUtils.addC(rlp2pd, cd, "right_leg_part_3", 40, 72, -2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, 0.0f, 4.5f, 0.0f);
        ModClientUtils.addC(rlp3pd, cd, "right_leg_part_4", 40, 80, -1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, 0.0f, 2.0f, 0.0f);
        PartDefinition llpd = ModClientUtils.addC(pd, cd, "left_leg", 0, 16, -1.5f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, 1.5f, 6.5f, -2.0f, true);
        PartDefinition llp1pd = ModClientUtils.addC(llpd, cd, "left_leg_part_1", 40, 56, -1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, 2.75f, 0.0f, true);
        PartDefinition llp2pd = ModClientUtils.addC(llp1pd, cd, "left_leg_part_2", 40, 64, -1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 3.75f, 0.0f, true, 0.25f);
        PartDefinition llp3pd = ModClientUtils.addC(llp2pd, cd, "left_leg_part_3", 40, 72, -2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, 0.0f, 4.5f, 0.0f, true);
        ModClientUtils.addC(llp3pd, cd, "left_leg_part_4", 40, 80, -1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, 0.0f, 2.0f, 0.0f, true);
        PartDefinition thoraxpd = ModClientUtils.addC(bodypd, cd, "thorax", 32, 48, -2.0f, -0.25f, -1.0f, 4.0f, 3.0f, 2.0f, 0.0f, 8.0f, 0.0f);
        PartDefinition abp1pd = ModClientUtils.addC(thoraxpd, cd, "abdomen_part_1", 18, 32, -2.5f, 0.0f, -1.5f, 5.0f, 1.0f, 3.0f, 0.0f, 2.0f, 0.25f);
        PartDefinition abp2pd = ModClientUtils.addC(abp1pd, cd, "abdomen_part_2", 0, 40, -3.0f, 0.0f, -2.0f, 6.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f);
        PartDefinition abp3pd = ModClientUtils.addC(abp2pd, cd, "abdomen_part_3", 0, 48, -3.5f, 0.0f, -3.0f, 7.0f, 2.0f, 6.0f, 0.0f, 1.0f, 0.0f);
        PartDefinition abp4pd = ModClientUtils.addC(abp3pd, cd, "abdomen_part_4", 0, 56, -4.0f, 0.0f, -3.5f, 8.0f, 2.0f, 7.0f, 0.0f, 2.0f, 0.0f);
        PartDefinition abp5pd = ModClientUtils.addC(abp4pd, cd, "abdomen_part_5", 0, 68, -4.5f, 0.0f, -4.0f, 9.0f, 4.0f, 8.0f, 0.0f, 2.0f, 0.0f);
        PartDefinition abp6pd = ModClientUtils.addC(abp5pd, cd, "abdomen_part_6", 0, 80, -4.0f, 0.0f, -3.5f, 8.0f, 2.0f, 7.0f, 0.0f, 4.0f, 0.0f);
        PartDefinition abp7pd = ModClientUtils.addC(abp6pd, cd, "abdomen_part_7", 0, 92, -3.0f, 0.0f, -2.5f, 6.0f, 1.0f, 5.0f, 0.0f, 2.0f, 0.5f);
        PartDefinition abp8pd = ModClientUtils.addC(abp7pd, cd, "abdomen_part_8", 0, 100, -2.5f, 0.0f, -2.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.5f);
        PartDefinition abp9pd = ModClientUtils.addC(abp8pd, cd, "abdomen_part_9", 0, 108, -1.5f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f, 0.0f, 1.0f, 0.75f);
        ModClientUtils.addC(abp9pd, cd, "needle", 32, 56, -1.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, 0.0f, 2.0f, 0.0f);
        return md;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)HornetModel.createMesh(CubeDeformation.f_171458_), (int)64, (int)128);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_, (Object)this.rightArmB, (Object)this.leftArmB);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)((AbstractFlyingMonsterEntity)((Object)entity)).isCharging(), (float)this.f_102608_, (float)ageInTicks);
        float f = (float)(-Math.PI) / (((AbstractFlyingMonsterEntity)((Object)entity)).isCharging() ? 4.0f : 15.0f);
        float f1 = Mth.m_14031_((float)(ageInTicks * 0.12f));
        float f2 = Mth.m_14031_((float)(ageInTicks * 0.09f));
        this.f_102811_.f_104205_ += f1 * 0.05f + 0.05f;
        this.f_102812_.f_104205_ -= f1 * 0.05f + 0.05f;
        this.rightArmAPart1.f_104203_ = 0.1308997f;
        this.leftArmAPart1.f_104203_ = 0.1308997f;
        this.rightArmAPart2.f_104203_ = -0.17453294f;
        this.leftArmAPart2.f_104203_ = -0.17453294f;
        this.rightArmAPart2.f_104205_ = 0.11219974f;
        this.leftArmAPart2.f_104205_ = -0.11219974f;
        this.rightArmB.f_104203_ = f * 0.2f;
        this.leftArmB.f_104203_ = f * 0.2f;
        this.rightArmB.f_104205_ = 0.0f;
        this.leftArmB.f_104205_ = 0.0f;
        if (this.f_102817_) {
            this.rightArmB.f_104203_ += -0.62831855f;
            this.leftArmB.f_104203_ += -0.62831855f;
        }
        this.rightArmB.f_104205_ += f2 * 0.05f + 0.05f;
        this.leftArmB.f_104205_ -= f2 * 0.05f + 0.05f;
        this.rightArmB.f_104203_ += f1 * 0.06f;
        this.leftArmB.f_104203_ -= f1 * 0.06f;
        this.rightArmBPart1.f_104203_ = -0.14959966f;
        this.leftArmBPart1.f_104203_ = -0.14959966f;
        this.rightArmBPart1.f_104204_ = -0.14959966f;
        this.leftArmBPart1.f_104204_ = 0.14959966f;
        this.rightArmBPart2.f_104203_ = -1.3463968f;
        this.leftArmBPart2.f_104203_ = -1.3463968f;
        this.f_102813_.f_104204_ = 0.11219974f;
        this.f_102814_.f_104204_ = -0.11219974f;
        if (this.f_102817_) {
            this.f_102813_.f_104205_ = 0.20943952f;
            this.f_102814_.f_104205_ = -0.20943952f;
            this.f_102813_.f_104203_ = -0.3926991f;
            this.f_102814_.f_104203_ = -0.3926991f;
            this.f_102813_.f_104203_ = 0.0f;
            this.f_102814_.f_104203_ = 0.0f;
            this.rightLegPart2.f_104203_ = 0.0f;
            this.leftLegPart2.f_104203_ = 0.0f;
            this.rightLegPart4.f_104203_ = -0.7853982f;
            this.leftLegPart4.f_104203_ = -0.7853982f;
        } else {
            this.f_102813_.f_104205_ = 0.09817477f;
            this.f_102814_.f_104205_ = -0.09817477f;
            this.f_102813_.f_104203_ = -0.62831855f;
            this.f_102814_.f_104203_ = -0.62831855f;
            this.f_102813_.f_104203_ += f1 * 0.045f;
            this.f_102814_.f_104203_ += f1 * 0.045f;
            f1 = Mth.m_14031_((float)(ageInTicks * 0.12f - 0.7853982f));
            this.rightLegPart2.f_104203_ = 1.5707964f;
            this.leftLegPart2.f_104203_ = 1.5707964f;
            this.rightLegPart2.f_104203_ -= f1 * 0.075f;
            this.leftLegPart2.f_104203_ -= f1 * 0.075f;
            this.rightLegPart4.f_104203_ = -1.0471976f;
            this.leftLegPart4.f_104203_ = -1.0471976f;
            this.rightLegPart4.f_104203_ += f1 * 0.072f;
            this.leftLegPart4.f_104203_ += f1 * 0.072f;
        }
        f1 = Mth.m_14031_((float)(ageInTicks * 0.12f - 0.7853982f));
        this.rightLegPart4.f_104204_ = 0.11219974f;
        this.leftLegPart4.f_104204_ = -0.11219974f;
        this.rightFeelerPart1.f_104204_ = 0.14959966f;
        this.leftFeelerPart1.f_104204_ = -0.14959966f;
        this.rightFeelerPart1.f_104203_ = 0.3926991f;
        this.leftFeelerPart1.f_104203_ = 0.3926991f;
        this.rightFeelerPart1.f_104203_ += f1 * 0.067f;
        this.leftFeelerPart1.f_104203_ += f1 * 0.067f;
        this.rightFeelerPart2.f_104204_ = 0.1308997f;
        this.leftFeelerPart2.f_104204_ = -0.1308997f;
        this.rightFeelerPart2.f_104203_ = 1.0471976f;
        this.leftFeelerPart2.f_104203_ = 1.0471976f;
        this.rightFeelerPart2.f_104203_ -= f2 * 0.048f;
        this.leftFeelerPart2.f_104203_ -= f2 * 0.048f;
        this.bust.f_104203_ = 0.95993114f;
        float f4 = Mth.m_14089_((float)(ageInTicks * 0.2f + 0.7853982f));
        float f3 = Mth.m_14089_((float)(ageInTicks * 2.1f));
        this.rightWingA.f_104204_ = 0.7853982f;
        this.leftWingA.f_104204_ = -0.7853982f;
        this.rightWingA.f_104205_ = 0.19634955f;
        this.leftWingA.f_104205_ = -0.19634955f;
        this.rightWingA.f_104204_ += f3 * 0.42f;
        this.leftWingA.f_104204_ -= f3 * 0.42f;
        this.rightWingA.f_104205_ += f4 * 0.18f;
        this.leftWingA.f_104205_ -= f4 * 0.18f;
        f3 = Mth.m_14089_((float)(ageInTicks * 2.1f + 1.0471976f));
        this.rightWingB.f_104204_ = 0.7853982f;
        this.leftWingB.f_104204_ = -0.7853982f;
        this.rightWingB.f_104205_ = -0.19634955f;
        this.leftWingB.f_104205_ = 0.19634955f;
        this.rightWingB.f_104204_ += f3 * 0.42f;
        this.leftWingB.f_104204_ -= f3 * 0.42f;
        this.rightWingB.f_104205_ -= f4 * 0.18f;
        this.leftWingB.f_104205_ += f4 * 0.18f;
        f2 = Mth.m_14031_((float)(ageInTicks * 0.09f + 1.5707964f));
        this.thorax.f_104203_ = 0.14959966f;
        this.thorax.f_104203_ += f2 * 0.036f;
        this.abdomenPart1.f_104203_ = 0.5235988f;
        this.abdomenPart1.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.12f;
        this.abdomenPart1.f_104203_ -= f1 * 0.067f;
        this.abdomenPart8.f_104203_ = f1 * 0.033f;
        this.abdomenPart9.f_104203_ = f1 * 0.04f;
        this.abdomenPart6.f_104201_ = 3.5f;
        this.abdomenPart6.f_104201_ -= Mth.m_14031_((float)(ageInTicks * 0.09f + (float)Math.PI)) * 0.2f;
        this.needle.f_104201_ = 1.0f;
        this.needle.f_104201_ -= Mth.m_14031_((float)(ageInTicks * 0.09f + (float)Math.PI)) * 0.8f;
    }
}

