/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KashaModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart tail1;
    private final ModelPart tail2A;
    private final ModelPart tail2B;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    public int state = 1;

    public KashaModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.m_171324_("head");
        this.body = modelPart.m_171324_("body");
        this.tail1 = modelPart.m_171324_("tail_1");
        this.tail2A = modelPart.m_171324_("tail_2a");
        this.tail2B = modelPart.m_171324_("tail_2b");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition md = new MeshDefinition();
        PartDefinition pd = md.m_171576_();
        pd.m_171599_("head", CubeListBuilder.m_171558_().m_171517_("main", -2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f).m_171534_("nose", -1.5f, 0.0f, -4.0f, 3, 2, 2, 0, 24).m_171534_("ear1", -2.0f, -3.0f, 0.0f, 1, 1, 2, 0, 10).m_171534_("ear2", 1.0f, -3.0f, 0.0f, 1, 1, 2, 6, 10), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-9.0f));
        pd.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-2.0f, 3.0f, -8.0f, 4.0f, 16.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)-10.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        pd.m_171599_("tail_1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)8.0f, (float)0.9f, (float)0.0f, (float)0.0f));
        pd.m_171599_("tail_2a", CubeListBuilder.m_171558_().m_171514_(4, 15).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)14.0f));
        pd.m_171599_("tail_2b", CubeListBuilder.m_171558_().m_171514_(4, 15).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)14.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(8, 13).m_171481_(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f);
        pd.m_171599_("left_hind_leg", cubelistbuilder, PartPose.m_171419_((float)1.1f, (float)18.0f, (float)5.0f));
        pd.m_171599_("right_hind_leg", cubelistbuilder, PartPose.m_171419_((float)-1.1f, (float)18.0f, (float)5.0f));
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f);
        pd.m_171599_("left_front_leg", cubelistbuilder1, PartPose.m_171419_((float)1.2f, (float)14.1f, (float)-5.0f));
        pd.m_171599_("right_front_leg", cubelistbuilder1, PartPose.m_171419_((float)-1.2f, (float)14.1f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)md, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104203_ = 1.5707964f;
        float f = 0.6662f;
        float f1 = 1.7278761f;
        float f2 = 0.47123894f;
        if (this.state == 2) {
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f)) * limbSwingAmount;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f + 0.3f)) * limbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f + (float)Math.PI + 0.3f)) * limbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f + (float)Math.PI)) * limbSwingAmount;
            this.tail2A.f_104203_ = f1 + 0.31415927f * Mth.m_14089_((float)limbSwing) * limbSwingAmount;
            this.tail2B.f_104203_ = f1 + 0.31415927f * Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * limbSwingAmount;
        } else {
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f)) * limbSwingAmount;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f + (float)Math.PI)) * limbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f + (float)Math.PI)) * limbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * f)) * limbSwingAmount;
            if (this.state == 1) {
                this.tail2A.f_104203_ = f1 + 0.7853982f * Mth.m_14089_((float)limbSwing) * limbSwingAmount;
                this.tail2B.f_104203_ = f1 + 0.7853982f * Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * limbSwingAmount;
            } else {
                this.tail2A.f_104203_ = f1 + f2 * Mth.m_14089_((float)limbSwing) * limbSwingAmount;
                this.tail2B.f_104203_ = f1 + f2 * Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * limbSwingAmount;
            }
        }
        this.tail1.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.067f - 0.7853982f)) * 0.036f;
        this.tail1.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.067f;
        this.tail2A.f_104204_ = 0.3926991f;
        this.tail2B.f_104204_ = -0.3926991f;
        this.tail2A.f_104204_ += Mth.m_14089_((float)(ageInTicks * 0.075f + 1.0471976f)) * 0.072f;
        this.tail2B.f_104204_ -= Mth.m_14089_((float)(ageInTicks * 0.075f)) * 0.072f;
    }

    public void m_6839_(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.body.f_104201_ = 12.0f;
        this.body.f_104202_ = -10.0f;
        this.head.f_104201_ = 15.0f;
        this.head.f_104202_ = -9.0f;
        this.tail1.f_104201_ = 15.0f;
        this.tail1.f_104202_ = 8.0f;
        this.tail2A.f_104201_ = 20.0f;
        this.tail2B.f_104202_ = 14.0f;
        this.tail2A.f_104201_ = 20.0f;
        this.tail2B.f_104202_ = 14.0f;
        this.leftFrontLeg.f_104201_ = 14.1f;
        this.leftFrontLeg.f_104202_ = -5.0f;
        this.rightFrontLeg.f_104201_ = 14.1f;
        this.rightFrontLeg.f_104202_ = -5.0f;
        this.leftHindLeg.f_104201_ = 18.0f;
        this.leftHindLeg.f_104202_ = 5.0f;
        this.rightHindLeg.f_104201_ = 18.0f;
        this.rightHindLeg.f_104202_ = 5.0f;
        this.tail1.f_104203_ = 0.9f;
        if (entityIn.m_6047_()) {
            this.body.f_104201_ += 1.0f;
            this.head.f_104201_ += 2.0f;
            this.tail1.f_104201_ += 1.0f;
            this.tail2A.f_104201_ += -4.0f;
            this.tail2A.f_104202_ += 2.0f;
            this.tail2B.f_104201_ += -4.0f;
            this.tail2B.f_104202_ += 2.0f;
            this.tail1.f_104203_ = 1.5707964f;
            this.tail2A.f_104203_ = 1.5707964f;
            this.tail2B.f_104203_ = 1.5707964f;
            this.state = 0;
        } else if (entityIn.m_20142_()) {
            this.tail2A.f_104201_ = this.tail1.f_104201_;
            this.tail2A.f_104202_ += 2.0f;
            this.tail2B.f_104201_ = this.tail1.f_104201_;
            this.tail2B.f_104202_ += 2.0f;
            this.tail1.f_104203_ = 1.5707964f;
            this.tail2A.f_104203_ = 1.5707964f;
            this.tail2B.f_104203_ = 1.5707964f;
            this.state = 2;
        } else {
            this.state = 1;
        }
    }
}

