/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.DyssomniaModel;
import com.github.mechalopa.hmag.client.renderer.layers.DyssomniaEyesLayer;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.DyssomniaEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DyssomniaRenderer
extends MobRenderer<DyssomniaEntity, DyssomniaModel<DyssomniaEntity>> {
    private static final ResourceLocation TEXTURE = ModClientUtils.getHMaGEntityTexture("dyssomnia");
    private final Random rand = new Random();

    public DyssomniaRenderer(EntityRendererProvider.Context context) {
        super(context, new DyssomniaModel(context.m_174023_(ModModelLayers.DYSSOMNIA)), 1.2f);
        this.m_115326_((RenderLayer)new DyssomniaEyesLayer(this));
    }

    protected void scale(DyssomniaEntity entity, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(1.75f, 1.75f, 1.75f);
        poseStack.m_85837_(0.0, 1.25, 0.0);
    }

    protected void setupRotations(DyssomniaEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.getXRotAnimationScale(partialTicks) * 180.0f));
    }

    public Vec3 getRenderOffset(DyssomniaEntity entity, float partialTicks) {
        if (entity.getAttackingTime() >= 0 && entity.getAttackPhase() == DyssomniaEntity.AttackPhase.SUMMON && entity.m_6084_()) {
            return new Vec3(this.rand.nextGaussian() * 0.03, this.rand.nextGaussian() * 0.03, this.rand.nextGaussian() * 0.03);
        }
        return super.m_7860_((Entity)entity, partialTicks);
    }

    public ResourceLocation getTextureLocation(DyssomniaEntity entity) {
        return TEXTURE;
    }
}

