/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.projectile.MagicBulletEntity;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MagicBulletRenderer
extends EntityRenderer<MagicBulletEntity> {
    private static final Map<MagicBulletEntity.Variant, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newEnumMap(MagicBulletEntity.Variant.class), p -> {
        p.put(MagicBulletEntity.Variant.LICH, ModClientUtils.getHMaGEntityTexture("projectile/magic_bullet_0"));
        p.put(MagicBulletEntity.Variant.DYSSOMNIA, ModClientUtils.getHMaGEntityTexture("projectile/magic_bullet_1"));
        p.put(MagicBulletEntity.Variant.NEMESIS, ModClientUtils.getHMaGEntityTexture("projectile/magic_bullet_2"));
        p.put(MagicBulletEntity.Variant.NIGHTWALKER, ModClientUtils.getHMaGEntityTexture("projectile/magic_bullet_3"));
    });

    public MagicBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(MagicBulletEntity entity, BlockPos pos) {
        switch (entity.getVariant()) {
            case DYSSOMNIA: {
                return Mth.m_14045_((int)(super.m_6086_((Entity)entity, pos) + 7), (int)0, (int)15);
            }
        }
        return 15;
    }

    public void render(MagicBulletEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float f = (float)entity.f_19797_ + partialTicks;
        float f1 = 0.5f + (entity.getVariant() == MagicBulletEntity.Variant.NEMESIS ? Mth.m_14031_((float)(f * 0.8f)) * 0.03f : Mth.m_14031_((float)(f * 0.4f)) * 0.09f);
        poseStack.m_85841_(f1, f1, f1);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1);
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1);
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0);
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void drawVertex(VertexConsumer vertexConsumer, Matrix4f matrix, Matrix3f normals, int packedLightIn, float f, int i, int j, int k) {
        vertexConsumer.m_252986_(matrix, f - 0.5f, (float)i - 0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)j, (float)k).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(MagicBulletEntity entity) {
        return TEXTURES.getOrDefault((Object)entity.getVariant(), TEXTURES.get((Object)MagicBulletEntity.Variant.LICH));
    }
}

