/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.AbstractFlyingMonsterEntity;
import com.github.mechalopa.hmag.world.entity.CommonOrUncommonVariant;
import javax.annotation.Nullable;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class BansheeEntity
extends AbstractFlyingMonsterEntity
implements VariantHolder<CommonOrUncommonVariant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(BansheeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BansheeEntity(EntityType<? extends BansheeEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 12;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)CommonOrUncommonVariant.COMMON.getId());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new AbstractFlyingMonsterEntity.ChargeAttackGoal(0.5, 1.5f));
        this.f_21345_.m_25352_(5, (Goal)new AbstractFlyingMonsterEntity.MoveRandomGoal());
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(120));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22277_, 24.0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_()) {
            Vec3 vec3 = this.getVariant() == CommonOrUncommonVariant.UNCOMMON ? new Vec3((double)(this.m_217043_().m_188501_() * 0.1f + 0.8f), (double)(this.m_217043_().m_188501_() * 0.1f + 0.9f), (double)(this.m_217043_().m_188501_() * 0.375f + 0.25f)) : new Vec3((double)(this.m_217043_().m_188501_() * 0.25f + 0.75f), (double)(this.m_217043_().m_188501_() * 0.25f + 0.25f), (double)(this.m_217043_().m_188501_() * 0.5f + 0.5f));
            this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(vec3.m_252839_(), 0.875f), this.m_20208_(0.75), this.m_20187_() - 0.25, this.m_20262_(0.75), 0.0, 0.0, 0.0);
        }
        ModUtils.burnInDay((LivingEntity)this, this.m_217043_(), this.m_21527_());
        super.m_8107_();
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            ModUtils.catchFire((LivingEntity)this, entity, this.m_217043_());
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19612_, i * 20, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(levelAccessor, difficulty, spawnType, spawnData, dataTag);
        this.setVariant(CommonOrUncommonVariant.getSpawnVariant(levelAccessor.m_213780_(), ModConfigs.cachedServer.BANSHEE_ANOTHER_VARIANT_SPAWN_CHANCE));
        return spawnData;
    }

    public CommonOrUncommonVariant getVariant() {
        return CommonOrUncommonVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(CommonOrUncommonVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.getId());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(CommonOrUncommonVariant.byId(compound.m_128451_("Variant")));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
    }

    public int m_5792_() {
        return 3;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_DEATH.get();
    }
}

