/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.util.ModUtils;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class GhastlySeekerEntity
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Integer> ATTACKING_TIME = SynchedEntityData.m_135353_(GhastlySeekerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int explosionPower = 1;

    public GhastlySeekerEntity(EntityType<? extends GhastlySeekerEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 25;
        this.f_21342_ = new GhastlySeekerMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAroundGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FireballAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p -> Math.abs(p.m_20186_() - this.m_20186_()) <= 10.0));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING_TIME, (Object)-1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_() && this.f_19797_ % 3 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_() - 0.8, this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return this.getAttackingTime() > 10;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackingTime() {
        return (Integer)this.f_19804_.m_135370_(ATTACKING_TIME);
    }

    private void setAttackingTime(int value) {
        this.f_19804_.m_135381_(ATTACKING_TIME, (Object)value);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    protected boolean m_8028_() {
        return true;
    }

    private static boolean isReflectedFireball(DamageSource source) {
        return source.m_7640_() != null && source.m_7640_() instanceof LargeFireball && source.m_7639_() instanceof Player;
    }

    public boolean m_6673_(DamageSource source) {
        return !GhastlySeekerEntity.isReflectedFireball(source) && super.m_6673_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (GhastlySeekerEntity.isReflectedFireball(source)) {
            return super.m_6469_(source, amount * 2.0f);
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11919_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11921_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public static boolean checkGhastlySeekerSpawnRules(EntityType<GhastlySeekerEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && random.m_188500_() < ModConfigs.cachedServer.GHASTLY_SEEKER_SPAWN_CHANCE && Mob.m_217057_(type, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public int m_5792_() {
        return 1;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ExplosionPower", this.explosionPower);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ExplosionPower", 99)) {
            this.explosionPower = compound.m_128451_("ExplosionPower");
        }
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected class GhastlySeekerMoveControl
    extends MoveControl {
        private final GhastlySeekerEntity parent;
        private int floatDuration;

        public GhastlySeekerMoveControl(GhastlySeekerEntity mob) {
            super((Mob)mob);
            this.parent = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.parent.m_217043_().m_188503_(5) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.parent.m_20185_(), this.f_24976_ - this.parent.m_20186_(), this.f_24977_ - this.parent.m_20189_());
                double d0 = vec3.m_82553_();
                if (ModUtils.canReach((LivingEntity)this.parent, vec3 = vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parent.m_20256_(this.parent.m_20184_().m_82549_(vec3.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }
    }

    private static class RandomFlyGoal
    extends Goal {
        private final GhastlySeekerEntity parent;

        public RandomFlyGoal(GhastlySeekerEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movecontrol = this.parent.m_21566_();
            if (!movecontrol.m_24995_()) {
                return true;
            }
            double d0 = movecontrol.m_25000_() - this.parent.m_20185_();
            double d3 = d0 * d0 + (d1 = movecontrol.m_25001_() - this.parent.m_20186_()) * d1 + (d2 = movecontrol.m_25002_() - this.parent.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            LivingEntity target;
            double distance;
            RandomSource random = this.parent.m_217043_();
            boolean flag = false;
            if (this.parent.m_5448_() != null && (distance = (target = this.parent.m_5448_()).m_20280_((Entity)this.parent)) < 4096.0 && distance > 256.0) {
                Vec3 vec3 = target.m_20299_(1.0f);
                this.parent.m_21566_().m_6849_(vec3.f_82479_ + (double)((random.m_188501_() * 2.0f - 1.0f) * 2.0f), vec3.f_82480_ - 1.0, vec3.f_82481_ + (double)((random.m_188501_() * 2.0f - 1.0f) * 2.0f), 0.75);
                flag = true;
            }
            if (!flag) {
                double d0 = this.parent.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.parent.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.parent.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                this.parent.m_21566_().m_6849_(d0, d1, d2, 0.75);
            }
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final GhastlySeekerEntity parent;

        public LookAroundGoal(GhastlySeekerEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.parent.m_5448_() == null) {
                Vec3 vec3 = this.parent.m_20184_();
                this.parent.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.parent.f_20883_ = this.parent.m_146908_();
            } else {
                LivingEntity target = this.parent.m_5448_();
                if (target.m_20280_((Entity)this.parent) < 4096.0) {
                    double d0 = target.m_20185_() - this.parent.m_20185_();
                    double d1 = target.m_20189_() - this.parent.m_20189_();
                    this.parent.m_146922_(-((float)Mth.m_14136_((double)d0, (double)d1)) * 57.295776f);
                    this.parent.f_20883_ = this.parent.m_146908_();
                }
            }
        }
    }

    private static class FireballAttackGoal
    extends Goal {
        private final GhastlySeekerEntity parent;
        public int attackTimer;

        public FireballAttackGoal(GhastlySeekerEntity mob) {
            this.parent = mob;
        }

        public boolean m_8036_() {
            return this.parent.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.parent.setAttackingTime(-1);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.parent.m_5448_();
            if (target != null) {
                double d0 = 24.0;
                if ((target.m_20280_((Entity)this.parent) < d0 * d0 || this.attackTimer > 10) && this.parent.m_142582_((Entity)target)) {
                    Level world = this.parent.m_9236_();
                    ++this.attackTimer;
                    if (this.attackTimer == 10 && !this.parent.m_20067_()) {
                        world.m_5898_((Player)null, 1015, this.parent.m_20183_(), 0);
                    }
                    if (this.attackTimer == 20) {
                        double d1 = 4.0;
                        Vec3 vec3 = this.parent.m_20252_(1.0f);
                        double d2 = target.m_20185_() - (this.parent.m_20185_() + vec3.f_82479_ * d1);
                        double d3 = target.m_20186_() + (double)target.m_20192_() * 0.5 - this.parent.m_20227_(0.5) + 0.25;
                        double d4 = target.m_20189_() - (this.parent.m_20189_() + vec3.f_82481_ * d1);
                        if (!this.parent.m_20067_()) {
                            world.m_5898_((Player)null, 1016, this.parent.m_20183_(), 0);
                        }
                        LargeFireball largefireball = new LargeFireball(world, (LivingEntity)this.parent, d2, d3, d4, this.parent.getExplosionPower());
                        largefireball.m_6034_(this.parent.m_20185_() + vec3.f_82479_ * 0.5, this.parent.m_20227_(0.5) + 0.25, largefireball.m_20189_() + vec3.f_82481_ * 0.5);
                        world.m_7967_((Entity)largefireball);
                        this.attackTimer = -50;
                    }
                } else if (this.attackTimer > 0) {
                    --this.attackTimer;
                }
                this.parent.setAttackingTime(this.attackTimer < 0 ? -1 : this.attackTimer);
            }
        }
    }
}

