/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class GiantMummyEntity
extends Monster {
    public GiantMummyEntity(EntityType<? extends GiantMummyEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal2((PathfinderMob)this, 1.0, false, 0.8888889f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (ModConfigs.cachedServer.GIANT_MUMMY_ATTACK_VILLAGERS) {
            this.f_21345_.m_25352_(4, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> false));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (ModConfigs.cachedServer.GIANT_MUMMY_ATTACK_BABY_TURTLES) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 20.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GiantMummyNavigation(this, level);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_() && this.f_19797_ % 2 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.m_217043_().m_188500_() - 0.5) * 3.0, -this.m_217043_().m_188500_(), (this.m_217043_().m_188500_() - 0.5) * 3.0);
        }
        ModUtils.burnInDay((LivingEntity)this, this.m_217043_(), this.m_21527_());
        super.m_8107_();
        if (this.m_6084_() && ModConfigs.cachedServer.GIANT_MUMMY_DESTROY_BLOCKS && this.m_9236_().m_46791_().m_19028_() > 1 && this.m_5448_() != null && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.25);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState state = this.m_9236_().m_8055_(blockpos);
                if (!this.canDestroyBlock(state, this.m_9236_(), blockpos, (LivingEntity)this)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            ModUtils.catchFire((LivingEntity)this, entity, this.m_217043_());
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19612_, i * 20, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.GIANT_MUMMY_VULNERABLE_TO)) {
            amount *= 1.5f;
        }
        if (source.m_269533_(ModTags.DamageTypeTags.GIANT_MUMMY_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public static boolean checkGiantMummySpawnRules(EntityType<GiantMummyEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() >= ModConfigs.cachedServer.SURFACE_MOB_SPAWN_MIN_HEIGHT || levelAccessor.m_6018_().m_215010_().m_220491_(pos, ModTags.StructureTags.GIANT_MUMMIES_SPAWN_IN).m_73603_());
    }

    public int m_5792_() {
        return 2;
    }

    public double m_6049_() {
        return -0.6;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 2.5f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GIANT_MUMMY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.GIANT_MUMMY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GIANT_MUMMY_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12047_, 0.15f, 1.0f);
    }

    private boolean canDestroyBlock(BlockState state, Level level, BlockPos pos, LivingEntity livingEntity) {
        return state.m_204336_(ModTags.BlockTags.GIANT_MUMMY_DESTROYABLES) && state.canEntityDestroy((BlockGetter)this.m_9236_(), pos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)pos, (BlockState)state);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class GiantMummyNavigation
    extends GroundPathNavigation {
        public GiantMummyNavigation(GiantMummyEntity mob, Level level) {
            super((Mob)mob, level);
        }

        protected PathFinder m_5532_(int maxVisitedNodes) {
            this.f_26508_ = new GiantMummyNodeEvaluator();
            return new PathFinder(this.f_26508_, maxVisitedNodes);
        }
    }

    private static class GiantMummyNodeEvaluator
    extends WalkNodeEvaluator {
        private GiantMummyNodeEvaluator() {
        }

        protected BlockPathTypes m_264405_(BlockGetter getter, BlockPos pos, BlockPathTypes blockPathTypes) {
            if ((blockPathTypes == BlockPathTypes.BLOCKED || blockPathTypes == BlockPathTypes.FENCE || blockPathTypes == BlockPathTypes.LEAVES || blockPathTypes == BlockPathTypes.COCOA) && this.f_77313_ != null && this.f_77313_.m_6084_() && ModConfigs.cachedServer.GIANT_MUMMY_DESTROY_BLOCKS && this.f_77313_.m_9236_().m_46791_().m_19028_() > 1 && this.f_77313_.m_5448_() != null && getter.m_8055_(pos).m_204336_(ModTags.BlockTags.GIANT_MUMMY_DESTROYABLES)) {
                return BlockPathTypes.OPEN;
            }
            return super.m_264405_(getter, pos, blockPathTypes);
        }
    }
}

