/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.SlimeGirlEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class MagicalSlimeEntity
extends Slime
implements VariantHolder<SlimeGirlEntity.ColorVariant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(MagicalSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MagicalSlimeEntity(EntityType<? extends MagicalSlimeEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)SlimeGirlEntity.ColorVariant.PINK_1.getId());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.MAGICAL_SLIME_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7839_(int size, boolean resetHealth) {
        super.m_7839_(size, resetHealth);
        this.setVariant(SlimeGirlEntity.ColorVariant.getSpawnVariant(this.m_217043_()));
        this.m_21051_(Attributes.f_22284_).m_22100_((double)(size * 2));
    }

    protected int m_7549_() {
        return (int)((float)super.m_7549_() * 0.75f);
    }

    protected boolean m_7483_() {
        return this.m_21515_();
    }

    protected float m_7566_() {
        return super.m_7566_() + 2.0f;
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123771_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getColors() {
        return this.getVariant().getColors();
    }

    public SlimeGirlEntity.ColorVariant getVariant() {
        return SlimeGirlEntity.ColorVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(SlimeGirlEntity.ColorVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.getId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(SlimeGirlEntity.ColorVariant.byId(compound.m_128451_("Variant")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

