/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.world.entity.projectile.InkSpitEntity;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public class SwamperEntity
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> SHOULD_SPIT_TIMER = SynchedEntityData.m_135353_(SwamperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_SUFFOCATING = SynchedEntityData.m_135353_(SwamperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SwamperEntity(EntityType<? extends SwamperEntity> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21364_ = 12;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_SPIT_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_SUFFOCATING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SwamperFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SwamperGoToWaterGoal(this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new SwamperMeleeAttackGoal(this, 1.2, false, 0.8888889f, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 60, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new SwamperRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.17).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20072_() && this.isSuffocating()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_8119_() {
        if (!this.m_21525_()) {
            this.setSuffocating(!this.m_20072_() && SwamperEntity.isSuffocatingBiome((Entity)this, this.m_9236_()) || this.m_6060_());
        }
        super.m_8119_();
    }

    private static boolean isSuffocatingBiome(Entity enity, Level level) {
        return level.m_204166_(enity.m_20183_()).m_203656_(ModTags.BiomeTags.SWAMPER_SUFFOCATES);
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_() && this.m_20069_() && this.m_217043_().m_188503_(4) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.75), this.m_20227_(this.m_217043_().m_188500_() * 0.75) - 0.1, this.m_20262_(0.75), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if (!this.isSuffocating() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_().m_21223_() <= 1.0f && this.m_21223_() <= this.m_21233_() / 4.0f) {
                this.setShouldSpitTimer(Math.max(20, this.getShouldSpitTimer() - 1));
            } else if (this.getShouldSpitTimer() > 0) {
                if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                    this.setShouldSpitTimer(this.getShouldSpitTimer() - 1);
                } else {
                    this.setShouldSpitTimer(0);
                }
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public void m_6504_(LivingEntity target, float distance) {
        InkSpitEntity inkspit = new InkSpitEntity(this.m_9236_(), (LivingEntity)this);
        double d0 = target.m_20188_() - (double)1.1f;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - inkspit.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.2;
        inkspit.m_6686_(d1, d2 + d4, d3, 1.4f, 12.0f);
        inkspit.setDamage(2.0f);
        this.m_9236_().m_7967_((Entity)inkspit);
        this.m_5496_((SoundEvent)ModSoundEvents.SWAMPER_SQUIRT.get(), this.m_6121_(), this.m_6100_());
        this.setShouldSpitTimer(0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.SWAMPER_VULNERABLE_TO)) {
            amount *= 1.5f;
        }
        if (source.m_269533_(ModTags.DamageTypeTags.SWAMPER_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        if (super.m_6469_(source, amount)) {
            if (!this.m_9236_().m_5776_() && !this.m_21525_() && this.getShouldSpitTimer() <= 0 && !this.isSuffocating() && this.m_217043_().m_188503_(3) == 0 && source.m_7640_() != null && source.m_7640_() instanceof LivingEntity && this.m_5448_() != null && source.m_7640_().equals((Object)this.m_5448_()) && !this.m_5448_().m_21023_(MobEffects.f_19610_)) {
                this.setShouldSpitTimer(60);
            }
            return true;
        }
        return false;
    }

    public int getShouldSpitTimer() {
        return (Integer)this.f_19804_.m_135370_(SHOULD_SPIT_TIMER);
    }

    private void setShouldSpitTimer(int value) {
        this.f_19804_.m_135381_(SHOULD_SPIT_TIMER, (Object)value);
    }

    public boolean isSuffocating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SUFFOCATING);
    }

    public void setSuffocating(boolean flag) {
        this.f_19804_.m_135381_(DATA_SUFFOCATING, (Object)flag);
    }

    public int m_5792_() {
        return 3;
    }

    public int m_8132_() {
        return 6;
    }

    public int m_8085_() {
        return 12;
    }

    public double m_6049_() {
        return 0.1;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.9f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.SWAMPER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.SWAMPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.SWAMPER_DEATH.get();
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class SwamperFloatGoal
    extends FloatGoal {
        private final SwamperEntity mob;

        public SwamperFloatGoal(SwamperEntity mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && !this.mob.m_5448_().isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get());
        }
    }

    private class SwamperGoToWaterGoal
    extends Goal {
        private final SwamperEntity mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public SwamperGoToWaterGoal(SwamperEntity mob, double speed) {
            this.mob = mob;
            this.speedModifier = speed;
            this.level = mob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mob.isSuffocating() || this.mob.m_20072_()) {
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource random = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(random.m_188503_(20) - 10, 2 - random.m_188503_(8), random.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    private class SwamperMeleeAttackGoal
    extends MeleeAttackGoal2 {
        private final SwamperEntity mob;
        private final Level level;

        public SwamperMeleeAttackGoal(SwamperEntity mob, double speed, boolean useLongMemory, float reachScale, float maxAttackDistance) {
            super((PathfinderMob)mob, speed, useLongMemory, reachScale, maxAttackDistance);
            this.mob = mob;
            this.level = mob.m_9236_();
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.mob.getShouldSpitTimer() <= 0;
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && this.mob.getShouldSpitTimer() <= 0;
        }

        @Override
        protected boolean isValidDistance(LivingEntity attackTarget) {
            return !this.mob.m_20072_() || !SwamperEntity.isSuffocatingBiome((Entity)this.mob, this.level) ? super.isValidDistance(attackTarget) : 4.0 >= this.mob.m_20275_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_());
        }
    }

    private class SwamperRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        private final SwamperEntity mob;
        private final Level level;

        public SwamperRandomStrollGoal(SwamperEntity mob, double speed) {
            super((PathfinderMob)mob, speed);
            this.mob = mob;
            this.level = mob.m_9236_();
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (this.mob.m_20072_() && SwamperEntity.isSuffocatingBiome((Entity)this.mob, this.level)) {
                Vec3 vec3 = super.m_7037_();
                return vec3 != null && this.level.m_8055_(BlockPos.m_274446_((Position)vec3)).m_60713_(Blocks.f_49990_) ? vec3 : null;
            }
            if (this.level.m_46461_() && this.level.m_45527_(this.mob.m_20183_())) {
                return super.m_7037_();
            }
            return DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
        }
    }
}

