/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class RangedAttackGoal2
extends Goal {
    private final Mob mob;
    private final RangedAttackMob rangedAttackMob;
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float maxAttackDistanceSqr;
    private final float minAttackDistanceSqr;
    private final boolean canStrafe;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public RangedAttackGoal2(RangedAttackMob attacker, double movespeed, int attackIntervalMin, float maxAttackDistance) {
        this(attacker, movespeed, attackIntervalMin, attackIntervalMin, maxAttackDistance);
    }

    public RangedAttackGoal2(RangedAttackMob attacker, double movespeed, int attackIntervalMin, int attackIntervalMax, float maxAttackDistance) {
        this(attacker, movespeed, attackIntervalMin, attackIntervalMax, maxAttackDistance, maxAttackDistance, false);
    }

    public RangedAttackGoal2(RangedAttackMob attacker, double movespeed, int attackIntervalMin, int attackIntervalMax, float maxAttackDistance, boolean canStrafe) {
        this(attacker, movespeed, attackIntervalMin, attackIntervalMax, maxAttackDistance, maxAttackDistance, canStrafe);
    }

    public RangedAttackGoal2(RangedAttackMob attacker, double movespeed, int attackIntervalMin, int attackIntervalMax, float maxAttackDistance, float minAttackDistance, boolean canStrafe) {
        if (!(attacker instanceof LivingEntity)) {
            throw new IllegalArgumentException("RangedAttackGoal2 requires Mob implements RangedAttackMob");
        }
        this.rangedAttackMob = attacker;
        this.mob = (Mob)attacker;
        this.speedModifier = movespeed;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = maxAttackDistance;
        this.maxAttackDistanceSqr = maxAttackDistance * maxAttackDistance;
        this.minAttackDistanceSqr = minAttackDistance * minAttackDistance;
        this.canStrafe = canStrafe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.maxAttackDistanceSqr || d0 > (double)this.minAttackDistanceSqr && this.attackTime > 10 || this.seeTime < (this.canStrafe ? 20 : 5))) {
            this.mob.m_21573_().m_26573_();
            if (this.canStrafe) {
                ++this.strafingTime;
            }
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            if (this.canStrafe) {
                this.strafingTime = -1;
            }
        }
        if (this.canStrafe && this.strafingTime >= 20) {
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.canStrafe && this.strafingTime > -1) {
            if (d0 > (double)(this.maxAttackDistanceSqr * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.maxAttackDistanceSqr * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.m_21391_((Entity)this.target, 30.0f, 30.0f);
        } else {
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        }
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.m_6504_(this.target, f1);
            this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public LivingEntity getTarget() {
        return this.target;
    }
}

