/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item;

import com.github.mechalopa.hmag.util.ModTags;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum ModArmorMaterial implements StringRepresentable,
ArmorMaterial
{
    ANCIENT("hmag:ancient", 34, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), p -> {
        p.put(ArmorItem.Type.BOOTS, 3);
        p.put(ArmorItem.Type.LEGGINGS, 6);
        p.put(ArmorItem.Type.CHESTPLATE, 8);
        p.put(ArmorItem.Type.HELMET, 3);
    }), 15, SoundEvents.f_11677_, 2.5f, 0.05f, () -> Ingredient.m_204132_(ModTags.ItemTags.ANCIENT_ARMOR_REPAIR_ITEMS)),
    NECROTIC_CHAIN("hmag:necrotic_chainmail", 19, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), p -> {
        p.put(ArmorItem.Type.BOOTS, 2);
        p.put(ArmorItem.Type.LEGGINGS, 5);
        p.put(ArmorItem.Type.CHESTPLATE, 6);
        p.put(ArmorItem.Type.HELMET, 2);
    }), 15, SoundEvents.f_11672_, 2.0f, 0.0f, () -> Ingredient.m_204132_(ModTags.ItemTags.NECROTIC_CHAINMAIL_ARMOR_REPAIR_ITEMS));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private ModArmorMaterial(String nameIn, int durabilityMultiplierIn, EnumMap<ArmorItem.Type, Integer> protectionFunctionForTypeIn, int enchantmentIn, SoundEvent sound, float toughnessIn, float knockbackResistanceIn, Supplier<Ingredient> repairItems) {
        this.name = nameIn;
        this.durabilityMultiplier = durabilityMultiplierIn;
        this.protectionFunctionForType = protectionFunctionForTypeIn;
        this.enchantmentValue = enchantmentIn;
        this.sound = sound;
        this.toughness = toughnessIn;
        this.knockbackResistance = knockbackResistanceIn;
        this.repairIngredient = new LazyLoadedValue(repairItems);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

