/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.level.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record ModAddSpawnsBiomeModifier(List<List<BiomeProp>> biomePropLists, List<MobSpawnSettings.SpawnerData> spawners, double energyBudget, double charge) implements BiomeModifier
{
    public static final Supplier<Codec<ModAddSpawnsBiomeModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(builder -> builder.group((App)BiomeProp.CODEC.listOf().listOf().fieldOf("biomes").forGetter(ModAddSpawnsBiomeModifier::biomePropLists), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(ModAddSpawnsBiomeModifier::spawners), (App)Codec.DOUBLE.optionalFieldOf("energy_budget", (Object)-1.0).forGetter(ModAddSpawnsBiomeModifier::energyBudget), (App)Codec.DOUBLE.optionalFieldOf("charge", (Object)-1.0).forGetter(ModAddSpawnsBiomeModifier::charge)).apply((Applicative)builder, ModAddSpawnsBiomeModifier::new)));

    public static ModAddSpawnsBiomeModifier singleSpawn(List<List<BiomeProp>> biomePropLists, MobSpawnSettings.SpawnerData spawner, double energyBudget, double charge) {
        return new ModAddSpawnsBiomeModifier(biomePropLists, List.of(spawner), energyBudget, charge);
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && ModAddSpawnsBiomeModifier.matches(biome, this.biomePropLists)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                EntityType type = spawner.f_48404_;
                spawns.m_48376_(type.m_20674_(), spawner);
                if (!(this.energyBudget > 0.0) || !(this.charge > 0.0)) continue;
                spawns.m_48370_(type, this.charge, this.energyBudget);
            }
        }
    }

    public static boolean matches(Holder<Biome> biome, List<List<BiomeProp>> biomePropLists) {
        if (biomePropLists != null && !biomePropLists.isEmpty()) {
            for (List<BiomeProp> biomeProps : biomePropLists) {
                boolean flag = true;
                for (BiomeProp biomeProp : biomeProps) {
                    if (!(!biomeProp.biomes().m_203333_(biome) ^ biomeProp.negate())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                return true;
            }
        }
        return false;
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC.get();
    }

    public record BiomeProp(HolderSet<Biome> biomes, boolean negate) {
        public static final Codec<BiomeProp> CODEC = RecordCodecBuilder.create(p -> p.group((App)Biome.f_47432_.fieldOf("name").forGetter(BiomeProp::biomes), (App)Codec.BOOL.optionalFieldOf("negate", (Object)false).forGetter(BiomeProp::negate)).apply((Applicative)p, BiomeProp::new));
    }
}

