/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.level.storage.loot.modifiers;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemForEntityLootModifier
extends LootModifier {
    private static final Codec<LootItemFunction[]> LOOT_FUNCTIONS_CODEC = Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            LootItemFunction[] functions = (LootItemFunction[])LootModifierManager.GSON_INSTANCE.fromJson(IGlobalLootModifier.getJson((Dynamic)d), LootItemFunction[].class);
            return DataResult.success((Object)functions);
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode loot functions", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }, functions -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(functions);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode loot functions", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    });
    public static final Supplier<Codec<AddItemForEntityLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemForEntityLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)LOOT_FUNCTIONS_CODEC.optionalFieldOf("functions", (Object)new LootItemFunction[0]).forGetter(m -> m.functions), (App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("addition", (Object)Items.f_42127_).forGetter(m -> m.addition))).apply((Applicative)inst, AddItemForEntityLootModifier::new)));
    private final LootItemFunction[] functions;
    private final Item addition;

    public AddItemForEntityLootModifier(LootItemCondition[] conditions, LootItemFunction[] functions, Item addition) {
        super(conditions);
        this.functions = functions;
        this.addition = addition;
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78953_(LootContextParams.f_81455_) != null && context.m_78953_(LootContextParams.f_81461_) == null && this.addition != null && !this.addition.equals(Items.f_42127_)) {
            ItemStack stack = this.addition.m_7968_();
            for (LootItemFunction function : this.functions) {
                stack = (ItemStack)function.apply((Object)stack, (Object)context);
            }
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

