/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.level.storage.loot.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class ReplaceItemModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("original", (Object)Items.f_42127_).forGetter(m -> m.original), (App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("replacement", (Object)Items.f_42127_).forGetter(m -> m.replacement))).apply((Applicative)inst, ReplaceItemModifier::new)));
    private final Item original;
    private final Item replacement;

    public ReplaceItemModifier(LootItemCondition[] conditions, Item original, Item replacement) {
        super(conditions);
        this.original = original;
        this.replacement = replacement;
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.original == null || this.original.equals(Items.f_42127_) || this.replacement == null || this.replacement.equals(Items.f_42127_)) {
            return generatedLoot;
        }
        return generatedLoot.stream().map(stack -> {
            if (stack.m_41720_() == this.original) {
                return new ItemStack((ItemLike)this.replacement, stack.m_41613_());
            }
            return stack;
        }).collect(Collectors.toCollection(ObjectArrayList::new));
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

