/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.miauczel.legendary_monsters.CommonProxy;
import net.miauczel.legendary_monsters.client.ModBlockEntityWithoutLevelRenderer;
import net.miauczel.legendary_monsters.util.ModKeybinds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="legendary_monsters", value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static List<UUID> blockedEntityRenders = new ArrayList<UUID>();

    @Override
    public void releaseRenderingEntity(UUID id) {
        blockedEntityRenders.remove(id);
    }

    @Override
    public boolean isFirstPersonPlayer(Entity entity) {
        return entity.equals((Object)Minecraft.m_91087_().f_91075_) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
    }

    @Override
    public void blockRenderingEntity(UUID id) {
        blockedEntityRenders.add(id);
    }

    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeybinds);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Callable<BlockEntityWithoutLevelRenderer> getItemRenderer() {
        return ModBlockEntityWithoutLevelRenderer::new;
    }

    @Override
    public Object getItemRender() {
        return new ModBlockEntityWithoutLevelRenderer();
    }

    @Override
    public void clientInit() {
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public boolean isKeyDown(int keyType) {
        if (keyType != -1) {
            if (keyType == 4) {
                return ModKeybinds.MOSSY.m_90857_();
            }
            if (keyType == 7) {
                return ModKeybinds.FIERY.m_90857_();
            }
            if (keyType == 4) {
                return ModKeybinds.SKELORAPTOR_ROAR.m_90857_();
            }
            if (keyType == 5) {
                return ModKeybinds.SKELORAPTOR_ATTACK.m_90857_();
            }
            if (keyType == 6) {
                return ModKeybinds.HELMET.m_90857_();
            }
        } else {
            return Minecraft.m_91087_().f_91066_.f_92086_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92088_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92085_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92087_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        }
        return Minecraft.m_91087_().f_91066_.f_92086_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92088_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92085_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92087_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
    }

    @Override
    public void removeBossBarRender(UUID bossBar) {
        bossBarRenderTypes.remove(bossBar);
    }

    private void registerKeybinds(RegisterKeyMappingsEvent e) {
        e.register(ModKeybinds.FIERY);
        e.register(ModKeybinds.MOSSY);
        e.register(ModKeybinds.SKELORAPTOR_ROAR);
        e.register(ModKeybinds.HELMET);
    }

    @Override
    public void setBossBarRender(UUID bossBar, int renderType) {
        bossBarRenderTypes.put(bossBar, renderType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Callable<BlockEntityWithoutLevelRenderer> ModBlockRenderer() {
        return ModBlockEntityWithoutLevelRenderer::new;
    }

    @Override
    public Object getModBlockEntityWithoutLevelRenderer() {
        return new ModBlockEntityWithoutLevelRenderer();
    }
}

