/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.Message;

import java.util.function.Supplier;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.network.NetworkEvent;

public class AnnihilatorHelmetAbilityMessage {
    public int equipmentSlot;
    public int playerId;
    public int type;
    public static int teleportRange = 15;

    public AnnihilatorHelmetAbilityMessage(int equipmentSlot, int playerId, int type) {
        this.equipmentSlot = equipmentSlot;
        this.playerId = playerId;
        this.type = type;
    }

    public AnnihilatorHelmetAbilityMessage() {
    }

    public static AnnihilatorHelmetAbilityMessage read(FriendlyByteBuf buf) {
        int equipmentSlot = buf.readInt();
        int playerId = buf.readInt();
        int type = buf.readInt();
        return new AnnihilatorHelmetAbilityMessage(equipmentSlot, playerId, type);
    }

    public static void write(AnnihilatorHelmetAbilityMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.equipmentSlot);
        buf.writeInt(message.playerId);
        buf.writeInt(message.type);
    }

    public static BlockHitResult PlayerLookAtHitResult(Level pLevel, Player pPlayer, ClipContext.Fluid pFluidMode) {
        float f = pPlayer.m_146909_();
        float f1 = pPlayer.m_146908_();
        Vec3 vec3 = pPlayer.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = teleportRange;
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return pLevel.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, pFluidMode, (Entity)pPlayer));
    }

    public static boolean teleport(double x, double y, double z, ServerPlayer player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.TELEPORT_EFFECT.get()), player.m_20185_(), player.m_20186_() + 3.0, player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > player.m_9236_().m_141937_() && !player.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = player.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        if (flag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)player, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = player.m_20182_();
            boolean flag2 = AnnihilatorHelmetAbilityMessage.teleportBoolean(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true, player);
            if (flag2) {
                player.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)player));
                if (!player.m_20067_()) {
                    CameraShakeEntity.cameraShake(player.m_9236_(), player.m_20182_(), 10.0f, 0.1f, 5, 5);
                }
            }
            return flag2;
        }
        return false;
    }

    public static boolean teleportBoolean(double x, double y, double z, boolean p_20988_, ServerPlayer player) {
        double d0 = player.m_20185_();
        double d1 = player.m_20186_();
        double d2 = player.m_20189_();
        double d3 = y;
        boolean flag = false;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Level level = player.m_9236_();
        if (level.m_46805_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                player.m_6021_(x, d3, z);
                if (level.m_45786_((Entity)player) && !level.m_46855_(player.m_20191_())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            player.m_6021_(d0, d1, d2);
            return false;
        }
        if (p_20988_) {
            level.m_7605_((Entity)player, (byte)46);
        }
        return true;
    }

    public static class Handler {
        public static void onMessage(AnnihilatorHelmetAbilityMessage message, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            context.enqueueWork(() -> {
                BlockHitResult hitResult;
                ServerPlayer sender = context.getSender();
                if (sender != null && (hitResult = AnnihilatorHelmetAbilityMessage.PlayerLookAtHitResult(sender.m_9236_(), (Player)sender, ClipContext.Fluid.NONE)).m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos blockPos = hitResult.m_82425_();
                    if (MathUtils.distanceToVec(sender.m_20182_(), blockPos.m_252807_()) < (float)teleportRange) {
                        Vec3 pos = blockPos.m_252807_();
                        double d1 = pos.f_82479_;
                        double d2 = pos.f_82480_ + 1.0;
                        double d3 = pos.f_82481_;
                        AnnihilatorHelmetAbilityMessage.teleport(d1, blockPos.m_123342_() + 1, d3, sender);
                        Level patt3334$temp = sender.m_9236_();
                        if (patt3334$temp instanceof ServerLevel) {
                            ServerLevel level = (ServerLevel)patt3334$temp;
                            level.m_5594_(null, blockPos, SoundEvents.f_12418_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        sender.m_36335_().m_41524_((Item)ModItems.ANNIHILATOR_HELMET.get(), MathUtils.toSeconds(7.0f));
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

