/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.Particle.custom;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class TestTrail
extends Particle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("legendary_monsters", "textures/particle/trail.png");
    private final int EntityId;
    private final float width;
    private final float height;
    private final float initialYRot;
    private final float rotateByAge;
    public int trailProgress;
    public float r;
    public float g;
    public float b;

    public TestTrail(ClientLevel world, double x, double y, double z, float r, float g, float b, float width, float height, int EntityId) {
        super(world, x, y, z, (double)r, (double)g, (double)b);
        this.EntityId = EntityId;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 20 + this.f_107223_.m_188503_(20);
        this.initialYRot = this.f_107223_.m_188501_() * 360.0f;
        this.rotateByAge = (10.0f + this.f_107223_.m_188501_() * 10.0f) * (this.f_107223_.m_188499_() ? -1.0f : 1.0f);
        this.width = width;
        this.height = height;
        Vec3 vec3 = this.getOrbitPosition();
        this.f_107212_ = this.f_107209_ = vec3.f_82479_;
        this.f_107213_ = this.f_107210_ = vec3.f_82480_;
        this.f_107214_ = this.f_107211_ = vec3.f_82481_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Vec3 getEntityPosition() {
        Entity from = this.getFromEntity();
        if (from != null) {
            return from.m_20182_();
        }
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public Entity getFromEntity() {
        return this.EntityId == -1 ? null : this.f_107208_.m_6815_(this.EntityId);
    }

    public Vec3 getOrbitPosition() {
        Vec3 dinoPos = this.getEntityPosition();
        Vec3 vec3 = new Vec3(0.0, (double)this.height, (double)this.width).m_82524_((float)Math.toRadians(this.initialYRot + this.rotateByAge * (float)this.f_107224_));
        return dinoPos.m_82549_(vec3);
    }

    public void m_5989_() {
        super.m_5989_();
        ++this.trailProgress;
        Entity from = this.getFromEntity();
        if (from == null) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        BufferBuilder bufferBuilder = new BufferBuilder(256);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        if (this.trailProgress != 0) {
            PoseStack poseStack = new PoseStack();
            PoseStack.Pose PoseposeStack = poseStack.m_85850_();
            Matrix4f matrix4f = PoseposeStack.m_252922_();
            BufferBuilder starter = new BufferBuilder(1);
            float size = 0.5f;
            poseStack.m_85836_();
            pBuffer.m_5954_((float)this.f_107212_, (float)this.f_107213_, (float)this.f_107214_, this.r, this.g, this.b, 1.0f, 1.0f, 1.0f, 1, 1, (float)this.f_107212_, (float)this.f_107213_, (float)this.f_107214_);
            poseStack.m_85849_();
            bufferBuilder.m_231175_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class TrailData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<TrailData> DESERIALIZER = new ParticleOptions.Deserializer<TrailData>(){

            public TrailData fromCommand(ParticleType<TrailData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = reader.readFloat();
                reader.expect(' ');
                float g = reader.readFloat();
                reader.expect(' ');
                float b = reader.readFloat();
                reader.expect(' ');
                float width = reader.readFloat();
                reader.expect(' ');
                float height = reader.readFloat();
                reader.expect(' ');
                int EntityId = reader.readInt();
                return new TrailData(r, g, b, width, height, EntityId);
            }

            public TrailData fromNetwork(ParticleType<TrailData> particleTypeIn, FriendlyByteBuf buffer) {
                return new TrailData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
            }
        };
        private final float r;
        private final float g;
        private final float b;
        private final float width;
        private final float height;
        private final int entityid;

        public TrailData(float r, float g, float b, float width, float height, int entityid) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.width = width;
            this.height = height;
            this.entityid = entityid;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.width);
            buffer.writeFloat(this.height);
            buffer.writeInt(this.entityid);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.width), Float.valueOf(this.height), this.entityid);
        }

        public ParticleType<TrailData> m_6012_() {
            return (ParticleType)ModParticles.TEST_TRAIL.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getWidth() {
            return this.width;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getHeight() {
            return this.height;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getentityid() {
            return this.entityid;
        }

        public static Codec<TrailData> CODEC(ParticleType<TrailData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(TrailData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(TrailData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(TrailData::getB), (App)Codec.FLOAT.fieldOf("width").forGetter(TrailData::getWidth), (App)Codec.FLOAT.fieldOf("height").forGetter(TrailData::getHeight), (App)Codec.INT.fieldOf("entityid").forGetter(TrailData::getentityid)).apply((Applicative)codecBuilder, TrailData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class OrbFactory
    implements ParticleProvider<TrailData> {
        public Particle createParticle(TrailData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TestTrail particle = new TestTrail(worldIn, x, y, z, typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getWidth(), typeIn.getHeight(), typeIn.getentityid());
            return particle;
        }
    }
}

