/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.block.blockentity;

import java.util.Random;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.Particle.custom.MovingTrailParticle;
import net.miauczel.legendary_monsters.block.ModBlockEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class TeleportMachineBlockEntity
extends BlockEntity {
    public boolean active = false;
    public int tickCount;
    public int activeTicks = 0;
    public Random random = new Random();
    public Vec3 vec3 = this.f_58858_.m_252807_();
    public boolean canSendMessage = true;

    public TeleportMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntity.TELEPORT_MACHINE.get(), pPos, pBlockState);
    }

    public boolean shouldRenderFace(Direction pFace) {
        return pFace.m_122434_() == Direction.Axis.Y;
    }

    private void Sphereparticle(ParticleOptions particleType, float y, float vec, float size) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.tickCount % 2 == 0) {
            double d0 = this.getX();
            double d1 = this.getY() + (double)y;
            double d2 = this.getZ();
            double theta = Math.PI / 360;
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double d4 = (double)i + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double d5 = (double)k + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.random.nextGaussian() * 0.05;
                        this.f_58857_.m_7106_(particleType, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2.0f - 1.0f;
                    }
                }
            }
        }
    }

    public double getX() {
        return this.vec3.f_82479_;
    }

    public double getY() {
        return this.vec3.f_82480_;
    }

    public double getZ() {
        return this.vec3.f_82481_;
    }

    public Level level() {
        return this.f_58857_ != null ? this.f_58857_ : null;
    }

    public void tick() {
        ++this.tickCount;
        AABB aabb = new AABB(this.f_58858_).m_82400_(1.75);
        for (Object entity : this.level().m_45976_(Player.class, aabb)) {
            if (!this.canSendMessage) continue;
            this.sendBasicHotbarMessage("legendary_monsters.message.teleport_machine", (Player)entity);
        }
        AABB aabb1 = new AABB(this.f_58858_).m_82400_(20.0);
        for (TheObliteratorEntity entity : this.level().m_45976_(TheObliteratorEntity.class, aabb1)) {
            this.canSendMessage = entity == null;
        }
        if (!this.active && this.activeTicks != 0) {
            this.activeTicks = 0;
        }
        if (this.active) {
            ++this.activeTicks;
            Random random = new Random();
            int boomTick = 70;
            if (this.tickCount % 15 == 0 && this.activeTicks < boomTick - 15) {
                Circle.RingData particleOptions = new Circle.RingData(0.0f, 1.5707964f, 20, 0.0f, 1.0f, 0.0f, 1.0f, 150.0f, false, Circle.EnumRingBehavior.SHRINK);
                if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                    this.f_58857_.m_7106_((ParticleOptions)particleOptions, this.getX(), this.getY() + 0.25, this.getZ(), 0.0, 0.0, 0.0);
                }
            }
            if (this.activeTicks < boomTick - 20) {
                CameraShakeEntity.cameraShake(this.level(), this.f_58858_.m_252807_(), 10.0f, 0.05f, 1, 0);
            }
            if (this.activeTicks < boomTick - 15) {
                for (int k = 0; k < 3; ++k) {
                    float d1 = Mth.m_14116_((float)k);
                    float ran = 0.4f;
                    float r = 0.0f;
                    float g = 0.7647059f + random.nextFloat() * ran;
                    float b = 0.0f;
                    if (this.f_58857_ == null || !this.f_58857_.f_46443_) continue;
                    this.f_58857_.m_7106_((ParticleOptions)new MovingTrailParticle.TrailData(r, g, b, 0.2f, 0.1f), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.75, (double)this.m_58899_().m_123343_() + 0.5, (double)Mth.m_14031_((float)k), 0.0, (double)(d1 * 0.01f));
                }
            }
            if (this.activeTicks == boomTick - 3) {
                CameraShakeEntity.cameraShake(this.level(), this.f_58858_.m_252807_(), 10.0f, 0.1f, 5, 10);
                this.level().m_7785_(this.getX(), this.getY(), this.getZ(), SoundEvents.f_12513_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (this.activeTicks > boomTick - 3 && this.activeTicks < boomTick) {
                this.Sphereparticle((ParticleOptions)ModParticles.SMALL_ANNIHILATION_FLAME.get(), 0.75f, 0.0f, 1.0f);
            }
            if (this.activeTicks == boomTick) {
                TheObliteratorEntity obliteratorEntity = new TheObliteratorEntity((EntityType)ModEntities.THE_OBLITERATOR.get(), this.level());
                BlockPos pos = new BlockPos((int)this.getX(), (int)(this.getY() + 1.0), (int)this.getZ());
                obliteratorEntity.setBossBarVisible(false);
                obliteratorEntity.setSpawnBlockPos(pos);
                obliteratorEntity.m_20343_(this.getX(), this.getY() + 1.0, this.getZ());
                obliteratorEntity.setAttackState(1);
                this.level().m_7967_((Entity)obliteratorEntity);
                this.active = false;
            }
        }
    }

    public void sendBasicHotbarMessage(String message, Player player) {
        MutableComponent messageComponent = Component.m_237115_((String)message);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)messageComponent));
        }
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TeleportMachineBlockEntity entity) {
        entity.tick();
    }

    public BlockPos getPos() {
        return null;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        return super.getModelData();
    }

    public boolean hasCustomOutlineRendering(Player player) {
        return super.hasCustomOutlineRendering(player);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return super.getCapability(cap);
    }
}

