/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.block.custom;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.block.ModBlocks;
import net.miauczel.legendary_monsters.block.custom.EnderAnchorBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EnderAnchorBlock
extends BaseEntityBlock {
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final IntegerProperty CHARGES = BlockStateProperties.f_61389_;
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::m_7495_).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::m_7494_).iterator()).add((Object)new Vec3i(0, 1, 0)).build();
    public int state = 0;

    public EnderAnchorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(0)));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237115_((String)"block.legendary_monsters.ender_anchor1").m_130940_(ChatFormatting.GRAY));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new EnderAnchorBlockEntity(pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CHARGES});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ServerPlayer serverplayer;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pHand == InteractionHand.MAIN_HAND && !EnderAnchorBlock.isRespawnFuel(itemstack) && EnderAnchorBlock.isRespawnFuel(pPlayer.m_21120_(InteractionHand.OFF_HAND))) {
            return InteractionResult.PASS;
        }
        if (EnderAnchorBlock.isRespawnFuel(itemstack) && EnderAnchorBlock.canBeCharged(pState)) {
            this.charge((Entity)pPlayer, pLevel, pPos, pState);
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if ((Integer)pState.m_61143_((Property)CHARGES) == 0) {
            return InteractionResult.PASS;
        }
        if (!EnderAnchorBlock.canSetSpawn(pLevel)) {
            if (!pLevel.f_46443_) {
                this.explode(pState, pLevel, pPos);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (!(pLevel.f_46443_ || (serverplayer = (ServerPlayer)pPlayer).m_8963_() == pLevel.m_46472_() && pPos.equals((Object)serverplayer.m_8961_()))) {
            serverplayer.m_9158_(pLevel.m_46472_(), pPos, 0.0f, false, true);
            pLevel.m_6263_((Player)null, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isRespawnFuel(ItemStack pStack) {
        return pStack.m_150930_(((Block)ModBlocks.ANNIHILATION_LANTERN.get()).m_5456_());
    }

    private static boolean canBeCharged(BlockState pState) {
        return (Integer)pState.m_61143_((Property)CHARGES) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPos pPos, Level pLevel) {
        FluidState fluidstate = pLevel.m_6425_(pPos);
        if (!fluidstate.m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        if (fluidstate.m_76170_()) {
            return true;
        }
        float f = fluidstate.m_76186_();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluidstate1 = pLevel.m_6425_(pPos.m_7495_());
        return !fluidstate1.m_205070_(FluidTags.f_13131_);
    }

    private void explode(BlockState pState, Level pLevel, final BlockPos pPos2) {
        pLevel.m_7471_(pPos2, false);
        boolean flag = Direction.Plane.HORIZONTAL.m_122557_().map(arg_0 -> ((BlockPos)pPos2).m_121945_(arg_0)).anyMatch(p_55854_ -> EnderAnchorBlock.isWaterThatWouldFlow(p_55854_, pLevel));
        final boolean flag1 = flag || pLevel.m_6425_(pPos2.m_7494_()).m_205070_(FluidTags.f_13131_);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(){

            public Optional<Float> m_6617_(Explosion p_55904_, BlockGetter p_55905_, BlockPos p_55906_, BlockState p_55907_, FluidState p_55908_) {
                return p_55906_.equals((Object)pPos2) && flag1 ? Optional.of(Float.valueOf(Blocks.f_49990_.m_7325_())) : super.m_6617_(p_55904_, p_55905_, p_55906_, p_55907_, p_55908_);
            }
        };
        Vec3 vec3 = pPos2.m_252807_();
        pLevel.m_254951_((Entity)null, pLevel.m_269111_().m_269488_(vec3), explosiondamagecalculator, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
    }

    public static boolean canSetSpawn(Level pLevel) {
        return pLevel.m_46472_() == Level.f_46430_;
    }

    public void charge(@javax.annotation.Nullable Entity pEntity, Level pLevel, BlockPos pPos, BlockState pState) {
        BlockState blockstate = (BlockState)pState.m_61124_((Property)CHARGES, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)CHARGES) + 1));
        this.state = (Integer)pState.m_61143_((Property)CHARGES) + 1;
        System.out.println("STATE: " + this.state);
        pLevel.m_7731_(pPos, blockstate, 3);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
        pLevel.m_6263_((Player)null, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.m_61143_((Property)CHARGES) != 0) {
            if (pRandom.m_188503_(100) == 0) {
                pLevel.m_6263_((Player)null, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_12375_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            double d0 = (double)pPos.m_123341_() + 0.5 + (0.5 - pRandom.m_188500_());
            double d1 = (double)pPos.m_123342_() + 1.0;
            double d2 = (double)pPos.m_123343_() + 0.5 + (0.5 - pRandom.m_188500_());
            double d3 = (double)pRandom.m_188501_() * 0.04;
            pLevel.m_7106_((ParticleOptions)ModParticles.SMALL_ANNIHILATION_FLAME.get(), d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Deprecated
    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
    }

    public static int getScaledChargeLevel(BlockState pState, int pScale) {
        return Mth.m_14143_((float)((float)((Integer)pState.m_61143_((Property)CHARGES)).intValue() / 4.0f * (float)pScale));
    }

    public int getCharges() {
        return this.state;
    }

    @Deprecated
    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return EnderAnchorBlock.getScaledChargeLevel(pBlockState, 15);
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> pEntityType, CollisionGetter pLevel, BlockPos pPos) {
        Optional<Vec3> optional = EnderAnchorBlock.findStandUpPosition(pEntityType, pLevel, pPos, true);
        return optional.isPresent() ? optional : EnderAnchorBlock.findStandUpPosition(pEntityType, pLevel, pPos, false);
    }

    private static Optional<Vec3> findStandUpPosition(EntityType<?> pEntityType, CollisionGetter pLevel, BlockPos pPos, boolean pSimulate) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : RESPAWN_OFFSETS) {
            blockpos$mutableblockpos.m_122190_((Vec3i)pPos).m_122193_(vec3i);
            Vec3 vec3 = DismountHelper.m_38441_(pEntityType, (CollisionGetter)pLevel, (BlockPos)blockpos$mutableblockpos, (boolean)pSimulate);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

