/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.miauczel.legendary_monsters.ClientProxy;
import net.miauczel.legendary_monsters.LegendaryMonsters;
import net.miauczel.legendary_monsters.client.ModBlockEntityWithoutLevelRenderer;
import net.miauczel.legendary_monsters.client.RenderUtils;
import net.miauczel.legendary_monsters.client.event.gui.CustomBossBar;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.PossessedPaladinEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Pets.SkeloraptorEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.ShulkerTower.Shulker_MimicEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.SpaceStation.Flameborn.AnnihilationPursuer.AnnihilationPursuerEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.BigShulkerBulletEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ThrownEntity.EntityThrownEntity;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.mixin.CameraInvoker;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvent {
    private static final ResourceLocation[] TYPE_A_TEXTURES = new ResourceLocation[]{new ResourceLocation("legendary_monsters", "textures/entity/annihilation_portal/type_a/annihilation_portal_0.png"), new ResourceLocation("legendary_monsters", "textures/entity/annihilation_portal/type_a/annihilation_portal_1.png"), new ResourceLocation("legendary_monsters", "textures/entity/annihilation_portal/type_a/annihilation_portal_2.png"), new ResourceLocation("legendary_monsters", "textures/entity/annihilation_portal/type_a/annihilation_portal_3.png"), new ResourceLocation("legendary_monsters", "textures/entity/annihilation_portal/type_a/annihilation_portal_4.png")};
    private static boolean CameraApplied = false;
    private static CameraType previousCameraType;

    @SubscribeEvent
    public static void renderPortals(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            float multiplier;
            float f3;
            int k;
            if (!player.m_6117_() || player.m_21205_().m_41720_() != ModItems.TESSERACT.get()) {
                return;
            }
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            PoseStack matrix = event.getPoseStack();
            Camera cam = event.getCamera();
            Vec3 camPos = cam.m_90583_();
            float pt = event.getPartialTick();
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            matrix.m_85836_();
            matrix.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
            double x = Mth.m_14139_((double)pt, (double)player.f_19790_, (double)player.m_20185_());
            double y = Mth.m_14139_((double)pt, (double)player.f_19791_, (double)player.m_20186_());
            double z = Mth.m_14139_((double)pt, (double)player.f_19792_, (double)player.m_20189_());
            matrix.m_85836_();
            matrix.m_85837_(x, y, z);
            ResourceLocation[] texArr = TYPE_A_TEXTURES;
            int total = texArr.length;
            int frame = (int)(((float)player.f_19797_ + pt) * 12.0f / 20.0f) % total;
            ResourceLocation tex = texArr[Math.floorMod(frame, total)];
            RenderType rt = RenderType.m_234338_((ResourceLocation)tex);
            VertexConsumer vertexConsumer = buffer.m_6299_(rt);
            double dy = 0.1f;
            int FULL_BRIGHT = LightTexture.m_109885_((int)15, (int)15);
            double bigsize = Mth.m_14008_((double)((double)(player.m_21252_() * 2) * 0.1), (double)0.0, (double)4.0);
            double smallsize = Mth.m_14008_((double)((double)player.m_21252_() * 0.1), (double)0.0, (double)2.0);
            RenderUtils.renderQuad((float)bigsize, 0.0, dy, 0.0, 90.0, 0.0, 0.0, vertexConsumer, matrix, OverlayTexture.f_118083_, FULL_BRIGHT);
            for (k = 0; k < 5; ++k) {
                f3 = (float)k * (float)Math.PI * 2.0f / 5.0f + 0.62831855f;
                multiplier = 7.5f;
                RenderUtils.renderQuad((float)smallsize, Mth.m_14089_((float)f3) * multiplier, dy, Mth.m_14031_((float)f3) * multiplier, 90.0, 0.0, 0.0, vertexConsumer, matrix, OverlayTexture.f_118083_, FULL_BRIGHT);
            }
            for (k = 0; k < 5; ++k) {
                f3 = (float)k * (float)Math.PI * 2.0f / 5.0f + 0.62831855f;
                multiplier = 4.0f;
                RenderUtils.renderQuad((float)smallsize, Mth.m_14089_((float)f3) * multiplier, dy, Mth.m_14031_((float)f3) * multiplier, 90.0, 0.0, 0.0, vertexConsumer, matrix, OverlayTexture.f_118083_, FULL_BRIGHT);
            }
            matrix.m_85849_();
            matrix.m_85849_();
            buffer.m_109911_();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ModBlockEntityWithoutLevelRenderer.incrementTick();
        }
        if (event.phase == TickEvent.Phase.END) {
            PossessedPaladinEntity PossessedPaladin;
            AnnihilationPursuerEntity AnnihilationPursuer;
            Shulker_MimicEntity ShulkerMimicEntity;
            BigShulkerBulletEntity BigShulkerbulletEntity;
            EntityThrownEntity bulletEntity;
            TheObliteratorEntity theWarpedOneEntity;
            boolean isRidingWarp;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            Entity entity = mc.f_91074_.m_20202_();
            boolean bl = isRidingWarp = entity instanceof TheObliteratorEntity && (theWarpedOneEntity = (TheObliteratorEntity)entity).getAttackState() != 20 && theWarpedOneEntity.getAttackState() != 19 && theWarpedOneEntity.getAttackState() != 18 || (entity = mc.f_91074_.m_20202_()) instanceof EntityThrownEntity && (bulletEntity = (EntityThrownEntity)entity).m_20160_() || (entity = mc.f_91074_.m_20202_()) instanceof BigShulkerBulletEntity && (BigShulkerbulletEntity = (BigShulkerBulletEntity)entity).m_20160_() || (entity = mc.f_91074_.m_20202_()) instanceof Shulker_MimicEntity && (ShulkerMimicEntity = (Shulker_MimicEntity)entity).m_20160_() || (entity = mc.f_91074_.m_20202_()) instanceof AnnihilationPursuerEntity && (AnnihilationPursuer = (AnnihilationPursuerEntity)entity).m_20160_() || (entity = mc.f_91074_.m_20202_()) instanceof PossessedPaladinEntity && (PossessedPaladin = (PossessedPaladinEntity)entity).m_20160_();
            if (isRidingWarp && !CameraApplied) {
                previousCameraType = mc.f_91066_.m_92176_();
                mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
                CameraApplied = true;
            } else if (!isRidingWarp && CameraApplied) {
                mc.f_91066_.m_92157_(previousCameraType);
                CameraApplied = false;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPreRenderEntity(RenderLivingEvent.Pre event) {
        if (ClientProxy.blockedEntityRenders.contains(event.getEntity().m_20148_())) {
            if (!LegendaryMonsters.PROXY.isFirstPersonPlayer((Entity)event.getEntity())) {
                MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(event.getEntity(), event.getRenderer(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight()));
                event.setCanceled(true);
            }
            ClientProxy.blockedEntityRenders.remove(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null) {
            MobEffect curseEffect;
            MobEffectInstance curseInstance;
            float shakeAmplitude = 0.0f;
            for (CameraShakeEntity cameraShake : player.m_9236_().m_45976_(CameraShakeEntity.class, player.m_20191_().m_82400_(20.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            MobEffect stunEffect = (MobEffect)ModEffects.STUN.get();
            MobEffectInstance effectInstance = player.m_21124_(stunEffect);
            if (effectInstance != null) {
                float stunShakeAmplitude = (float)(1 + effectInstance.m_19564_()) * 0.01f;
                event.setPitch((float)((double)event.getPitch() + (double)stunShakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)stunShakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)stunShakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
            if ((curseInstance = player.m_21124_(curseEffect = (MobEffect)ModEffects.PHARAONS_CURSE.get())) != null) {
                event.setRoll(event.getRoll() + 180.0f);
            }
        }
    }

    @SubscribeEvent
    public static void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        double wanted;
        Entity camEntity = Minecraft.m_91087_().m_91288_();
        if (camEntity == null) {
            return;
        }
        if (!camEntity.m_20159_()) {
            return;
        }
        if (!event.getCamera().m_90594_()) {
            return;
        }
        Entity vehicle = camEntity.m_20202_();
        if (vehicle == null) {
            return;
        }
        if (vehicle instanceof SkeloraptorEntity) {
            wanted = 2.0;
        } else if (vehicle instanceof TheObliteratorEntity) {
            wanted = 3.0;
        } else if (vehicle instanceof Shulker_MimicEntity || vehicle instanceof EntityThrownEntity || vehicle instanceof BigShulkerBulletEntity || vehicle instanceof AnnihilationPursuerEntity || vehicle instanceof PossessedPaladinEntity) {
            wanted = 4.0;
        } else {
            return;
        }
        Camera cam = event.getCamera();
        CameraInvoker inv = (CameraInvoker)cam;
        double maxZoom = inv.legendaryMonsters$invokeGetMaxZoom(wanted);
        inv.legendaryMonsters$invokeMove(-maxZoom, 0.0, 0.0);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderBossOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (((Boolean)ModConfig.MOB_CONFIG.allowCustomBossBar.get()).booleanValue() && ClientProxy.bossBarRenderTypes.containsKey(event.getBossEvent().m_18860_())) {
            int renderTypeFor = (Integer)ClientProxy.bossBarRenderTypes.get(event.getBossEvent().m_18860_());
            CustomBossBar customBossBar = CustomBossBar.customBossBars.getOrDefault(renderTypeFor, null);
            if (customBossBar == null) {
                return;
            }
            event.setCanceled(true);
            customBossBar.renderBossBar(event);
        }
    }
}

