/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.IHurtingEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.client.ControlledAnim;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class SoulShieldEntity
extends IHurtingEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 30;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Boolean> IS_OUTER = SynchedEntityData.m_135353_(SoulShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DESTINATION_Z = SynchedEntityData.m_135353_(SoulShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESTINATION_Y = SynchedEntityData.m_135353_(SoulShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESTINATION_X = SynchedEntityData.m_135353_(SoulShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(SoulShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RED = SynchedEntityData.m_135353_(SoulShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float activateProgress;
    public float prevactivateProgress;
    public AnimationState emergeAnimationState = new AnimationState();
    public final ControlledAnim RendercontrolledAnim = new ControlledAnim(15);
    public final ControlledAnim RendercontrolledAnim2 = new ControlledAnim(15);
    public int timer;

    public boolean getRed() {
        return (Boolean)this.f_19804_.m_135370_(IS_RED);
    }

    public void setRed(boolean damage) {
        this.f_19804_.m_135381_(IS_RED, (Object)damage);
    }

    public SoulShieldEntity(EntityType<? extends SoulShieldEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public SoulShieldEntity(Level worldIn, double x, double y, double z, float yawRad, int p_i47276_9_, LivingEntity casterIn, float damage, float destX, float destY, float destZ, boolean isOuter, boolean isRed) {
        this((EntityType<? extends SoulShieldEntity>)((EntityType)ModEntities.SOUL_SHIELD.get()), worldIn);
        this.setIsOuter(isOuter);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        float yawDeg = yawRad * 57.295776f - 90.0f;
        this.m_146922_(yawDeg);
        this.m_6034_(x, y, z);
        if (!isOuter) {
            this.setDestinationX(destX);
            this.setDestinationY(destY);
            this.setDestinationZ(destZ);
        }
        this.setRed(isRed);
        this.setDamage(damage);
        this.m_274367_(1.5f);
    }

    public boolean isGlowing() {
        return this.m_20291_(6);
    }

    public float getDestinationX() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_X)).floatValue();
    }

    public float getDestinationY() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_Y)).floatValue();
    }

    public float getDestinationZ() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_Z)).floatValue();
    }

    public boolean getIsOuter() {
        return (Boolean)this.f_19804_.m_135370_(IS_OUTER);
    }

    public void setDestinationX(float destination) {
        this.f_19804_.m_135381_(DESTINATION_X, (Object)Float.valueOf(destination));
    }

    public void setDestinationY(float destination) {
        this.f_19804_.m_135381_(DESTINATION_Y, (Object)Float.valueOf(destination));
    }

    public void setDestinationZ(float destination) {
        this.f_19804_.m_135381_(DESTINATION_Z, (Object)Float.valueOf(destination));
    }

    public void setIsOuter(boolean isOuter) {
        this.f_19804_.m_135381_(IS_OUTER, (Object)isOuter);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(DESTINATION_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATION_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_OUTER, (Object)false);
        this.f_19804_.m_135372_(IS_RED, (Object)false);
        super.m_8097_();
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "emerge") {
            return this.emergeAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATIONSTATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAnimationState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.emergeAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.emergeAnimationState.m_216973_();
    }

    @Override
    public int disappearTicks() {
        return 10;
    }

    @Override
    public void m_8119_() {
        double distancetotarget;
        double speed;
        super.m_8119_();
        if (this.lifeTicks > 50) {
            this.controlledAnim.increaseTimer();
            this.timer = this.controlledAnim.getTimer();
        }
        for (int i = 0; i < 10; ++i) {
            BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double d1 = this.m_20186_() + 0.03;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double d3 = this.f_19796_.m_188583_() * 0.07;
            double d4 = this.f_19796_.m_188583_() * 0.07;
            double d5 = this.f_19796_.m_188583_() * 0.07;
            if (!this.m_9236_().f_46443_) continue;
            if (this.f_19797_ % 5 == 0) {
                this.m_9236_().m_7106_(this.getRed() ? (ParticleOptions)ModParticles.GROUNDSOUL_RED.get() : (ParticleOptions)ModParticles.GROUNDSOUL.get(), this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            this.m_9236_().m_7106_(this.getRed() ? (ParticleOptions)ModParticles.GHOSTLY_SOUL_RED.get() : (ParticleOptions)ModParticles.GHOSTLY_SOUL.get(), d0, d1, d2, d3, d4, d5);
        }
        if (this.getIsOuter()) {
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double theta = (double)this.m_146908_() * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            float vec = 8.0f;
            float offset = 0.0f;
            this.setDestinationX((float)(this.m_20185_() + (double)vec * vecX + (double)(f * offset)));
            this.setDestinationY((float)this.m_20186_());
            this.setDestinationZ((float)(this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset)));
        }
        for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.25))) {
            this.damage(livingEntity);
        }
        Vec3 toDest = new Vec3((double)this.getDestinationX() - this.m_20185_(), (double)this.getDestinationY() - this.m_20186_(), (double)this.getDestinationZ() - this.m_20189_());
        double distance = toDest.m_82553_();
        if (!(distance <= (speed = 0.1 + (distancetotarget = toDest.m_82553_() * (double)0.05f)))) {
            Vec3 motion = toDest.m_82541_().m_82490_(speed);
            this.m_6478_(MoverType.SELF, motion);
        }
        this.RendercontrolledAnim2.increaseTimer();
        Vec3 vec3 = new Vec3((double)this.getDestinationX(), (double)this.getDestinationY(), (double)this.getDestinationZ());
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, vec3);
        this.prevactivateProgress = this.activateProgress;
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                ++this.lifeTicks;
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (++this.lifeTicks > 55) {
                this.m_146870_();
            }
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
        if (id <= 0) {
            this.lifeTicks = 0;
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LivingEntity target() {
        if (this.caster != null && this.caster instanceof Mob) {
            return ((Mob)this.caster).m_5448_();
        }
        return null;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getAnimationState() == 0) {
            this.setAnimationState(1);
        }
    }

    private void damage(LivingEntity ImpactEntity) {
        LivingEntity livingentity = this.getCaster();
        if (ImpactEntity.m_6084_() && !ImpactEntity.m_20147_() && ImpactEntity != livingentity && this.f_19797_ % 5 == 0) {
            if (livingentity == null) {
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.GHOST), (Entity)livingentity);
                boolean flag = ImpactEntity.m_6469_(damageSource, this.getDamage());
                if (flag) {
                    if (this.caster != null) {
                        this.caster.m_5634_(3.0f + MathUtils.entityBasedHpDamage(ImpactEntity, 1.0f));
                    }
                    EntityUtil.applyStackingEffect(ImpactEntity, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
                }
            } else {
                if (livingentity.m_7307_((Entity)ImpactEntity)) {
                    return;
                }
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.GHOST), (Entity)livingentity);
                boolean hurt = ImpactEntity.m_6469_(damageSource, this.getDamage());
                if (hurt) {
                    EntityUtil.applyStackingEffect(ImpactEntity, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
                    if (this.caster != null) {
                        this.caster.m_5634_(3.0f + MathUtils.entityBasedHpDamage(ImpactEntity, 1.0f));
                    }
                }
                if (!this.m_9236_().f_46443_) {
                    // empty if block
                }
            }
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int $$1 = this.lifeTicks - 2;
        return $$1 <= 0 ? 1.0f : 1.0f - ((float)$$1 - pPartialTicks) / 20.0f;
    }
}

