/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.IHurtingEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationBombEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.client.ControlledAnim;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class TheObliteratorCloneEntity
extends IHurtingEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 30;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Float> DESTINATION_Z = SynchedEntityData.m_135353_(TheObliteratorCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESTINATION_Y = SynchedEntityData.m_135353_(TheObliteratorCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESTINATION_X = SynchedEntityData.m_135353_(TheObliteratorCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(TheObliteratorCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float activateProgress;
    public float prevactivateProgress;
    public AnimationState emergeAnimationState = new AnimationState();
    public final ControlledAnim controlledAnim = new ControlledAnim(15);
    public final ControlledAnim RendercontrolledAnim = new ControlledAnim(15);
    public final ControlledAnim RendercontrolledAnim2 = new ControlledAnim(15);

    public TheObliteratorCloneEntity(EntityType<? extends TheObliteratorCloneEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public TheObliteratorCloneEntity(Level worldIn, double x, double y, double z, float yawRad, int p_i47276_9_, LivingEntity casterIn, float damage, float destX, float destY, float destZ) {
        this((EntityType<? extends TheObliteratorCloneEntity>)((EntityType)ModEntities.THE_WARPED_ONE_DUPLICATE.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        float yawDeg = yawRad * 57.295776f - 90.0f;
        this.m_146922_(yawDeg);
        this.m_6034_(x, y, z);
        this.setDestinationX(destX);
        this.setDestinationY(destY);
        this.setDestinationZ(destZ);
        this.setDamage(damage);
    }

    public boolean isGlowing() {
        return this.m_20291_(6);
    }

    public float getDestinationX() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_X)).floatValue();
    }

    public float getDestinationY() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_Y)).floatValue();
    }

    public float getDestinationZ() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_Z)).floatValue();
    }

    public void setDestinationX(float destination) {
        this.f_19804_.m_135381_(DESTINATION_X, (Object)Float.valueOf(destination));
    }

    public void setDestinationY(float destination) {
        this.f_19804_.m_135381_(DESTINATION_Y, (Object)Float.valueOf(destination));
    }

    public void setDestinationZ(float destination) {
        this.f_19804_.m_135381_(DESTINATION_Z, (Object)Float.valueOf(destination));
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(DESTINATION_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATION_Z, (Object)Float.valueOf(0.0f));
        super.m_8097_();
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "emerge") {
            return this.emergeAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATIONSTATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAnimationState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.emergeAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.emergeAnimationState.m_216973_();
    }

    @Override
    public int disappearTicks() {
        return 15;
    }

    public void shootDimensionalBomb(float velocity, float x, float y, float z) {
        float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        double theta = (double)this.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float vec = 1.0f;
        float offset = 0.0f;
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.ANNIHILATION_EXPLOSION.get(), this.m_20185_() + (double)vec * vecX + (double)(f * offset), this.m_20186_() + 3.0, this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset), 0.0, 0.0, 0.0);
        }
        if (this.getCaster() instanceof Mob && ((Mob)this.getCaster()).m_5448_() != null) {
            AnnihilationBombEntity chorusBomb = new AnnihilationBombEntity((EntityType<AnnihilationBombEntity>)((EntityType)ModEntities.ANNIHILATION_BOMB_ENTITY.get()), this.m_9236_(), this.caster, 12.0f, 0, true);
            chorusBomb.m_20343_(x, y, z);
            double d0 = this.getDestinationX() - x;
            double d1 = (double)this.getDestinationY() - chorusBomb.m_20186_();
            double d2 = this.getDestinationZ() - z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            chorusBomb.m_6686_(d0, d1 + d3 * 0.2, d2, velocity, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            chorusBomb.m_5602_((Entity)this.getCaster());
            this.m_9236_().m_7967_((Entity)chorusBomb);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.RendercontrolledAnim2.increaseTimer();
        Vec3 vec3 = new Vec3((double)this.getDestinationX(), (double)this.getDestinationY(), (double)this.getDestinationZ());
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, vec3);
        float yaw = this.m_146908_();
        if (this.AnimationTicks > 23) {
            this.controlledAnim.increaseTimer();
        }
        if (this.AnimationTicks > 13) {
            this.RendercontrolledAnim.increaseTimer();
        }
        if (this.AnimationTicks == 13) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.THE_WARPED_ONE_SHOOT.get(), this.m_5720_(), 0.1f, 1.0f, false);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double theta = (double)this.m_146908_() * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            float vec = 0.0f;
            float offset = 0.0f;
            this.shootDimensionalBomb(1.0f, (float)(this.m_20185_() + (double)vec * vecX + (double)(f * offset)), (float)(this.m_20186_() + 1.5), (float)(this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset)));
        }
        if (this.AnimationTicks == 6 && this.m_9236_().f_46443_) {
            for (int i = 0; i < 40; ++i) {
                BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                double d1 = this.m_20186_() + 0.03;
                double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                double d3 = this.f_19796_.m_188583_() * 0.07;
                double d4 = this.f_19796_.m_188583_() * 0.07;
                double d = this.f_19796_.m_188583_() * 0.07;
            }
        }
        if (this.AnimationTicks < 4 || this.AnimationTicks > 6 || this.m_9236_().f_46443_) {
            // empty if block
        }
        this.prevactivateProgress = this.activateProgress;
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                ++this.lifeTicks;
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (++this.lifeTicks > 55) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
        if (id <= 0) {
            this.lifeTicks = 0;
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LivingEntity target() {
        if (this.caster != null && this.caster instanceof Mob) {
            return ((Mob)this.caster).m_5448_();
        }
        return null;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getAnimationState() == 0) {
            this.setAnimationState(1);
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int $$1 = this.lifeTicks - 2;
        return $$1 <= 0 ? 1.0f : 1.0f - ((float)$$1 - pPartialTicks) / 20.0f;
    }
}

