/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.AnnihilationBombTrail;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.IHurtingEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.client.ControlledAnim;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class TheObliteratorCloneWithArmsEntity
extends IHurtingEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 17;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    public float lastYawToDest = 0.0f;
    public float lastPitchToDest = 0.0f;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE_SET = SynchedEntityData.m_135353_(TheObliteratorCloneWithArmsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(TheObliteratorCloneWithArmsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DESTINATION_Z = SynchedEntityData.m_135353_(TheObliteratorCloneWithArmsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESTINATION_Y = SynchedEntityData.m_135353_(TheObliteratorCloneWithArmsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESTINATION_X = SynchedEntityData.m_135353_(TheObliteratorCloneWithArmsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(TheObliteratorCloneWithArmsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float activateProgress;
    public float prevactivateProgress;
    public final ControlledAnim RendercontrolledAnim = new ControlledAnim(15);
    public AnimationState leftHookComboAnimationState = new AnimationState();
    public AnimationState uppercutAnimationState = new AnimationState();
    public AnimationState rightUppercutAnimationState = new AnimationState();
    public final ControlledAnim controlledAnim = new ControlledAnim(this.disappearTicks());
    public float shakeStrenght = 0.05f;
    public float attackArc = 290.0f;

    public TheObliteratorCloneWithArmsEntity(EntityType<? extends TheObliteratorCloneWithArmsEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public TheObliteratorCloneWithArmsEntity(Level worldIn, double x, double y, double z, float yawRad, int p_i47276_9_, LivingEntity casterIn, float damage, float destX, float destY, float destZ, int animationState, int life) {
        this((EntityType<? extends TheObliteratorCloneWithArmsEntity>)((EntityType)ModEntities.THE_WARPED_ONE_DUPLICATE_ARMED.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        float yawDeg = yawRad * 57.295776f - 90.0f;
        this.m_146922_(yawDeg);
        this.m_6034_(x, y, z);
        this.setDestinationX(destX);
        this.setDestinationY(destY);
        this.setDestinationZ(destZ);
        this.setAnimationStateValue(animationState);
        this.m_274367_(2.0f);
        this.setDamage(damage);
        this.setLifeTicks(life);
    }

    public float getDestinationX() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_X)).floatValue();
    }

    public float getDestinationY() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_Y)).floatValue();
    }

    public float getDestinationZ() {
        return ((Float)this.f_19804_.m_135370_(DESTINATION_Z)).floatValue();
    }

    public void setDestinationX(float destination) {
        this.f_19804_.m_135381_(DESTINATION_X, (Object)Float.valueOf(destination));
    }

    public void setDestinationY(float destination) {
        this.f_19804_.m_135381_(DESTINATION_Y, (Object)Float.valueOf(destination));
    }

    public void setDestinationZ(float destination) {
        this.f_19804_.m_135381_(DESTINATION_Z, (Object)Float.valueOf(destination));
    }

    public int getAnimationStateValue() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE_SET);
    }

    public void setAnimationStateValue(int value) {
        this.f_19804_.m_135381_(ANIMATION_STATE_SET, (Object)value);
    }

    public void setLifeTicks(int amount) {
        this.f_19804_.m_135381_(LIFE, (Object)amount);
    }

    public int getLifeTicks() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(DESTINATION_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESTINATION_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_STATE_SET, (Object)0);
        super.m_8097_();
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "uppercut") {
            return this.uppercutAnimationState;
        }
        if (input == "right_uppercut") {
            return this.rightUppercutAnimationState;
        }
        if (input == "left_hook_combo") {
            return this.leftHookComboAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATIONSTATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAnimationState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.uppercutAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.leftHookComboAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.rightUppercutAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.uppercutAnimationState.m_216973_();
        this.leftHookComboAnimationState.m_216973_();
        this.rightUppercutAnimationState.m_216973_();
    }

    @Override
    public int disappearTicks() {
        return 10;
    }

    public float damage() {
        return 6.0f;
    }

    @Override
    public void m_8119_() {
        Vec3 motion;
        double speed;
        double distancetotarget;
        double distance;
        Vec3 toDest;
        float b;
        float g;
        float r;
        float ran;
        double dz1;
        double dy1;
        double stopDistance;
        boolean shouldRotate;
        double dz;
        double dy;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            int i = 0;
            while ((double)i < 0.1) {
                if (this.m_9236_().f_46443_) {
                    double uniformScale = 0.5;
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.BIG_ANNIHILATION_FLAME.get(), this.m_20208_(uniformScale), this.m_20187_(), this.m_20262_(uniformScale), 0.0, 0.025, 0.0);
                }
                ++i;
            }
        }
        SoundEvent swingSound = (SoundEvent)ModSounds.HEAVY_SWING.get();
        SoundEvent impactSound = (SoundEvent)ModSounds.WEAPON_IMPACT.get();
        double dx = (double)this.getDestinationX() - this.m_20185_();
        double dist = Math.sqrt(dx * dx + (dy = (double)this.getDestinationY() - this.m_20186_()) * dy + (dz = (double)this.getDestinationZ() - this.m_20189_()) * dz);
        boolean bl = shouldRotate = dist > (stopDistance = 3.0);
        if (shouldRotate) {
            Vec3 vec3 = new Vec3((double)this.getDestinationX(), (double)this.getDestinationY(), (double)this.getDestinationZ());
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, vec3);
        }
        if (this.getAnimationState() == 2) {
            SoundEvent soundEvent;
            if (this.AnimationTicks > 29) {
                this.controlledAnim.increaseTimer();
            }
            if (this.AnimationTicks >= 12 && this.AnimationTicks <= 14) {
                double dx1 = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                dy1 = this.m_20186_() + 3.0;
                dz1 = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                ran = 0.4f;
                r = 0.0f;
                g = 0.7647059f + this.f_19796_.m_188501_() * ran;
                b = 0.0f;
                this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 2.25f, this.m_19879_()), dx1, dy1, dz1, 0.0, 0.0, 0.0);
                toDest = new Vec3((double)this.getDestinationX() - this.m_20185_(), (double)this.getDestinationY() - this.m_20186_(), (double)this.getDestinationZ() - this.m_20189_());
                distance = toDest.m_82553_();
                distancetotarget = toDest.m_82553_() * 0.5;
                speed = 0.1 + distancetotarget;
                if (!(distance <= speed)) {
                    motion = toDest.m_82541_().m_82490_(speed);
                    this.m_6478_(MoverType.SELF, motion);
                }
            }
            if (this.AnimationTicks == 11) {
                this.m_5496_(swingSound, 1.0f, 1.0f);
            }
            if (this.AnimationTicks == 15) {
                if (this.target() != null) {
                    float destX = (float)this.target().m_20185_();
                    float destY = (float)this.target().m_20186_();
                    float destZ = (float)this.target().m_20189_();
                    this.setDestinationX(destX);
                    this.setDestinationY(destY);
                    this.setDestinationZ(destZ);
                }
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, this.shakeStrenght, 0, 20);
                soundEvent = (SoundEvent)ModSounds.WEAPON_IMPACT.get();
                this.SideAreaAttack(4.0f, 4.0f, this.attackArc, -90.0f, this.damage(), 120, false, true, soundEvent);
            }
            if (this.AnimationTicks >= 25) {
                double dx1 = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                dy1 = this.m_20186_() + 3.0;
                dz1 = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                ran = 0.4f;
                r = 0.0f;
                g = 0.7647059f + this.f_19796_.m_188501_() * ran;
                b = 0.0f;
                this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 2.25f, this.m_19879_()), dx1, dy1, dz1, 0.0, 0.0, 0.0);
                toDest = new Vec3((double)this.getDestinationX() - this.m_20185_(), (double)this.getDestinationY() - this.m_20186_(), (double)this.getDestinationZ() - this.m_20189_());
                distance = toDest.m_82553_();
                distancetotarget = toDest.m_82553_() * 0.5;
                speed = 0.1 + distancetotarget;
                if (!(distance <= speed)) {
                    motion = toDest.m_82541_().m_82490_(speed);
                    this.m_6478_(MoverType.SELF, motion);
                }
            }
            if (this.AnimationTicks == 24) {
                this.m_5496_(swingSound, 1.0f, 1.0f);
            }
            if (this.AnimationTicks == 28) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, this.shakeStrenght, 0, 20);
                soundEvent = (SoundEvent)ModSounds.WEAPON_IMPACT.get();
                this.SideAreaAttack(5.0f, 4.0f, this.attackArc, -90.0f, this.damage(), 120, false, true, soundEvent);
            }
        }
        if (this.getAnimationState() == 1) {
            if (this.AnimationTicks > 23) {
                this.controlledAnim.increaseTimer();
            }
            if (this.AnimationTicks >= 10) {
                this.RendercontrolledAnim.increaseTimer();
            }
            if (this.AnimationTicks >= 15) {
                double dx1 = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                dy1 = this.m_20186_() + 3.0;
                dz1 = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                ran = 0.4f;
                r = 0.0f;
                g = 0.7647059f + this.f_19796_.m_188501_() * ran;
                b = 0.0f;
                this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 2.25f, this.m_19879_()), dx1, dy1, dz1, 0.0, 0.0, 0.0);
                toDest = new Vec3((double)this.getDestinationX() - this.m_20185_(), (double)this.getDestinationY() - this.m_20186_(), (double)this.getDestinationZ() - this.m_20189_());
                distance = toDest.m_82553_();
                distancetotarget = toDest.m_82553_() * 0.5;
                speed = 0.1 + distancetotarget;
                if (distance <= speed) {
                    this.m_6034_(this.getDestinationX(), this.getDestinationY(), this.getDestinationZ());
                } else {
                    motion = toDest.m_82541_().m_82490_(speed);
                    this.m_6478_(MoverType.SELF, motion);
                }
            }
            if (this.AnimationTicks == 14) {
                this.m_5496_(swingSound, 1.0f, 1.0f);
            }
            if (this.AnimationTicks == 18) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, this.shakeStrenght, 0, 20);
                SoundEvent soundEvent = (SoundEvent)ModSounds.WEAPON_IMPACT.get();
                this.SideAreaAttack(5.0f, 4.0f, this.attackArc, 90.0f, this.damage(), 120, false, true, soundEvent);
            }
        }
        if (this.getAnimationState() == 3) {
            if (this.AnimationTicks > 23) {
                this.controlledAnim.increaseTimer();
            }
            if (this.AnimationTicks >= 15) {
                double dx1 = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                dy1 = this.m_20186_() + 3.0;
                dz1 = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
                ran = 0.4f;
                r = 0.0f;
                g = 0.7647059f + this.f_19796_.m_188501_() * ran;
                b = 0.0f;
                this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 2.25f, this.m_19879_()), dx1, dy1, dz1, 0.0, 0.0, 0.0);
                toDest = new Vec3((double)this.getDestinationX() - this.m_20185_(), (double)this.getDestinationY() - this.m_20186_(), (double)this.getDestinationZ() - this.m_20189_());
                distance = toDest.m_82553_();
                distancetotarget = toDest.m_82553_() * 0.5;
                speed = 0.1 + distancetotarget;
                if (distance <= speed) {
                    this.m_6034_(this.getDestinationX(), this.getDestinationY(), this.getDestinationZ());
                } else {
                    motion = toDest.m_82541_().m_82490_(speed);
                    this.m_6478_(MoverType.SELF, motion);
                }
            }
            if (this.AnimationTicks == 14) {
                this.m_5496_(swingSound, 1.0f, 1.0f);
            }
            if (this.AnimationTicks == 18) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, this.shakeStrenght, 0, 20);
                SoundEvent soundEvent = (SoundEvent)ModSounds.WEAPON_IMPACT.get();
                this.SideAreaAttack(5.0f, 4.0f, this.attackArc, -90.0f, this.damage(), 120, false, true, soundEvent);
            }
        }
        this.prevactivateProgress = this.activateProgress;
        if (this.lifeTicks <= 20 || this.lifeTicks < 32) {
            // empty if block
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                ++this.lifeTicks;
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -10) {
                // empty if block
            }
            if (this.warmupDelayTicks >= -16 || this.warmupDelayTicks > -30) {
                // empty if block
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (++this.lifeTicks > this.getLifeTicks()) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
        if (id <= 0) {
            this.lifeTicks = 0;
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LivingEntity target() {
        if (this.caster != null && this.caster instanceof Mob) {
            return ((Mob)this.caster).m_5448_();
        }
        return null;
    }

    @Override
    public void setAnimationState(int Animation) {
        this.AnimationTicks = 0;
        this.f_19804_.m_135381_(ANIMATIONSTATE, (Object)Animation);
        this.m_5496_(SoundEvents.f_11852_, 3.0f, 1.0f);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.TELEPORT_EFFECT.get()), this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 25, 0.0f, 1.0f, 0.0f, 1.0f, 14.0f, false, Circle.EnumRingBehavior.SHRINK), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.getAnimationState() == 0) {
            this.setAnimationState(this.getAnimationStateValue());
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int $$1 = this.lifeTicks - 2;
        return $$1 <= 0 ? 1.0f : 1.0f - ((float)$$1 - pPartialTicks) / 20.0f;
    }

    public boolean m_5829_() {
        return false;
    }

    public void calculatedDash(float Multiplier) {
        Vec3 vec3 = new Vec3(((double)this.getDestinationX() - this.m_20185_()) * (double)Multiplier, 0.0, ((double)this.getDestinationZ() - this.m_20189_()) * (double)Multiplier);
        this.m_20334_(((double)this.getDestinationX() - this.m_20185_()) * (double)Multiplier, 0.0, ((double)this.getDestinationZ() - this.m_20189_()) * (double)Multiplier);
    }

    public void SideAreaAttack(float range, float height, float arc, float boxOffset, float damage, int brokenShieldTicks, boolean canStun, boolean canlaunch, SoundEvent soundEvent) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = (this.m_146908_() - boxOffset) % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.getCaster() == null || this.m_7307_((Entity)entityHit) || entityHit instanceof TheObliteratorEntity || entityHit == this.getCaster()) continue;
            boolean flag = entityHit.m_6469_(ModDamageTypes.causeAnnihilationDamage((Entity)this.getCaster(), this.getCaster()), damage + MathUtils.entityBasedHpDamage(entityHit, ((Integer)ModConfig.MOB_CONFIG.TheObliteratorCloneBurstHPDamage.get()).intValue()));
            if (flag) {
                TheObliteratorUtils.applyAnnihilationEffect(entityHit, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                if (canlaunch) {
                    this.launch(entityHit, true, 0.0f, 0.5f);
                }
                if (!canStun) {
                    this.m_5496_(soundEvent, 1.0f, 0.5f);
                }
                if (canStun) {
                    this.m_5496_(SoundEvents.f_11669_, 1.0f, 1.0f);
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 80, 1));
                }
            }
            if (entityHit instanceof Player && entityHit.m_21254_() && brokenShieldTicks <= 0) continue;
        }
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21211_().m_41720_(), ticks);
        livingEntity.m_5810_();
        livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
    }

    private void launch(LivingEntity entity, boolean huge, float launchMultiplier, float yPower) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 0.001);
        float multiplier = huge ? launchMultiplier : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? (double)yPower : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_20068_() {
        return false;
    }
}

