/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect;

import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class CameraShakeEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(CameraShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STRENGHT = SynchedEntityData.m_135353_(CameraShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LASTSFORTICKS = SynchedEntityData.m_135353_(CameraShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FADE_DURATION_IN_TICKS = SynchedEntityData.m_135353_(CameraShakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CameraShakeEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public CameraShakeEntity(Level world, Vec3 position, float radius, float strenght, int duration, int fadeDuration) {
        super((EntityType)ModEntities.CAMERA_SHAKE.get(), world);
        this.setRadius(radius);
        this.setStrenght(strenght);
        this.setDuration(duration);
        this.setFadeDuration(fadeDuration);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAmount(Player player, float delta) {
        float ticksDelta = (float)this.f_19797_ + delta;
        float timeFrac = 1.0f - (ticksDelta - (float)this.getDuration()) / ((float)this.getFadeDuration() + 1.0f);
        float baseAmount = ticksDelta < (float)this.getDuration() ? this.getStrenght() : timeFrac * timeFrac * this.getStrenght();
        Vec3 playerPos = player.m_20318_(delta);
        float distFrac = (float)(1.0 - Mth.m_14008_((double)(this.m_20182_().m_82554_(playerPos) / (double)this.getRadius()), (double)0.0, (double)1.0));
        return baseAmount * distFrac * distFrac;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > this.getDuration() + this.getFadeDuration()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(STRENGHT, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(LASTSFORTICKS, (Object)0);
        this.f_19804_.m_135372_(FADE_DURATION_IN_TICKS, (Object)5);
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getStrenght() {
        return ((Float)this.f_19804_.m_135370_(STRENGHT)).floatValue();
    }

    public void setStrenght(float strenght) {
        this.f_19804_.m_135381_(STRENGHT, (Object)Float.valueOf(strenght));
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(LASTSFORTICKS);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(LASTSFORTICKS, (Object)duration);
    }

    public int getFadeDuration() {
        return (Integer)this.f_19804_.m_135370_(FADE_DURATION_IN_TICKS);
    }

    public void setFadeDuration(int fadeDuration) {
        this.f_19804_.m_135381_(FADE_DURATION_IN_TICKS, (Object)fadeDuration);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setRadius(compound.m_128457_("radius"));
        this.setStrenght(compound.m_128457_("strenght"));
        this.setDuration(compound.m_128451_("duration"));
        this.setFadeDuration(compound.m_128451_("fade_duration"));
        this.f_19797_ = compound.m_128451_("ticks_existed");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("radius", this.getRadius());
        compound.m_128350_("strenght", this.getStrenght());
        compound.m_128405_("duration", this.getDuration());
        compound.m_128405_("fade_duration", this.getFadeDuration());
        compound.m_128405_("ticks_existed", this.f_19797_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void cameraShake(Level world, Vec3 position, float radius, float strenght, int duration, int fadeDuration) {
        if (!world.f_46443_ && ((Boolean)ModConfig.MOB_CONFIG.allowCameraShake.get()).booleanValue()) {
            CameraShakeEntity cameraShake = new CameraShakeEntity(world, position, radius, strenght, duration, fadeDuration);
            world.m_7967_((Entity)cameraShake);
        }
    }
}

