/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.Particle.custom.SoulSweepParticle;
import net.miauczel.legendary_monsters.Particle.custom.SoulSweepRedParticle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.FallingSoulBladeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.SoulBladeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.SoulShieldEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.AlertedGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.FlipSmashGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.P_PAttackGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.P_PSecondPhaseStateGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.P_PStateGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.SlamAttackGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.SlashFromGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.StabGrabGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.PossessedPaladin.goal.ThrowDaggersGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedBoss;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.SoulPillarEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.SoulStrike;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ThrownEntity.EntityThrownEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ThrownPhantomDagger;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.miauczel.legendary_monsters.util.LMBossInfoServer;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PossessedPaladinEntity
extends IAnimatedBoss {
    private static final Logger log = LoggerFactory.getLogger(PossessedPaladinEntity.class);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(PossessedPaladinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final LMBossInfoServer bossInfo = new LMBossInfoServer(this.m_5446_(), BossEvent.BossBarColor.RED, false, 2);
    public final int PARRY_COOLDOWN;
    public int parry_cooldown = this.PARRY_COOLDOWN = MathUtils.toSeconds(5.0f);
    public final int FLY_AWAY_COOLDOWN = MathUtils.toSeconds(4.0f);
    public int fly_away_cooldown = 0;
    public final int THROW_COOLDOWN = MathUtils.toSeconds(5.0f);
    public int throw_cooldown = 0;
    public final int STAB_GRAB_COOLDOWN = MathUtils.toSeconds(10.0f);
    public int stab_grab_cooldown = 0;
    public final int SLAM_COOLDOWN = MathUtils.toSeconds(6.0f);
    public int slam_cooldown = 0;
    public final int FLIP_SMASH_COOLDOWN = MathUtils.toSeconds(4.0f);
    public int flip_smash_cooldown = 0;
    public final int BACKSTEP_COOLDOWN = MathUtils.toSeconds(2.0f);
    public int backstep_cooldown = 0;
    public final int SLASH_FROM_COOLDOWN = MathUtils.toSeconds(1.0f);
    public int slash_from_cooldown = 0;
    public final int DOUBLE_SLASH_COOLDOWN = MathUtils.toSeconds(1.0f);
    public int double_slash_cooldown = 0;
    public final int JUMP_COOLDOWN = MathUtils.toSeconds(6.0f);
    public int jump_cooldown = 0;
    public final int SHIELD_SMASH_COOLDOWN = MathUtils.toSeconds(6.0f);
    public int shield_smash_cooldown = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState DoubleSlashAnimationState = new AnimationState();
    public AnimationState DoubleSlashEndAnimationState = new AnimationState();
    public AnimationState DoubleSlashSlamEndAnimationState = new AnimationState();
    public AnimationState ParryAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState SwordSlamAnimationState = new AnimationState();
    public AnimationState SwordSlamEndAnimationState = new AnimationState();
    public AnimationState SwordSlamCounterEndAnimationState = new AnimationState();
    public AnimationState AllertedAnimationState = new AnimationState();
    public AnimationState BackflipAnimationState = new AnimationState();
    public AnimationState BackflipEndAnimationState = new AnimationState();
    public AnimationState BackflipDoubleAnimationState = new AnimationState();
    public AnimationState FlyAwaySlashAnimationState = new AnimationState();
    public AnimationState FlipSmashAnimationState = new AnimationState();
    public AnimationState FlipSmashEndAnimationState = new AnimationState();
    public AnimationState FlipSmashFlipAnimationState = new AnimationState();
    public AnimationState SlashFromAnimationState = new AnimationState();
    public AnimationState SlashFromEndAnimationState = new AnimationState();
    public AnimationState SlashFromStabAnimationState = new AnimationState();
    public AnimationState SlashFromStabGrabAnimationState = new AnimationState();
    public AnimationState SlashFromStabGrabFailAnimationState = new AnimationState();
    public AnimationState SlashFromStabGrabSuccessAnimationState = new AnimationState();
    public AnimationState ThrowAnimationState = new AnimationState();
    public AnimationState JumpPreAnimationState = new AnimationState();
    public AnimationState JumpFallAnimationState = new AnimationState();
    public AnimationState JumpSmashAnimationState = new AnimationState();
    public AnimationState ShieldSmashAnimationState = new AnimationState();
    public AnimationState SecondPhaseAnimationState = new AnimationState();
    public int DoubleSlashType = 1;
    public boolean hasHurt = false;
    public float uR = 1.0f;
    public float uG = 0.0f;
    public float uB = 0.0f;
    public int soulRaysCount;
    public double lastTargetX;
    public double lastTargetY;
    public double lastTargetZ;
    public boolean hasParried = false;
    public boolean succedGrabbing = false;
    public Random random1 = new Random();
    public Random random2 = new Random();

    public PossessedPaladinEntity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 100;
        this.lastTargetX = this.m_20185_();
        this.lastTargetY = this.m_20186_();
        this.lastTargetZ = this.m_20189_();
        this.m_274367_(2.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("phase", this.getPhase());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPhase(pCompound.m_128451_("phase"));
    }

    public boolean getIsSecondPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE) == 2;
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    @Override
    public void m_8119_() {
        boolean b;
        super.m_8119_();
        boolean bl = b = this.getPhase() >= 2;
        if (this.bossInfo.getRenderType() == 2 && this.getIsSecondPhase()) {
            this.bossInfo.setRenderType(4);
        }
        if (this.bossInfo.getRenderType() == 4 && !this.getIsSecondPhase()) {
            this.bossInfo.setRenderType(2);
        }
        if (!this.bossInfo.getIsDarkenSky() && this.getIsSecondPhase()) {
            this.bossInfo.m_7003_(true);
        }
        if (this.bossInfo.getIsDarkenSky() && !this.getIsSecondPhase()) {
            this.bossInfo.m_7003_(false);
        }
        if (this.m_20160_() && this.m_146895_() != null) {
            this.m_146895_().m_20260_(false);
        }
        if (this.getAttackState() != 20 && this.getAttackState() != 19) {
            this.m_20153_();
        }
        if (this.parry_cooldown > 0) {
            --this.parry_cooldown;
        }
        if (this.slam_cooldown > 0) {
            --this.slam_cooldown;
        }
        if (this.fly_away_cooldown > 0) {
            --this.fly_away_cooldown;
        }
        if (this.backstep_cooldown > 0) {
            --this.backstep_cooldown;
        }
        if (this.flip_smash_cooldown > 0) {
            --this.flip_smash_cooldown;
        }
        if (this.throw_cooldown > 0) {
            --this.throw_cooldown;
        }
        if (this.slash_from_cooldown > 0) {
            --this.slash_from_cooldown;
        }
        if (this.double_slash_cooldown > 0) {
            --this.double_slash_cooldown;
        }
        if (this.stab_grab_cooldown > 0) {
            --this.stab_grab_cooldown;
        }
        if (this.jump_cooldown > 0) {
            --this.jump_cooldown;
        }
        if (this.shield_smash_cooldown > 0) {
            --this.shield_smash_cooldown;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
        this.UpdateWithAttack();
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(0, (Goal)new P_PSecondPhaseStateGoal(this, 0, 26, 0, MathUtils.toSeconds(7.38f), 0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new P_PAttackGoal(this, 0, 2, 0, 68, 68, 5.0f, false, 10.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && !PossessedPaladinEntity.this.animationLockedForTests() && target != null && PossessedPaladinEntity.this.getNextDoubleSlashType() == 1 && PossessedPaladinEntity.this.double_slash_cooldown <= 0;
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.double_slash_cooldown = PossessedPaladinEntity.this.DOUBLE_SLASH_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new P_PAttackGoal(this, 0, 3, 0, MathUtils.toSeconds(5.04f), 57, 5.0f, false, 10.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && !PossessedPaladinEntity.this.animationLockedForTests() && target != null && PossessedPaladinEntity.this.getNextDoubleSlashType() == 2 && PossessedPaladinEntity.this.double_slash_cooldown <= 0;
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.double_slash_cooldown = PossessedPaladinEntity.this.DOUBLE_SLASH_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new SlamAttackGoal(this, 0, 6, 0, MathUtils.toSeconds(1.54f), 20, 7.0f, false, 10.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && !PossessedPaladinEntity.this.animationLockedForTests() && PossessedPaladinEntity.this.slam_cooldown <= 0 && target != null;
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.slam_cooldown = PossessedPaladinEntity.this.SLAM_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 8, 8, 0, MathUtils.toSeconds(3.38f), 18, true, 50.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.parry_cooldown = PossessedPaladinEntity.this.PARRY_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 7, 7, 0, MathUtils.toSeconds(1.29f), 0, true, 50.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.parry_cooldown = PossessedPaladinEntity.this.PARRY_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 5, 5, 0, MathUtils.toSeconds(2.92f), MathUtils.toSeconds(3.71f)){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.hasParried = false;
                PossessedPaladinEntity.this.parry_cooldown = PossessedPaladinEntity.this.PARRY_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new AlertedGoal(this, 9, 9, 0, 20, 20, false, 0.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new P_PAttackGoal(this, 0, 10, 0, MathUtils.toSeconds(1.42f), 20, 5.0f, true, 35.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && !PossessedPaladinEntity.this.animationLockedForTests() && PossessedPaladinEntity.this.backstep_cooldown <= 0 && target != null;
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.backstep_cooldown = PossessedPaladinEntity.this.BACKSTEP_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new FlipSmashGoal(this, 0, 12, 0, MathUtils.toSeconds(1.63f), MathUtils.toSeconds(0.82f), 16.0f, false, 10.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && !PossessedPaladinEntity.this.animationLockedForTests() && PossessedPaladinEntity.this.flip_smash_cooldown <= 0 && target != null;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 13, 13, 0, MathUtils.toSeconds(1.04f), 20, true, 35.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.flip_smash_cooldown = PossessedPaladinEntity.this.FLIP_SMASH_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 14, 14, 0, MathUtils.toSeconds(2.38f), 11, true, 35.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.flip_smash_cooldown = PossessedPaladinEntity.this.FLIP_SMASH_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ThrowDaggersGoal(this, 0, 15, 0, MathUtils.toSeconds(2.04f), 30, 12.0f, true, 25.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && !PossessedPaladinEntity.this.animationLockedForTests() && PossessedPaladinEntity.this.throw_cooldown <= 0 && target != null;
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.throw_cooldown = PossessedPaladinEntity.this.THROW_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new SlashFromGoal(this, 0, 16, 0, 20, 20, 5.0f, false, 10.0){

            @Override
            public boolean m_8036_() {
                LivingEntity target = PossessedPaladinEntity.this.m_5448_();
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 32.0f && PossessedPaladinEntity.this.slash_from_cooldown <= 0 && target != null && !PossessedPaladinEntity.this.animationLockedForTests();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 18, 18, 0, MathUtils.toSeconds(2.75f), 10, true, 25.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.slash_from_cooldown = PossessedPaladinEntity.this.SLASH_FROM_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 17, 17, 0, 30, 11, true, 15.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.slash_from_cooldown = PossessedPaladinEntity.this.SLASH_FROM_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new StabGrabGoal(this, 19, 19, 0, 28, 20, false, 25.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.slash_from_cooldown = PossessedPaladinEntity.this.SLASH_FROM_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 20, 20, 0, MathUtils.toSeconds(7.5f), 0, true, 25.0){

            @Override
            public void m_8056_() {
                PossessedPaladinEntity.this.succedGrabbing = false;
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.stab_grab_cooldown = PossessedPaladinEntity.this.STAB_GRAB_COOLDOWN;
                PossessedPaladinEntity.this.succedGrabbing = false;
                PossessedPaladinEntity.this.slash_from_cooldown = PossessedPaladinEntity.this.SLASH_FROM_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 21, 21, 0, MathUtils.toSeconds(1.5f), 0, true, 25.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.stab_grab_cooldown = PossessedPaladinEntity.this.STAB_GRAB_COOLDOWN;
                PossessedPaladinEntity.this.succedGrabbing = false;
                PossessedPaladinEntity.this.slash_from_cooldown = PossessedPaladinEntity.this.SLASH_FROM_COOLDOWN;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 22, 23, MathUtils.toSeconds(1.67f), MathUtils.toSeconds(1.67f), 16.0f, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && PossessedPaladinEntity.this.jump_cooldown <= 0 && PossessedPaladinEntity.this.m_5448_() != null && !PossessedPaladinEntity.this.animationLockedForTests();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 23, 23, 24, 100, 0));
        this.f_21345_.m_25352_(0, (Goal)new P_PStateGoal(this, 24, 24, 0, MathUtils.toSeconds(3.25f), 0, true, 25.0){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PossessedPaladinEntity.this.jump_cooldown = PossessedPaladinEntity.this.JUMP_COOLDOWN;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new P_PAttackGoal(this, 0, 25, 0, MathUtils.toSeconds(5.04f), MathUtils.toSeconds(3.75f), 6.0f, false, 0.0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PossessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 20.0f && PossessedPaladinEntity.this.m_5448_() != null && PossessedPaladinEntity.this.shield_smash_cooldown <= 0;
            }

            @Override
            public void m_8041_() {
                PossessedPaladinEntity.this.shield_smash_cooldown = PossessedPaladinEntity.this.SHIELD_SMASH_COOLDOWN;
                super.m_8041_();
            }
        });
    }

    public AnimationState getAnimationState(String input) {
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "allerted") {
            return this.AllertedAnimationState;
        }
        if (input == "double_slash") {
            return this.DoubleSlashAnimationState;
        }
        if (input == "double_slash_end") {
            return this.DoubleSlashEndAnimationState;
        }
        if (input == "double_slash_slam_end") {
            return this.DoubleSlashSlamEndAnimationState;
        }
        if (input == "parry") {
            return this.ParryAnimationState;
        }
        if (input == "sword_slam_cut") {
            return this.SwordSlamAnimationState;
        }
        if (input == "sword_slam_end") {
            return this.SwordSlamEndAnimationState;
        }
        if (input == "sword_slam_counter_end") {
            return this.SwordSlamCounterEndAnimationState;
        }
        if (input == "backflip") {
            return this.BackflipAnimationState;
        }
        if (input == "fly_away_slash") {
            return this.FlyAwaySlashAnimationState;
        }
        if (input == "flip_smash") {
            return this.FlipSmashAnimationState;
        }
        if (input == "flip_smash_end") {
            return this.FlipSmashEndAnimationState;
        }
        if (input == "flip_smash_flip") {
            return this.FlipSmashFlipAnimationState;
        }
        if (input == "throw") {
            return this.ThrowAnimationState;
        }
        if (input == "slash_from") {
            return this.SlashFromAnimationState;
        }
        if (input == "slash_from_end") {
            return this.SlashFromEndAnimationState;
        }
        if (input == "slash_from_stab") {
            return this.SlashFromStabAnimationState;
        }
        if (input == "slash_from_stab_grab_pre") {
            return this.SlashFromStabGrabAnimationState;
        }
        if (input == "slash_from_stab_grab_fail") {
            return this.SlashFromStabGrabFailAnimationState;
        }
        if (input == "slash_from_stab_grab_success") {
            return this.SlashFromStabGrabSuccessAnimationState;
        }
        if (input == "jump_pre") {
            return this.JumpPreAnimationState;
        }
        if (input == "jump_fall") {
            return this.JumpFallAnimationState;
        }
        if (input == "jump_smash") {
            return this.JumpSmashAnimationState;
        }
        if (input == "shield_smash") {
            return this.ShieldSmashAnimationState;
        }
        if (input == "backflip_double") {
            return this.BackflipDoubleAnimationState;
        }
        if (input == "backflip_end") {
            return this.BackflipEndAnimationState;
        }
        if (input == "second_phase") {
            return this.SecondPhaseAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.DoubleSlashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.DoubleSlashEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.DoubleSlashSlamEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.ParryAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.SwordSlamAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.SwordSlamEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.SwordSlamCounterEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.AllertedAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.BackflipAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopAllAnimationStates();
                    this.FlyAwaySlashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopAllAnimationStates();
                    this.FlipSmashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 13: {
                    this.stopAllAnimationStates();
                    this.FlipSmashEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 14: {
                    this.stopAllAnimationStates();
                    this.FlipSmashFlipAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 15: {
                    this.stopAllAnimationStates();
                    this.ThrowAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 16: {
                    this.stopAllAnimationStates();
                    this.SlashFromAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 17: {
                    this.stopAllAnimationStates();
                    this.SlashFromEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 18: {
                    this.stopAllAnimationStates();
                    this.SlashFromStabAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 19: {
                    this.stopAllAnimationStates();
                    this.SlashFromStabGrabAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 20: {
                    this.stopAllAnimationStates();
                    this.SlashFromStabGrabSuccessAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 21: {
                    this.stopAllAnimationStates();
                    this.SlashFromStabGrabFailAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 22: {
                    this.stopAllAnimationStates();
                    this.JumpPreAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 23: {
                    this.stopAllAnimationStates();
                    this.JumpFallAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 24: {
                    this.stopAllAnimationStates();
                    this.JumpSmashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 25: {
                    this.stopAllAnimationStates();
                    this.ShieldSmashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 26: {
                    this.stopAllAnimationStates();
                    this.SecondPhaseAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 27: {
                    this.stopAllAnimationStates();
                    this.BackflipEndAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.DoubleSlashAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.DoubleSlashEndAnimationState.m_216973_();
        this.DoubleSlashSlamEndAnimationState.m_216973_();
        this.ParryAnimationState.m_216973_();
        this.SwordSlamEndAnimationState.m_216973_();
        this.SwordSlamCounterEndAnimationState.m_216973_();
        this.SwordSlamAnimationState.m_216973_();
        this.AllertedAnimationState.m_216973_();
        this.BackflipAnimationState.m_216973_();
        this.FlyAwaySlashAnimationState.m_216973_();
        this.FlipSmashEndAnimationState.m_216973_();
        this.FlipSmashFlipAnimationState.m_216973_();
        this.FlipSmashAnimationState.m_216973_();
        this.ThrowAnimationState.m_216973_();
        this.SlashFromEndAnimationState.m_216973_();
        this.SlashFromAnimationState.m_216973_();
        this.SlashFromStabAnimationState.m_216973_();
        this.SlashFromStabGrabSuccessAnimationState.m_216973_();
        this.SlashFromStabGrabAnimationState.m_216973_();
        this.SlashFromStabGrabFailAnimationState.m_216973_();
        this.JumpPreAnimationState.m_216973_();
        this.JumpFallAnimationState.m_216973_();
        this.JumpSmashAnimationState.m_216973_();
        this.BackflipDoubleAnimationState.m_216973_();
        this.BackflipEndAnimationState.m_216973_();
        this.ShieldSmashAnimationState.m_216973_();
        this.SecondPhaseAnimationState.m_216973_();
    }

    public int getNextDoubleSlashType() {
        return this.DoubleSlashType;
    }

    public void randomizeNextDoubleSlashType(int rolls) {
        switch (this.f_19796_.m_188503_(rolls)) {
            case 0: {
                this.DoubleSlashType = 1;
                break;
            }
            case 1: {
                this.DoubleSlashType = 2;
            }
        }
    }

    public void randomizeAttacks() {
        this.randomizeNextDoubleSlashType(2);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 15.0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    public boolean damageAdaptationSystem() {
        return true;
    }

    @Override
    public int adaptationFactor() {
        return 25;
    }

    public boolean animationLockedForTests() {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public boolean hasDagger() {
        return this.getAttackState() == 15;
    }

    public boolean hasShield() {
        return this.getAttackState() == 25;
    }

    public void UpdateWithAttack() {
        float pitch;
        float yaw;
        double d1;
        double dx;
        float sweepSize = 2.0f;
        float sweepRot = 20.0f;
        float bigSweepHeight = 3.0f;
        float bigSweepAdditionalY = 1.0f;
        float doubleSlashRange = 3.5f;
        float doubleSlashAttack1 = 20.0f;
        float doubleSlashAttack2 = 36.0f;
        float doubleSlashAttack3 = 62.0f;
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        if (this.getAttackState() == 2) {
            if ((float)this.attackTicks == doubleSlashAttack1 - 3.0f) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, false, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 0.75f);
                this.calculatedDash(0.25f);
            }
            if ((float)this.attackTicks == doubleSlashAttack1) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.05f, 0, 10);
                this.SideAreaAttack(doubleSlashRange, 3.0f, 180.0f, 0.0f, 0.0f, 15.0f, 100, SoundEvents.f_271165_, 1.0f, false, 0.0f);
            }
            if ((float)this.attackTicks == doubleSlashAttack2 - 3.0f) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, true, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 0.75f);
                this.calculatedDash(0.25f);
            }
            if ((float)this.attackTicks == doubleSlashAttack2) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.05f, 0, 10);
                this.SideAreaAttack(doubleSlashRange, 3.0f, 180.0f, 0.0f, 0.0f, 17.0f, 100, SoundEvents.f_271165_, 1.0f, false, 0.0f);
            }
        }
        if (this.getAttackState() == 3) {
            if ((float)this.attackTicks == doubleSlashAttack1 - 3.0f) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, false, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 0.75f);
                this.calculatedDash(0.25f);
            }
            if ((float)this.attackTicks == doubleSlashAttack1) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.05f, 0, 10);
                this.SideAreaAttack(doubleSlashRange, 3.0f, 180.0f, 0.0f, 0.0f, 15.0f, 100, SoundEvents.f_271165_, 1.0f, false, 0.0f);
            }
            if ((float)this.attackTicks == doubleSlashAttack2 - 3.0f) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, true, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 0.75f);
                this.calculatedDash(0.25f);
            }
            if ((float)this.attackTicks == doubleSlashAttack2) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.05f, 0, 10);
                this.SideAreaAttack(doubleSlashRange, 3.0f, 180.0f, 0.0f, 0.0f, 17.0f, 100, SoundEvents.f_271165_, 1.0f, false, 0.0f);
            }
            if ((float)this.attackTicks == doubleSlashAttack3 - 5.0f) {
                this.saveTargetPos();
            }
            if ((float)this.attackTicks == doubleSlashAttack3 - 3.0f) {
                double d0 = this.m_20185_();
                double d12 = this.m_20186_() + (double)bigSweepAdditionalY;
                double d2 = this.m_20189_();
                float yaw2 = (float)Math.toRadians(-this.f_20883_ + 90.0f);
                float pitch2 = (float)Math.toRadians(-this.m_146909_() + 180.0f);
                if (this.m_9236_().f_46443_) {
                    if (this.getPhase() < 2) {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * 2.0f, yaw2, pitch2), d0, d12, d2, 0.0, 0.0, 0.0);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * 2.0f, yaw2, pitch2), d0, d12, d2, 0.0, 0.0, 0.0);
                    }
                }
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
                this.calculatedDashToPositon(0.15f, this.lastTargetPos());
            }
            if ((float)this.attackTicks == doubleSlashAttack3) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 10);
                this.spawnSoulPillar(3.0f, 0.0f, 5);
                this.m_5496_((SoundEvent)ModSounds.POWERFUL_SWORD_IMPACT2.get(), 1.0f, 1.0f);
                this.StraightLineAreaAttack(-0.35f, 3.0f, 3.5f, 100, 18.0f, true, 1.5f);
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 27) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, true, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 0.75f);
                this.calculatedDash(0.25f);
            }
            for (int i = 28; i <= 30; ++i) {
                if (this.attackTicks != i) continue;
                int n = i - 26;
            }
            if (this.attackTicks == 30) {
                this.throwDaggers(1.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6, 30.0f, 0.0f, 10);
                this.SideAreaAttack(doubleSlashRange, 3.0f, 180.0f, 0.0f, 0.0f, 20.0f, 100, SoundEvents.f_11668_, 1.0f, true, 2.0f);
            }
        }
        int slamAttackTick = MathUtils.toSeconds(1.17f);
        if (this.getAttackState() == 6) {
            if (this.attackTicks == slamAttackTick - 5) {
                this.saveTargetPos();
            }
            if (this.attackTicks == slamAttackTick - 3) {
                double d0 = this.m_20185_();
                double d13 = this.m_20186_() + (double)bigSweepAdditionalY;
                double d2 = this.m_20189_();
                float yaw3 = (float)Math.toRadians(-this.f_20883_ + 90.0f);
                float pitch3 = (float)Math.toRadians(-this.m_146909_() + 180.0f);
                if (this.m_9236_().f_46443_) {
                    if (this.getPhase() < 2) {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * 2.0f, yaw3, pitch3), d0, d13, d2, 0.0, 0.0, 0.0);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * 2.0f, yaw3, pitch3), d0, d13, d2, 0.0, 0.0, 0.0);
                    }
                }
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == slamAttackTick) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 10);
                this.spawnSoulPillar(3.0f, 0.0f, 5);
                this.m_5496_((SoundEvent)ModSounds.POWERFUL_SWORD_IMPACT2.get(), 1.0f, 1.0f);
                this.StraightLineAreaAttack(-0.35f, 3.0f, 3.5f, 100, 18.0f, true, 1.5f);
            }
        }
        int counterTick = 24;
        if (this.getAttackState() == 8) {
            if (this.attackTicks > 5 && this.attackTicks < 20 && this.targetIsNotNull()) {
                if (this.f_19797_ % 3 == 0) {
                    this.spawnSoulPillar(-1.0f, 0.0f, 1);
                }
                float distance = this.m_20270_((Entity)this.target());
                float multiplier = Math.min(distance * 0.025f, 0.15f);
                this.calculatedDash(multiplier);
            }
            if (this.attackTicks == counterTick - 4) {
                this.saveTargetPos();
            }
            if (this.attackTicks == counterTick - 3) {
                double d0 = this.m_20185_();
                double d14 = this.m_20186_() + (double)bigSweepAdditionalY;
                double d2 = this.m_20189_();
                float yaw4 = (float)Math.toRadians(-this.f_20883_ + 90.0f);
                float pitch4 = (float)Math.toRadians(-this.m_146909_() + 180.0f);
                if (this.m_9236_().f_46443_) {
                    if (this.getPhase() < 2) {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * 2.0f, yaw4, pitch4), d0, d14, d2, 0.0, 0.0, 0.0);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * 2.0f, yaw4, pitch4), d0, d14, d2, 0.0, 0.0, 0.0);
                    }
                }
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == counterTick) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 10);
                this.spawnCircleParticle(1.5f, 0.0f, 30.0f, true, 1.0f, this.getPhase() >= 2 ? this.uR : 0.0f, this.getPhase() >= 2 ? this.uG : 0.9f, this.getPhase() >= 2 ? this.uB : 0.8f, 0.8f, Circle.EnumRingBehavior.GROW, 20);
                this.m_5496_(SoundEvents.f_12513_, 1.0f, 0.65f);
                this.SideAreaAttack(3.5f, 3.0f, 100.0f, 0.0f, 0.0f, 20.0f, 100, SoundEvents.f_271165_, 1.0f, true, 2.0f);
                this.randomizedSoulStrike(3, 4, 3);
                this.randomizedSoulStrike(2, 3, 5);
                this.randomizedSoulStrike(5, 6, 2);
            }
        }
        if (this.getAttackState() == 10 && this.attackTicks == 8) {
            this.backStep(-1.5f, 0.2f);
        }
        if (this.getAttackState() == 11) {
            if (this.attackTicks == 12) {
                this.basicDash(0.5f, 0.5f, 0.0f, false);
            }
            if (this.attackTicks == 15) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, true, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.WEAPON_SPIN.get(), 1.0f, 0.75f);
            }
            if (this.attackTicks == 18) {
                this.SideAreaAttack(3.5f, 3.0f, 180.0f, 0.0f, 0.0f, 20.0f, 100, SoundEvents.f_271165_, 1.0f, false, 2.0f);
            }
            if (this.attackTicks == 18) {
                this.backStep(-2.0f, 0.5f);
            }
        }
        float hitBoxWidth = 0.5f;
        if (this.getAttackState() == 12) {
            if (this.attackTicks == 6 && this.targetIsNotNull()) {
                float vec = 0.0f;
                float offset = 2.0f;
                dx = this.m_20185_() + (double)vec * vecX + (double)(f * offset);
                double dz = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset);
                this.jumpTowardsPosition(this.target().m_20185_(), this.target().m_20186_(), this.target().m_20189_());
            }
            if (this.attackTicks == 16) {
                double d0 = this.m_20185_();
                d1 = this.m_20186_() + (double)bigSweepAdditionalY;
                double d2 = this.m_20189_();
                yaw = (float)Math.toRadians(-this.f_20883_ + 90.0f);
                pitch = (float)Math.toRadians(-this.m_146909_() + 180.0f);
                if (this.m_9236_().f_46443_) {
                    if (this.getPhase() < 2) {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * 2.0f, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * 2.0f, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.attackTicks == 19) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 10);
                this.spawnSoulPillar(3.0f, 0.0f, 5);
                this.m_5496_((SoundEvent)ModSounds.POWERFUL_SWORD_IMPACT2.get(), 1.0f, 1.0f);
                this.StraightLineAreaAttack(-hitBoxWidth, 3.0f, 3.5f, 100, 18.0f, true, 1.5f);
            }
        }
        if (this.getAttackState() == 14) {
            if (this.attackTicks == 2 && this.targetIsNotNull()) {
                float vec = 0.0f;
                float offset = 2.0f;
                dx = this.m_20185_() + (double)vec * vecX + (double)(f * offset);
                double dz = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset);
                this.jumpTowardsPosition(this.target().m_20185_(), this.target().m_20186_(), this.target().m_20189_());
            }
            if (this.attackTicks == 11) {
                double d0 = this.m_20185_();
                d1 = this.m_20186_() + (double)bigSweepAdditionalY;
                double d2 = this.m_20189_();
                yaw = (float)Math.toRadians(-this.f_20883_ + 90.0f);
                pitch = (float)Math.toRadians(-this.m_146909_() + 180.0f);
                if (this.m_9236_().f_46443_) {
                    if (this.getPhase() < 2) {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * 2.0f, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * 2.0f, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.attackTicks == 14) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 10);
                this.spawnSoulPillar(3.0f, 0.0f, 5);
                this.m_5496_((SoundEvent)ModSounds.POWERFUL_SWORD_IMPACT2.get(), 1.0f, 1.0f);
                this.StraightLineAreaAttack(-hitBoxWidth, 3.0f, 3.5f, 100, 18.0f, true, 1.5f);
            }
        }
        if (this.getAttackState() == 15) {
            if (this.attackTicks == 10) {
                this.backStep(-1.0f, 0.0f);
            }
            if (this.attackTicks == 12) {
                this.throwDaggers(1.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 30.0f, 0.0f, 10);
            }
        }
        int slashFromAttack = 18;
        int stabAttack = 18;
        if (this.getAttackState() == 16) {
            if (this.attackTicks == slashFromAttack - 3) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, true, sweepSize, sweepRot, false);
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 0.75f);
                this.calculatedDash(0.25f);
            }
            if (this.attackTicks == slashFromAttack) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.05f, 0, 10);
                this.GambitedSideAreaAttack(doubleSlashRange, 3.0f, 180.0f, 0.0f, 0.0f, 17.0f, 100, SoundEvents.f_271165_, 1.0f, false, 0.0f);
            }
        }
        if (this.getAttackState() == 18) {
            if (this.attackTicks == stabAttack - 8) {
                this.saveTargetPos();
            }
            if (this.attackTicks == stabAttack - 3) {
                this.m_5496_((SoundEvent)ModSounds.PP_STAB.get(), 1.0f, 0.8f);
                this.calculatedDashToPositon(0.25f, this.lastTargetPos());
            }
            if (this.attackTicks == stabAttack) {
                this.StraightLineAreaAttack(-0.6f, 3.0f, 4.0f, 100, 17.0f, true, 1.35f);
            }
        }
        int stabGrabAttack = 28;
        if (this.getAttackState() == 19) {
            if (this.attackTicks == stabGrabAttack - 8) {
                this.saveTargetPos();
            }
            if (this.attackTicks == stabGrabAttack - 3) {
                this.m_5496_((SoundEvent)ModSounds.PP_STAB.get(), 1.0f, 0.8f);
                this.calculatedDashToPositon(0.25f, this.lastTargetPos());
            }
            if (this.attackTicks == stabGrabAttack) {
                this.StabGrab(-0.6f, 3.0f, 4.0f, 100, 17.0f, true, 1.35f);
            }
        }
        if (this.getAttackState() == 20) {
            if (this.attackTicks < 20) {
                this.soulRaysCount = 0;
            }
            if (this.attackTicks == 20 || this.attackTicks == 30 || this.attackTicks == 40) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, 0.1f, 0, 10);
                for (Entity entity : this.m_20197_()) {
                    boolean hurt = entity.m_6469_(ModDamageTypes.causeGhostlyDamage((Entity)this, (LivingEntity)this), (float)(2.0 + (double)MathUtils.entityBasedHpDamage((LivingEntity)entity, 5.0f) * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
                    if (!hurt) continue;
                    this.m_5634_(3.0f + MathUtils.entityBasedHpDamage((LivingEntity)entity, 0.25f));
                }
                this.spawnCircleParticle(2.0f, -1.0f, 30.0f, false, 1.0f, this.getPhase() >= 2 ? this.uR : 0.0f, this.getPhase() >= 2 ? this.uG : 0.9f, this.getPhase() >= 2 ? this.uB : 0.8f, 0.8f, Circle.EnumRingBehavior.GROW, 20, 4.0, true);
                ++this.soulRaysCount;
            }
            if (this.attackTicks == 20) {
                this.m_5496_(SoundEvents.f_12376_, 1.0f, 0.75f);
            }
            if (this.attackTicks == 30) {
                this.m_5496_(SoundEvents.f_12376_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 40) {
                this.m_5496_(SoundEvents.f_12376_, 1.0f, 1.25f);
            }
            if (this.attackTicks == 60) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 63) {
                this.soulRaysCount = 0;
                double d0 = this.m_20185_();
                double d15 = this.m_20186_() + (double)bigSweepAdditionalY;
                double d2 = this.m_20189_();
                float yaw5 = (float)Math.toRadians(-this.f_20883_ + 90.0f);
                float pitch5 = (float)Math.toRadians(-this.m_146909_() + 180.0f);
                if (this.m_9236_().f_46443_) {
                    if (this.getPhase() < 2) {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * 2.0f, yaw5, pitch5), d0, d15, d2, 0.0, 0.0, 0.0);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * 2.0f, yaw5, pitch5), d0, d15, d2, 0.0, 0.0, 0.0);
                    }
                }
                this.m_5496_(SoundEvents.f_12513_, 1.0f, 1.0f);
                Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                CameraShakeEntity.cameraShake(this.m_9236_(), pos, 20.0f, 0.25f, 0, 20);
                this.spawnCircleParticle(1.5f, -0.25f, 50.0f, true, 5.0f, this.getPhase() >= 2 ? this.uR : 0.25f, this.getPhase() >= 2 ? this.uG : 1.0f, this.getPhase() >= 2 ? this.uB : 0.75f, 1.0f);
                this.SideAreaAttack(4.0f, 4.0f, 360.0f, 0.0f, 1.0f, 10.0f, 0, SoundEvents.f_271165_, 0.0f, false, 0.0f);
            }
            if (this.attackTicks >= 63 && this.attackTicks <= 68) {
                this.SphereParticle((ParticleOptions)ModParticles.GHOSTLY_SOUL.get(), 0.35f, 2.0f, 3.0f);
            }
            if (this.attackTicks == 106) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 109) {
                this.createSweep(0.0f, 0.0f, bigSweepHeight, bigSweepAdditionalY, false, sweepSize, sweepRot, false);
                float destVec = 15.0f;
                float destoffset = 0.0f;
                float vec = 3.0f;
                float offset = 0.0f;
                Entity entity = this.m_146895_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (this.m_146895_() != null && !this.m_9236_().f_46443_) {
                        this.throwAnGravityEntity(1.0f, this.m_20185_() + (double)destVec * vecX + (double)(f * destoffset), this.m_20186_() + 2.0, this.m_20189_() + (double)destVec * vecZ + (double)(f1 * destoffset), this.m_20185_() + (double)vec * vecX + (double)(f * offset), this.m_20186_() + 1.0, this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset), 1.0f, livingEntity);
                    }
                }
            }
        }
        LivingEntity target = this.target();
        if (this.getAttackState() == 22 && this.attackTicks == 24) {
            if (target != null) {
                // empty if block
            }
            if (target != null) {
                double d0 = target.m_20185_() - this.m_20185_();
                double d16 = target.m_20186_() - this.m_20186_();
                double d2 = target.m_20189_() - this.m_20189_();
                double mult = 0.2;
                Vec3 vec3 = new Vec3(d0, 0.7 + Mth.m_14008_((double)(d16 * 0.075), (double)0.0, (double)10.0), d2).m_82542_(mult, 1.0, mult);
                this.m_20256_(vec3);
            } else {
                Vec3 vec3 = new Vec3(0.0, 0.7, 0.0);
                this.m_20256_(vec3);
            }
        }
        if (this.getAttackState() == 23 && this.m_20096_()) {
            this.setAttackState(24);
        }
        if (this.getAttackState() == 24) {
            if (this.attackTicks == 4) {
                this.SideAreaAttack(3.0f, 3.0f, 180.0f, 0.0f, 0.0f, 20.0f, 100, ModSounds.f_271165_, 0.0f, true, 1.5f);
                this.m_5496_(SoundEvents.f_12513_, 1.0f, 0.75f);
                this.strikeZigzagXBlades(12, 1.0, false, 10.0f, 4.0f, 1, 2.0, true);
                this.spawnCircleParticle(1.5f, -0.25f, 60.0f, true, 5.0f, this.getPhase() >= 2 ? this.uR : 0.25f, this.getPhase() >= 2 ? this.uG : 1.0f, this.getPhase() >= 2 ? this.uB : 0.75f, 1.0f);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.25f, 0, 20);
            }
            if (this.attackTicks == 7) {
                this.strikeZigzagXBlades(12, 1.0, false, 12.0f, 4.0f, 1, 2.0, false);
            }
        }
        if (this.getAttackState() == 25) {
            double totalRadius = 12.0;
            int points = 16;
            int smashTick1 = 35;
            int smashTick2 = 59;
            if (this.attackTicks == smashTick1 - 7) {
                this.spawnSoulShieldRing(0, 2, points, totalRadius, false, true);
            }
            if (this.attackTicks == smashTick1 - 3) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == smashTick1) {
                this.SideAreaAttack(3.25f, 3.0f, 180.0f, 0.0f, 0.0f, 20.0f, 100, ModSounds.f_271165_, 0.0f, true, 1.0f);
                this.m_5496_((SoundEvent)ModSounds.SOUL_SHIELD_SMASH.get(), 1.0f, 1.0f);
                this.spawnCircleParticle(0.0f, 0.0f, 100.0f, true, 2.0f, this.getPhase() >= 2 ? this.uR : 0.0f, this.getPhase() >= 2 ? this.uG : 0.9f, this.getPhase() >= 2 ? this.uB : 0.8f, 0.8f, Circle.EnumRingBehavior.SHRINK, 30);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 5);
                this.spawnSoulShieldRing(0, 2, points, totalRadius, false, false);
            }
            if (this.attackTicks == smashTick2 - 7) {
                double radius = 2.0;
                this.spawnSoulShieldRing(1, 2, points, radius, true, true);
            }
            if (this.attackTicks == smashTick2 - 3) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == smashTick2) {
                double radius = 2.0;
                this.m_5496_((SoundEvent)ModSounds.STAB_HIT.get(), 1.0f, 1.0f);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 5);
                this.spawnCircleParticle(0.0f, 0.0f, 100.0f, true, 2.0f, this.getPhase() >= 2 ? this.uR : 0.0f, this.getPhase() >= 2 ? this.uG : 0.9f, this.getPhase() >= 2 ? this.uB : 0.8f, 0.8f, Circle.EnumRingBehavior.GROW, 30);
                this.spawnSoulShieldRing(1, 2, points, radius, true, false);
            }
        }
        if (this.getAttackState() == 26) {
            if (this.attackTicks == 49) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.15f, 5, 5);
                this.m_5496_(ModSounds.f_12513_, 1.0f, 0.75f);
                this.earthquakeEffect(15.0f, 0.25f);
            }
            if (this.attackTicks >= 49 && this.attackTicks < 51) {
                this.SphereParticle((ParticleOptions)ModParticles.GHOSTLY_SOUL.get(), 0.0f, 2.0f, 6.0f);
            }
            if (this.attackTicks >= 51 && this.attackTicks <= 53) {
                this.SphereParticle((ParticleOptions)ModParticles.GHOSTLY_SOUL_RED.get(), 0.0f, 2.0f, 6.0f);
            }
            if (this.attackTicks == MathUtils.toSeconds(4.13f)) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.1f, 5, 5);
                this.m_5496_(ModSounds.f_12558_, 1.0f, 1.0f);
                this.SoulStrike(0.0f, 15, 1.5f);
            }
        }
    }

    public void earthquakeEffect(float range, float amplitude) {
        for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)range))) {
            Vec3 delta = livingEntity.m_20184_();
            livingEntity.m_20334_(delta.f_82479_, delta.f_82480_ + (double)amplitude, delta.f_82481_);
            EntityUtil.applyPlayerDeltaMovement(livingEntity);
        }
    }

    private void spawnSoulShieldRing(int waveIndex, int wavesTotal, int totalPoints, double radius, boolean isOuter, boolean isWarningParticle) {
        double step = Math.PI * 2 / (double)totalPoints;
        int pointsThisWave = totalPoints / wavesTotal;
        double base = -0.41887902047863906;
        double waveOffset = (double)waveIndex * step;
        for (int i = 0; i < pointsThisWave; ++i) {
            double angle = base + waveOffset + (double)i * ((double)wavesTotal * step);
            double spawnX = this.m_20185_() + Math.cos(angle) * radius;
            double spawnZ = this.m_20189_() + Math.sin(angle) * radius;
            double spawnY = Mth.m_14107_((double)this.m_20186_());
            double headY = this.m_20186_() + 1.0;
            double dx = this.m_20185_() - spawnX;
            double dz = this.m_20189_() - spawnZ;
            float yawRad = (float)Math.atan2(dz, dx);
            float f2 = (float)i * ((float)Math.PI * 2) / (float)pointsThisWave + ((float)Math.PI * 2 / (float)pointsThisWave - 1.0f);
            this.spawnSoulShields(spawnX, spawnZ, spawnY, headY, isOuter ? f2 : yawRad, 4, (float)this.m_20185_(), (float)this.m_20186_(), (float)this.m_20189_(), isOuter, isWarningParticle);
        }
    }

    public void spawnSoulShields(double x, double z, double minY, double maxY, float rotation, int delay, float destX, float destY, float destZ, boolean isOuter, boolean isWarningParticle) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            PossessedPaladinEntity entity1 = this;
            if (isWarningParticle) {
                if (this.m_9236_().f_46443_) {
                    this.m_9236_().m_7106_(this.getPhase() >= 2 ? (ParticleOptions)ModParticles.GROUNDSOUL_RED.get() : (ParticleOptions)ModParticles.GROUNDSOUL.get(), x, (double)blockpos.m_123342_() + 2.0 + d0, z, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 35, this.getPhase() >= 2 ? this.uR : 0.0f, this.getPhase() >= 2 ? this.uG : 0.9f, this.getPhase() >= 2 ? this.uB : 0.8f, 0.8f, 15.0f, false, Circle.EnumRingBehavior.SHRINK), x, (double)blockpos.m_123342_() + 0.25 + d0, z, 0.0, 0.0, 0.0);
                }
            } else {
                this.m_9236_().m_7967_((Entity)new SoulShieldEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, 10.0f, destX, destY, destZ, isOuter, this.getPhase() >= 2));
            }
        }
    }

    private void strikeZigzagXBlades(int rune, double time, boolean isFalling, float damage, float divider, int offset, double amplitude, boolean particleWarning) {
        for (int i = 0; i < rune; ++i) {
            float throwAngle = (float)i * (float)Math.PI / ((float)rune / divider);
            float perpX = -Mth.m_14031_((float)throwAngle);
            float perpZ = Mth.m_14089_((float)throwAngle);
            for (int k = 0; k < 8; ++k) {
                double forward = 1.25 * (double)(k + 1);
                int group = k / offset % 2;
                double lateral = amplitude * (double)(group == 0 ? 1 : -1);
                double xOff = (double)Mth.m_14089_((float)throwAngle) * forward + (double)perpX * lateral;
                double zOff = (double)Mth.m_14031_((float)throwAngle) * forward + (double)perpZ * lateral;
                int delay = (int)(time * (double)(k + 1));
                this.spawnBlades(this.m_20185_() + xOff, this.m_20189_() + zOff, this.m_20186_(), this.m_20186_() + 2.0, throwAngle, delay, isFalling, damage, particleWarning);
            }
        }
    }

    private void spawnBlades(double x, double z, double minY, double maxY, float rotation, int delay, boolean falling, float damage, boolean warning) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            PossessedPaladinEntity entity1 = this;
            if (warning) {
                this.m_9236_().m_7107_(this.getPhase() >= 2 ? (ParticleOptions)ModParticles.GROUNDSOUL_RED.get() : (ParticleOptions)ModParticles.GROUNDSOUL.get(), x, (double)blockpos.m_123342_() + 2.0 + d0, z, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 35, this.getPhase() >= 2 ? this.uR : 0.0f, this.getPhase() >= 2 ? this.uG : 0.9f, this.getPhase() >= 2 ? this.uB : 0.8f, 0.8f, 15.0f, false, Circle.EnumRingBehavior.SHRINK), x, (double)blockpos.m_123342_() + 0.25 + d0, z, 0.0, 0.0, 0.0);
            } else if (falling) {
                this.m_9236_().m_7967_((Entity)new FallingSoulBladeEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, damage));
            } else {
                this.m_9236_().m_7967_((Entity)new SoulBladeEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, damage, this.getPhase() >= 2));
            }
        }
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float vec = 1.0f;
        float offset = 0.0f;
        if (this.m_20363_(pPassenger)) {
            pCallback.m_20372_(pPassenger, this.m_20185_() + (double)vec * vecX + (double)(f * offset), this.m_20186_() + 1.0, this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset));
        }
    }

    private void SphereParticle(ParticleOptions particleType, float height, float vec, float size) {
        if (this.m_9236_().f_46443_ && this.f_19797_ % 2 == 0) {
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + (double)height;
            double d2 = this.m_20189_();
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                        double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                        double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.m_188583_() * 0.05;
                        this.m_9236_().m_7106_(particleType, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2.0f - 1.0f;
                    }
                }
            }
        }
    }

    public void backStep(float v, float y) {
        float yaw = (float)Math.toRadians(this.m_146908_() + 90.0f);
        Vec3 dodgePos = this.m_20184_().m_82520_((double)v * Math.cos(yaw), (double)y, (double)v * Math.sin(yaw));
        this.m_20334_(dodgePos.f_82479_, dodgePos.f_82480_, dodgePos.f_82481_);
    }

    public void jumpTowardsPosition(double x, double y, double z) {
        Vec3 start = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 end = new Vec3(x, y, z);
        Vec3 sub = end.m_82546_(start);
        Vec3 finalPos = sub.m_82490_(0.8);
        double d0 = finalPos.f_82479_;
        double d1 = finalPos.f_82480_;
        double d2 = finalPos.f_82481_;
        Vec3 vec3 = new Vec3(d0, 0.3 + Mth.m_14008_((double)(d1 * 0.075), (double)0.0, (double)10.0), d2).m_82542_(0.2, 1.0, 0.2);
        this.m_20256_(vec3);
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public LivingEntity target() {
        return this.m_5448_();
    }

    public Vec3 lastTargetPos() {
        return new Vec3(this.lastTargetX, this.lastTargetY, this.lastTargetZ);
    }

    public boolean isMagicAttack() {
        return this.getAttackState() == 20;
    }

    public void saveTargetPos() {
        if (this.targetIsNotNull()) {
            this.lastTargetX = this.target().m_20185_();
            this.lastTargetY = this.target().m_20186_();
            this.lastTargetZ = this.target().m_20189_();
        }
    }

    public boolean canParry() {
        return !this.hasParried && this.parry_cooldown <= 0 && (this.getAttackState() == 0 || this.getAttackState() == 9);
    }

    public boolean isBlockin() {
        return this.getAttackState() == 5 && this.attackTicks < MathUtils.toSeconds(0.92f);
    }

    @Override
    public int attackDelayTicksValue() {
        return this.parry_cooldown <= 0 ? 3 : 1;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isBlockin()) {
            this.m_5496_((SoundEvent)ModSounds.BLOCK.get(), 1.0f, 1.0f);
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, 0.15f, 5, 5);
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.canParry() && amount > 1.0f) {
            this.hasParried = true;
            this.setAttackState(5);
            this.stopAllAnimationStates();
            this.m_5496_((SoundEvent)ModSounds.BLOCK.get(), 1.0f, 1.0f);
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, 0.15f, 5, 5);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public double damageCap() {
        return 21.0;
    }

    public void createSweep(float pos, float posOffset, float yHeight, double additionalY, boolean reverse, float scale, float rot, boolean small) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float vec = pos;
        float offset = posOffset;
        double x = this.m_20185_() + (double)vec * vecX + (double)(f * offset);
        double z = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset);
        if (this.m_9236_().f_46443_) {
            double d0 = x;
            double d1 = this.m_20186_() + (double)(this.m_20206_() / 2.0f) + additionalY;
            double d2 = z;
            float yaw = (float)Math.toRadians(-this.f_20883_ + (reverse ? rot : 180.0f));
            double lookX = -Math.cos(yaw);
            double lookZ = -Math.sin(yaw);
            float pitch = (float)(reverse ? -1 : 1) * (float)Math.atan2(yHeight, Math.sqrt(lookX * lookX + lookZ * lookZ));
            if (this.getPhase() >= 2) {
                this.m_9236_().m_7106_((ParticleOptions)new SoulSweepRedParticle.SweepData(this.m_6134_() * scale, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
            } else {
                this.m_9236_().m_7106_((ParticleOptions)new SoulSweepParticle.SweepData(this.m_6134_() * scale, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void throwAnGravityEntity(float velocity, double destX, double destY, double destZ, double x, double y, double z, float damage, LivingEntity passenger) {
        if (passenger != null) {
            EntityThrownEntity thrownEntity = new EntityThrownEntity(this.m_9236_(), (LivingEntity)this, x, y, z, damage, 1.0f, passenger);
            thrownEntity.m_20343_(x, y, z);
            double d0 = destX - x;
            double d1 = destY + 0.5 - thrownEntity.m_20186_();
            double d2 = destZ - z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            double d4 = (destX - y) * 0.5;
            thrownEntity.m_6686_(d0, d1 + d3 * 0.2, d2, velocity, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            thrownEntity.m_5602_((Entity)this);
            this.m_9236_().m_7967_((Entity)thrownEntity);
        }
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.PosessedPaladinHealthMultiplier.get());
    }

    public boolean m_5825_() {
        return true;
    }

    private void StraightLineAreaAttack(float boxWidth, float yHeight, float range, int brokenShieldTicks, float damage, boolean launch, float launchPower) {
        double rad = Math.toRadians(this.m_146908_() + 90.0f);
        double xRange = (double)range * Math.cos(rad);
        double zRange = (double)range * Math.sin(rad);
        AABB attackRange = this.m_20191_().m_82377_((double)boxWidth, (double)yHeight, (double)boxWidth).m_82363_(xRange, 0.0, zRange);
        for (LivingEntity entityHit : this.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
            if (this.m_7307_((Entity)entityHit) || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage + (double)MathUtils.entityBasedHpDamage(entityHit, 3.0f) * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
            if (flag) {
                this.applyStackingEffect(entityHit, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
            }
            if (flag && launch) {
                this.launch(entityHit, true);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            PossessedPaladinEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    private void StabGrab(float boxWidth, float yHeight, float range, int brokenShieldTicks, float damage, boolean launch, float launchPower) {
        double rad = Math.toRadians(this.m_146908_() + 90.0f);
        double xRange = (double)range * Math.cos(rad);
        double zRange = (double)range * Math.sin(rad);
        AABB attackRange = this.m_20191_().m_82377_((double)boxWidth, (double)yHeight, (double)boxWidth).m_82363_(xRange, 0.0, zRange);
        for (LivingEntity entityHit : this.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
            if (this.m_7307_((Entity)entityHit) || entityHit == this) continue;
            boolean entityHitIsTarget = entityHit == this.target();
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage + (double)MathUtils.entityBasedHpDamage(entityHit, 3.0f) * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
            if (flag) {
                this.applyStackingEffect(entityHit, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
            }
            if (flag) {
                boolean mounted = entityHit.m_7998_((Entity)this, true);
                if (mounted && flag) {
                    entityHit.m_20260_(false);
                    this.succedGrabbing = true;
                } else {
                    this.succedGrabbing = false;
                }
            } else {
                this.succedGrabbing = false;
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            PossessedPaladinEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    public int getStunDuration() {
        return 55;
    }

    public void launch(LivingEntity entity, float strenght) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 1.0E-4);
        entity.m_5997_(deltaX / distanceSquared * (double)strenght, (double)strenght, deltaZ / distanceSquared * (double)strenght);
    }

    public void SideAreaAttack(float range, float height, float arc, float boxOffset, float forwardOffset, float damage, int brokenShieldTicks, SoundEvent soundEvent, float pitch, boolean launch, float launchPower) {
        double theta = Math.toRadians(this.f_20883_) + 1.5707963267948966;
        double forwardX = Math.cos(theta) * (double)forwardOffset;
        double forwardZ = Math.sin(theta) * (double)forwardOffset;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityAttackingAngle;
            double dx = entityHit.m_20185_() - (this.m_20185_() + forwardX);
            double dz = entityHit.m_20189_() - (this.m_20189_() + forwardZ);
            float entityHitAngle = (float)((Math.toDegrees(Math.atan2(dz, dx)) - 90.0) % 360.0);
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if ((entityAttackingAngle = (this.f_20883_ - boxOffset) % 360.0f) < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityHitDistance = (float)Math.sqrt(dx * dx + dz * dz);
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof PossessedPaladinEntity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.isMagicAttack() ? ModDamageTypes.causeGhostlyDamage((Entity)this, (LivingEntity)this) : this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage + (double)MathUtils.entityBasedHpDamage(entityHit, 3.0f) * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
            if (flag) {
                if (this.getAttackState() == 20) {
                    this.m_5634_(3.0f + MathUtils.entityBasedHpDamage(entityHit, 1.0f));
                }
                if (launch) {
                    this.launch(entityHit, true);
                }
                if (this.getAttackState() == 5) {
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), this.getStunDuration(), 0));
                }
                this.applyStackingEffect(entityHit, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
                this.m_5496_(soundEvent, 1.0f, pitch);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            PossessedPaladinEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    public void GambitedSideAreaAttack(float range, float height, float arc, float boxOffset, float forwardOffset, float damage, int brokenShieldTicks, SoundEvent soundEvent, float pitch, boolean launch, float launchPower) {
        double theta = Math.toRadians(this.f_20883_) + 1.5707963267948966;
        double forwardX = Math.cos(theta) * (double)forwardOffset;
        double forwardZ = Math.sin(theta) * (double)forwardOffset;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityAttackingAngle;
            double dx = entityHit.m_20185_() - (this.m_20185_() + forwardX);
            double dz = entityHit.m_20189_() - (this.m_20189_() + forwardZ);
            float entityHitAngle = (float)((Math.toDegrees(Math.atan2(dz, dx)) - 90.0) % 360.0);
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if ((entityAttackingAngle = (this.f_20883_ - boxOffset) % 360.0f) < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityHitDistance = (float)Math.sqrt(dx * dx + dz * dz);
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof PossessedPaladinEntity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage + (double)MathUtils.entityBasedHpDamage(entityHit, 3.0f) * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
            if (flag) {
                this.hasHurt = true;
                if (launch) {
                    this.launch(entityHit, true);
                }
                if (this.getAttackState() == 5) {
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), this.getStunDuration(), 0));
                }
                this.applyStackingEffect(entityHit, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
                this.m_5496_(soundEvent, 1.0f, pitch);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            PossessedPaladinEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    private boolean spawnSoulPillars(double x, double y, double z, int lowestYCheck, float yRot, int warmupDelayTicks, Level world, LivingEntity player) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)world, blockpos1, Direction.UP)) continue;
            if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= lowestYCheck);
        if (flag) {
            world.m_7967_((Entity)new SoulPillarEntity(world, x, (double)blockpos.m_123342_() + d0, z, yRot, warmupDelayTicks, (LivingEntity)this, 20, 5.0f, this.getIsSecondPhase()));
            return true;
        }
        return false;
    }

    public void spawnSoulPillar(float vec, float offset, int amount) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        int standingOnY = Mth.m_14107_((double)this.m_20186_()) - 1;
        double headY = this.m_20186_() + 1.0;
        float yawRadians = (float)Math.toRadians(90.0f + this.m_146908_());
        for (int l = 0; l < amount; ++l) {
            double d2 = 1.25 * (double)(l + 1);
            int j = 1 * l;
            if (!this.spawnSoulPillars(this.m_20185_() + (double)vec * vecX + (double)(f * offset) + (double)Mth.m_14089_((float)yawRadians) * d2, headY, this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset) + (double)Mth.m_14031_((float)yawRadians) * d2, standingOnY, yawRadians, j, this.m_9236_(), (LivingEntity)this)) continue;
        }
    }

    public void randomizedSoulStrike(int firstRandomMin, int secondRandomMin, int amount) {
        int uCap = 5;
        int rX = this.random1.nextInt(-uCap, uCap);
        int rX2 = this.random1.nextInt(-uCap, uCap);
        int rZ = this.random1.nextInt(-uCap, uCap);
        int rZ2 = this.random1.nextInt(-uCap, uCap);
        Vec3 randomPos = new Vec3(this.m_20185_() + (double)rX, this.m_20186_(), this.m_20189_() + (double)rZ);
        Vec3 atanPos = new Vec3(randomPos.f_82479_ + (double)rX2, randomPos.f_82480_, randomPos.f_82481_ + (double)rZ2);
        double d0 = Math.min(this.m_20186_(), this.m_20186_());
        double d1 = Math.max(this.m_20186_(), this.m_20186_()) + 1.0;
        float f = (float)Mth.m_14136_((double)(atanPos.f_82481_ - randomPos.f_82481_), (double)(atanPos.f_82479_ - randomPos.f_82479_));
        for (int l = 0; l < amount; ++l) {
            double d2 = 1.25 * (double)(l + 1);
            int j = 1 * l + 10;
            this.spawnSoulPillars(randomPos.f_82479_ + (double)Mth.m_14089_((float)f) * d2, this.m_20186_(), randomPos.f_82481_ + (double)Mth.m_14031_((float)f) * d2, (int)d1, f, j, this.m_9236_(), (LivingEntity)this);
        }
    }

    private void SoulStrike(float vec, int quake, float math) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float angle = 360.0f / (float)quake;
        for (int i = 0; i < quake; ++i) {
            SoulStrike peq = new SoulStrike(this.m_9236_(), (LivingEntity)this, this.getPhase() >= 2);
            peq.setDamage(9.0f);
            peq.m_37251_((Entity)this, 0.0f, angle * (float)i, 0.0f, 0.45f, 0.0f);
            peq.m_6034_(this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + 0.3, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math));
            this.m_9236_().m_7967_((Entity)peq);
        }
    }

    private void throwPhantomDaggers(float v, float offset, int amount, float throwAngle, float additionalY) {
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        for (int i = 0; i < amount; ++i) {
            float angle = this.f_20883_ + ((float)i - (float)amount / 2.0f) * throwAngle;
            float rad = (float)Math.toRadians(angle);
            double dx = -Math.sin(rad);
            double dz = Math.cos(rad);
            if (this.m_5448_() == null) continue;
            float y = Mth.m_14107_((double)this.m_20186_());
            float m = (float)((double)this.m_5448_().m_21233_() * 0.01);
            ThrownPhantomDagger witherskull = new ThrownPhantomDagger((EntityType<? extends ThrownPhantomDagger>)((EntityType)ModEntities.THROWN_PHANTOM_DAGGER.get()), this.m_9236_());
            witherskull.m_5602_((Entity)this);
            witherskull.m_146922_(angle);
            double spawnX = this.m_20185_() + vecX * 1.0;
            double spawnY = this.m_20186_() + (double)(this.m_20206_() / 2.0f) + (double)additionalY;
            double spawnZ = this.m_20189_() + vecZ * 1.0;
            witherskull.m_6034_(spawnX, spawnY, spawnZ);
            witherskull.m_37251_((Entity)this, 0.0f, angle * (float)i, 0.0f, v, 0.0f);
            this.m_9236_().m_7967_((Entity)witherskull);
        }
    }

    private void SoulShockwave(float spreadarc, int distance, float vec, int delay, float pos, float offset) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta1 = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta1 += 1.5707963267948966);
        double vecZ = Math.sin(theta1);
        int floor = Mth.m_14107_((double)this.m_20186_());
        double x = this.m_20185_() + (double)pos * vecX + (double)(f * offset);
        double z = this.m_20189_() + (double)pos * vecZ + (double)(f1 * offset);
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = x + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = z + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            this.spawnSoulPillars((double)hitX + 0.5, 1.0, (double)hitZ + 0.5, (int)(this.m_20186_() - 5.0), (float)theta, delay, this.m_9236_(), (LivingEntity)this);
        }
    }

    public void throwDaggers(float velocity, double x, double y, double z, int daggerCount, float angleBetween, float elevationAngle, int returnTick) {
        if (this.targetIsNotNull()) {
            double dx = this.target().m_20185_() - x;
            double dz = this.target().m_20189_() - z;
            double dy = this.target().m_20186_() - y;
            Vec3 flatDir = new Vec3(dx, dy, dz).m_82541_();
            double elevRad = Math.toRadians(dy);
            double totalSpread = angleBetween * (float)(daggerCount - 1);
            double startYaw = -totalSpread * 0.5;
            for (int i = 0; i < daggerCount; ++i) {
                double yawOffset = startYaw + (double)((float)i * angleBetween);
                Vec3 dirYaw = MathUtils.rotateYaw(flatDir, yawOffset);
                double cosP = Math.cos(elevRad);
                double sinP = Math.sin(elevRad);
                Vec3 finalVec = new Vec3(dirYaw.f_82479_ * cosP, sinP, dirYaw.f_82481_ * cosP);
                ThrownPhantomDagger dagger = new ThrownPhantomDagger((EntityType<? extends ThrownPhantomDagger>)((EntityType)ModEntities.THROWN_PHANTOM_DAGGER.get()), this.m_9236_());
                dagger.m_20343_(x, y + (double)(this.m_20206_() / 2.0f), z);
                dagger.setReturnTick(returnTick);
                dagger.setDamage(5.0f);
                dagger.m_6686_(finalVec.f_82479_, finalVec.f_82480_, finalVec.f_82481_, velocity, 0.0f);
                dagger.m_5602_((Entity)this);
                dagger.setRed(this.getPhase() >= 2);
                this.m_9236_().m_7967_((Entity)dagger);
            }
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.65f),
        HIGH(0.3f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

