/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.goals;

import java.util.EnumSet;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class AmbushLongerGoal
extends Goal {
    protected final TheObliteratorEntity entity;
    private final int getattackstate;
    private final int attackstate;
    private final int attackendstate;
    private final int attackMaxtick;
    private final int attackseetick;
    private final float attackrange;

    public AmbushLongerGoal(TheObliteratorEntity entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        this.getattackstate = getattackstate;
        this.attackstate = attackstate;
        this.attackendstate = attackendstate;
        this.attackMaxtick = attackMaxtick;
        this.attackseetick = attackseetick;
        this.attackrange = attackrange;
    }

    public AmbushLongerGoal(TheObliteratorEntity entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, EnumSet<Goal.Flag> interruptFlagTypes) {
        this.entity = entity;
        this.m_7021_(interruptFlagTypes);
        this.getattackstate = getattackstate;
        this.attackstate = attackstate;
        this.attackendstate = attackendstate;
        this.attackMaxtick = attackMaxtick;
        this.attackseetick = attackseetick;
        this.attackrange = attackrange;
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.entity.getAttackDelayTicks() <= 0;
    }

    public void m_8056_() {
        this.entity.setAttackState(this.attackstate);
    }

    public void m_8041_() {
        this.entity.setAttackState(this.attackendstate);
        this.entity.attackCooldown = 0;
    }

    public boolean m_8045_() {
        return this.entity.attackTicks < this.attackMaxtick;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double radius;
        int totalPoints;
        LivingEntity target = this.entity.m_5448_();
        if (this.entity.attackTicks < this.attackseetick && target != null) {
            this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.entity.m_146922_(this.entity.f_19859_);
        }
        int attackTicks = this.entity.getAttackTicks();
        if (attackTicks >= 57 && attackTicks <= 58) {
            this.entity.saveTeleportPos(this.entity.m_5448_(), this.entity.targetIsNotNull(), 6.0f, 0.0f);
        }
        if (attackTicks == 75) {
            this.entity.m_21573_().m_26573_();
            this.entity.m_5496_(SoundEvents.f_11852_, 2.0f, 1.0f);
            if (this.entity.m_5448_() != null && !this.entity.m_9236_().f_46443_ && this.entity.m_9236_() instanceof ServerLevel) {
                this.entity.m_20331_(false);
                if (this.entity.targetIsNotNull()) {
                    this.entity.teleportRandomly(this.entity.m_5448_(), 10.0f, 10.0f);
                }
            }
        }
        if (attackTicks >= 29 && attackTicks <= 30) {
            this.entity.saveTeleportPos((LivingEntity)this.entity, this.entity.m_6084_(), -8.0f, 0.0f);
        }
        if (attackTicks == 29) {
            this.entity.teleport(this.entity.teleportX, this.entity.teleportY, this.entity.teleportZ);
        }
        if (attackTicks == 33) {
            totalPoints = 16;
            radius = 8.5;
            this.spawnRingWave(0, 2, totalPoints, radius);
        }
        if (this.entity.getPhase() >= 2 && attackTicks == 49) {
            totalPoints = 16;
            radius = 8.5;
            this.spawnRingWave(1, 2, totalPoints, radius);
        }
    }

    private void spawnRingWave(int waveIndex, int wavesTotal, int totalPoints, double radius) {
        LivingEntity target = this.entity.m_5448_();
        if (target == null) {
            return;
        }
        double step = Math.PI * 2 / (double)totalPoints;
        int pointsThisWave = totalPoints / wavesTotal;
        double base = -0.41887902047863906;
        double waveOffset = (double)waveIndex * step;
        for (int i = 0; i < pointsThisWave; ++i) {
            double angle = base + waveOffset + (double)i * ((double)wavesTotal * step);
            double spawnX = target.m_20185_() + Math.cos(angle) * radius;
            double spawnZ = target.m_20189_() + Math.sin(angle) * radius;
            double spawnY = Mth.m_14107_((double)this.entity.m_20186_());
            double headY = target.m_20186_() + 1.0;
            double dx = target.m_20185_() - spawnX;
            double dz = target.m_20189_() - spawnZ;
            float yawRad = (float)Math.atan2(dz, dx);
            this.entity.spawnDuplicateVersions(spawnX, spawnZ, spawnY, headY, yawRad, 4, (float)target.m_20185_(), (float)target.m_20186_(), (float)target.m_20189_());
        }
    }
}

