/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.goals;

import java.util.EnumSet;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class AmbushSwapGoal
extends Goal {
    protected final TheObliteratorEntity entity;
    private final int getattackstate;
    private final int attackstate;
    private final int attackendstate;
    private final int attackMaxtick;
    private final int attackseetick;
    private final float attackrange;

    public AmbushSwapGoal(TheObliteratorEntity entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        this.getattackstate = getattackstate;
        this.attackstate = attackstate;
        this.attackendstate = attackendstate;
        this.attackMaxtick = attackMaxtick;
        this.attackseetick = attackseetick;
        this.attackrange = attackrange;
    }

    public AmbushSwapGoal(TheObliteratorEntity entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, EnumSet<Goal.Flag> interruptFlagTypes) {
        this.entity = entity;
        this.m_7021_(interruptFlagTypes);
        this.getattackstate = getattackstate;
        this.attackstate = attackstate;
        this.attackendstate = attackendstate;
        this.attackMaxtick = attackMaxtick;
        this.attackseetick = attackseetick;
        this.attackrange = attackrange;
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.entity.getAttackDelayTicks() <= 0;
    }

    public void m_8056_() {
        this.entity.setAttackState(this.attackstate);
    }

    public void m_8041_() {
        this.entity.setAttackState(this.attackendstate);
        this.entity.attackCooldown = 0;
    }

    public boolean m_8045_() {
        return this.entity.attackTicks < this.attackMaxtick;
    }

    public void m_8037_() {
        int totalPoints;
        int clonesAmount;
        int bonusClones;
        int randomOffset;
        int tp1 = 32;
        int tp2 = 52;
        int tp3 = 74;
        int tp4 = 96;
        LivingEntity target = this.entity.m_5448_();
        if (this.entity.attackTicks < this.attackseetick && target != null) {
            this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.entity.m_146922_(this.entity.f_19859_);
        }
        int attackTicks = this.entity.getAttackTicks();
        if (attackTicks == tp1 - 2) {
            this.entity.saveTeleportPos((LivingEntity)this.entity, this.entity.m_6084_(), -8.0f, 0.0f);
        }
        if (attackTicks == tp1) {
            this.entity.m_20331_(true);
            this.entity.teleport(this.entity.teleportX, this.entity.teleportY, this.entity.teleportZ);
        }
        if (attackTicks == tp2 - 2) {
            this.entity.saveTeleportPos(this.entity.m_5448_(), this.entity.targetIsNotNull(), 6.0f, 0.0f);
        }
        if (attackTicks == tp2 && this.entity.m_5448_() != null) {
            this.entity.m_20331_(false);
            this.entity.teleportRandomly((LivingEntity)this.entity, 10.0f, 10.0f);
            this.entity.m_20242_(false);
        }
        if (attackTicks == tp3 - 2) {
            this.entity.saveTeleportPos((LivingEntity)this.entity, this.entity.m_6084_(), -8.0f, 0.0f);
        }
        if (attackTicks == 91) {
            // empty if block
        }
        if (attackTicks == tp3 && this.entity.m_5448_() != null) {
            this.entity.m_21573_().m_26573_();
            this.entity.m_20331_(true);
            this.entity.teleport(this.entity.teleportX, this.entity.teleportY, this.entity.teleportZ);
        }
        if (attackTicks == tp4 - 2) {
            this.entity.saveTeleportPos(this.entity.target(), this.entity.targetIsNotNull(), -6.0f, 0.0f);
        }
        if (attackTicks == 100) {
            // empty if block
        }
        if (attackTicks == tp4) {
            this.entity.m_21573_().m_26573_();
            if (this.entity.m_5448_() != null) {
                this.entity.m_20331_(false);
                this.entity.teleport(this.entity.teleportX, this.entity.teleportY, this.entity.teleportZ);
                this.entity.m_20242_(false);
            }
        }
        if (attackTicks == 31) {
            // empty if block
        }
        if (attackTicks == 32 && this.entity.m_5448_() != null) {
            randomOffset = this.entity.m_217043_().m_188503_(3);
            bonusClones = this.entity.m_217043_().m_188503_(2);
            clonesAmount = 10 + bonusClones;
            for (int k = 0; k < clonesAmount; ++k) {
                float angleOnCircle = (float)k * (float)Math.PI * -2.0f / 8.0f + (float)randomOffset + -0.41887903f;
                double spawnX = this.entity.m_5448_().m_20185_() + Math.cos(angleOnCircle) * 8.5;
                double spawnZ = this.entity.m_5448_().m_20189_() + Math.sin(angleOnCircle) * 8.5;
                int standingOnY = Mth.m_14107_((double)this.entity.m_20186_());
                float targetY = (float)(this.entity.target().m_20186_() + (double)this.entity.target().m_20206_() * 0.3333333333333333);
                double spawnY = standingOnY;
                double headY = this.entity.m_5448_().m_20186_() + 1.0;
                double dx = this.entity.m_5448_().m_20185_() - spawnX;
                double dz = this.entity.m_5448_().m_20189_() - spawnZ;
                float yawRad = (float)Math.atan2(dz, dx);
                this.entity.spawnDuplicateVersions(spawnX, spawnZ, spawnY, headY, yawRad, 4, (float)this.entity.m_5448_().m_20185_(), (float)this.entity.m_5448_().m_20186_(), (float)this.entity.m_5448_().m_20189_());
            }
        }
        if (attackTicks == tp3 + 2) {
            totalPoints = 16;
            double radius = 8.5;
            this.spawnRingWave(0, 2, totalPoints, radius);
        }
        if (attackTicks == tp3 + 18) {
            totalPoints = 16;
            double radius = 8.5;
            this.spawnRingWave(1, 2, totalPoints, radius);
        }
        if (attackTicks == 65) {
            this.entity.m_20331_(false);
            this.entity.m_20242_(false);
        }
        if (attackTicks == 92) {
            // empty if block
        }
        if (attackTicks == tp3 + 2 && this.entity.m_5448_() != null) {
            randomOffset = this.entity.m_217043_().m_188503_(3);
            bonusClones = this.entity.m_217043_().m_188503_(2);
            clonesAmount = 7 + bonusClones;
            double Cx = this.entity.m_5448_().m_20185_();
            double Cz = this.entity.m_5448_().m_20189_();
            double baseR = 8.5;
            double scale = 1.25;
            double R = baseR * scale;
            double x1 = Cx + R;
            double z1 = Cz;
            double x2 = Cx + R * -0.5;
            double z2 = Cz + R * Math.sqrt(3.0) / 2.0;
            double x3 = Cx + R * -0.5;
            double z3 = Cz - R * Math.sqrt(3.0) / 2.0;
            double side = R * Math.sqrt(3.0);
            double perimeter = 3.0 * side;
            int standingOnY = Mth.m_14107_((double)this.entity.m_20186_());
            double spawnY = standingOnY;
            double headY = this.entity.m_5448_().m_20186_() + 1.0;
            float destX = (float)Cx;
            float destY = (float)this.entity.m_5448_().m_20186_();
            float destZ = (float)Cz;
            for (int k = 0; k < clonesAmount; ++k) {
                double spawnX;
                double d = ((double)k + (double)randomOffset * 0.1) * (perimeter / (double)clonesAmount);
                int edgeIndex = (int)Math.floor(d / side);
                if (edgeIndex >= 3) {
                    edgeIndex = 2;
                }
                double distAlongEdge = d - (double)edgeIndex * side;
                double t = distAlongEdge / side;
                double spawnZ = switch (edgeIndex) {
                    case 0 -> {
                        spawnX = x1 + t * (x2 - x1);
                        yield z1 + t * (z2 - z1);
                    }
                    case 1 -> {
                        spawnX = x2 + t * (x3 - x2);
                        yield z2 + t * (z3 - z2);
                    }
                    default -> {
                        spawnX = x3 + t * (x1 - x3);
                        yield z3 + t * (z1 - z3);
                    }
                };
                double dx = Cx - spawnX;
                double dz = Cz - spawnZ;
                float f = (float)Math.atan2(dz, dx);
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private void spawnRingWave(int waveIndex, int wavesTotal, int totalPoints, double radius) {
        LivingEntity target = this.entity.m_5448_();
        if (target == null) {
            return;
        }
        double step = Math.PI * 2 / (double)totalPoints;
        int pointsThisWave = totalPoints / wavesTotal;
        double base = -0.41887902047863906;
        double waveOffset = (double)waveIndex * step;
        for (int i = 0; i < pointsThisWave; ++i) {
            double angle = base + waveOffset + (double)i * ((double)wavesTotal * step);
            double spawnX = target.m_20185_() + Math.cos(angle) * radius;
            double spawnZ = target.m_20189_() + Math.sin(angle) * radius;
            double spawnY = Mth.m_14107_((double)this.entity.m_20186_());
            double headY = target.m_20186_() + 1.0;
            double dx = target.m_20185_() - spawnX;
            double dz = target.m_20189_() - spawnZ;
            float yawRad = (float)Math.atan2(dz, dx);
            this.entity.spawnDuplicateVersions(spawnX, spawnZ, spawnY, headY, yawRad, 4, (float)target.m_20185_(), (float)target.m_20186_(), (float)target.m_20189_());
        }
    }
}

