/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AbandonedCrypt;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AbandonedCrypt.HauntedGuardEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AbandonedCrypt.HauntedKnightEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Lava_eaterEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ShockwaveSpawner;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.SoulStrike;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.tag.ModEntityTags;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PosessedPaladinEntity
extends IAnimatedMonster {
    private int attackAnimationTick = 0;
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(PosessedPaladinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(PosessedPaladinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SECOND_PHASE = SynchedEntityData.m_135353_(PosessedPaladinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> Tr = SynchedEntityData.m_135353_(PosessedPaladinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int STUN_COOLDOWN_DURATION = 200;
    private int stunCooldown = 0;
    private boolean hasPlayedHurtSound = false;
    public int gcool = 0;
    public boolean hasUsedSwordSmash = false;
    public int pcool = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState slashAnimationState = new AnimationState();
    public AnimationState midSlashAnimationState = new AnimationState();
    public AnimationState comboAnimationState = new AnimationState();
    public AnimationState combo1AnimationState = new AnimationState();
    public AnimationState combo3AnimationState = new AnimationState();
    public AnimationState combo7AnimationState = new AnimationState();
    public AnimationState combo8AnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();
    public AnimationState dmgAnimationState = new AnimationState();
    public AnimationState postRunAnimationState = new AnimationState();
    public AnimationState c10AnimationState = new AnimationState();
    public AnimationState c9AnimationState = new AnimationState();
    public AnimationState prerununAnimationState = new AnimationState();
    public int attackLock = 0;
    private boolean tr = false;
    public int tcooldown = 160;
    public int pcooldown = 0;
    private boolean seeing = false;
    private int teleportCooldown = 0;
    private int smashCooldown = 0;
    private final int SMASH_COOLDOWN = 160;
    public int bigsmashCooldown = 0;
    public final int SMASH_ANCHOR_COOLDOWN = 160;
    public final int SMASH_ANCHOR2_COOLDOWN = 100;
    public int bigsmash2Cooldown = 0;
    public int dragonDeathTime;

    public void resetAttackAnimationTick() {
        this.attackAnimationTick = 0;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean isSecondPhase() {
        return (Boolean)this.f_19804_.m_135370_(IS_SECOND_PHASE);
    }

    public void setSecondPhase(boolean phase) {
        this.f_19804_.m_135381_(IS_SECOND_PHASE, (Object)phase);
    }

    public PosessedPaladinEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public int AttackReady() {
        this.attackAnimationTick = 5;
        return 5;
    }

    public boolean canStun() {
        return this.stunCooldown <= 0;
    }

    public boolean h() {
        return this.f_19804_.m_135370_(ATTACKING) == Boolean.TRUE;
    }

    public boolean k() {
        return this.tr == Boolean.TRUE;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    public void attackTargets(Entity entity1) {
        LivingEntity livingEntity;
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 14.0 * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get();
        if (entity1 instanceof LivingEntity && ((livingEntity = (LivingEntity)entity1) instanceof Player || livingEntity instanceof ServerPlayer)) {
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 5.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 13.0));
            }
        }
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    private void sendActionBarMessageToPlayer(Player player, String message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)message)));
        }
    }

    public void resetSmashAnchorCooldown() {
        if (this.bigsmashCooldown <= 0) {
            this.bigsmashCooldown = 160;
        }
    }

    public void resetSmash2Cooldown() {
        if (this.bigsmash2Cooldown <= 0) {
            this.bigsmash2Cooldown = 100;
        }
    }

    public void resetSmashCooldown() {
        if (this.smashCooldown <= 0) {
            this.smashCooldown = 160;
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        Crackiness crackiness = this.getCrackiness();
        if (!(this.getAttackState() != 0 || crackiness != Crackiness.MEDIUM && crackiness != Crackiness.HIGH || this.isSecondPhase())) {
            this.setAttackState(15);
        }
        if (this.gcool > 0) {
            --this.gcool;
        }
        if (this.pcool > 0) {
            --this.pcool;
        }
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.pcooldown > 0) {
            --this.pcooldown;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.bigsmashCooldown > 0) {
            --this.bigsmashCooldown;
        }
        if (this.bigsmash2Cooldown > 0) {
            --this.bigsmash2Cooldown;
        }
        if (this.tcooldown > 0) {
            --this.tcooldown;
        }
        if (this.stunCooldown == 0 && (livingEntity = this.m_5448_()) instanceof Player) {
            Player player = (Player)livingEntity;
        }
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
        if ((livingEntity = this.m_5448_()) instanceof Player) {
            Player pPlayer = (Player)livingEntity;
            if (this.m_5448_() != null && this.stunCooldown != 0) {
                this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)0);
            }
        }
        if (this.stunCooldown > 0) {
            --this.stunCooldown;
        }
        if (crackiness == Crackiness.MEDIUM && !this.hasPlayedHurtSound) {
            this.hasPlayedHurtSound = true;
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @Nullable SpawnGroupData p_29681_, @Nullable CompoundTag p_29682_) {
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "slash") {
            return this.slashAnimationState;
        }
        if (input == "midslash") {
            return this.midSlashAnimationState;
        }
        if (input == "combo") {
            return this.comboAnimationState;
        }
        if (input == "combo1") {
            return this.combo1AnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "combo3") {
            return this.combo3AnimationState;
        }
        if (input == "combo8") {
            return this.combo8AnimationState;
        }
        if (input == "combo7") {
            return this.combo7AnimationState;
        }
        if (input == "run") {
            return this.runAnimationState;
        }
        if (input == "damage") {
            return this.dmgAnimationState;
        }
        if (input == "postrun") {
            return this.postRunAnimationState;
        }
        if (input == "runpre") {
            return this.prerununAnimationState;
        }
        if (input == "c9") {
            return this.c9AnimationState;
        }
        if (input == "c10") {
            return this.c10AnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.slashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.midSlashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.comboAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.combo1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 19: {
                    this.stopAllAnimationStates();
                    this.combo7AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 20: {
                    this.stopAllAnimationStates();
                    this.combo8AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.combo3AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 18: {
                    this.stopAllAnimationStates();
                    this.postRunAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 17: {
                    this.stopAllAnimationStates();
                    this.runAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 15: {
                    this.stopAllAnimationStates();
                    this.dmgAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 16: {
                    this.stopAllAnimationStates();
                    this.prerununAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 21: {
                    this.stopAllAnimationStates();
                    this.c9AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 22: {
                    this.stopAllAnimationStates();
                    this.c10AnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.comboAnimationState.m_216973_();
        this.combo1AnimationState.m_216973_();
        this.slashAnimationState.m_216973_();
        this.midSlashAnimationState.m_216973_();
        this.combo3AnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.c10AnimationState.m_216973_();
        this.c9AnimationState.m_216973_();
        this.combo7AnimationState.m_216973_();
        this.combo8AnimationState.m_216973_();
        this.prerununAnimationState.m_216973_();
        this.postRunAnimationState.m_216973_();
        this.runAnimationState.m_216973_();
        this.dmgAnimationState.m_216973_();
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SECOND_PHASE, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Lava_eaterEntity.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 43, 10, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 45.0f < 16.0f && PosessedPaladinEntity.this.bigsmashCooldown <= 0 && PosessedPaladinEntity.this.pcooldown > 0 && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 6 && !PosessedPaladinEntity.this.h() && PosessedPaladinEntity.this.getAttackState() != 19 && PosessedPaladinEntity.this.attackLock == 0 && PosessedPaladinEntity.this.getAttackState() != 20;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.resetSmashAnchorCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 40, 10, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 25.0f < 16.0f && PosessedPaladinEntity.this.bigsmash2Cooldown <= 0 && PosessedPaladinEntity.this.pcooldown > 0 && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 9 && PosessedPaladinEntity.this.attackLock == 0 && !PosessedPaladinEntity.this.h();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.resetSmash2Cooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 9, 0, 83, 15, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && PosessedPaladinEntity.this.gcool <= 0 && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 20 && PosessedPaladinEntity.this.getAttackState() != 5 && PosessedPaladinEntity.this.attackLock == 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.gcool = PosessedPaladinEntity.this.h() ? 120 : 120;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 19, 0, 69, 15, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 50.0f < 16.0f && PosessedPaladinEntity.this.pcooldown <= 0 && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 9 && PosessedPaladinEntity.this.attackLock == 0 && !PosessedPaladinEntity.this.h();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.pcooldown = 60;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 22, 0, 77, 55, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 60.0f < 16.0f && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 9 && PosessedPaladinEntity.this.attackLock == 0 && PosessedPaladinEntity.this.h();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 20, 0, 89, 15, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 9 && PosessedPaladinEntity.this.attackLock == 0 && PosessedPaladinEntity.this.h();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.pcooldown = 60;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 15, 15, 0, 55, 0){

            @Override
            public void m_8056_() {
                PosessedPaladinEntity.this.setSecondPhase(true);
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !PosessedPaladinEntity.this.isSecondPhase();
            }

            @Override
            public void m_8041_() {
                PosessedPaladinEntity.this.hasUsedSwordSmash = true;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 46, 15, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && PosessedPaladinEntity.this.smashCooldown <= 0 && PosessedPaladinEntity.this.m_5448_() != null && PosessedPaladinEntity.this.getAttackState() != 5 && PosessedPaladinEntity.this.getAttackState() != 19 && PosessedPaladinEntity.this.getAttackState() != 20 && PosessedPaladinEntity.this.attackLock == 0 && !PosessedPaladinEntity.this.h() && PosessedPaladinEntity.this.pcooldown > 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.resetSmashCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 40, 75, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.attackLock == 0 && PosessedPaladinEntity.this.getAttackState() != 9 && PosessedPaladinEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && !PosessedPaladinEntity.this.h();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 46, 30, 5.5f){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 20.0f < 9.0f && PosessedPaladinEntity.this.teleportCooldown <= 0 && PosessedPaladinEntity.this.getAttackState() != 9 && PosessedPaladinEntity.this.attackLock == 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.m_20331_(false);
                PosessedPaladinEntity.this.teleportCooldown = 60;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 16, 17, 20, 10, 15.0f, 2.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.m_217043_().m_188501_() * 100.0f < 9.0f && PosessedPaladinEntity.this.tcooldown <= 0 && PosessedPaladinEntity.this.attackLock == 0;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 17, 17, 18, 30, 0){

            @Override
            public void m_8037_() {
                if (this.entity.m_20096_()) {
                    Vec3 vector3d = this.entity.m_20184_();
                    float f = this.entity.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.entity.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(0.45).m_82549_(vector3d.m_82490_(0.6));
                    this.entity.m_20334_(vector3d1.f_82479_, this.entity.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 17, 18, 0, 75, 40, 5.0f){

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.tcooldown = 160;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 18, 18, 0, 75, 40){

            @Override
            public void m_8041_() {
                super.m_8041_();
                PosessedPaladinEntity.this.tcooldown = 160;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 20, 0, 15.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && PosessedPaladinEntity.this.getAttackState() != 9;
            }
        });
    }

    private void Sphereparticle(float height, float vec, float size) {
        block8: {
            block7: {
                if (this.m_9236_().f_46443_) break block7;
                if (this.f_19797_ % 2 != 0) break block8;
                double d0 = this.m_20185_();
                double d1 = this.m_20186_() + (double)height;
                double d2 = this.m_20189_();
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                for (float i = -size; i <= size; i += 1.0f) {
                    for (float j = -size; j <= size; j += 1.0f) {
                        for (float k = -size; k <= size; k += 1.0f) {
                            double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.m_188583_() * 0.05;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                            if (i == -size || i == size || j == -size || j == size) continue;
                            k += size * 2.0f - 1.0f;
                        }
                    }
                }
                break block8;
            }
            if (this.f_19797_ % 2 == 0) {
                double d0 = this.m_20185_();
                double d1 = this.m_20186_() + (double)height;
                double d2 = this.m_20189_();
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                for (float i = -size; i <= size; i += 1.0f) {
                    for (float j = -size; j <= size; j += 1.0f) {
                        for (float k = -size; k <= size; k += 1.0f) {
                            double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.m_188583_() * 0.05;
                            SimpleParticleType type = ParticleTypes.f_123744_;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                            if (i == -size || i == size || j == -size || j == size) continue;
                            k += size * 2.0f - 1.0f;
                        }
                    }
                }
            }
        }
    }

    public void performAreaAttack() {
        double attackRadius = 4.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof HauntedGuardEntity || entity instanceof HauntedKnightEntity || entity instanceof CameraShakeEntity) continue;
            this.m_7327_((Entity)livingEntity);
        }
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_6095_().m_204039_(ModEntityTags.POSSESSED_ARMOR_TEAM) || super.m_7307_(pEntity);
    }

    public boolean m_5825_() {
        return this.getTextureVariant() == 1 || this.isAttacking();
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        this.updateWithAttack();
        if ((Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT) == 1) {
            this.Sphereparticle(0.35f, 2.0f, 3.0f);
        }
        if (this.getAttackState() == 15) {
            // empty if block
        }
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null && movementSpeedAttribute.m_22135_() != 0.1) {
                movementSpeedAttribute.m_22100_(0.1);
            }
        } else {
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null && movementSpeedAttribute.m_22135_() != 0.0) {
                movementSpeedAttribute.m_22100_(0.0);
            }
        }
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 170.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22281_, 16.0);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.LIVING_ARMOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.dragonDeathTime = 0;
        this.setAttackState(8);
        Vec3 entityPosition = this.m_20182_();
        CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.025f, 140, 20);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.PosessedPaladinHealthMultiplier.get());
        this.attackLock = 0;
        this.m_21530_();
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.seeing = true;
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.seeing = false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Sleep", this.isSleep());
        compound.m_128379_("phase", this.isSecondPhase());
        compound.m_128405_("TextureVariant", this.getTextureVariant());
        compound.m_128405_("StunCooldown", this.stunCooldown);
        compound.m_128379_("Attacking", this.h());
        compound.m_128379_("Tr", this.k());
        compound.m_128405_("AttackLock", this.attackLock);
        compound.m_128379_("usedSmash", this.hasUsedSwordSmash);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.attackLock = compound.m_128451_("AttackLock");
        this.tr = compound.m_128471_("Tr");
        this.f_19804_.m_135381_(ATTACKING, (Object)compound.m_128471_("Attacking"));
        this.setSleep(compound.m_128471_("is_Sleep"));
        this.hasUsedSwordSmash = compound.m_128471_("usedSmash");
        this.stunCooldown = compound.m_128451_("StunCooldown");
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)compound.m_128451_("TextureVariant"));
        this.f_19804_.m_135381_(IS_SECOND_PHASE, (Object)compound.m_128471_("phase"));
        if (this.m_21223_() == this.m_21233_()) {
            // empty if block
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAttackState() == 15 || this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Posessedprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 140 && this.dragonDeathTime <= 160) {
            float f = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        int i = 500;
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && flag) {
                int f2 = Mth.m_14143_((float)((float)i * 0.08f));
            }
            if (this.dragonDeathTime != 1 || !this.m_20067_()) {
                // empty if block
            }
        }
        if (this.dragonDeathTime == 140) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 20, 20);
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        if (this.dragonDeathTime == 160 && this.m_9236_() instanceof ServerLevel) {
            if (flag) {
                ItemStack diamond = new ItemStack((ItemLike)ModItems.CORRUPTED_SOUL.get(), 1);
                ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
                int n = Mth.m_14143_((float)((float)i * 0.2f));
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    private void launchMini(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 0.001);
        float multiplier = huge ? 1.2f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.3 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            MobEffectInstance brokenArmorEffect;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof PosessedPaladinEntity || entityHit instanceof HauntedGuardEntity || entityHit instanceof HauntedKnightEntity || entityHit == this) continue;
            if (!stun) {
                // empty if block
            }
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.PosessedPaladinDamageMutliplier.get()));
            if ((this.getAttackState() == 4 || this.getAttackState() == 3) && this.attackTicks == 20) {
                if (BNknockback && !entityHit.m_21254_()) {
                    double knockbackRadius = 5.0;
                    double dx = entityHit.m_20185_() - this.m_20185_();
                    double dz = entityHit.m_20189_() - this.m_20189_();
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    double knockbackStrength = (double)knockback + 0.5 * (knockbackRadius - distance);
                    entityHit.m_5997_(dx / distance * knockbackStrength, 0.4, dz / distance * knockbackStrength);
                }
                Vec3 entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
            }
            Crackiness crackiness = this.getCrackiness();
            if (!entityHit.m_21254_() && Math.random() > 0.5 && this.h()) {
                entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), 60, 0));
            }
            if (launch) {
                if (this.getAttackState() == 6 || this.getAttackState() == 7) {
                    this.launch(entityHit, true);
                }
                if (this.getAttackState() == 4) {
                    this.launchMini(entityHit, true);
                }
                if (this.getAttackState() == 9 && this.attackTicks == 60 && !entityHit.m_21254_()) {
                    brokenArmorEffect = entityHit.m_21124_((MobEffect)ModEffects.BROKEN_ARMOR.get());
                    if (brokenArmorEffect != null) {
                        int currentLevel = brokenArmorEffect.m_19564_();
                        if (currentLevel < 6) {
                            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, currentLevel + 3));
                        } else {
                            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 4));
                        }
                    } else {
                        entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 0));
                    }
                }
            }
            if ((this.getAttackState() != 9 || this.getAttackState() != 15) && Math.random() > 0.5 && !entityHit.m_21254_()) {
                brokenArmorEffect = entityHit.m_21124_((MobEffect)ModEffects.BROKEN_ARMOR.get());
                if (brokenArmorEffect != null) {
                    int currentLevel = brokenArmorEffect.m_19564_();
                    if (currentLevel < 6) {
                        entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, currentLevel + 1));
                    } else {
                        entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 6));
                    }
                } else {
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 0));
                }
            }
            if (this.getAttackState() == 9 || this.getAttackState() == 15) {
                if (this.attackTicks == 60 && this.getAttackState() == 9 && !entityHit.m_21254_()) {
                    brokenArmorEffect = entityHit.m_21124_((MobEffect)ModEffects.BROKEN_ARMOR.get());
                    if (brokenArmorEffect != null) {
                        int currentLevel = brokenArmorEffect.m_19564_();
                        if (currentLevel < 6) {
                            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, currentLevel + 3));
                        } else {
                            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 6));
                        }
                    } else {
                        entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 0));
                    }
                }
                if (this.getAttackState() == 15 && !entityHit.m_21254_()) {
                    brokenArmorEffect = entityHit.m_21124_((MobEffect)ModEffects.BROKEN_ARMOR.get());
                    if (brokenArmorEffect != null) {
                        int currentLevel = brokenArmorEffect.m_19564_();
                        if (currentLevel < 6) {
                            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, currentLevel + 3));
                        } else {
                            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 6));
                        }
                    } else {
                        entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BROKEN_ARMOR.get(), 60, 0));
                    }
                }
            }
            if (launch) {
                this.launch(entityHit, true);
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            PosessedPaladinEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    private void dash(float a1, float a2, float minD) {
        if (this.m_20096_()) {
            LivingEntity target = this.m_5448_();
            if (this.m_5448_() != null) {
                assert (target != null);
                double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget > (double)minD) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_((double)a1).m_82549_(vector3d.m_82490_((double)a2));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        }
    }

    public void updateWithAttack() {
        int a;
        LivingEntity t;
        int standingOnY;
        if (this.getAttackState() == 15) {
            if (this.attackTicks == 30) {
                this.Sphereparticle(0.75f, 2.0f, 6.0f);
                this.m_5496_(SoundEvents.f_12513_, 2.0f, 0.75f);
                this.spawnCircleParticle(1.5f, 0.0f, 15.0f, true, 1.5f, 1.0f, 1.0f, 1.0f, 1.0f);
                this.setAttacking(true);
                this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)1);
                this.tr = true;
                standingOnY = Mth.m_14107_((double)this.m_20186_());
                this.attackLock = 0;
                t = this.m_5448_();
                if (t != null) {
                    a = (int)((double)t.m_21233_() * 0.05);
                    this.EarthQuakeSummon(0.0f, 15, 1.5f);
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 20.0f + (float)a, 100, false, 0.5f, false, 0.25f, true);
                } else {
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 20.0f, 100, false, 0.5f, false, 0.25f, true);
                }
            }
            if (this.attackTicks == 40) {
                this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)0);
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 10) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 12) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 14) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 0, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 10) {
                // empty if block
            }
            if (this.attackTicks == 12) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 14) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 14.0f, 40, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 10) {
                // empty if block
            }
            if (this.attackTicks == 12) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 14) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 20, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 21) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 26) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 32) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 12.0f, 20, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 4) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 11) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 20, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 18) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 23) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 40, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 21) {
            if (this.attackTicks == 10) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 12) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 16) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 0, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 27) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 28) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 31) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 20, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 39) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 41) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 44) {
                this.AreaAttack(5.5f, 5.0f, 360.0f, 14.0f, 20, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 22) {
            if (this.attackTicks == 15) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 17) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 19) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 0, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 30) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 32) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 34) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 20, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 49) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 50) {
                this.m_5496_((SoundEvent)ModSounds.WEAPON_SPIN.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 53) {
                this.AreaAttack(5.5f, 5.0f, 360.0f, 14.0f, 20, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 19) {
            if (this.attackTicks == 4) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 11) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 0, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 18) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 23) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 20, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 39) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 43) {
                this.m_5496_((SoundEvent)ModSounds.WEAPON_SPIN.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 47) {
                this.AreaAttack(5.5f, 5.0f, 360.0f, 14.0f, 20, false, 0.5f, true, 0.25f, false);
            }
        }
        if (this.getAttackState() == 20) {
            if (this.attackTicks == 4) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 11) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 0, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 18) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 23) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 20, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 39) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 43) {
                this.m_5496_((SoundEvent)ModSounds.WEAPON_SPIN.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 47) {
                this.AreaAttack(5.5f, 5.0f, 360.0f, 14.0f, 40, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 73) {
                this.m_5496_(SoundEvents.f_12513_, 2.0f, 0.7f);
                LivingEntity t2 = this.m_5448_();
                if (t2 != null) {
                    int a2 = (int)((double)t2.m_21233_() * 0.02);
                    this.EarthQuakeSummon(0.0f, 15, 1.5f);
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 17.0f + (float)a2, 40, false, 0.5f, false, 0.25f, true);
                } else {
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 17.0f, 40, false, 0.5f, false, 0.25f, true);
                }
            }
        }
        if (this.getAttackState() == 9) {
            if (this.attackTicks == 8) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 13) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 14) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 12.0f, 40, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 23) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 25) {
                this.m_5496_((SoundEvent)ModSounds.WEAPON_SPIN.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 30) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 40, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 35) {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    if (distanceToTarget > 9.0 && this.h()) {
                        this.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
                        Vec3 vec3 = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
                        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_ * 0.9, 1.0, vec3.f_82481_ * 0.9));
                    }
                } else {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0, 0.0));
                }
            }
            if (this.attackTicks == 60) {
                this.m_5496_(SoundEvents.f_12513_, 2.0f, 0.7f);
                this.spawnCircleParticle(1.5f, 0.0f, 15.0f, true, 1.5f, 1.0f, 1.0f, 1.0f, 1.0f);
                standingOnY = Mth.m_14107_((double)this.m_20186_());
                this.spawnIceSpikesAdvanced(this.m_20185_(), this.m_20189_(), standingOnY, this.m_20186_(), 0.0f, 0);
                t = this.m_5448_();
                if (t != null) {
                    a = (int)((double)t.m_21233_() * 0.02);
                    this.EarthQuakeSummon(0.0f, 15, 1.5f);
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 17.0f + (float)a, 40, false, 0.5f, false, 0.25f, true);
                } else {
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 17.0f, 40, false, 0.5f, false, 0.25f, true);
                }
            }
            if (this.attackTicks == 64) {
                // empty if block
            }
        }
        if (this.getAttackState() == 18) {
            if (this.attackTicks == 5) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.PP_SWING.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 10) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 12.0f, 40, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 19) {
                this.dash(0.9f, 0.6f, 4.0f);
            }
            if (this.attackTicks == 22) {
                this.m_5496_((SoundEvent)ModSounds.WEAPON_SPIN.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(5.5f, 5.0f, 180.0f, 13.0f, 40, false, 0.5f, true, 0.25f, false);
            }
            if (this.attackTicks == 20) {
                // empty if block
            }
            if (this.attackTicks == 57) {
                this.m_5496_(SoundEvents.f_12513_, 2.0f, 0.7f);
                this.spawnCircleParticle(1.5f, 0.0f, 15.0f, true, 1.5f, 1.0f, 1.0f, 1.0f, 1.0f);
                standingOnY = Mth.m_14107_((double)this.m_20186_());
                this.spawnIceSpikesAdvanced(this.m_20185_(), this.m_20189_(), standingOnY, this.m_20186_(), 0.0f, 0);
                if (this.h()) {
                    // empty if block
                }
                if ((t = this.m_5448_()) != null) {
                    a = (int)((double)t.m_21233_() * 0.02);
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 17.0f + (float)a, 40, false, 0.5f, false, 0.25f, true);
                } else {
                    this.AreaAttack(6.5f, 5.0f, 360.0f, 17.0f, 40, false, 0.5f, false, 0.25f, true);
                }
            }
            if (this.attackTicks == 64) {
                // empty if block
            }
        }
    }

    private void spawnIceSpikesAdvanced(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            PosessedPaladinEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new ShockwaveSpawner(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)this, false));
        }
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    private void EarthQuakeSummon(float vec, int quake, float math) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float angle = 360.0f / (float)quake;
        for (int i = 0; i < quake; ++i) {
            SoulStrike peq = new SoulStrike(this.m_9236_(), (LivingEntity)this, false);
            peq.setDamage(9.0f);
            peq.m_37251_((Entity)this, 0.0f, angle * (float)i, 0.0f, 0.45f, 0.0f);
            peq.m_6034_(this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + 0.3, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math));
            this.m_9236_().m_7967_((Entity)peq);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

