/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AncientStronghold;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.CloudGolem.Cloud_GolemEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ShockwaveSpawner;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class Ancient_GuardianEntity
extends IAnimatedMonster {
    private static final EntityDataAccessor<Boolean> GRABBING = SynchedEntityData.m_135353_(Ancient_GuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PARTICLE_TICKS = SynchedEntityData.m_135353_(Ancient_GuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int stunCooldown = 0;
    private int smashCooldown = 0;
    private final int SMASH_COOLDOWN = 100;
    private int smashAnchorCooldown = 0;
    private final int SMASH_ANCHOR_COOLDOWN = 60;
    private boolean isScary;
    private boolean hasPlayerHurtSound;
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(Ancient_GuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ROAR = SynchedEntityData.m_135353_(Ancient_GuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState attackarm1AnimationState = new AnimationState();
    public AnimationState attackarm2AnimationState = new AnimationState();
    public AnimationState attackarmsAnimationState = new AnimationState();
    public AnimationState attackstunAnimationState = new AnimationState();
    public AnimationState attackComboAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState grabAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();
    public AnimationState runpreAnimationState = new AnimationState();
    public AnimationState postRunAnimationState = new AnimationState();
    int k;
    public int guardianDeathTime;

    public Ancient_GuardianEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21530_();
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public boolean canStun() {
        return this.stunCooldown <= 0;
    }

    private void sendActionBarMessageToPlayer(Player player, String message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)message)));
        }
    }

    public void resetSmashCooldown() {
        if (this.smashCooldown <= 0) {
            this.smashCooldown = 100;
        }
    }

    public void resetSmashAnchorCooldown() {
        if (this.smashAnchorCooldown <= 0) {
            this.smashAnchorCooldown = 60;
        }
    }

    @Override
    public void m_8119_() {
        if ((Integer)this.f_19804_.m_135370_(PARTICLE_TICKS) >= 0) {
            this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)((Integer)this.f_19804_.m_135370_(PARTICLE_TICKS) + 1));
        }
        if (this.getAttackState() != 7) {
            this.m_20331_(false);
        }
        if (this.getCrackiness() == Crackiness.MEDIUM && !this.getRoar()) {
            this.f_19804_.m_135381_(ROAR, (Object)true);
        }
        Vec3 b = new Vec3(this.m_20185_(), (double)this.k, this.m_20189_());
        if (this.getAttackState() == 8) {
            // empty if block
        }
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.stunCooldown > 0) {
            --this.stunCooldown;
        }
        if (this.smashAnchorCooldown > 0) {
            --this.smashAnchorCooldown;
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.getAttackState() == 0, this.f_19797_);
        }
        if ((this.getCrackiness() == Crackiness.MEDIUM || this.getCrackiness() == Crackiness.HIGH) && this.m_21051_(Attributes.f_22284_).m_22115_() == 13.0) {
            this.m_21051_(Attributes.f_22284_).m_22100_(20.0);
        }
        this.UpdateWithAttack();
        super.m_8119_();
        LivingEntity livingEntity = this.m_5448_();
        if (livingEntity instanceof Player) {
            Player pPlayer = (Player)livingEntity;
            if (this.m_5448_() != null) {
                if (this.stunCooldown == 0) {
                    this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)1);
                } else {
                    this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)0);
                }
            }
        }
        if (this.stunCooldown > 0) {
            --this.stunCooldown;
        }
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Attacking", this.isAttacking());
        compound.m_128379_("is_Sleep", this.isSleep());
        compound.m_128405_("TextureVariant", this.getTextureVariant());
        compound.m_128405_("StunCooldown", this.stunCooldown);
        compound.m_128379_("roar", this.getRoar());
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(GRABBING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(GRABBING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARTICLE_TICKS, (Object)0);
        this.f_19804_.m_135372_(GRABBING, (Object)false);
        this.f_19804_.m_135372_(ROAR, (Object)false);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Cloud_GolemEntity.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 15, 16, 20, 10, 6.5f, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Ancient_GuardianEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Ancient_GuardianEntity.this.stunCooldown <= 0 && Ancient_GuardianEntity.this.m_5448_() != null && Ancient_GuardianEntity.this.getAttackState() != 3;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 16, 16, 17, 100, 100));
        this.f_21345_.m_25352_(0, (Goal)new IStateGoal(this, 17, 17, 0, 20, 0){

            @Override
            public void m_8056_() {
                super.m_8056_();
                Ancient_GuardianEntity.this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)0);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Ancient_GuardianEntity.this.stunCooldown = 200;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 48, 15, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Ancient_GuardianEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && Ancient_GuardianEntity.this.smashAnchorCooldown <= 0 && Ancient_GuardianEntity.this.m_5448_() != null && Ancient_GuardianEntity.this.getAttackState() != 3 && Ancient_GuardianEntity.this.smashCooldown > 0;
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = Ancient_GuardianEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Ancient_GuardianEntity.this.m_5448_() != null) {
                        Ancient_GuardianEntity.this.sendActionBarMessageToPlayer(player, "\u00a7cAncient Guardian is preparing a Stun Attack!");
                    }
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                LivingEntity livingEntity = Ancient_GuardianEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (Ancient_GuardianEntity.this.m_5448_() != null) {
                        Ancient_GuardianEntity.this.sendActionBarMessageToPlayer(player, "\u00a7cAncient Guardian is preparing a Stun Attack!");
                    }
                }
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Ancient_GuardianEntity.this.resetSmashAnchorCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 78, 15, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Ancient_GuardianEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && Ancient_GuardianEntity.this.smashCooldown <= 0 && Ancient_GuardianEntity.this.m_5448_() != null && Ancient_GuardianEntity.this.getAttackState() != 4;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                Ancient_GuardianEntity.this.resetSmashCooldown();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 90, 64, 5.0f){

            @Override
            public void m_8056_() {
                Ancient_GuardianEntity.this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)0);
                super.m_8056_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 8, 8, 0, 75, 0){

            @Override
            public void m_8056_() {
                super.m_8056_();
                Ancient_GuardianEntity.this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)0);
            }

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 1, 1, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new IAttackGoal(this, 1, 2, 0, 20, 0, 15.0f));
    }

    private void destroy() {
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return;
        }
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.5, 0.5);
        Iterator var3 = BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_)).iterator();
        while (var3.hasNext()) {
            BlockPos blockpos = (BlockPos)var3.next();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || !blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate) || this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) continue;
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
        }
        return;
    }

    public void attackParticle() {
        if (this.attackTicks == 1) {
            this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)1);
        }
        if (this.m_9236_().f_46443_) {
            // empty if block
        }
        if (this.getAttackState() == 17 && (Integer)this.f_19804_.m_135370_(PARTICLE_TICKS) == 2 && this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 30, 1.0f, 1.0f, 1.0f, 1.0f, 85.0f, false, Circle.EnumRingBehavior.GROW), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.getAttackState() == 6 && (Integer)this.f_19804_.m_135370_(PARTICLE_TICKS) == 68) {
            float radius = 2.0f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) - 0.5;
            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + 0.5 * (double)Mth.m_14031_((float)angle);
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 30, 1.0f, 1.0f, 1.0f, 1.0f, 50.0f, false, Circle.EnumRingBehavior.GROW), this.m_20185_() + extraX, this.m_20186_() + (double)0.1f, this.m_20189_() + extraZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.attackParticle();
        if (this.getAttackState() == 16) {
            this.destroy();
        }
        if (this.getAttackState() == 6 && this.attackTicks >= 36 && this.attackTicks <= 41) {
            this.destroy();
            if (this.m_9236_().f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                this.destroy();
            }
        }
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        LivingEntity target = this.m_5448_();
        if (this.isAttacking()) {
            // empty if block
        }
        if (target != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
        if (target != null) {
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null && movementSpeedAttribute.m_22135_() != 0.1) {
                movementSpeedAttribute.m_22100_(0.1);
            }
        } else {
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null && movementSpeedAttribute.m_22135_() != 0.0) {
                movementSpeedAttribute.m_22100_(0.0);
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 170.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 13.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 20.0);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.ANCIENT_GUARDIAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setAttackState(5);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.AncientGuardianHealthMutliplier.get());
        this.m_21530_();
    }

    public boolean m_6094_() {
        return this.getAttackState() != 8;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getCrackiness() == Crackiness.MEDIUM && this.hasPlayerHurtSound) {
            this.m_5496_(SoundEvents.f_12533_, 2.0f, 1.0f);
            this.hasPlayerHurtSound = true;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Ancientprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.isSleep() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)ModSounds.STEP_SOUND.get(), 1.0f, 1.0f);
    }

    public boolean WantsToStun() {
        return this.getTextureVariant() == 1;
    }

    public boolean getRoar() {
        return (Boolean)this.f_19804_.m_135370_(ROAR);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public void m_7378_(CompoundTag compound) {
        this.stunCooldown = compound.m_128451_("StunCooldown");
        this.f_19804_.m_135381_(GRABBING, (Object)compound.m_128471_("Attacking"));
        this.setSleep(compound.m_128471_("is_Sleep"));
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)compound.m_128451_("TextureVariant"));
        this.f_19804_.m_135381_(ROAR, (Object)compound.m_128471_("roar"));
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            // empty if block
        }
    }

    public void m_20256_(Vec3 movement) {
        if (this.getAttackState() != 8) {
            super.m_20256_(movement);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sleep") {
            return this.sleepAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "attackarmright") {
            return this.attackarm1AnimationState;
        }
        if (input == "attackarmleft") {
            return this.attackarm2AnimationState;
        }
        if (input == "attackarms") {
            return this.attackarmsAnimationState;
        }
        if (input == "attackstun") {
            return this.attackstunAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "attackcombo") {
            return this.attackComboAnimationState;
        }
        if (input == "roar") {
            return this.roarAnimationState;
        }
        if (input == "grab") {
            return this.grabAnimationState;
        }
        if (input == "run") {
            return this.runAnimationState;
        }
        if (input == "runpre") {
            return this.runpreAnimationState;
        }
        if (input == "postrun") {
            return this.postRunAnimationState;
        }
        return new AnimationState();
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        super.m_19956_(passenger, moveFunc);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.attackarm1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.attackarm2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.attackComboAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.roarAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.grabAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 17: {
                    this.stopAllAnimationStates();
                    this.postRunAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 16: {
                    this.stopAllAnimationStates();
                    this.runAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 15: {
                    this.stopAllAnimationStates();
                    this.runpreAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.grabAnimationState.m_216973_();
        this.postRunAnimationState.m_216973_();
        this.runAnimationState.m_216973_();
        this.runpreAnimationState.m_216973_();
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.attackarmsAnimationState.m_216973_();
        this.attackstunAnimationState.m_216973_();
        this.attackarm1AnimationState.m_216973_();
        this.attackarm2AnimationState.m_216973_();
        this.attackComboAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.roarAnimationState.m_216973_();
    }

    public boolean isSleep() {
        return this.getAttackState() == 1 || this.getAttackState() == 2;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean m_142066_() {
        return !this.isSleep() && super.m_142066_();
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, int knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            Vec3 knockbackRadius2;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Ancient_GuardianEntity || entityHit == this) continue;
            boolean hurt = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.AncientGuardianDamageMultiplier.get()));
            if (this.getAttackState() == 4) {
                this.m_5496_(SoundEvents.f_11669_, 1.0f, 0.5f);
                if (hurt) {
                    this.launch(entityHit, true);
                }
                if (entityHit instanceof Player && !entityHit.m_21254_()) {
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 40, 0));
                } else if (!(entityHit instanceof Player)) {
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 80, 0));
                }
            }
            if (this.getAttackState() == 17 && hurt) {
                this.launch(entityHit, true);
            }
            if (this.getAttackState() == 4 && this.attackTicks == 20) {
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_HIT.get(), 1.0f, 1.0f);
            }
            if (this.getAttackState() == 3 && this.attackTicks == 20) {
                if (this.m_5448_() != null) {
                    if (this.m_5448_() instanceof Player) {
                        if (!this.m_5448_().m_21254_() && hurt) {
                            this.setAttackState(8);
                            this.stopAllAnimationStates();
                            this.f_19804_.m_135381_(GRABBING, (Object)true);
                        }
                    } else if (!this.m_5448_().m_21254_() && !this.m_20159_() && hurt) {
                        this.setAttackState(8);
                        this.stopAllAnimationStates();
                        this.f_19804_.m_135381_(GRABBING, (Object)true);
                    }
                }
                if (entityHit == this.m_5448_()) {
                    // empty if block
                }
                if (BNknockback && !entityHit.m_21254_()) {
                    double knockbackRadius2 = 5.0;
                    double dx = entityHit.m_20185_() - this.m_20185_();
                    double dz = entityHit.m_20189_() - this.m_20189_();
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    double d = (double)knockback + 0.5 * (knockbackRadius2 - distance);
                }
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK.get(), 1.0f, 1.0f);
                knockbackRadius2 = this.m_20182_();
            }
            if (this.getAttackState() == 6) {
                Vec3 entityPosition;
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_HIT.get(), 1.0f, 1.0f);
                if (this.attackTicks == 18) {
                    knockbackRadius2 = this.m_20182_();
                }
                if (this.attackTicks == 41) {
                    this.m_5496_((SoundEvent)ModSounds.ANCHOR_HIT.get(), 1.0f, 1.0f);
                    entityPosition = this.m_20182_();
                    if (stun && !entityHit.m_21254_()) {
                        entityHit.m_147207_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 40, 0), (Entity)this);
                    }
                }
                if (this.attackTicks == 68) {
                    entityPosition = this.m_20182_();
                    CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.15f, 0, 20);
                    if (hurt) {
                        this.launch(entityHit, true);
                    }
                }
            }
            if (launch) {
                entityHit.m_20256_(new Vec3(0.0, (double)Lstrenght, 0.0));
            }
            if (!entityHit.m_21254_()) {
                // empty if block
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            Ancient_GuardianEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    private void spawnIceSpikesAdvanced(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Ancient_GuardianEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new ShockwaveSpawner(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)this, false));
        }
    }

    public void UpdateWithAttack() {
        Vec3 entityPosition;
        double distanceToTarget;
        LivingEntity target;
        block42: {
            block43: {
                block44: {
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    block49: {
                                                                        block48: {
                                                                            block47: {
                                                                                block46: {
                                                                                    block45: {
                                                                                        if (this.getAttackState() == 15) {
                                                                                            if (this.attackTicks == 17) {
                                                                                                target = this.m_5448_();
                                                                                                if (target != null) {
                                                                                                    distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                                                                                                    this.m_21563_().m_24960_((Entity)target, 60.0f, 30.0f);
                                                                                                    Vec3 vec3 = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
                                                                                                    this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_ * 0.9, 1.0, vec3.f_82481_ * 0.9));
                                                                                                }
                                                                                            } else {
                                                                                                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0, 0.0));
                                                                                            }
                                                                                        }
                                                                                        if (this.getAttackState() == 16 && (this.m_20096_() || !this.m_146900_().m_60819_().m_76178_())) {
                                                                                            this.setAttackState(17);
                                                                                        }
                                                                                        if (this.getAttackState() == 17) {
                                                                                            if (this.attackTicks == 2) {
                                                                                                if (this.isScary) {
                                                                                                    // empty if block
                                                                                                }
                                                                                                int standingOnY = Mth.m_14107_((double)this.m_20186_());
                                                                                                this.spawnIceSpikesAdvanced(this.m_20185_(), this.m_20189_(), standingOnY, this.m_20186_(), 0.0f, 0);
                                                                                                this.AreaAttack(6.0f, 6.0f, 360.0f, 16.0f, 100, false, 5, false, 0.25f, false);
                                                                                                this.m_5496_((SoundEvent)ModSounds.ANCHOR_SLAM.get(), 1.0f, 1.0f);
                                                                                                Vec3 entityPosition2 = this.m_20182_();
                                                                                                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition2, 20.0f, 0.1f, 0, 20);
                                                                                                Vec3 vec3 = this.m_20182_();
                                                                                            }
                                                                                            if (this.attackTicks == 50) {
                                                                                                this.m_20331_(false);
                                                                                            }
                                                                                        }
                                                                                        if (this.getAttackState() == 5) {
                                                                                            if (this.attackTicks == 32) {
                                                                                                entityPosition = this.m_20182_();
                                                                                                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
                                                                                            }
                                                                                            if (this.attackTicks == 58) {
                                                                                                // empty if block
                                                                                            }
                                                                                        }
                                                                                        if (this.getAttackState() == 3) {
                                                                                            if (this.attackTicks == 15) {
                                                                                                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
                                                                                            }
                                                                                            if (this.attackTicks == 20) {
                                                                                                this.AreaAttack(6.5f, 4.0f, 180.0f, 5.0f, 0, false, 1, true, 0.25f, false);
                                                                                            }
                                                                                            if (this.attackTicks == 45) {
                                                                                                // empty if block
                                                                                            }
                                                                                        }
                                                                                        if (this.getAttackState() != 8) break block42;
                                                                                        if (this.attackTicks == 0) {
                                                                                            this.k = (int)this.m_20186_();
                                                                                        }
                                                                                        target = this.m_5448_();
                                                                                        if (this.m_5448_() == null) break block43;
                                                                                        assert (target != null);
                                                                                        distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                                                                                        if (!(distanceToTarget < 64.0)) break block43;
                                                                                        if (this.m_5448_() instanceof Player) break block44;
                                                                                        if (this.attackTicks < 3 || this.attackTicks > 6) break block45;
                                                                                        this.f_20885_ = this.f_20883_;
                                                                                        float radius = 1.0f;
                                                                                        float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                                        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                                        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                                        Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 1.0, this.m_20189_() + extraZ);
                                                                                        if (this.m_5448_() == null) break block43;
                                                                                        this.m_5448_().m_146884_(p1);
                                                                                        break block43;
                                                                                    }
                                                                                    if (this.attackTicks < 6 || this.attackTicks > 9) break block46;
                                                                                    this.f_20885_ = this.f_20883_;
                                                                                    float radius = 0.5f;
                                                                                    float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                                    double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                                    double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                                    Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 2.0, this.m_20189_() + extraZ);
                                                                                    if (this.m_5448_() == null) break block43;
                                                                                    this.m_5448_().m_146884_(p1);
                                                                                    break block43;
                                                                                }
                                                                                if (this.attackTicks < 9 || this.attackTicks > 12) break block47;
                                                                                this.f_20885_ = this.f_20883_;
                                                                                float radius = 0.0f;
                                                                                float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                                Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 3.0, this.m_20189_() + extraZ);
                                                                                if (this.m_5448_() == null) break block43;
                                                                                this.m_5448_().m_146884_(p1);
                                                                                break block43;
                                                                            }
                                                                            if (this.attackTicks < 12 || this.attackTicks > 13) break block48;
                                                                            this.f_20885_ = this.f_20883_;
                                                                            float radius = 0.5f;
                                                                            float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                            Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 2.0, this.m_20189_() + extraZ);
                                                                            if (this.m_5448_() == null) break block43;
                                                                            this.m_5448_().m_146884_(p1);
                                                                            break block43;
                                                                        }
                                                                        if (this.attackTicks < 13 || this.attackTicks > 14) break block49;
                                                                        this.f_20885_ = this.f_20883_;
                                                                        float radius = 1.0f;
                                                                        float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                        Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 1.0, this.m_20189_() + extraZ);
                                                                        if (this.m_5448_() == null) break block43;
                                                                        this.m_5448_().m_146884_(p1);
                                                                        break block43;
                                                                    }
                                                                    if (this.attackTicks < 14 || this.attackTicks > 20) break block50;
                                                                    this.f_20885_ = this.f_20883_;
                                                                    float radius = 2.0f;
                                                                    float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                    double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                    double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                    Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_(), this.m_20189_() + extraZ);
                                                                    if (this.m_5448_() == null) break block43;
                                                                    this.m_5448_().m_146884_(p1);
                                                                    break block43;
                                                                }
                                                                if (this.attackTicks < 20 || this.attackTicks > 23) break block51;
                                                                this.f_20885_ = this.f_20883_;
                                                                float radius = 1.0f;
                                                                float angle = (float)Math.PI / 180 * this.f_20883_;
                                                                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                                Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 1.0, this.m_20189_() + extraZ);
                                                                if (this.m_5448_() == null) break block43;
                                                                this.m_5448_().m_146884_(p1);
                                                                break block43;
                                                            }
                                                            if (this.attackTicks < 23 || this.attackTicks > 26) break block52;
                                                            this.f_20885_ = this.f_20883_;
                                                            float radius = 0.5f;
                                                            float angle = (float)Math.PI / 180 * this.f_20883_;
                                                            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                            Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 2.0, this.m_20189_() + extraZ);
                                                            if (this.m_5448_() == null) break block43;
                                                            this.m_5448_().m_146884_(p1);
                                                            break block43;
                                                        }
                                                        if (this.attackTicks < 26 || this.attackTicks > 33) break block53;
                                                        this.f_20885_ = this.f_20883_;
                                                        float radius = 0.0f;
                                                        float angle = (float)Math.PI / 180 * this.f_20883_;
                                                        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                        Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 3.0, this.m_20189_() + extraZ);
                                                        if (this.m_5448_() == null) break block43;
                                                        this.m_5448_().m_146884_(p1);
                                                        break block43;
                                                    }
                                                    if (this.attackTicks < 33 || this.attackTicks > 36) break block54;
                                                    this.f_20885_ = this.f_20883_;
                                                    float radius = 0.5f;
                                                    float angle = (float)Math.PI / 180 * this.f_20883_;
                                                    double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                    double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                    Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 2.0, this.m_20189_() + extraZ);
                                                    if (this.m_5448_() == null) break block43;
                                                    this.m_5448_().m_146884_(p1);
                                                    break block43;
                                                }
                                                if (this.attackTicks < 36 || this.attackTicks > 39) break block55;
                                                this.f_20885_ = this.f_20883_;
                                                float radius = 1.0f;
                                                float angle = (float)Math.PI / 180 * this.f_20883_;
                                                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                                Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 1.0, this.m_20189_() + extraZ);
                                                if (this.m_5448_() == null) break block43;
                                                this.m_5448_().m_146884_(p1);
                                                break block43;
                                            }
                                            if (this.attackTicks < 42 || this.attackTicks > 46) break block56;
                                            this.f_20885_ = this.f_20883_;
                                            float radius = 2.0f;
                                            float angle = (float)Math.PI / 180 * this.f_20883_;
                                            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                            Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_(), this.m_20189_() + extraZ);
                                            if (this.m_5448_() == null) break block43;
                                            this.m_5448_().m_146884_(p1);
                                            break block43;
                                        }
                                        if (this.attackTicks < 46 || this.attackTicks > 49) break block57;
                                        this.f_20885_ = this.f_20883_;
                                        float radius = 1.0f;
                                        float angle = (float)Math.PI / 180 * this.f_20883_;
                                        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                        Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 1.0, this.m_20189_() + extraZ);
                                        if (this.m_5448_() == null) break block43;
                                        this.m_5448_().m_146884_(p1);
                                        break block43;
                                    }
                                    if (this.attackTicks < 52 || this.attackTicks > 55) break block58;
                                    this.f_20885_ = this.f_20883_;
                                    float radius = 0.5f;
                                    float angle = (float)Math.PI / 180 * this.f_20883_;
                                    double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                    double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                    Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 2.0, this.m_20189_() + extraZ);
                                    if (this.m_5448_() == null) break block43;
                                    this.m_5448_().m_146884_(p1);
                                    break block43;
                                }
                                if (this.attackTicks < 55 || this.attackTicks > 61) break block59;
                                this.f_20885_ = this.f_20883_;
                                float radius = 0.0f;
                                float angle = (float)Math.PI / 180 * this.f_20883_;
                                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                                Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 3.0, this.m_20189_() + extraZ);
                                if (this.m_5448_() == null) break block43;
                                this.m_5448_().m_146884_(p1);
                                break block43;
                            }
                            if (this.attackTicks < 61 || this.attackTicks > 64) break block60;
                            this.f_20885_ = this.f_20883_;
                            float radius = 0.5f;
                            float angle = (float)Math.PI / 180 * this.f_20883_;
                            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                            Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 2.0, this.m_20189_() + extraZ);
                            if (this.m_5448_() == null) break block43;
                            this.m_5448_().m_146884_(p1);
                            break block43;
                        }
                        if (this.attackTicks < 64 || this.attackTicks > 66) break block61;
                        this.f_20885_ = this.f_20883_;
                        float radius = 1.0f;
                        float angle = (float)Math.PI / 180 * this.f_20883_;
                        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                        Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_() + 1.0, this.m_20189_() + extraZ);
                        if (this.m_5448_() == null) break block43;
                        this.m_5448_().m_146884_(p1);
                        break block43;
                    }
                    if (this.attackTicks < 66 || this.attackTicks > 69) break block43;
                    this.f_20885_ = this.f_20883_;
                    float radius = 2.0f;
                    float angle = (float)Math.PI / 180 * this.f_20883_;
                    double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                    double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                    Vec3 p1 = new Vec3(this.m_20185_() + extraX, this.m_20186_(), this.m_20189_() + extraZ);
                    if (this.m_5448_() != null) {
                        this.m_5448_().m_146884_(p1);
                    }
                    break block43;
                }
                if (this.getAttackState() == 8) {
                    int[][] tickRanges;
                    for (int[] range : tickRanges = new int[][]{{3, 6, 1}, {6, 9, 2}, {9, 12, 3}, {12, 13, 2}, {13, 14, 1}, {14, 20, -1}, {20, 23, 1}, {23, 26, 2}, {26, 33, 3}, {33, 36, 2}, {36, 39, 1}, {42, 46, -1}, {46, 49, 1}, {52, 55, 2}, {55, 61, 3}, {61, 64, 2}, {64, 66, 1}, {66, 69, -1}}) {
                        int startTick = range[0];
                        int endTick = range[1];
                        int heightOffset = range[2];
                        if (this.attackTicks < startTick || this.attackTicks > endTick) continue;
                        float radius = heightOffset == 3 ? 1.0f : 2.0f;
                        float angle = (float)Math.PI / 180 * this.f_20883_;
                        double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + 0.5;
                        double extraZ = (double)(radius * Mth.m_14089_((float)angle)) - 0.5 * (double)Mth.m_14031_((float)angle);
                        Vec3 targetPosition = new Vec3(this.m_20185_() + extraX, this.m_20186_() + (double)heightOffset, this.m_20189_() + extraZ);
                        if (this.m_5448_() == null) break;
                        LivingEntity target1 = this.m_5448_();
                        Vec3 currentPosition = target.m_20182_();
                        Vec3 velocity = targetPosition.m_82546_(currentPosition).m_82490_(0.2);
                        if (target instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)target;
                            serverPlayer.f_8906_.m_9774_(currentPosition.f_82479_ + velocity.f_82479_, currentPosition.f_82480_ + velocity.f_82480_, currentPosition.f_82481_ + velocity.f_82481_, serverPlayer.m_146908_(), serverPlayer.m_146909_());
                            break;
                        }
                        target.m_20256_(velocity);
                        break;
                    }
                }
            }
            if (this.m_5448_() != null) {
                assert (target != null);
                distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget < 36.0) {
                    if (this.attackTicks == 16 && this.m_5448_() != null) {
                        int standingOnY = Mth.m_14107_((double)this.m_5448_().m_20186_());
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_(), this.m_5448_().m_20189_(), standingOnY, this.m_20186_(), 0.0f, 0);
                        this.AreaAttack(6.0f, 6.0f, 360.0f, 14.0f, 100, false, 5, false, 0.25f, false);
                        this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)1000);
                        this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                    }
                    if (this.attackTicks == 42 && this.m_5448_() != null) {
                        this.f_19804_.m_135381_(PARTICLE_TICKS, (Object)1001);
                        int standingOnY = Mth.m_14107_((double)this.m_5448_().m_20186_());
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_(), this.m_5448_().m_20189_(), standingOnY, this.m_20186_(), 0.0f, 0);
                        this.AreaAttack(6.0f, 6.0f, 360.0f, 15.0f, 100, false, 5, false, 0.25f, false);
                        this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                    }
                    if (this.attackTicks == 67 && this.m_5448_() != null) {
                        int standingOnY = Mth.m_14107_((double)this.m_5448_().m_20186_());
                        this.spawnIceSpikesAdvanced(this.m_5448_().m_20185_(), this.m_5448_().m_20189_(), standingOnY, this.m_20186_(), 0.0f, 0);
                        this.AreaAttack(6.0f, 6.0f, 360.0f, 16.0f, 100, false, 5, false, 0.25f, false);
                        this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                    }
                }
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 15) {
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_SWING1.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 20) {
                this.AreaAttack(6.5f, 4.0f, 100.0f, 16.0f, 40, false, 5, false, 0.25f, false);
            }
        }
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 18) {
                this.AreaAttack(6.5f, 4.0f, 75.0f, 14.0f, 40, false, 5, false, 0.25f, false);
            }
            if (this.attackTicks == 13) {
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_SWING1.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 36) {
                if (this.m_20096_()) {
                    target = this.m_5448_();
                    if (this.m_5448_() != null) {
                        assert (target != null);
                        distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                        if (distanceToTarget > 16.0) {
                            Vec3 vector3d = this.m_20184_();
                            float f = this.m_146908_() * ((float)Math.PI / 180);
                            Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(1.6).m_82549_(vector3d.m_82490_(1.3));
                            this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                        }
                    }
                }
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_SWING2.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 41) {
                this.AreaAttack(6.5f, 4.0f, 75.0f, 15.0f, 40, false, 0, false, 0.0f, false);
            }
            if (this.attackTicks == 65) {
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_SWING2.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks == 68) {
                this.AreaAttack(7.0f, 4.0f, 160.0f, 17.0f, 80, false, 5, false, 0.25f, false);
                this.m_5496_((SoundEvent)ModSounds.ANCHOR_SLAM.get(), 1.0f, 1.0f);
                entityPosition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 20.0f, 0.1f, 0, 20);
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @Nullable SpawnGroupData p_29681_, @Nullable CompoundTag p_29682_) {
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    protected void m_6153_() {
        ++this.guardianDeathTime;
        if (this.m_9236_() instanceof ServerLevel && this.guardianDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.guardianDeathTime == 30) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 0, 20);
        }
        if (this.guardianDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

