/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.RuinedPyramid;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Pets.MossyGolemEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.BombEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.BigCannonAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.BigCannonShootGoal;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class DuneSentinelEntity
extends Monster
implements IForgeEntity,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(DuneSentinelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(DuneSentinelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public final AnimationState shootAnimationState = new AnimationState();
    public int shootAnimationTimeout = 0;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 200;
    private static final int SHOOT2_COOLDOWN_DURATION = 40;
    private static final int SHOOT_COOLDOWN_DURATION = 40;
    private int shootCooldown = 0;
    private int shootAnimCooldown = 0;
    public int dragonDeathTime;

    public DuneSentinelEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 2;
        this.m_21557_(false);
    }

    protected boolean m_8028_() {
        return false;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    public void attackTargets(Entity entity1) {
        DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
        double damage = 16.0 * (Double)ModConfig.MOB_CONFIG.DuneSentinelDamageMutliplier.get();
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity1;
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                livingEntity.m_6469_(damageSource, (float)(damage - 5.0));
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                livingEntity.m_6469_(damageSource, (float)damage);
            } else if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                livingEntity.m_6469_(damageSource, (float)(damage + 14.0));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.DeathAnimationState.m_216984_()) {
            --this.DeathAnimationTimeout;
            if (this.DeathAnimationTimeout <= 0) {
                this.DeathAnimationState.m_216973_();
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.shootAnimCooldown > 0) {
            this.f_19804_.m_135381_(SHOOTING, (Object)false);
            --this.shootAnimCooldown;
        } else if (!this.isAttacking() && this.shootAnimCooldown == 0 && this.m_5448_() != null) {
            this.f_19804_.m_135381_(SHOOTING, (Object)true);
        }
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    private void setupAnimationStates() {
        if (this.DeathAnimationTimeout >= 200) {
            if (this.dragonDeathTime > 0 && !this.DeathAnimationState.m_216984_()) {
                this.DeathAnimationState.m_216977_(this.f_19797_);
                --this.DeathAnimationTimeout;
                this.attackAnimationState.m_216973_();
                this.shootAnimationState.m_216973_();
            }
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
            if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
                this.attackAnimationTimeout = 17;
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.attackAnimationTimeout;
            }
            if (!this.isAttacking() && !this.isShooting()) {
                this.attackAnimationState.m_216973_();
            }
            if (this.isShooting() && this.shootAnimationTimeout <= 0 && this.shootCooldown == 0) {
                this.shootAnimationTimeout = 35;
                this.shootAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.shootAnimationTimeout;
            }
            if (!this.isShooting() && !this.isAttacking()) {
                this.shootAnimationState.m_216973_();
            }
        }
    }

    public void setShooting(boolean shooting) {
        this.f_19804_.m_135381_(SHOOTING, (Object)shooting);
    }

    public boolean isShooting() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8099_() {
        if (this.dragonDeathTime <= 0) {
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        }
        if (this.dragonDeathTime <= 0) {
            this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        }
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BigCannonAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new BigCannonShootGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, entity -> entity instanceof Player));
    }

    public void m_8107_() {
        LivingEntity target;
        int i;
        super.m_8107_();
        if (this.m_9236_().f_46443_ && this.getCrackiness() == Crackiness.HIGH) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            i = 0;
            while ((double)i < 0.5) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.025, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                ++i;
            }
        }
        if (this.m_9236_().f_46443_ && this.getCrackiness() == Crackiness.MEDIUM) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            i = 0;
            while ((double)i < 0.5) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                ++i;
            }
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
            if (this.attackAnimationTimeout <= 0) {
                this.m_6504_(target, (float)(horizontalDistance / 20.0));
                this.attackAnimationTimeout = 20;
            }
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        BombEntity chorusBomb = new BombEntity((EntityType<BombEntity>)((EntityType)ModEntities.BOMB.get()), this.m_9236_(), (LivingEntity)this);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - chorusBomb.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        chorusBomb.m_6686_(d0, d1 + d3 * 0.2, d2, 0.8f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        chorusBomb.m_5602_((Entity)this);
        if (Math.random() < 0.5) {
            this.m_5496_((SoundEvent)ModSounds.CANNON_SHOOT_2.get(), 3.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        } else {
            this.m_5496_((SoundEvent)ModSounds.CANNON_SHOOT_1.get(), 3.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        this.m_9236_().m_7967_((Entity)chorusBomb);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 170.0).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 16.0);
    }

    public void m_7334_(Entity pEntity) {
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void ResetShootCooldown() {
        this.shootCooldown = 40;
    }

    public void ResetShootAnimCooldown() {
        this.shootAnimCooldown = 40;
    }

    public boolean canAnim() {
        return this.shootAnimCooldown <= 0;
    }

    public boolean canShoot() {
        return this.shootCooldown <= 0;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            // empty if block
        }
        this.shootCooldown = compound.m_128451_("ShootCooldown");
        this.shootAnimCooldown = compound.m_128451_("ShootAnimCooldown");
    }

    public void performAreaAttack() {
        double attackRadius = 4.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || entity == this.m_5448_() || entity instanceof MossyGolemEntity || entity instanceof CameraShakeEntity) continue;
            this.m_7327_((Entity)livingEntity);
        }
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.DUNE_SENTINEL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DUNE_SENTINEL_DEATH.get();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ShootCooldown", this.shootCooldown);
        compound.m_128405_("ShootAnimCooldown", this.shootAnimCooldown);
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return false;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.dragonDeathTime = 0;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.DuneSentinelHealthMultiplier.get());
        this.m_21530_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (((Boolean)ModConfig.MOB_CONFIG.Duneprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268534_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
            if (this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                    this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
                }
                int i = 0;
                while ((double)i < 0.5) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.025, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    ++i;
                }
            }
        }
        if (this.dragonDeathTime > 100 && this.m_9236_().f_46443_) {
            int i = 0;
            while ((double)i < 0.5) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.025, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.025, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                ++i;
            }
        }
        if (this.dragonDeathTime == 60) {
            this.m_7311_(140);
        }
        if (this.dragonDeathTime == 190) {
            Vec3 entityPosition = this.m_20182_();
            CameraShakeEntity.cameraShake(this.m_9236_(), entityPosition, 40.0f, 0.1f, 20, 20);
        }
        if (this.dragonDeathTime == 200 && this.m_9236_() instanceof ServerLevel) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        public final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

