/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.SpaceStation.FlameDrifter;

import java.util.List;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.AnnihilationBombTrail;
import net.miauczel.legendary_monsters.Particle.custom.BigAnnihilationSweepParticle;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.Particle.custom.LightningParticle;
import net.miauczel.legendary_monsters.Particle.custom.MovingTrailParticle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Chorusling.EndersentEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AbstractChorusling;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AbstractFlameborn;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.SmallAnnihilationBombEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoalMin;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.tag.ModEntityTags;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class FlameDrifterEntity
extends AbstractFlameborn {
    public final int SPIN_COOLDOWN = 80;
    public int spin_cooldown = 80;
    public int nextShootType = 1;
    public double lastX;
    public double lastY;
    public double lastZ;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState leftCannonShootAnimationState = new AnimationState();
    public AnimationState rightCannonShootAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState spinChargeAnimationState = new AnimationState();
    public AnimationState spinAnimationState = new AnimationState();
    public int deathTime;

    public FlameDrifterEntity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 5;
        this.lastX = this.m_20185_();
        this.lastY = this.m_20186_();
        this.lastZ = this.m_20189_();
        this.m_21530_();
        this.m_274367_(2.0f);
    }

    @Override
    public void m_8119_() {
        if (this.spin_cooldown > 0) {
            --this.spin_cooldown;
        }
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
            if (this.isDuringTeleportation() && !this.m_20145_()) {
                this.m_6842_(true);
            }
            if (!this.isDuringTeleportation() && this.m_20145_()) {
                this.m_6842_(false);
            }
        }
        super.m_8119_();
    }

    public void m_8107_() {
        this.UpdateWithAttack();
        super.m_8107_();
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractChorusling.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EndersentEntity.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 40, 54, 12.0f){

            @Override
            public void m_8041_() {
                FlameDrifterEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlameDrifterEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && FlameDrifterEntity.this.m_5448_() != null && FlameDrifterEntity.this.getNextShootType() == 1;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 76, 76, 5.0f){

            @Override
            public void m_8041_() {
                FlameDrifterEntity.this.randomizeAttacks();
                FlameDrifterEntity.this.spin_cooldown = 80;
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlameDrifterEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && FlameDrifterEntity.this.m_5448_() != null && FlameDrifterEntity.this.spin_cooldown <= 0;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 2, 0, 40, 54, 12.0f){

            @Override
            public void m_8041_() {
                FlameDrifterEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlameDrifterEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && FlameDrifterEntity.this.m_5448_() != null && FlameDrifterEntity.this.getNextShootType() == 2;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoalMin(this, 0, 5, 0, 53, 53, 12.0f, 5.0f){

            @Override
            public void m_8041_() {
                FlameDrifterEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlameDrifterEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && FlameDrifterEntity.this.m_5448_() != null;
            }
        });
    }

    public void randomizeAttacks() {
        this.setRandomNextShootType(2);
    }

    public int getNextShootType() {
        return this.nextShootType;
    }

    public void setRandomNextShootType(int rolls) {
        switch (this.m_217043_().m_188503_(rolls)) {
            case 0: {
                this.nextShootType = 1;
                break;
            }
            case 1: {
                this.nextShootType = 2;
            }
        }
    }

    public void backStep(float backstepStrenght, float yStrenght) {
        float yaw = (float)Math.toRadians(this.m_146908_() + 90.0f);
        Vec3 dodgePos = this.m_20184_().m_82520_((double)backstepStrenght * Math.cos(yaw), (double)yStrenght, (double)backstepStrenght * Math.sin(yaw));
        this.m_20334_(dodgePos.f_82479_, dodgePos.f_82480_, dodgePos.f_82481_);
    }

    public void saveLastPosition(LivingEntity entity) {
        this.lastX = entity.m_20185_();
        this.lastY = entity.m_20186_();
        this.lastZ = entity.m_20189_();
    }

    public void teleportToLastPosition() {
        this.teleport(this.lastX, this.lastY, this.lastZ);
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_6095_().m_204039_(ModEntityTags.ANNIHILATION_TEAM) || super.m_7307_(pEntity);
    }

    public void UpdateWithAttack() {
        if (this.getAttackState() == 2 || this.getAttackState() == 3) {
            float offset;
            if (this.attackTicks == 4) {
                this.m_5496_((SoundEvent)ModSounds.FLAME_DRIFTER_CHARGE_SHOOT.get(), 1.0f, 1.25f);
            }
            float y = (float)(this.m_20186_() + 0.5);
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            float vec = 0.75f;
            float f2 = offset = this.getAttackState() == 2 ? 1.75f : -1.75f;
            if (this.attackTicks == 13) {
                for (int k = 0; k < 3; ++k) {
                    float d1 = Mth.m_14116_((float)k);
                    float ran = 0.4f;
                    float r = 0.0f;
                    float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
                    float b = 0.0f;
                    if (!this.m_9236_().f_46443_) continue;
                    this.m_9236_().m_7106_((ParticleOptions)new MovingTrailParticle.TrailData(r, g, b, 0.1f, 0.1f), this.m_20185_() + (double)vec * vecX + (double)(f * offset), (double)y, this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset), (double)Mth.m_14031_((float)k), 0.0, (double)(d1 * 0.01f));
                }
            }
            if (this.attackTicks == 20) {
                if (this.m_9236_().f_46443_) {
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.ANNIHILATION_EXPLOSION.get(), (double)((float)(this.m_20185_() + (double)vec * vecX + (double)(f * offset))), (double)y, (double)((float)(this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset))), 0.0, 0.0, 0.0);
                }
                this.m_5496_((SoundEvent)ModSounds.OBLITERATOR_ARM_SHOOT.get(), 1.0f, 1.25f);
                this.backStep(-0.75f, 0.0f);
                this.shootAnnihilationBomb(1.0f, (float)(this.m_20185_() + (double)vec * vecX + (double)(f * offset)), y, (float)(this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset)), 15);
                this.shootAnnihilationBomb(1.0f, (float)(this.m_20185_() + (double)vec * vecX + (double)(f * offset)), y, (float)(this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset)), 30);
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 10) {
                this.saveLastPosition((LivingEntity)this);
            }
            if (this.attackTicks == 15) {
                this.m_5496_((SoundEvent)ModSounds.CANNON_SHOOT_1.get(), 2.0f, 0.75f);
                this.calculatedDash(0.55f);
            }
            if (this.attackTicks > 15 && this.attackTicks < 22) {
                if (this.m_9236_().f_46443_) {
                    float yaw = (float)Math.toRadians(-this.m_146908_() + 180.0f);
                    double theta = (double)this.m_146908_() * (Math.PI / 180);
                    double vecX = Math.cos(theta += 1.5707963267948966);
                    double vecZ = Math.sin(theta);
                    double spawnX = this.m_20185_() + vecX * 1.5;
                    double spawnZ = this.m_20189_() + vecZ * 1.5;
                    double d0 = (double)(this.f_19796_.m_188501_() - 0.5f) + this.m_20184_().f_82479_;
                    double d1 = (double)(this.f_19796_.m_188501_() - 0.5f) + this.m_20184_().f_82480_;
                    double d2 = (double)(this.f_19796_.m_188501_() - 0.5f) + this.m_20184_().f_82481_;
                    double dist = 2.0f + this.f_19796_.m_188501_() * 0.2f;
                    double d3 = d0 * dist;
                    double d4 = d1 * dist;
                    double d5 = d2 * dist;
                    this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.OrbData(25, 255, 0), this.m_20185_() + d0, this.m_20186_() + 1.0, this.m_20189_() + d2, d3, d4, d5);
                    this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.OrbData(255, 255, 255), this.m_20185_() + d0, this.m_20186_() + 1.0, this.m_20189_() + d2, d3, d4, d5);
                    this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(yaw, 0.0f, 30, 0.0f, 1.0f, 0.0f, 1.0f, 40.0f, false, Circle.EnumRingBehavior.GROW_THEN_SHRINK), spawnX, this.m_20186_() + 1.0, spawnZ, 0.0, 0.0, 0.0);
                }
                float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                float vec = 0.0f;
                float offset = 2.0f;
                float offset2 = -2.0f;
                double dx = this.m_20185_() + (double)vec * vecX + (double)(f * offset);
                double dx2 = this.m_20185_() + (double)vec * vecX + (double)(f * offset2);
                double dy = this.m_20186_() + 1.5;
                double dz = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset);
                double dz2 = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset2);
                float ran = 0.4f;
                float r = 0.0f;
                float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
                float b = 0.0f;
                if (this.m_9236_().f_46443_) {
                    this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 1.0f, this.m_19879_()), dx, dy, dz, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 1.0f, this.m_19879_()), dx2, dy, dz2, 0.0, 0.0, 0.0);
                }
                this.SideAreaAttack(1.0f, 2.0f, 360.0f, 0.0f, 10.0f, 60, false, true, SoundEvents.f_12600_, 0.5f);
            }
            if (this.attackTicks == 34) {
                this.teleportToLastPosition();
            }
        }
        if (this.getAttackState() == 6 && this.attackTicks > 20 && this.attackTicks < 50) {
            float a = 0.275f;
            this.basicDash(a, a, 0.0f, false);
            if (this.f_19797_ % 5 == 0) {
                this.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f);
                float sweepSize = 1.25f;
                float sweepRot = 0.0f;
                this.createSweep(0.0f, 0.0f, 3.0f, this.m_217043_().m_188502_() * 100 < 50, sweepSize, sweepRot);
                this.createSweep(0.0f, 0.0f, -3.0f, this.m_217043_().m_188502_() * 100 < 50, sweepSize, sweepRot);
            }
            this.SideAreaAttack(3.0f, 3.0f, 360.0f, 0.0f, 13.0f, 100, false, true, SoundEvents.f_12600_, 0.5f);
        }
    }

    @Override
    public int attackDelayTicksValue() {
        return 3;
    }

    public AnimationState getAnimationState(String input) {
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "left_cannon_shoot") {
            return this.leftCannonShootAnimationState;
        }
        if (input == "right_cannon_shoot") {
            return this.rightCannonShootAnimationState;
        }
        if (input == "spin_charge") {
            return this.spinChargeAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "spin") {
            return this.spinAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.leftCannonShootAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.rightCannonShootAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.spinChargeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.spinAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.leftCannonShootAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.rightCannonShootAnimationState.m_216973_();
        this.spinChargeAnimationState.m_216973_();
        this.spinAnimationState.m_216973_();
    }

    public void createSweep(float pos, float posOffset, float yHeight, boolean reverse, float scale, float rot) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float vec = pos;
        float offset = posOffset;
        double x = this.m_20185_() + (double)vec * vecX + (double)(f * offset);
        double z = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset);
        if (this.m_9236_().f_46443_) {
            double d0 = x;
            double d1 = this.m_20186_() + (double)(this.m_20206_() / 2.0f) + 0.4;
            double d2 = z;
            float yaw = (float)Math.toRadians(-this.f_20883_ + (reverse ? rot : 180.0f));
            double lookX = -Math.cos(yaw);
            double lookZ = -Math.sin(yaw);
            float pitch = (float)(reverse ? -1 : 1) * (float)Math.atan2(yHeight, Math.sqrt(lookX * lookX + lookZ * lookZ));
            this.m_9236_().m_7106_((ParticleOptions)new BigAnnihilationSweepParticle.SweepData(this.m_6134_() * scale, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void shootAnnihilationBomb(float velocity, float x, float y, float z, int inaccuracy) {
        if (this.targetIsNotNull()) {
            SmallAnnihilationBombEntity chorusBomb = new SmallAnnihilationBombEntity((EntityType<SmallAnnihilationBombEntity>)((EntityType)ModEntities.SMALL_ANNIHILATION_BOMB_ENTITY.get()), this.m_9236_(), (LivingEntity)this, 8.0f);
            chorusBomb.m_20343_(x, y, z);
            double d0 = this.target().m_20185_() - (double)x;
            double d4 = (this.target().m_20186_() - (double)y) * 0.5;
            double d1 = this.target().m_20191_().f_82289_ + (double)(this.target().m_20206_() / 2.0f) - chorusBomb.m_20186_();
            double d2 = this.target().m_20189_() - (double)z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            chorusBomb.m_6686_(d0, d1 + d3 * 0.2, d2, velocity, inaccuracy - this.m_9236_().m_46791_().m_19028_() * 4);
            chorusBomb.m_5602_((Entity)this);
            this.m_9236_().m_7967_((Entity)chorusBomb);
        }
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime == 45) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        this.deathTime = 0;
        this.setAttackState(4);
        this.stopAllAnimationStates();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.THE_WARPED_ONE_HURT2.get();
    }

    public void SideAreaAttack(float range, float height, float arc, float boxOffset, float damage, int brokenShieldTicks, boolean canStun, boolean canlaunch, SoundEvent soundEvent, float pitch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = (this.f_20883_ - boxOffset) % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof TheObliteratorEntity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.getAttackState() == 14 || this.getAttackState() == 40 ? ModDamageTypes.causeAnnihilationDamage((Entity)this, (LivingEntity)this) : this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.FlameDrifterDamageMutliplier.get()));
            if (flag) {
                this.m_5496_(soundEvent, 1.0f, pitch);
                if (canlaunch) {
                    entityHit.m_5997_(entityHit.m_20184_().f_82479_, 0.5, entityHit.m_20184_().f_82481_);
                }
                if (this.getAttackState() == 5) {
                    entityHit.m_20254_(3);
                }
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            FlameDrifterEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    @Override
    public boolean teleport(double x, double y, double z) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.TELEPORT_EFFECT.get()), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        if (flag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.teleportBoolean(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, 0.1f, 5, 5);
                    this.m_5496_(SoundEvents.f_12418_, 4.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    public boolean teleportBoolean(double x, double y, double z, boolean p_20988_) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        double d3 = y;
        boolean flag = false;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Level level = this.m_9236_();
        if (level.m_46805_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.m_6021_(x, d3, z);
                EntityUtil.applyServerTeleport((LivingEntity)this);
                if (level.m_45786_((Entity)this) && !level.m_46855_(this.m_20191_())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.m_6021_(d0, d1, d2);
            EntityUtil.applyServerTeleport((LivingEntity)this);
            return false;
        }
        if (p_20988_) {
            level.m_7605_((Entity)this, (byte)46);
        }
        this.m_21573_().m_26573_();
        return true;
    }

    public void onAddedToWorld() {
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.FlameDrifterHealthMultiplier.get());
        super.onAddedToWorld();
    }

    public boolean isDuringTeleportation() {
        return this.getAttackState() == 5 && this.attackTicks >= 34 && this.attackTicks <= 41;
    }
}

